/*
 * Decompiled with CFR 0.152.
 */
package hec.map;

import hec.map.LocalRect;
import hec.map.MapGlyph;
import hec.map.MapScale;
import hec.map.WorldRect;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.image.BufferedImage;
import java.awt.image.DataBufferInt;
import java.awt.image.ImageObserver;
import java.awt.image.WritableRaster;
import java.util.Arrays;
import java.util.List;

public class MapScaleBufferedImage {
    double _lastZoomValue = -1.0;
    LocalRect _lastLocalRect = null;
    WorldRect _lastWorldRect = null;
    BufferedImage _bufferedImage = null;

    public void draw(Graphics g, MapScale scl, List mapGlyphs, ImageObserver parent) {
        double currentZoom = scl.getZoom();
        WorldRect currentWorldRect = scl.getWorldRect();
        LocalRect currentLocalRect = scl.getViewRect();
        if (this._bufferedImage == null || this._lastLocalRect == null || !this._lastLocalRect.equals(currentLocalRect)) {
            this.createImage(currentLocalRect);
        }
        if (this._bufferedImage == null || this._lastZoomValue == -1.0 || this._lastZoomValue != currentZoom || this._lastLocalRect == null || !this._lastLocalRect.equals(currentLocalRect) || this._lastWorldRect == null || !this._lastWorldRect.equals(currentWorldRect)) {
            this.drawImage(scl, mapGlyphs);
            this._lastZoomValue = currentZoom;
            this._lastLocalRect = currentLocalRect;
            this._lastWorldRect = currentWorldRect;
        }
        g.drawImage(this._bufferedImage, 0, 0, parent);
    }

    private void createImage(LocalRect rectangle) {
        System.out.println("MapScaleBufferedImage.createImage()");
        int w = rectangle.width();
        int h = rectangle.height();
        this._bufferedImage = new BufferedImage(w, h, 2);
    }

    private void drawImage(MapScale scl, List mapGlyphs) {
        System.out.println("MapScaleBufferedImage.drawImage()");
        Graphics2D g = this._bufferedImage.createGraphics();
        WritableRaster raster = this._bufferedImage.getRaster();
        DataBufferInt dataBuffer = (DataBufferInt)raster.getDataBuffer();
        int[] data = dataBuffer.getBankData()[0];
        Arrays.fill(data, 0);
        for (int i = 0; i < mapGlyphs.size(); ++i) {
            ((MapGlyph)mapGlyphs.get(i)).draw(g, scl);
        }
    }
}

