/*
 * Decompiled with CFR 0.152.
 */
package hec.map;

import hec.map.IntegerDocument2;
import hec.map.MapPanel;
import hec.map.MapScaleEditorPanel_m_alwaysShowLayerRadio_actionAdapter;
import hec.map.MapScaleEditorPanel_m_useScaleRangeRadio_actionAdapter;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.ButtonGroup;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.UIManager;
import rma.swing.RmaJIntegerField;
import rma.swing.RmaJRadioButton;
import rma.util.RMAIO;
import rma.util.RMAUtil;

public class MapScaleEditorPanel
extends JPanel {
    MapPanel m_mapPanel = null;
    GridBagLayout gridBagLayout1 = new GridBagLayout();
    JButton m_setMaxToCurrent = new JButton("Set to Current");
    JButton m_setMinToCurrent = new JButton("Set to Current");
    RmaJRadioButton m_alwaysShowLayerRadio = new RmaJRadioButton();
    RmaJRadioButton m_useScaleRangeRadio = new RmaJRadioButton();
    JPanel jPanel1 = new JPanel(new GridBagLayout());
    RmaJIntegerField m_minimumScaleTxt = new RmaJIntegerField();
    RmaJIntegerField m_maximumScaleTxt = new RmaJIntegerField();
    JLabel m_currentScaleLabel = new JLabel();

    public MapScaleEditorPanel() {
        try {
            this.jbInit();
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    void jbInit() throws Exception {
        this.m_minimumScaleTxt.setDocument(new IntegerDocument2());
        this.m_maximumScaleTxt.setDocument(new IntegerDocument2());
        this.m_alwaysShowLayerRadio.setText("Always show layer");
        this.m_alwaysShowLayerRadio.addActionListener(new MapScaleEditorPanel_m_alwaysShowLayerRadio_actionAdapter(this));
        this.setLayout(this.gridBagLayout1);
        this.m_useScaleRangeRadio.setToolTipText("");
        this.m_useScaleRangeRadio.setText("Only show layer in the following scale range");
        this.m_useScaleRangeRadio.addActionListener(new MapScaleEditorPanel_m_useScaleRangeRadio_actionAdapter(this));
        this.m_minimumScaleTxt.setText("");
        this.m_maximumScaleTxt.setText("");
        this.m_minimumScaleTxt.setColumns(8);
        this.m_maximumScaleTxt.setColumns(8);
        this.add((Component)this.m_alwaysShowLayerRadio, new GridBagConstraints(0, 0, 1, 1, 1.0, 0.0, 18, 0, new Insets(5, 5, 0, 5), 0, 0));
        this.add((Component)this.m_useScaleRangeRadio, new GridBagConstraints(0, 1, 1, 1, 1.0, 0.0, 18, 0, new Insets(5, 5, 0, 5), 0, 0));
        this.add((Component)this.jPanel1, new GridBagConstraints(0, 2, 1, 1, 1.0, 1.0, 18, 1, new Insets(5, 5, 5, 5), 0, 0));
        this.m_setMinToCurrent.addActionListener(new ButtonAdapter(this.m_minimumScaleTxt));
        this.m_setMaxToCurrent.addActionListener(new ButtonAdapter(this.m_maximumScaleTxt));
        JLabel label2 = new JLabel("Only visible below 1:");
        JLabel label = new JLabel("Only visible above 1:");
        this.jPanel1.add((Component)label2, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 18, 0, new Insets(5, 25, 0, 5), 0, 0));
        this.jPanel1.add((Component)label, new GridBagConstraints(0, 1, 1, 1, 0.0, 0.0, 18, 0, new Insets(5, 25, 5, 0), 0, 0));
        this.jPanel1.add((Component)this.m_maximumScaleTxt, new GridBagConstraints(1, 0, 1, 1, 1.0, 0.0, 18, 2, new Insets(5, 5, 0, 0), 0, 0));
        this.jPanel1.add((Component)this.m_setMaxToCurrent, new GridBagConstraints(2, 0, 1, 1, 0.0, 0.0, 12, 0, new Insets(5, 5, 0, 5), 0, 0));
        this.jPanel1.add((Component)this.m_minimumScaleTxt, new GridBagConstraints(1, 1, 1, 1, 1.0, 0.0, 18, 2, new Insets(5, 5, 0, 0), 0, 0));
        this.jPanel1.add((Component)this.m_setMinToCurrent, new GridBagConstraints(2, 1, 1, 1, 0.0, 0.0, 12, 0, new Insets(5, 5, 0, 5), 0, 0));
        ButtonGroup bg = new ButtonGroup();
        bg.add(this.m_alwaysShowLayerRadio);
        bg.add(this.m_useScaleRangeRadio);
        this.m_alwaysShowLayerRadio.setMargin(new Insets(0, 0, 0, 0));
        this.m_useScaleRangeRadio.setMargin(new Insets(0, 0, 0, 0));
        this.jPanel1.add((Component)this.m_currentScaleLabel, new GridBagConstraints(0, 2, 3, 1, 1.0, 1.0, 18, 0, new Insets(5, 5, 5, 5), 0, 0));
    }

    @Override
    public void setEnabled(boolean enable) {
        super.setEnabled(enable);
        if (!enable) {
            this.m_alwaysShowLayerRadio.setSelected(true);
        }
        this.m_useScaleRangeRadio.setEnabled(enable);
    }

    public void setScale(int minimumScale, int maximumScale) {
        this.m_maximumScaleTxt.setText("");
        this.m_minimumScaleTxt.setText("");
        if (minimumScale == Integer.MIN_VALUE && maximumScale == Integer.MAX_VALUE) {
            this.setScaleTextFieldsEnabled(false);
            this.m_alwaysShowLayerRadio.setSelected(true);
        } else {
            this.m_useScaleRangeRadio.setSelected(true);
            this.setScaleTextFieldsEnabled(true);
            if (minimumScale != Integer.MIN_VALUE) {
                this.m_minimumScaleTxt.setValue(minimumScale);
            }
            if (maximumScale != Integer.MAX_VALUE) {
                this.m_maximumScaleTxt.setValue(maximumScale);
            }
        }
        if (this.m_mapPanel != null) {
            this.m_currentScaleLabel.setText("Current Scale 1 : " + (int)this.m_mapPanel.viewport().computeMapScale());
        }
    }

    public void setMapPanel(MapPanel mPanel) {
        this.m_mapPanel = mPanel;
        if (this.m_mapPanel != null) {
            this.m_currentScaleLabel.setText("Current Scale 1 : " + (int)this.m_mapPanel.viewport().computeMapScale());
        }
    }

    public int getMaximumScale() {
        if (this.m_alwaysShowLayerRadio.isSelected()) {
            return Integer.MAX_VALUE;
        }
        return RMAIO.parseInt(this.m_maximumScaleTxt.getText(), Integer.MAX_VALUE);
    }

    public int getMinimumScale() {
        if (this.m_alwaysShowLayerRadio.isSelected()) {
            return Integer.MIN_VALUE;
        }
        return RMAIO.parseInt(this.m_minimumScaleTxt.getText(), Integer.MIN_VALUE);
    }

    void m_alwaysShowLayerRadio_actionPerformed(ActionEvent e) {
        this.setScaleTextFieldsEnabled(false);
    }

    void m_useScaleRangeRadio_actionPerformed(ActionEvent e) {
        this.setScaleTextFieldsEnabled(true);
    }

    void setScaleTextFieldsEnabled(boolean b) {
        this.m_maximumScaleTxt.setEditable(b);
        this.m_minimumScaleTxt.setEditable(b);
        this.m_setMaxToCurrent.setEnabled(b);
        this.m_setMinToCurrent.setEnabled(b);
    }

    public static void main(String[] args) {
        try {
            UIManager.setLookAndFeel(UIManager.getSystemLookAndFeelClassName());
        }
        catch (Exception exception) {
            // empty catch block
        }
        JFrame frame = new JFrame();
        frame.getContentPane().add((Component)new MapScaleEditorPanel(), "Center");
        frame.setLocation(200, 200);
        frame.setSize(200, 200);
        frame.setVisible(true);
    }

    @Override
    public void setVisible(boolean b) {
        if (b) {
            // empty if block
        }
        super.setVisible(b);
    }

    private class ButtonAdapter
    implements ActionListener {
        RmaJIntegerField m_intField = null;

        public ButtonAdapter(RmaJIntegerField field) {
            this.m_intField = field;
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            if (MapScaleEditorPanel.this.m_mapPanel == null) {
                return;
            }
            this.m_intField.setValue((int)MapScaleEditorPanel.this.m_mapPanel.viewport().computeMapScale());
            RMAUtil.setParentModified(MapScaleEditorPanel.this);
        }
    }
}

