/*
 * Decompiled with CFR 0.152.
 */
package hec.map;

import hec.map.LocalRect;
import java.awt.Color;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;

public abstract class MapTextObject {
    protected String _text;
    int _w;
    int _h;
    int _a;
    int _d;
    protected float _priority = 0.0f;
    protected Font _font;
    protected Color _bgcolor;
    protected Color _fgcolor;
    protected int _strwidth;
    protected transient LocalRect _bounds;

    public MapTextObject() {
    }

    public MapTextObject(String txt, float priority, Font font, Color fg, Color bg, Graphics g) {
        this._text = txt;
        this._priority = priority;
        this._font = font;
        this._bgcolor = bg;
        this._fgcolor = fg;
        Font f = g.getFont();
        g.setFont(this._font);
        FontMetrics metrics = g.getFontMetrics();
        this._strwidth = metrics.stringWidth(txt);
        this._a = metrics.getAscent();
        this._d = metrics.getDescent();
        this._h = this._a + this._d;
        this._w = metrics.stringWidth(this._text);
        g.setFont(f);
    }

    public abstract LocalRect getBounds();

    public abstract void draw(Graphics var1);

    public boolean intersects(MapTextObject textobj) {
        return false;
    }
}

