/*
 * Decompiled with CFR 0.152.
 */
package hec.map;

import hec.map.ButtonGifStrings;
import hec.map.MapPanel;
import hec.map.MapToolSet;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.Graphics;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.IllegalComponentStateException;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.Point;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ContainerEvent;
import java.awt.event.ContainerListener;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.MouseEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.awt.event.WindowListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.ArrayList;
import java.util.List;
import javax.swing.AbstractButton;
import javax.swing.ButtonGroup;
import javax.swing.ImageIcon;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JPanel;
import javax.swing.JRootPane;
import javax.swing.JToggleButton;
import javax.swing.JToolBar;
import javax.swing.RootPaneContainer;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.event.MouseInputListener;
import javax.swing.plaf.UIResource;
import rma.swing.RmaImage;
import rma.swing.RmaInsets;

public class MapToolPanel
extends JPanel {
    static Insets _zeroInsets = new Insets(0, 0, 0, 0);
    MapPanel _mapPanel = null;
    SymAction _lSymAction;
    GridBagLayout _gridbag = new GridBagLayout();
    ButtonGroup _group = new ButtonGroup();
    List<JToggleButton> _buttonVector = new ArrayList<JToggleButton>();
    List<ButtonGifStrings> _buttonGifVector = new ArrayList<ButtonGifStrings>();
    int _selectedButton = -1;
    protected Color dockingColor = null;
    protected Color floatingColor = null;
    protected Color dockingBorderColor = null;
    protected Color floatingBorderColor = null;
    Handler handler;
    protected MouseInputListener dockingListener;
    protected PropertyChangeListener propertyListener;
    protected ContainerListener toolBarContListener;
    protected FocusListener toolBarFocusListener;
    List<MapToolSet> mapToolSetCache = new ArrayList<MapToolSet>();
    int orientation = 1;
    int dockingSensitivity;
    DragWindow dragWindow;
    MapToolPanel toolBar = this;
    private RootPaneContainer floatingToolBar;
    private Container dockingSource;
    boolean floating = false;
    int floatingX;
    int floatingY;
    protected String constraintBeforeFloating = "North";

    public MapToolPanel(MapPanel panel) {
        this._mapPanel = panel;
        this.setLayout(null);
        this.setSize(this.getInsets().left + this.getInsets().right + 430, this.getInsets().top + this.getInsets().bottom + 270);
        this.setLayout(this._gridbag);
        this._lSymAction = new SymAction();
        if (this.dockingColor == null || this.dockingColor instanceof UIResource) {
            this.dockingColor = UIManager.getColor("ToolBar.dockingBackground");
        }
        if (this.floatingColor == null || this.floatingColor instanceof UIResource) {
            this.floatingColor = UIManager.getColor("ToolBar.floatingBackground");
        }
        if (this.dockingBorderColor == null || this.dockingBorderColor instanceof UIResource) {
            this.dockingBorderColor = UIManager.getColor("ToolBar.dockingForeground");
        }
        if (this.floatingBorderColor == null || this.floatingBorderColor instanceof UIResource) {
            this.floatingBorderColor = UIManager.getColor("ToolBar.floatingForeground");
        }
        this.dockingListener = this.createDockingListener();
        if (this.dockingListener != null) {
            this.toolBar.addMouseMotionListener(this.dockingListener);
            this.toolBar.addMouseListener(this.dockingListener);
        }
        this.propertyListener = this.createPropertyListener();
        if (this.propertyListener != null) {
            this.toolBar.addPropertyChangeListener(this.propertyListener);
        }
        this.toolBarContListener = this.createToolBarContListener();
        if (this.toolBarContListener != null) {
            this.toolBar.addContainerListener(this.toolBarContListener);
        }
        this.toolBarFocusListener = this.createToolBarFocusListener();
    }

    public void removeMapTools(MapToolSet set) {
        int cnt = this.getComponentCount();
        this.mapToolSetCache.remove(set);
        if (cnt > 0) {
            for (int i = 0; i < cnt; ++i) {
                GridBagConstraints gbc;
                MapToolSetPanel panel;
                Component c2 = this.getComponent(i);
                if (!(c2 instanceof MapToolSetPanel) || (panel = (MapToolSetPanel)c2).getMapToolSet() != set) continue;
                this.remove(panel);
                panel.cleanTools();
                cnt = this.getComponentCount();
                if (cnt > 0 && (gbc = this._gridbag.getConstraints(c2 = this.getComponent(cnt - 1))) != null) {
                    gbc.weighty = 1.0;
                    this._gridbag.setConstraints(c2, gbc);
                }
                this._mapPanel.revalidate();
                return;
            }
        }
    }

    public void addMapTools(MapToolSet set) {
        Component c2;
        GridBagConstraints gbc;
        if (set == null) {
            return;
        }
        if (this.mapToolSetCache.contains(set)) {
            return;
        }
        this.mapToolSetCache.add(set);
        MapToolSetPanel panel = new MapToolSetPanel(set);
        int cnt = this.getComponentCount();
        if (cnt > 0 && (gbc = this._gridbag.getConstraints(c2 = this.getComponent(cnt - 1))) != null) {
            gbc.weighty = 0.0;
            this._gridbag.setConstraints(c2, gbc);
        }
        gbc = new GridBagConstraints();
        if (this.orientation == 1) {
            gbc.gridx = 0;
            gbc.gridy = -1;
            gbc.weightx = 0.0;
            gbc.weighty = 1.0;
            gbc.anchor = 11;
            gbc.fill = 0;
            gbc.insets = RmaInsets.insets(10, 0, 0, 0);
        } else {
            gbc.gridx = -1;
            gbc.gridy = 0;
            gbc.weightx = 1.0;
            gbc.weighty = 0.0;
            gbc.anchor = 17;
            gbc.fill = 0;
            gbc.insets = RmaInsets.insets(0, 10, 0, 0);
        }
        this.add((Component)panel, gbc);
        this._mapPanel.revalidate();
    }

    public void addToolButton(JToggleButton button, ButtonGifStrings bgstr) {
        Component c2;
        GridBagConstraints gbc;
        int cnt = this.getComponentCount();
        if (cnt > 0 && (gbc = this._gridbag.getConstraints(c2 = this.getComponent(cnt - 1))) != null) {
            if (this.orientation == 1) {
                gbc.weighty = 0.0;
            } else {
                gbc.weightx = 0.0;
            }
            this._gridbag.setConstraints(c2, gbc);
        }
        gbc = new GridBagConstraints();
        if (this.orientation == 1) {
            gbc.gridx = 0;
            gbc.gridy = -1;
            gbc.weightx = 0.0;
            gbc.weighty = 1.0;
            gbc.anchor = 11;
            gbc.fill = 0;
        } else {
            gbc.gridx = -1;
            gbc.gridy = 0;
            gbc.weightx = 1.0;
            gbc.weighty = 0.0;
            gbc.anchor = 17;
            gbc.fill = 0;
        }
        gbc.insets = new Insets(0, 0, 0, 0);
        this.addToolButton(button, bgstr, gbc);
    }

    public void addToolButton(JToggleButton button, ButtonGifStrings bgstr, GridBagConstraints gbc) {
        this.addToolButton(button, bgstr, gbc, this);
    }

    private void addToolButton(JToggleButton button, ButtonGifStrings bgstr, GridBagConstraints gbc, JPanel panel) {
        ImageIcon ii;
        button.setRolloverEnabled(true);
        try {
            ii = RmaImage.getImageIcon(bgstr.over);
            button.setRolloverIcon(ii);
        }
        catch (Exception e) {
            System.out.println("MapToolPanel.addToolButton: bad URL " + bgstr.over + " " + e);
        }
        try {
            ii = RmaImage.getImageIcon(bgstr.down);
            button.setSelectedIcon(ii);
        }
        catch (Exception e) {
            System.out.println("MapToolPanel.addToolButton: bad URL " + bgstr.down + " " + e);
        }
        try {
            ii = RmaImage.getImageIcon(bgstr.up);
            button.setIcon(ii);
        }
        catch (Exception e) {
            System.out.println("MapToolPanel.addToolButton: bad URL " + bgstr.up + " " + e);
        }
        button.setMargin(_zeroInsets);
        button.setBorderPainted(bgstr.borderPainted);
        if (bgstr.toolTipText != null) {
            button.setToolTipText(bgstr.toolTipText);
        }
        boolean enabled = this.isEnabled() && bgstr.enabled;
        button.setEnabled(enabled);
        panel.add((Component)button, gbc);
        this._group.add(button);
        this._buttonVector.add(button);
        button.addActionListener(this._lSymAction);
        this._buttonGifVector.add(bgstr);
    }

    public int getSelectedButton() {
        return this._selectedButton;
    }

    public void forceSelectButton(int idx) {
        this._selectedButton = -1;
        this.selectButton(idx);
    }

    public void selectButton(int idx) {
        JToggleButton button;
        if (this._selectedButton == idx) {
            return;
        }
        try {
            if (this._selectedButton >= 0) {
                button = this._buttonVector.get(this._selectedButton);
                ButtonGifStrings buttonGifStrings = this._buttonGifVector.get(this._selectedButton);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        int oldSelectedButton = this._selectedButton;
        this._selectedButton = idx;
        try {
            button = this._buttonVector.get(this._selectedButton);
            ButtonGifStrings bgstr = this._buttonGifVector.get(this._selectedButton);
            if (button.isEnabled()) {
                button.doClick();
            } else {
                button.setSelected(true);
            }
            if (!this._mapPanel.setMouseAdapter(bgstr.adapter)) {
                this._selectedButton = oldSelectedButton;
            }
        }
        catch (Exception e) {
            System.out.println("selectButton:exception " + e);
        }
    }

    protected void miButton_Action(ActionEvent event) {
        Object object = event.getSource();
        for (int i = 0; i < this._buttonVector.size(); ++i) {
            if (object != this._buttonVector.get(i)) continue;
            this.selectButton(i);
            break;
        }
    }

    public void setToolEnabled(Class buttonGifStringClass, boolean enabled) {
        int cnt = this._buttonGifVector.size();
        for (int i = 0; i < cnt; ++i) {
            ButtonGifStrings bgs = this._buttonGifVector.get(i);
            if (!buttonGifStringClass.isInstance(bgs)) continue;
            Component c2 = this._buttonVector.get(i);
            c2.setEnabled(enabled);
        }
    }

    @Override
    public void setEnabled(boolean b) {
        int size = this._buttonVector.size();
        for (int i = 0; i < size; ++i) {
            JComponent comp = this._buttonVector.get(i);
            if (b && comp instanceof EnabledJToggleButton) {
                EnabledJToggleButton btn = (EnabledJToggleButton)comp;
                if (!btn.canEnable()) continue;
                btn.setEnabled(b);
                continue;
            }
            comp.setEnabled(b);
        }
    }

    public void removeToolButton(ButtonGifStrings tool) {
        if (tool == null) {
            return;
        }
        this.removeToolButton(tool, this);
    }

    private void removeToolButton(ButtonGifStrings tool, JPanel panel) {
        int size = this._buttonGifVector.size();
        for (int i = 0; i < size; ++i) {
            Component c2;
            GridBagConstraints gbc;
            ButtonGifStrings buttonTool = this._buttonGifVector.get(i);
            GridBagLayout gridbag = (GridBagLayout)panel.getLayout();
            if (buttonTool != tool && !buttonTool.adapter.equals(tool.adapter)) continue;
            if (i == size - 1 && i - 1 >= 0 && i - 1 < this.getComponentCount() && (gbc = gridbag.getConstraints(c2 = this.getComponent(i - 1))) != null) {
                if (this.orientation == 1) {
                    gbc.weighty = 1.0;
                    gbc.weightx = 0.0;
                } else {
                    gbc.weightx = 1.0;
                    gbc.weighty = 0.0;
                }
                gridbag.setConstraints(c2, gbc);
            }
            AbstractButton button = this._buttonVector.get(i);
            panel.remove(button);
            this._group.remove(button);
            button.removeActionListener(this._lSymAction);
            this._buttonGifVector.remove(buttonTool);
            this._buttonVector.remove(button);
            if (this.getSelectedButton() == i) {
                this.selectButton(0);
            }
            this.repaint();
            break;
        }
    }

    public JToggleButton findToolButtonFor(String classname) {
        if (classname == null || classname.length() == 0) {
            return null;
        }
        int size = this._buttonGifVector.size();
        for (int i = 0; i < size; ++i) {
            ButtonGifStrings bgs = this._buttonGifVector.get(i);
            if (bgs == null || !classname.equals(bgs.adapter)) continue;
            return this._buttonVector.get(i);
        }
        return null;
    }

    public int findToolButtonIndex(String classname) {
        if (classname == null || classname.length() == 0) {
            return -1;
        }
        int size = this._buttonGifVector.size();
        for (int i = 0; i < size; ++i) {
            ButtonGifStrings bgs = this._buttonGifVector.get(i);
            if (bgs == null || !classname.equals(bgs.adapter)) continue;
            return i;
        }
        return -1;
    }

    public int getToolButtonCount() {
        return this._buttonVector.size();
    }

    public JToggleButton getToolButton(int idx) {
        if (idx >= this.getToolButtonCount() || idx < 0) {
            return null;
        }
        return this._buttonVector.get(idx);
    }

    public ButtonGifStrings getButtonGifStrings(int idx) {
        if (idx >= this.getToolButtonCount() || idx < 0) {
            return null;
        }
        return this._buttonGifVector.get(idx);
    }

    protected Handler getHandler() {
        if (this.handler == null) {
            this.handler = new Handler();
        }
        return this.handler;
    }

    protected ContainerListener createToolBarContListener() {
        return this.getHandler();
    }

    protected FocusListener createToolBarFocusListener() {
        return this.getHandler();
    }

    protected MouseInputListener createDockingListener() {
        if (this.getHandler() != null) {
            this.getHandler().mapToolPanel = this.toolBar;
        }
        return this.getHandler();
    }

    protected PropertyChangeListener createPropertyListener() {
        return this.getHandler();
    }

    public int getOrientation() {
        return this.orientation;
    }

    public void setOrientation(int orientation) {
        this.orientation = orientation;
        Component[] components = this.getComponents();
        Object prevComponent = null;
        if (components != null && components.length > 0) {
            int currentWidth = this.getWidth();
            int currentHeight = this.getHeight();
            this.removeAll();
            int totalWidth = 0;
            int totalHeight = 0;
            for (int i = 0; i < components.length; ++i) {
                GridBagConstraints gbc = new GridBagConstraints();
                Insets insets = new Insets(0, 0, 0, 0);
                if (components[i] instanceof MapToolSetPanel || components[i] instanceof JToggleButton && prevComponent instanceof MapToolSetPanel) {
                    Insets insets2 = insets = orientation == 1 ? new Insets(10, 0, 0, 0) : new Insets(0, 10, 0, 0);
                }
                if (components[i] instanceof MapToolSetPanel) {
                    ((MapToolSetPanel)components[i]).setOrientation(orientation);
                }
                gbc.insets = insets;
                totalWidth += components[i].getWidth();
                totalHeight = components[i].getHeight();
                if (orientation == 1) {
                    int numCols;
                    gbc.gridx = numCols = 0;
                    gbc.gridy = -1;
                    gbc.weightx = 0.0;
                    gbc.weighty = i == components.length - 1 ? 1.0 : 0.0;
                    gbc.anchor = 11;
                    gbc.fill = 0;
                } else {
                    int numRows = 0;
                    gbc.gridx = -1;
                    gbc.gridy = numRows;
                    gbc.weightx = i == components.length - 1 ? 1.0 : 0.0;
                    gbc.weighty = 0.0;
                    gbc.anchor = 17;
                    gbc.fill = 0;
                }
                this.add(components[i], gbc);
            }
        }
        if (this.dragWindow != null) {
            this.dragWindow.setOrientation(orientation);
        }
    }

    private int mapConstraintToOrientation(String constraint) {
        int orientation = this.toolBar.getOrientation();
        if (constraint != null) {
            if (constraint.equals("East") || constraint.equals("West")) {
                orientation = 1;
            } else if (constraint.equals("North") || constraint.equals("South")) {
                orientation = 0;
            }
        }
        return orientation;
    }

    public Color getDockingColor() {
        return this.dockingColor;
    }

    public void setDockingColor(Color c2) {
        this.dockingColor = c2;
    }

    public Color getFloatingColor() {
        return this.floatingColor;
    }

    private boolean isBlocked(Component comp, Object constraint) {
        Container cont;
        LayoutManager lm;
        if (comp instanceof Container && (lm = (cont = (Container)comp).getLayout()) instanceof BorderLayout) {
            BorderLayout blm = (BorderLayout)lm;
            Component c2 = blm.getLayoutComponent(cont, constraint);
            return c2 != null && c2 != this.toolBar;
        }
        return false;
    }

    public boolean canDock(Component c2, Point p) {
        return p != null && this.getDockingConstraint(c2, p) != null;
    }

    private String getDockingConstraint(Component c2, Point p) {
        if (p == null) {
            return this.constraintBeforeFloating;
        }
        if (c2.contains(p)) {
            int n = this.dockingSensitivity = this.toolBar.getOrientation() == 0 ? this.toolBar.getSize().height : this.toolBar.getSize().width;
            if (p.y < this.dockingSensitivity && !this.isBlocked(c2, "North")) {
                return "North";
            }
            if (p.x >= c2.getWidth() - this.dockingSensitivity && !this.isBlocked(c2, "East")) {
                return "East";
            }
            if (p.x < this.dockingSensitivity && !this.isBlocked(c2, "West")) {
                return "West";
            }
            if (p.y >= c2.getHeight() - this.dockingSensitivity && !this.isBlocked(c2, "South")) {
                return "South";
            }
        }
        return null;
    }

    protected void dragTo(Point position, Point origin) {
        try {
            Point offset;
            if (this.dragWindow == null) {
                this.dragWindow = this.createDragWindow(this.toolBar);
            }
            if ((offset = this.dragWindow.getOffset()) == null) {
                Dimension size = this.toolBar.getPreferredSize();
                offset = new Point(size.width / 2, size.height / 2);
                this.dragWindow.setOffset(offset);
            }
            Point global = new Point(origin.x + position.x, origin.y + position.y);
            Point dragPoint = new Point(global.x - offset.x, global.y - offset.y);
            if (this.dockingSource == null) {
                this.dockingSource = this.toolBar.getParent();
            }
            this.constraintBeforeFloating = this.calculateConstraint();
            Point dockingPosition = this.dockingSource.getLocationOnScreen();
            Point comparisonPoint = new Point(global.x - dockingPosition.x, global.y - dockingPosition.y);
            if (this.canDock(this.dockingSource, comparisonPoint)) {
                this.dragWindow.setBackground(this.getDockingColor());
                String constraint = this.getDockingConstraint(this.dockingSource, comparisonPoint);
                int orientation = this.mapConstraintToOrientation(constraint);
                this.dragWindow.setOrientation(orientation);
                this.dragWindow.setBorderColor(this.dockingBorderColor);
            } else {
                this.dragWindow.setBackground(this.getFloatingColor());
                this.dragWindow.setBorderColor(this.floatingBorderColor);
            }
            this.dragWindow.setLocation(dragPoint.x, dragPoint.y);
            if (!this.dragWindow.isVisible()) {
                Dimension size = this.toolBar.getPreferredSize();
                this.dragWindow.setSize(size.width, size.height);
                this.dragWindow.show();
            }
        }
        catch (IllegalComponentStateException illegalComponentStateException) {
            // empty catch block
        }
    }

    protected DragWindow createDragWindow(MapToolPanel toolbar) {
        Window frame = null;
        if (this.toolBar != null) {
            Container p;
            for (p = this.toolBar.getParent(); p != null && !(p instanceof Window); p = p.getParent()) {
            }
            if (p != null && p instanceof Window) {
                frame = (Window)p;
            }
        }
        if (this.floatingToolBar == null) {
            this.floatingToolBar = this.createFloatingWindow(this.toolBar);
        }
        if (this.floatingToolBar instanceof Window) {
            frame = (Window)((Object)this.floatingToolBar);
        }
        DragWindow dragWindow = new DragWindow(frame);
        return dragWindow;
    }

    protected RootPaneContainer createFloatingWindow(MapToolPanel toolbar) {
        Window window = SwingUtilities.getWindowAncestor(toolbar);
        class ToolBarDialog
        extends JDialog {
            public ToolBarDialog(Frame owner, String title, boolean modal) {
                super(owner, title, modal);
            }

            public ToolBarDialog(Dialog owner, String title, boolean modal) {
                super(owner, title, modal);
            }

            @Override
            protected JRootPane createRootPane() {
                JRootPane rootPane = new JRootPane(){
                    private boolean packing = false;

                    @Override
                    public void validate() {
                        super.validate();
                        if (!this.packing) {
                            this.packing = true;
                            this.pack();
                            this.packing = false;
                        }
                    }
                };
                rootPane.setOpaque(true);
                return rootPane;
            }
        }
        ToolBarDialog dialog = window instanceof Frame ? new ToolBarDialog((Frame)window, toolbar.getName(), false) : (window instanceof Dialog ? new ToolBarDialog((Dialog)window, toolbar.getName(), false) : new ToolBarDialog((Frame)null, toolbar.getName(), false));
        dialog.getRootPane().setName("ToolBar.FloatingWindow");
        dialog.setTitle(toolbar.getName());
        WindowListener wl = this.createFrameListener();
        dialog.addWindowListener(wl);
        return dialog;
    }

    protected DragWindow createDragWindow() {
        Window frame = null;
        if (this.toolBar != null) {
            Container p;
            for (p = this.toolBar.getParent(); p != null && !(p instanceof Window); p = p.getParent()) {
            }
            if (p != null && p instanceof Window) {
                frame = (Window)p;
            }
        }
        if (this.floatingToolBar == null) {
            this.floatingToolBar = this.createFloatingWindow(this.toolBar);
        }
        if (this.floatingToolBar instanceof Window) {
            frame = (Window)((Object)this.floatingToolBar);
        }
        DragWindow dragWindow = new DragWindow(frame);
        return dragWindow;
    }

    protected void paintDragWindow(Graphics g) {
        g.setColor(this.dragWindow.getBackground());
        int w = this.dragWindow.getWidth();
        int h = this.dragWindow.getHeight();
        g.fillRect(0, 0, w, h);
        g.setColor(this.dragWindow.getBorderColor());
        g.drawRect(0, 0, w - 1, h - 1);
    }

    protected WindowListener createFrameListener() {
        return new FrameListener();
    }

    protected void floatAt(Point position, Point origin) {
        try {
            Point offset = this.dragWindow.getOffset();
            if (offset == null) {
                offset = position;
                this.dragWindow.setOffset(offset);
            }
            Point global = new Point(origin.x + position.x, origin.y + position.y);
            this.setFloatingLocation(global.x - offset.x, global.y - offset.y);
            if (this.dockingSource != null) {
                Point dockingPosition = this.dockingSource.getLocationOnScreen();
                Point comparisonPoint = new Point(global.x - dockingPosition.x, global.y - dockingPosition.y);
                if (this.canDock(this.dockingSource, comparisonPoint)) {
                    this.setFloating(false, comparisonPoint);
                } else {
                    this.setFloating(true, null);
                }
            } else {
                this.setFloating(true, null);
            }
            this.dragWindow.setOffset(null);
        }
        catch (IllegalComponentStateException illegalComponentStateException) {
            // empty catch block
        }
    }

    public void setFloatingLocation(int x, int y) {
        this.floatingX = x;
        this.floatingY = y;
    }

    public boolean isFloating() {
        return this.floating;
    }

    protected void setFloating(boolean b, Point p) {
        boolean visible = false;
        Window ancestor = SwingUtilities.getWindowAncestor(this.toolBar);
        if (ancestor != null) {
            visible = ancestor.isVisible();
        }
        if (this.dragWindow != null) {
            this.dragWindow.setVisible(false);
        }
        this.floating = b;
        if (this.floatingToolBar == null) {
            this.floatingToolBar = this.createFloatingWindow(this.toolBar);
        }
        if (b) {
            if (this.dockingSource == null) {
                this.dockingSource = this.toolBar.getParent();
                this.dockingSource.remove(this.toolBar);
            }
            this.constraintBeforeFloating = this.calculateConstraint();
            if (this.propertyListener != null) {
                UIManager.addPropertyChangeListener(this.propertyListener);
            }
            this.floatingToolBar.getContentPane().add((Component)this.toolBar, "Center");
            if (this.floatingToolBar instanceof Window) {
                ((Window)((Object)this.floatingToolBar)).pack();
                ((Window)((Object)this.floatingToolBar)).setLocation(this.floatingX, this.floatingY);
                if (visible) {
                    ((Window)((Object)this.floatingToolBar)).show();
                } else {
                    ancestor.addWindowListener(new WindowAdapter(){

                        @Override
                        public void windowOpened(WindowEvent e) {
                            ((Window)((Object)MapToolPanel.this.floatingToolBar)).show();
                        }
                    });
                }
            }
        } else {
            if (this.floatingToolBar == null) {
                this.floatingToolBar = this.createFloatingWindow(this.toolBar);
            }
            if (this.floatingToolBar instanceof Window) {
                ((Window)((Object)this.floatingToolBar)).setVisible(false);
            }
            this.floatingToolBar.getContentPane().remove(this.toolBar);
            String constraint = this.getDockingConstraint(this.dockingSource, p);
            if (constraint == null) {
                constraint = "North";
            }
            int orientation = this.mapConstraintToOrientation(constraint);
            this.setOrientation(orientation);
            if (this.dockingSource == null) {
                this.dockingSource = this.toolBar.getParent();
            }
            if (this.propertyListener != null) {
                UIManager.removePropertyChangeListener(this.propertyListener);
            }
            this.dockingSource.add(constraint, this.toolBar);
        }
        this.dockingSource.invalidate();
        Container dockingSourceParent = this.dockingSource.getParent();
        if (dockingSourceParent != null) {
            dockingSourceParent.validate();
        }
        this.dockingSource.repaint();
    }

    private String calculateConstraint() {
        String constraint = null;
        LayoutManager lm = this.dockingSource.getLayout();
        if (lm instanceof BorderLayout) {
            constraint = (String)((BorderLayout)lm).getConstraints(this.toolBar);
        }
        return constraint != null ? constraint : this.constraintBeforeFloating;
    }

    private class SymAction
    implements ActionListener {
        private SymAction() {
        }

        @Override
        public void actionPerformed(ActionEvent event) {
            Object object = event.getSource();
            if (object instanceof JToggleButton) {
                MapToolPanel.this.miButton_Action(event);
            }
        }
    }

    public class MapToolSetPanel
    extends JPanel {
        private MapToolSet _toolSet;

        MapToolSetPanel(MapToolSet toolSet) {
            super(new GridBagLayout());
            this._toolSet = toolSet;
            this.addTools();
        }

        private void addTools() {
            GridBagConstraints gbc = new GridBagConstraints();
            if (MapToolPanel.this.orientation == 1) {
                gbc.gridx = 0;
                gbc.gridy = -1;
                gbc.weightx = 0.0;
                gbc.weighty = 0.0;
                gbc.anchor = 11;
                gbc.fill = 0;
                gbc.insets = RmaInsets.insets(0, 0, 0, 0);
            } else {
                gbc.gridx = -1;
                gbc.gridy = 0;
                gbc.weightx = 0.0;
                gbc.weighty = 0.0;
                gbc.anchor = 17;
                gbc.fill = 0;
                gbc.insets = RmaInsets.insets(0, 0, 0, 0);
            }
            List tools = this._toolSet.getMapTools();
            for (int i = 0; i < tools.size(); ++i) {
                ButtonGifStrings bgstr = (ButtonGifStrings)tools.get(i);
                EnabledJToggleButton button = new EnabledJToggleButton();
                button.setCanEnable(bgstr.enabled);
                MapToolPanel.this.addToolButton(new EnabledJToggleButton(), bgstr, gbc, this);
            }
        }

        void cleanTools() {
            List tools = this._toolSet.getMapTools();
            for (int i = 0; i < tools.size(); ++i) {
                ButtonGifStrings bgstr = (ButtonGifStrings)tools.get(i);
                MapToolPanel.this.removeToolButton(bgstr, MapToolPanel.this);
            }
        }

        public MapToolSet getMapToolSet() {
            return this._toolSet;
        }

        private void setOrientation(int orientation) {
            this.removeAll();
            this.addTools();
        }
    }

    public class EnabledJToggleButton
    extends JToggleButton {
        private boolean _canEnable;

        public boolean canEnable() {
            return this._canEnable;
        }

        public void setCanEnable(boolean enable) {
            this._canEnable = enable;
        }

        @Override
        public String getToolTipText(MouseEvent e) {
            ButtonGifStrings bgstr;
            int idx;
            if (e.isAltDown() && e.isControlDown() && e.isShiftDown() && (idx = MapToolPanel.this._buttonVector.indexOf(this)) > -1 && (bgstr = MapToolPanel.this._buttonGifVector.get(idx)) != null) {
                return bgstr.paramString();
            }
            return super.getToolTipText(e);
        }
    }

    protected class Handler
    implements ContainerListener,
    FocusListener,
    MouseInputListener,
    PropertyChangeListener {
        MapToolPanel mapToolPanel;
        boolean isDragging = false;
        Point origin = null;

        protected Handler() {
        }

        @Override
        public void componentAdded(ContainerEvent evt) {
            Component c2 = evt.getChild();
        }

        @Override
        public void componentRemoved(ContainerEvent evt) {
            Component c2 = evt.getChild();
        }

        @Override
        public void focusGained(FocusEvent evt) {
            Component c2 = evt.getComponent();
        }

        @Override
        public void focusLost(FocusEvent evt) {
        }

        @Override
        public void mousePressed(MouseEvent evt) {
            if (!this.mapToolPanel.isEnabled()) {
                return;
            }
            this.isDragging = false;
        }

        @Override
        public void mouseReleased(MouseEvent evt) {
            if (!this.mapToolPanel.isEnabled()) {
                return;
            }
            if (this.isDragging) {
                Point position = evt.getPoint();
                if (this.origin == null) {
                    this.origin = evt.getComponent().getLocationOnScreen();
                }
                MapToolPanel.this.floatAt(position, this.origin);
            }
            this.origin = null;
            this.isDragging = false;
        }

        @Override
        public void mouseDragged(MouseEvent evt) {
            if (!this.mapToolPanel.isEnabled()) {
                return;
            }
            this.isDragging = true;
            Point position = evt.getPoint();
            if (this.origin == null) {
                this.origin = evt.getComponent().getLocationOnScreen();
            }
            MapToolPanel.this.dragTo(position, this.origin);
        }

        @Override
        public void mouseClicked(MouseEvent evt) {
        }

        @Override
        public void mouseEntered(MouseEvent evt) {
        }

        @Override
        public void mouseExited(MouseEvent evt) {
        }

        @Override
        public void mouseMoved(MouseEvent evt) {
        }

        @Override
        public void propertyChange(PropertyChangeEvent evt) {
            String propertyName = evt.getPropertyName();
            if (propertyName == "lookAndFeel") {
                this.mapToolPanel.updateUI();
            } else if (propertyName == "orientation") {
                Component[] components = this.mapToolPanel.getComponents();
                int orientation = (Integer)evt.getNewValue();
                for (int i = 0; i < components.length; ++i) {
                    if (!(components[i] instanceof JToolBar.Separator)) continue;
                    JToolBar.Separator separator = (JToolBar.Separator)components[i];
                    if (orientation == 0) {
                        separator.setOrientation(1);
                    } else {
                        separator.setOrientation(0);
                    }
                    Dimension size = separator.getSeparatorSize();
                    if (size == null || size.width == size.height) continue;
                    Dimension newSize = new Dimension(size.height, size.width);
                    separator.setSeparatorSize(newSize);
                }
            }
        }
    }

    protected class DragWindow
    extends Window {
        Color borderColor;
        int orientation;
        Point offset;

        DragWindow(Window w) {
            super(w);
            this.borderColor = Color.gray;
            this.orientation = MapToolPanel.this.toolBar.getOrientation();
        }

        public void setOrientation(int o) {
            if (this.isShowing()) {
                if (o == this.orientation) {
                    return;
                }
                this.orientation = o;
                Dimension size = this.getSize();
                this.setSize(new Dimension(size.height, size.width));
                if (this.offset != null) {
                    if (o == 0) {
                        this.setOffset(new Point(size.height - this.offset.y, this.offset.x));
                    } else {
                        this.setOffset(new Point(this.offset.y, size.width - this.offset.x));
                    }
                }
                this.repaint();
            }
        }

        public Point getOffset() {
            return this.offset;
        }

        public void setOffset(Point p) {
            this.offset = p;
        }

        public void setBorderColor(Color c2) {
            if (this.borderColor == c2) {
                return;
            }
            this.borderColor = c2;
            this.repaint();
        }

        public Color getBorderColor() {
            return this.borderColor;
        }

        @Override
        public void paint(Graphics g) {
            MapToolPanel.this.paintDragWindow(g);
            super.paint(g);
        }

        @Override
        public Insets getInsets() {
            return new Insets(1, 1, 1, 1);
        }
    }

    protected class FrameListener
    extends WindowAdapter {
        protected FrameListener() {
        }

        @Override
        public void windowClosing(WindowEvent w) {
            if (MapToolPanel.this.dragWindow != null) {
                MapToolPanel.this.dragWindow.setVisible(false);
            }
            MapToolPanel.this.floating = false;
            if (MapToolPanel.this.floatingToolBar == null) {
                MapToolPanel.this.floatingToolBar = MapToolPanel.this.createFloatingWindow(MapToolPanel.this.toolBar);
            }
            if (MapToolPanel.this.floatingToolBar instanceof Window) {
                ((Window)((Object)MapToolPanel.this.floatingToolBar)).setVisible(false);
            }
            MapToolPanel.this.floatingToolBar.getContentPane().remove(MapToolPanel.this.toolBar);
            String constraint = MapToolPanel.this.constraintBeforeFloating;
            if (MapToolPanel.this.toolBar.getOrientation() == 0) {
                if (constraint == "West" || constraint == "East") {
                    constraint = "North";
                }
            } else if (constraint == "North" || constraint == "South") {
                constraint = "West";
            }
            if (MapToolPanel.this.dockingSource == null) {
                MapToolPanel.this.dockingSource = MapToolPanel.this.toolBar.getParent();
            }
            if (MapToolPanel.this.propertyListener != null) {
                UIManager.removePropertyChangeListener(MapToolPanel.this.propertyListener);
            }
            MapToolPanel.this.dockingSource.add((Component)MapToolPanel.this.toolBar, constraint);
            MapToolPanel.this.dockingSource.invalidate();
            Container dockingSourceParent = MapToolPanel.this.dockingSource.getParent();
            if (dockingSourceParent != null) {
                dockingSourceParent.validate();
            }
            MapToolPanel.this.dockingSource.repaint();
        }
    }
}

