/*
 * Decompiled with CFR 0.152.
 */
package hec.map;

import hec.map.ModelDrawingAttributeSet;
import hec.map.ModelDrawingAttributeSetFactory;
import java.util.Enumeration;
import java.util.Hashtable;

public class ModeDrawingAttributeSet {
    public static final String RSS_MODEL = "ResSim";
    public static final String RESPRM_MODEL = "ResPRM";
    public static final String FIA_MODEL = "FIA";
    public static final String RAS_MODEL = "RAS";
    public static final String GRID_UTIL_MODEL = "Gridded Data";
    public static final String GRID_UTIL_MODEL2 = "Single Grid";
    public static final String STREAM_ALIGNMENT_MODEL = "Stream Alignment";
    public static final String TSLOCATION_MODEL = "Time Series Icons";
    public static final String STUDY_MODEL = "Study";
    public static final String RMA_MODEL = "RMA";
    public static final String HEC5Q_MODEL = "HEC5Q";
    public static final String RMA11_MODEL = "RMA11";
    public static final String RMA2_MODEL = "RMA2";
    public static final String GLM_MODEL = "Great Lakes";
    private static Hashtable _modeAttributeSets = new Hashtable();
    private Hashtable _modelAttributesSet = new Hashtable();

    public static ModeDrawingAttributeSet getModeAttributeSet(String modeName) {
        if (modeName == null || modeName.length() < 1) {
            return null;
        }
        ModeDrawingAttributeSet set = (ModeDrawingAttributeSet)_modeAttributeSets.get(modeName = modeName.toUpperCase());
        if (set == null) {
            set = new ModeDrawingAttributeSet();
            _modeAttributeSets.put(modeName, set);
        }
        return set;
    }

    public ModelDrawingAttributeSet getModelAttributeSet(String model) {
        if (model == null || model.length() < 1) {
            return null;
        }
        ModelDrawingAttributeSet set = (ModelDrawingAttributeSet)this._modelAttributesSet.get(model = model.toLowerCase());
        if (set == null && (set = ModelDrawingAttributeSetFactory.newAttributeSet(model)) != null) {
            this._modelAttributesSet.put(model, set);
        }
        return set;
    }

    public ModelDrawingAttributeSet[] getAttributeSets() {
        Enumeration e = this._modelAttributesSet.elements();
        ModelDrawingAttributeSet[] modelSets = new ModelDrawingAttributeSet[this._modelAttributesSet.size()];
        int i = 0;
        while (e.hasMoreElements()) {
            modelSets[i++] = (ModelDrawingAttributeSet)e.nextElement();
        }
        return modelSets;
    }

    public void saveModelAttributeSet(String model, ModelDrawingAttributeSet modas) {
        if (modas != null) {
            this._modelAttributesSet.put(model, modas);
        }
    }

    public boolean isExistingAttributeSet(String model) {
        return model.equalsIgnoreCase(RSS_MODEL) || model.equalsIgnoreCase(FIA_MODEL) || model.equalsIgnoreCase(RAS_MODEL) || model.equalsIgnoreCase(GRID_UTIL_MODEL) || model.equalsIgnoreCase(GRID_UTIL_MODEL2) || model.equalsIgnoreCase(STREAM_ALIGNMENT_MODEL) || model.equalsIgnoreCase(TSLOCATION_MODEL) || model.equalsIgnoreCase(RMA_MODEL) || model.equalsIgnoreCase(STUDY_MODEL);
    }

    public static void workspaceOpening() {
        Enumeration e = _modeAttributeSets.elements();
        while (e.hasMoreElements()) {
            ModeDrawingAttributeSet set = (ModeDrawingAttributeSet)e.nextElement();
            Enumeration ee = set._modelAttributesSet.elements();
            while (ee.hasMoreElements()) {
                ModelDrawingAttributeSet aset = (ModelDrawingAttributeSet)ee.nextElement();
                aset.workspaceOpening();
            }
        }
    }

    public static void workspaceClosing() {
        Enumeration e = _modeAttributeSets.elements();
        while (e.hasMoreElements()) {
            ModeDrawingAttributeSet set = (ModeDrawingAttributeSet)e.nextElement();
            Enumeration ee = set._modelAttributesSet.elements();
            while (ee.hasMoreElements()) {
                ModelDrawingAttributeSet aset = (ModelDrawingAttributeSet)ee.nextElement();
                aset.workspaceClosing();
            }
        }
    }
}

