/*
 * Decompiled with CFR 0.152.
 */
package hec.map;

import hec.appInterface.AppDaddy;
import hec.event.AttributeAddRemoveListener;
import hec.event.AttributeChangedListener;
import hec.lang.NamedType;
import hec.map.AttributeInfo;
import hec.map.LayerSymbol;
import java.awt.Color;
import java.awt.Component;
import java.awt.Frame;
import java.awt.Graphics;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.EventListener;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.swing.Icon;
import javax.swing.JDialog;
import javax.swing.event.EventListenerList;

public class ModelDrawingAttributeSet
extends NamedType
implements Cloneable {
    public static final String SHOWN = "shown";
    public static final String NAME = "name";
    protected Map<String, Object> _attributes;
    private boolean _shown = true;
    private EventListenerList _listeners = new EventListenerList();
    private JDialog _drawPropDlg;

    public ModelDrawingAttributeSet() {
        this._attributes = this.createAttributesTable();
    }

    public ModelDrawingAttributeSet(String name) {
        this();
        this.setName(name);
    }

    protected Map<String, Object> createAttributesTable() {
        return new Hashtable<String, Object>();
    }

    public Hashtable<String, Boolean> getAttributes() {
        Set<Map.Entry<String, Object>> set = this._attributes.entrySet();
        Iterator<Map.Entry<String, Object>> iter = set.iterator();
        Hashtable<String, Boolean> boolsOnlyCopy = new Hashtable<String, Boolean>(this._attributes.size());
        while (iter.hasNext()) {
            Map.Entry<String, Object> entry = iter.next();
            if (!(entry.getValue() instanceof Boolean)) continue;
            boolsOnlyCopy.put(entry.getKey(), (Boolean)entry.getValue());
        }
        return boolsOnlyCopy;
    }

    public void setAttribute(String att, boolean shown) {
        if (att == null || att.length() < 1) {
            return;
        }
        if (!this.isValidAttribute(att)) {
            throw new IllegalArgumentException(this.getName() + " Invalid attribute name " + att);
        }
        this._attributes.put(att, shown);
        this.fireAttributeChanged(att, shown);
    }

    public void putAttribute(String att, boolean shown) {
        if (att == null || att.length() < 1) {
            return;
        }
        this._attributes.put(att, shown);
        this.fireAttributeChanged(att, shown);
    }

    public boolean hasFixedAttributes() {
        return true;
    }

    public void removeAttribute(String attrName) {
        if (attrName == null || attrName.length() < 1) {
            return;
        }
        if (!this.isValidAttribute(attrName)) {
            throw new IllegalArgumentException(this.getName() + " Invalid attribute name " + attrName);
        }
        this._attributes.remove(attrName);
        this.fireAttributeRemoved(attrName);
    }

    public List<String> getAttributeNames() {
        ArrayList<String> attNames = new ArrayList<String>(this._attributes.size());
        Set<String> set = this._attributes.keySet();
        for (String key : set) {
            attNames.add(key);
        }
        return attNames;
    }

    public boolean isAttributeShown(String att) {
        Object obj = this._attributes.get(att);
        if (obj instanceof Boolean) {
            Boolean b = (Boolean)obj;
            if (b == null) {
                return false;
            }
            return b;
        }
        return true;
    }

    public void setShown(boolean b) {
        this._shown = b;
        this.fireAttributeChanged(SHOWN, b);
    }

    public boolean isShown() {
        return this._shown;
    }

    protected void fireAttributeChanged(String attrName, boolean shown) {
        String name = this.getName();
        Object[] listeners = this._listeners.getListenerList();
        for (int i = listeners.length - 2; i >= 0; i -= 2) {
            if (listeners[i] != AttributeChangedListener.class) continue;
            ((AttributeChangedListener)listeners[i + 1]).attributeChanged(name, attrName, shown);
        }
    }

    protected void fireAttributeAdded(Object attribute) {
        String name = this.getName();
        Object[] listeners = this._listeners.getListenerList();
        for (int i = listeners.length - 2; i >= 0; i -= 2) {
            if (listeners[i] != AttributeAddRemoveListener.class) continue;
            ((AttributeAddRemoveListener)listeners[i + 1]).attributeAdded(name, attribute);
        }
    }

    protected void fireAttributeRemoved(Object attribute) {
        String name = this.getName();
        Object[] listeners = this._listeners.getListenerList();
        for (int i = listeners.length - 2; i >= 0; i -= 2) {
            if (listeners[i] != AttributeAddRemoveListener.class) continue;
            ((AttributeAddRemoveListener)listeners[i + 1]).attributeRemoved(name, attribute);
        }
    }

    public void addAttributeChangedListener(AttributeChangedListener acl) {
        if (!this.containsListener(AttributeChangedListener.class, acl)) {
            this._listeners.add(AttributeChangedListener.class, acl);
        }
    }

    private boolean containsListener(Class cls, AttributeChangedListener acl) {
        EventListener[] listeners = this._listeners.getListeners(cls);
        for (int i = 0; i < listeners.length; ++i) {
            if (listeners[i] != acl) continue;
            return true;
        }
        return false;
    }

    public void removeAttributeChangeListener(AttributeChangedListener acl) {
        this._listeners.remove(AttributeChangedListener.class, acl);
    }

    public void addAttributeAddRemoveListener(AttributeAddRemoveListener aarl) {
        this._listeners.add(AttributeAddRemoveListener.class, aarl);
    }

    public void removeAttributeAddRemoveListener(AttributeAddRemoveListener aarl) {
        this._listeners.remove(AttributeAddRemoveListener.class, aarl);
    }

    public String getDrawPropDialogClassname() {
        return null;
    }

    public JDialog getDrawPropDlg() {
        return this._drawPropDlg;
    }

    public boolean isValidAttribute(String attrName) {
        return this._attributes.get(attrName) != null;
    }

    public void displayDrawPropDialogClass(Frame frame, boolean modal) {
        this.closeDrawPropDialog();
        String dlgCls = this.getDrawPropDialogClassname();
        if (dlgCls == null) {
            return;
        }
        try {
            Class<?> cls = Class.forName(dlgCls);
            Constructor<?>[] ctors = cls.getDeclaredConstructors();
            if (!JDialog.class.isAssignableFrom(cls)) {
                throw new IllegalArgumentException(dlgCls + " doesn't extend JDialog");
            }
            Object[] args = new Object[]{frame, modal};
            for (int i = 0; i < ctors.length; ++i) {
                Class<?>[] ctorParams = ctors[i].getParameterTypes();
                if (ctorParams.length != 2 || ctorParams[0] != Frame.class || ctorParams[1] != Boolean.TYPE) continue;
                this._drawPropDlg = (JDialog)ctors[i].newInstance(args);
                this._drawPropDlg.setVisible(true);
                ((Component)((Object)AppDaddy.getFrame())).repaint();
                return;
            }
            System.out.println("found no constructor in " + dlgCls + " that takes a Frame and a boolean");
        }
        catch (ClassNotFoundException cnfe) {
            System.out.println("class not found " + dlgCls + " " + cnfe);
            return;
        }
        catch (InstantiationException ie) {
            System.out.println("failed to create new " + dlgCls + " " + ie);
            return;
        }
        catch (IllegalAccessException iea) {
            System.out.println("IllegalAccessException " + iea);
            return;
        }
        catch (InvocationTargetException ite) {
            System.out.println("InvocationTargetException creating " + dlgCls + " " + ite.getTargetException());
            ite.getTargetException().printStackTrace();
            return;
        }
    }

    public void closeDrawPropDialog() {
        if (this._drawPropDlg != null && this._drawPropDlg.isVisible()) {
            this._drawPropDlg.setVisible(false);
        }
    }

    public Icon getIcon(String attrName) {
        return null;
    }

    public void workspaceOpening() {
    }

    public void workspaceClosing() {
    }

    public String getNameAttribute() {
        return (String)this._attributes.get(NAME);
    }

    @Override
    public Object clone() {
        try {
            ModelDrawingAttributeSet that = (ModelDrawingAttributeSet)super.clone();
            that._attributes = new Hashtable<String, Object>();
            that._attributes.putAll(this._attributes);
            return that;
        }
        catch (CloneNotSupportedException e) {
            System.out.println("CloneNotSupportedException " + e);
            return null;
        }
    }

    public Object getAttributeValue(String attrName) {
        if (attrName == null) {
            return null;
        }
        return this._attributes.get(attrName);
    }

    public List<AttributeInfo> getAttributeInfo(String attrName) {
        return null;
    }

    protected static class SymbolIcon
    implements Icon {
        protected float size = 15.0f;
        protected Color lineclr = Color.black;
        protected Color fillclr = null;
        protected int symbolType = 0;

        public SymbolIcon(int i) {
            this.symbolType = i;
        }

        @Override
        public void paintIcon(Component c2, Graphics g, int x, int y) {
            LayerSymbol.draw(g, x + 10, y + 10, this.symbolType, this.lineclr, this.fillclr, this.size);
        }

        @Override
        public int getIconWidth() {
            return 25;
        }

        @Override
        public int getIconHeight() {
            return 25;
        }
    }
}

