/*
 * Decompiled with CFR 0.152.
 */
package hec.map;

import hec.map.ModelDrawingAttributeSet;
import java.util.Hashtable;

public class ModelDrawingAttributeSetFactory {
    private static Hashtable<String, String> _attributeSets = new Hashtable();

    public static void addMapping(String model, String attributeSetClass) {
        if (model == null || attributeSetClass == null) {
            return;
        }
        _attributeSets.put(model.toLowerCase(), attributeSetClass);
    }

    public static ModelDrawingAttributeSet newAttributeSet(String modelName) {
        String className = _attributeSets.get(modelName);
        if (className == null) {
            return new ModelDrawingAttributeSet(modelName);
        }
        try {
            Class<?> cls = Thread.currentThread().getContextClassLoader().loadClass(className);
            Object obj = cls.newInstance();
            return (ModelDrawingAttributeSet)obj;
        }
        catch (Exception e) {
            System.out.println("newAttributeSet: Exception creating " + className + " error " + e);
            return new ModelDrawingAttributeSet(modelName);
        }
    }

    static {
        _attributeSets.put("ResSim".toLowerCase(), "hec.rss.client.RssDrawingAttributeSet");
        _attributeSets.put("ResPRM".toLowerCase(), "hec.res.client.ResDrawingAttributeSet");
        _attributeSets.put("FIA".toLowerCase(), "hec.fia.client.FiaDrawingAttributeSet");
        _attributeSets.put("RAS".toLowerCase(), "hec.ras.client.RasDrawingAttributeSet");
        _attributeSets.put("Gridded Data".toLowerCase(), "hec.gridUtil.client.GridDrawingAttributeSet");
        _attributeSets.put("Single Grid".toLowerCase(), "hec.gridUtil.client.SingleGridDrawingAttributeSet");
        _attributeSets.put("Stream Alignment".toLowerCase(), "hec.map.streamAlignment.StreamAlignmentAttributeSet");
        _attributeSets.put("Time Series Icons".toLowerCase(), "hec.dssmapgui.client.DmgTsLocationAttributeSet");
        _attributeSets.put("Study".toLowerCase(), "hec.watershed.client.StudyDrawingAttributeSet");
        _attributeSets.put("Great Lakes".toLowerCase(), "hec.glm.client.GlmDrawingAttributeSet");
    }
}

