/*
 * Decompiled with CFR 0.152.
 */
package hec.map;

import hec.map.ButtonGifStrings;
import hec.map.LocalPt;
import hec.map.MapCanvas;
import hec.map.MapMouseAdapter;
import hec.map.MapPanel;
import hec.map.MapScale;
import hec.map.WorldPt;
import java.awt.Cursor;
import java.awt.Image;
import java.awt.Point;
import java.awt.Toolkit;
import java.awt.event.MouseEvent;
import rma.swing.RmaImage;

public class MousePanAdapter
extends MapMouseAdapter {
    public static final String PAN_DOWN_CURSOR = "PanDownCursor";
    public static final String PAN_UP_CURSOR = "PanUpCursor";
    public static final boolean DEBUG = false;
    static Cursor _panUpCursor;
    static Cursor _panDownCursor;
    boolean _panning = false;
    LocalPt _newPoint = new LocalPt();
    LocalPt _oldPoint = new LocalPt();
    WorldPt _newWorldPoint = new WorldPt();
    WorldPt _oldWorldPoint = new WorldPt();
    WorldPt _newOrigin = new WorldPt();

    MousePanAdapter(MapPanel panel, MapCanvas canvas) {
        super(panel, canvas);
        if (_panDownCursor == null || _panUpCursor == null) {
            Image panDownCursor = RmaImage.loadURLImage("Images/PanDown.gif");
            Image panUpCursor = RmaImage.loadURLImage("Images/PanUp.gif");
            if (panDownCursor != null && panUpCursor != null) {
                _panDownCursor = Toolkit.getDefaultToolkit().createCustomCursor(panDownCursor, new Point(5, 5), PAN_DOWN_CURSOR);
                _panUpCursor = Toolkit.getDefaultToolkit().createCustomCursor(panUpCursor, new Point(5, 5), PAN_UP_CURSOR);
            }
        }
    }

    public static ButtonGifStrings buildDefaultButtonGifStrings() {
        ButtonGifStrings bgstr = new ButtonGifStrings();
        bgstr.up = "Images/Pan.gif";
        bgstr.down = "Images/Pan.gif";
        bgstr.over = "Images/Pan.gif";
        bgstr.on = "Images/Pan.gif";
        bgstr.borderPainted = true;
        bgstr.adapter = MousePanAdapter.class.getName();
        bgstr.toolTipText = "Pan Tool";
        return bgstr;
    }

    @Override
    public synchronized void mouseReleased(MouseEvent e) {
        if (this._mapCanvas != null && this._mapPanel != null && this._panning) {
            this._panning = false;
            this._mapCanvas.setCursor(this.getCursor());
            this._mapPanel.resetScrollbars();
            this._mapPanel.paintMap();
        }
        this.notify();
    }

    @Override
    public synchronized void mousePressed(MouseEvent e) {
        if (this._mapCanvas != null && this._mapPanel != null) {
            this._panning = true;
            this._mapCanvas.setCursor(this.getCursor());
            MapScale scale = this._mapPanel.scale();
            this._oldPoint.x = e.getX();
            this._oldPoint.y = e.getY();
        }
        this.notify();
    }

    @Override
    public synchronized void mouseDragged(MouseEvent e) {
        if (this._mapCanvas != null && this._mapPanel != null) {
            this._newPoint.x = e.getX();
            this._newPoint.y = e.getY();
            if (!this._mapCanvas.contains(this._newPoint.x, this._newPoint.y)) {
                return;
            }
            MapScale scale = this._mapPanel.scale();
            WorldPt oldOrigin = scale.getOrigin();
            scale.lp2wp(this._newPoint, this._newWorldPoint);
            scale.lp2wp(this._oldPoint, this._oldWorldPoint);
            this._newOrigin.e = oldOrigin.e - (this._newWorldPoint.e - this._oldWorldPoint.e);
            this._newOrigin.n = oldOrigin.n - (this._newWorldPoint.n - this._oldWorldPoint.n);
            this._mapPanel.setOrigin(this._newOrigin, false);
            this._oldPoint.x = this._newPoint.x;
            this._oldPoint.y = this._newPoint.y;
        }
        this.notify();
    }

    @Override
    public Cursor getCursor() {
        if (_panDownCursor == null || _panUpCursor == null) {
            return super.getCursor();
        }
        if (this._panning) {
            return _panDownCursor;
        }
        return _panUpCursor;
    }
}

