/*
 * Decompiled with CFR 0.152.
 */
package hec.map;

import hec.map.ButtonGifStrings;
import hec.map.LocalPt;
import hec.map.LocalRect;
import hec.map.MapCanvas;
import hec.map.MapMouseAdapter;
import hec.map.MapPanel;
import hec.map.MousePanAdapter;
import hec.map.WorldPt;
import java.awt.BasicStroke;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.Point;
import java.awt.RenderingHints;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.MouseEvent;
import java.awt.geom.Rectangle2D;
import javax.swing.AbstractAction;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.KeyStroke;
import javax.swing.SwingUtilities;
import rma.swing.RmaImage;

public class MouseZoomAdapter
extends MapMouseAdapter {
    public static final String ZOOM_CURSOR = "ZoomCursor";
    boolean _zoomIn = false;
    boolean _drawDragRect = false;
    LocalPt _beginPt = new LocalPt();
    LocalPt _endPt = new LocalPt();
    LocalRect _dragRect = new LocalRect();
    LocalRect _oldDragRect = new LocalRect();
    WorldPt _wpt = new WorldPt();
    Cursor _zoomCursor;
    private AbstractAction _shiftDownAction;
    private AbstractAction _shiftUpAction;
    private boolean _panning;
    JComponent _lassoPanel = new LassoPanel();

    protected MouseZoomAdapter(MapPanel panel, MapCanvas canvas) {
        super(panel, canvas);
        Image zoomCursor = RmaImage.loadURLImage("Images/ZoomCursor.gif");
        if (zoomCursor != null) {
            this._zoomCursor = Toolkit.getDefaultToolkit().createCustomCursor(zoomCursor, new Point(5, 5), ZOOM_CURSOR);
        }
    }

    @Override
    public void init() {
        super.init();
        JPanel glassPane = this._mapPanel.getGlassPane();
        glassPane.setLayout(new BorderLayout());
        glassPane.add((Component)this._lassoPanel, "Center");
        glassPane.setVisible(true);
        if (this._shiftDownAction == null) {
            this._shiftDownAction = new AbstractAction(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    MouseZoomAdapter.this.shiftKeyAction(true);
                }
            };
        }
        if (this._shiftUpAction == null) {
            this._shiftUpAction = new AbstractAction(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    MouseZoomAdapter.this.shiftKeyAction(false);
                }
            };
        }
        if (this._mapPanel.getActionMap().get("shiftDownKey") == null) {
            this._mapPanel.getInputMap(1).put(KeyStroke.getKeyStroke(90, 0, false), "shiftDownKey");
            this._mapPanel.getActionMap().put("shiftDownKey", this._shiftDownAction);
        }
        if (this._mapPanel.getActionMap().get("shiftUpKey") == null) {
            this._mapPanel.getInputMap(1).put(KeyStroke.getKeyStroke(90, 0, true), "shiftUpKey");
            this._mapPanel.getActionMap().put("shiftUpKey", this._shiftUpAction);
        }
    }

    @Override
    public void abort() {
        super.abort();
        JPanel glassPane = this._mapPanel.getGlassPane();
        glassPane.remove(this._lassoPanel);
        glassPane.setVisible(false);
        this._mapPanel.getInputMap(1).remove(KeyStroke.getKeyStroke(90, 0, false));
        this._mapPanel.getActionMap().remove("shiftDownKey");
        if (!this._panning) {
            this._mapPanel.getInputMap(1).remove(KeyStroke.getKeyStroke(90, 0, true));
            this._mapPanel.getActionMap().remove("shiftUpKey");
        }
    }

    protected void shiftKeyAction(boolean keyDown) {
        System.out.println("shiftKeyAction:keyDown=" + keyDown + " panning=" + this._panning);
        if (keyDown && !this._panning) {
            this._panning = true;
            this._mapPanel.setMouseAdapter(MousePanAdapter.class.getName());
        } else if (!keyDown) {
            this._panning = false;
            this.abort();
            this._mapPanel.setMouseAdapter(MouseZoomAdapter.class.getName());
        }
    }

    @Override
    public void mouseReleased(MouseEvent e) {
        if (this._zoomIn) {
            this._endPt.init(e.getX(), e.getY());
            this._dragRect.init(this._beginPt, this._endPt);
            this._zoomIn = false;
            if (this._dragRect.width() < 3 || this._dragRect.height() < 3) {
                this._dragRect.init(0, 0, 0, 0);
                this._lassoPanel.paintImmediately(this._lassoPanel.getBounds());
            } else {
                LocalRect tempRect = new LocalRect(this._dragRect);
                this._dragRect.init(0, 0, 0, 0);
                if (this._mapPanel != null) {
                    this._mapPanel.zoomIn(tempRect);
                }
            }
        } else if (MouseZoomAdapter.pressedButton3(e)) {
            this._zoomIn = false;
            if (this._mapPanel != null) {
                this._mapPanel.zoomByFactor(2.0);
            }
        }
        this._drawDragRect = false;
    }

    @Override
    public void mousePressed(MouseEvent e) {
        if (MouseZoomAdapter.pressedButton1(e)) {
            this._beginPt.init(e.getX(), e.getY());
            this._oldDragRect.initToPoint(this._beginPt);
            this._drawDragRect = true;
            this._zoomIn = true;
        } else if (MouseZoomAdapter.pressedButton3(e)) {
            this._zoomIn = false;
        }
    }

    @Override
    public void mouseDragged(MouseEvent e) {
        if (this._mapCanvas != null && this._zoomIn) {
            this._endPt.init(e.getX(), e.getY());
            this._dragRect.init(this._beginPt, this._endPt);
            this._oldDragRect.init(this._dragRect);
            this._lassoPanel.paintImmediately(this._lassoPanel.getBounds());
        }
    }

    @Override
    public void mouseClicked(MouseEvent e) {
        if (SwingUtilities.isLeftMouseButton(e) && e.getClickCount() == 2) {
            this._zoomIn = false;
            if (this._mapPanel != null) {
                WorldPt wpt = this.getWorldPt(e.getPoint());
                this._mapPanel.scale().setOrigin(wpt);
                this._mapPanel.zoomByFactor(0.5);
            }
        }
    }

    @Override
    public Cursor getCursor() {
        if (this._zoomCursor == null) {
            return super.getCursor();
        }
        return this._zoomCursor;
    }

    public static ButtonGifStrings buildDefaultButtonGifStrings() {
        ButtonGifStrings bgstr = new ButtonGifStrings();
        bgstr = new ButtonGifStrings();
        bgstr.up = "Images/ZoomUp.gif";
        bgstr.down = "Images/ZoomDown.gif";
        bgstr.over = "Images/ZoomUp.gif";
        bgstr.on = "Images/ZoomDown.gif";
        bgstr.toolTipText = "Zoom Tool";
        bgstr.borderPainted = true;
        bgstr.adapter = MouseZoomAdapter.class.getName();
        return bgstr;
    }

    private class LassoPanel
    extends JComponent {
        private LassoPanel() {
        }

        @Override
        public void paintComponent(Graphics graphics) {
            super.paintComponent(graphics);
            if (MouseZoomAdapter.this._dragRect == null || MouseZoomAdapter.this._dragRect.width() == 0 || MouseZoomAdapter.this._dragRect.height() == 0) {
                return;
            }
            Rectangle2D.Double rectangle2D = new Rectangle2D.Double(MouseZoomAdapter.this._dragRect.l, MouseZoomAdapter.this._dragRect.t, MouseZoomAdapter.this._dragRect.width(), MouseZoomAdapter.this._dragRect.height());
            Graphics2D buffGraphics = (Graphics2D)graphics;
            Color border = Color.BLACK;
            buffGraphics.setColor(border);
            buffGraphics.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
            buffGraphics.setStroke(new BasicStroke(2.0f));
            buffGraphics.draw(rectangle2D);
            buffGraphics.dispose();
        }
    }
}

