/*
 * Decompiled with CFR 0.152.
 */
package hec.map;

import hec.map.ButtonGifStrings;
import hec.map.LocalPt;
import hec.map.LocalRect;
import hec.map.MapCanvas;
import hec.map.MapGlyph;
import hec.map.MapMouseAdapter;
import hec.map.MapPanel;
import hec.map.WorldPt;
import hec.map.WorldRect;
import java.awt.Cursor;
import java.awt.Image;
import java.awt.Point;
import java.awt.Toolkit;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.util.List;
import javax.swing.SwingUtilities;
import rma.swing.RmaImage;

public class PointerMouseAdapter
extends MapMouseAdapter
implements MouseListener,
MouseMotionListener {
    public static final String POINTER_CURSOR = "PointerCursor";
    LocalPt _pt = new LocalPt();
    LocalPt _selectedPt = null;
    WorldPt _selectedWPt = null;
    LocalRect _lrc = new LocalRect();
    WorldRect _wrc = new WorldRect();
    MapGlyph _selectionGlyph = null;
    Cursor _pointerCursor;

    public PointerMouseAdapter(MapPanel panel, MapCanvas canvas) {
        super(panel, canvas);
        try {
            Image pointerCursor = RmaImage.loadURLImage("Images/PointerCursor.gif");
            this._pointerCursor = Toolkit.getDefaultToolkit().createCustomCursor(pointerCursor, new Point(0, 0), POINTER_CURSOR);
        }
        catch (Exception e) {
            System.out.println("init:failed to find cursor image: Images/PointerCursor.gif. Error:" + e);
        }
    }

    @Override
    public void init() {
    }

    @Override
    public void abort() {
        if (this._selectionGlyph != null) {
            this._selectionGlyph.clearSelection();
        }
    }

    @Override
    public void mousePressed(MouseEvent e) {
        if (e.isPopupTrigger() || PointerMouseAdapter.pressedButton3(e)) {
            LocalPt pt = new LocalPt(e.getX(), e.getY());
            List gvec = this._mapPanel.managerGlyphList();
            for (int i = gvec.size() - 1; i >= 0; --i) {
                MapGlyph g = (MapGlyph)gvec.get(i);
                if (!g.isShown() || !g.objectPopupMenu(pt, e.getModifiers())) continue;
                this._selectionGlyph = g;
                return;
            }
            if (this._selectionGlyph == null) {
                this.handleEmptyRightClick(e);
            }
        }
    }

    protected void handleEmptyRightClick(MouseEvent e) {
    }

    @Override
    public void mouseReleased(MouseEvent e) {
        if (PointerMouseAdapter.pressedButton1(e)) {
            LocalPt pt = new LocalPt(e.getX(), e.getY());
            List gvec = this._mapPanel.managerGlyphList();
            if (this._selectionGlyph != null) {
                if (!e.isShiftDown()) {
                    this._selectionGlyph.clearSelection();
                }
                this._selectionGlyph = null;
            }
            if (e.isPopupTrigger() || SwingUtilities.isRightMouseButton(e)) {
                return;
            }
            this.objectSelect(gvec, pt, e.getModifiers());
        }
    }

    protected void objectSelect(List glyphList, LocalPt pt, int modifiers) {
        for (int i = glyphList.size() - 1; i >= 0; --i) {
            MapGlyph g = (MapGlyph)glyphList.get(i);
            if (!g.isShown() || g.objectSelect(pt, modifiers) == null) continue;
            this._selectionGlyph = g;
            break;
        }
    }

    @Override
    public void mouseMoved(MouseEvent e) {
        super.mouseMoved(e);
    }

    @Override
    public void mouseDragged(MouseEvent e) {
        super.mouseDragged(e);
    }

    @Override
    public void mouseClicked(MouseEvent e) {
        if (e.getClickCount() == 2) {
            LocalPt pt = new LocalPt(e.getX(), e.getY());
            List gvec = this._mapPanel.managerGlyphList();
            if (this._selectionGlyph != null) {
                this._selectionGlyph.clearSelection();
                this._selectionGlyph = null;
            }
            for (int i = gvec.size() - 1; i >= 0; --i) {
                MapGlyph g = (MapGlyph)gvec.get(i);
                if (!g.isShown() || !g.objectDoubleClick(pt, e.getModifiers())) continue;
                this._selectionGlyph = g;
                break;
            }
        }
    }

    @Override
    public Cursor getCursor() {
        if (this._pointerCursor == null) {
            return super.getCursor();
        }
        return this._pointerCursor;
    }

    public static ButtonGifStrings buildDefaultButtonGifStrings() {
        ButtonGifStrings bgstr = new ButtonGifStrings();
        bgstr = new ButtonGifStrings();
        bgstr.up = "Images/Point.gif";
        bgstr.down = "Images/Point.gif";
        bgstr.over = "Images/Point.gif";
        bgstr.on = "Images/Point.gif";
        bgstr.borderPainted = true;
        bgstr.adapter = PointerMouseAdapter.class.getName();
        bgstr.toolTipText = "Pointer Tool";
        return bgstr;
    }
}

