/*
 * Decompiled with CFR 0.152.
 */
package hec.map;

import hec.map.ToolBarButtonItem;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.event.ActionEvent;
import java.io.File;
import java.io.IOException;
import java.util.Enumeration;
import java.util.StringTokenizer;
import java.util.Vector;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import java.util.zip.ZipEntry;
import javax.swing.JLabel;
import rma.swing.ButtonCmdPanel;
import rma.swing.ButtonCmdPanelListener;
import rma.swing.RmaInsets;
import rma.swing.RmaJComboBox;
import rma.swing.RmaJDialog;
import rma.swing.RmaJTextField;
import rma.swing.event.ReflectMultiListener;
import rma.swing.list.ImageFileCellRenderer;
import rma.swing.list.RmaListModel;

public class ToolBarButtonEditor
extends RmaJDialog {
    private RmaJTextField toolTipTxt;
    private RmaJComboBox unselectedIconCombo;
    private ButtonCmdPanel cmdPanel;
    private ReflectMultiListener _listener;
    private static Vector _iconList;
    private boolean _isCanceled = false;

    public ToolBarButtonEditor(Frame parent, boolean modal) {
        super(parent, modal);
        this.buildControls();
    }

    public ToolBarButtonEditor(Dialog parent, boolean modal) {
        super(parent, modal);
        this.buildControls();
    }

    private void buildControls() {
        if (_iconList == null || _iconList.size() < 1) {
            _iconList = this.createImageList();
        }
        this._listener = new ReflectMultiListener();
        this.getContentPane().setLayout(new GridBagLayout());
        this.setTitle("ToolBar Button Editor");
        this.setSize(300, 300);
        JLabel label = new JLabel("Tool Tip:", 4);
        label.setDisplayedMnemonic('T');
        GridBagConstraints gbc = new GridBagConstraints();
        gbc.gridx = 0;
        gbc.gridy = 1;
        gbc.insets = RmaInsets.insets(5, 5, 0, 0);
        gbc.anchor = 18;
        gbc.fill = 2;
        this.getContentPane().add((Component)label, gbc);
        this.toolTipTxt = new RmaJTextField();
        label.setLabelFor(this.toolTipTxt);
        gbc = new GridBagConstraints();
        gbc.gridx = 1;
        gbc.gridy = 1;
        gbc.insets = RmaInsets.insets(5, 5, 0, 5);
        gbc.anchor = 18;
        gbc.fill = 2;
        gbc.weightx = 1.0;
        this.getContentPane().add((Component)this.toolTipTxt, gbc);
        label = new JLabel("Icon:", 4);
        label.setDisplayedMnemonic('I');
        gbc = new GridBagConstraints();
        gbc.gridx = 0;
        gbc.gridy = 3;
        gbc.insets = RmaInsets.insets(5, 5, 0, 0);
        gbc.anchor = 18;
        gbc.fill = 2;
        this.getContentPane().add((Component)label, gbc);
        this.unselectedIconCombo = new RmaJComboBox(new RmaListModel(true, _iconList));
        this.unselectedIconCombo.setRenderer(new ImageFileCellRenderer(this.unselectedIconCombo));
        label.setLabelFor(this.unselectedIconCombo);
        gbc = new GridBagConstraints();
        gbc.gridx = 1;
        gbc.gridy = 3;
        gbc.insets = RmaInsets.insets(5, 5, 0, 5);
        gbc.anchor = 18;
        gbc.fill = 2;
        gbc.weightx = 1.0;
        this.getContentPane().add((Component)this.unselectedIconCombo, gbc);
        this.cmdPanel = new ButtonCmdPanel(12);
        gbc = new GridBagConstraints();
        gbc.gridx = 0;
        gbc.gridy = 4;
        gbc.gridwidth = 2;
        gbc.insets = RmaInsets.insets(5, 5, 0, 5);
        gbc.anchor = 18;
        gbc.fill = 2;
        gbc.weightx = 1.0;
        this.getContentPane().add((Component)this.cmdPanel, gbc);
        this.pack();
        this.setLocation();
        this.cmdPanel.addCmdPanelListener(new ButtonCmdPanelListener(){

            @Override
            public void buttonCmdActionPerformed(ActionEvent e) {
                switch (e.getID()) {
                    case 8: {
                        ToolBarButtonEditor.this.setVisible(false);
                        ToolBarButtonEditor.this._isCanceled = false;
                        break;
                    }
                    case 4: {
                        ToolBarButtonEditor.this.setVisible(false);
                        ToolBarButtonEditor.this._isCanceled = true;
                    }
                }
            }
        });
    }

    private Vector createImageList() {
        Vector<String> v = new Vector<String>();
        String classPath = System.getProperty("java.class.path");
        if (classPath == null) {
            System.out.println("createImageList: got null classpath");
            return v;
        }
        StringTokenizer tokenizer = new StringTokenizer(classPath, File.pathSeparator);
        String token = null;
        boolean found = false;
        while (tokenizer.hasMoreTokens()) {
            token = tokenizer.nextToken();
            if (token.indexOf("images.jar") <= -1) continue;
            found = true;
            break;
        }
        if (!found) {
            System.out.println("createImageList: failed to find Images.jar in " + classPath);
            return v;
        }
        try {
            JarFile imagesJar = new JarFile(token);
            Enumeration<JarEntry> e = imagesJar.entries();
            v.ensureCapacity(imagesJar.size());
            while (e.hasMoreElements()) {
                String name;
                ZipEntry entry = e.nextElement();
                if (!entry.getName().startsWith("Images/Icons") || entry.isDirectory() || !(name = entry.getName()).endsWith(".gif") || name.endsWith("Sel.gif")) continue;
                v.add(name);
            }
        }
        catch (IOException ioe) {
            System.out.println("createImageList: error reading jarfile " + token + " error " + ioe);
            return v;
        }
        v.trimToSize();
        return v;
    }

    public boolean isCanceled() {
        return this._isCanceled;
    }

    public ToolBarButtonItem getButtonItem() {
        ToolBarButtonItem item = new ToolBarButtonItem();
        item.setToolTipText(this.toolTipTxt.getText());
        String unselectedIconName = (String)this.unselectedIconCombo.getSelectedItem();
        if (unselectedIconName == null) {
            item.setSelectedIconName("");
            item.setUnselectedIconName("");
            return item;
        }
        int idx = unselectedIconName.lastIndexOf(".");
        Object selectedIconName = unselectedIconName;
        if (idx > -1) {
            selectedIconName = unselectedIconName.substring(0, idx);
            selectedIconName = (String)selectedIconName + "Sel";
            selectedIconName = (String)selectedIconName + unselectedIconName.substring(idx);
            try {
                if (this.getClass().getClassLoader().getResource((String)selectedIconName) == null) {
                    selectedIconName = unselectedIconName;
                }
            }
            catch (Exception e) {
                selectedIconName = unselectedIconName;
            }
        }
        item.setSelectedIconName((String)selectedIconName);
        item.setUnselectedIconName(unselectedIconName);
        return item;
    }

    public void setToolTipText(String text) {
        if (text == null) {
            this.toolTipTxt.setText("");
        } else {
            this.toolTipTxt.setText(text);
        }
    }
}

