/*
 * Decompiled with CFR 0.152.
 */
package hec.map;

import hec.appInterface.IToolBarButtonItem;
import hec.io.Identifier;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.IOException;
import rma.util.RMAIO;

public class ToolBarButtonItem
implements IToolBarButtonItem {
    private Identifier _glyphId;
    private Identifier _childGlyphId;
    private String _name;
    private String _attributeName;
    private String _selectedIconName;
    private String _unselectedIconName;
    private String _toolTip;

    @Override
    public String getName() {
        return this._name;
    }

    public void setName(String name) {
        this._name = name;
    }

    public void setGlyphId(Identifier id) {
        this._glyphId = id;
    }

    public void setChildGlyphId(Identifier id) {
        this._childGlyphId = id;
    }

    public void setAttributeName(String name) {
        this._attributeName = name;
    }

    @Override
    public Identifier getGlyphId() {
        return this._glyphId;
    }

    @Override
    public Identifier getChildGlyphId() {
        return this._childGlyphId;
    }

    @Override
    public String getAttributeName() {
        return this._attributeName;
    }

    @Override
    public void setSelectedIconName(String iconName) {
        this._selectedIconName = iconName;
    }

    @Override
    public String getSelectedIconName() {
        return this._selectedIconName;
    }

    @Override
    public void setUnselectedIconName(String iconName) {
        this._unselectedIconName = iconName;
    }

    @Override
    public String getUnselectedIconName() {
        return this._unselectedIconName;
    }

    @Override
    public String getToolTipText() {
        return this._toolTip;
    }

    public void setToolTipText(String text) {
        this._toolTip = text;
    }

    public void write(BufferedWriter out) throws IOException {
        if (out == null) {
            return;
        }
        RMAIO.fout(out, "ToolBarButtonItemBegin");
        if (this._name != null) {
            RMAIO.fout(out, "Name=" + this._name);
        }
        if (this._glyphId != null) {
            RMAIO.fout(out, "MapGlyph");
            RMAIO.fout(out, "Name=" + this._glyphId.getName());
            RMAIO.fout(out, "Class=" + this._glyphId.getClassName());
            RMAIO.fout(out, "MapGlyphEnd");
        }
        if (this._childGlyphId != null) {
            RMAIO.fout(out, "MapGlyph Child");
            RMAIO.fout(out, "Name=" + this._childGlyphId.getName());
            RMAIO.fout(out, "Class=" + this._childGlyphId.getClassName());
            RMAIO.fout(out, "MapGlyphEnd");
        }
        if (this._attributeName != null) {
            RMAIO.fout(out, "AttributeName=" + this._attributeName);
        }
        if (this._selectedIconName != null) {
            RMAIO.fout(out, "SelectedIconName=" + this._selectedIconName);
        }
        if (this._unselectedIconName != null) {
            RMAIO.fout(out, "UnselectedIconName=" + this._unselectedIconName);
        }
        if (this._toolTip != null) {
            RMAIO.fout(out, "ToolTip=" + this._toolTip);
        }
        RMAIO.fout(out, "ToolBarButtonItemEnd\n");
    }

    public void read(BufferedReader reader) throws IOException {
        String line;
        if (reader == null) {
            return;
        }
        while ((line = reader.readLine()) != null) {
            if ((line = line.trim()).startsWith("ToolBarButtonItemEnd")) {
                return;
            }
            if (line.startsWith("MapGlyph Child")) {
                this._childGlyphId = new Identifier();
                this.readId(this._childGlyphId, reader);
                continue;
            }
            if (line.startsWith("MapGlyph")) {
                this._glyphId = new Identifier();
                this.readId(this._glyphId, reader);
                continue;
            }
            if (line.startsWith("Name")) {
                this._name = RMAIO.getParam(line, "=");
                continue;
            }
            if (line.startsWith("AttributeName")) {
                this._attributeName = RMAIO.getParam(line, "=");
                continue;
            }
            if (line.startsWith("SelectedIconName")) {
                this._selectedIconName = RMAIO.getParam(line, "=");
                continue;
            }
            if (line.startsWith("UnselectedIconName")) {
                this._unselectedIconName = RMAIO.getParam(line, "=");
                continue;
            }
            if (!line.startsWith("ToolTip")) continue;
            this._toolTip = RMAIO.getParam(line, "=");
        }
    }

    private void readId(Identifier id, BufferedReader reader) throws IOException {
        String line;
        while ((line = reader.readLine()) != null) {
            if ((line = line.trim()).startsWith("MapGlyphEnd")) {
                return;
            }
            String type = RMAIO.getType(line, "=");
            if (type.equals("Name")) {
                id.setName(RMAIO.getParam(line, "="));
                continue;
            }
            if (!type.equals("Class")) continue;
            id.setClassName(RMAIO.getParam(line, "="));
        }
    }

    public boolean equals(Object that) {
        if (that instanceof ToolBarButtonItem) {
            return this.equals((ToolBarButtonItem)that);
        }
        return false;
    }

    public boolean equals(ToolBarButtonItem that) {
        return that._name.equals(this._name) && that._attributeName.equals(this._attributeName);
    }

    public int hashCode() {
        return (this._name + this._attributeName).hashCode();
    }

    public String toString() {
        return "ToolBarButtonItem(Name=" + this._name + " Attribute=" + this._attributeName + ")";
    }
}

