/*
 * Decompiled with CFR 0.152.
 */
package hec.map;

import hec.map.crs.CoordinateReferenceSystem;
import hec.map.crs.Transform;
import java.util.Arrays;
import java.util.List;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;

public class TransformCache {
    ConcurrentMap<List<CoordinateReferenceSystem>, Transform> transformMap = new ConcurrentHashMap<List<CoordinateReferenceSystem>, Transform>();

    private List<CoordinateReferenceSystem> createListKey(CoordinateReferenceSystem srcCrs, CoordinateReferenceSystem targetCrs) {
        return Arrays.asList(srcCrs, targetCrs);
    }

    public Transform get(CoordinateReferenceSystem srcCrs, CoordinateReferenceSystem targetCrs) {
        List<CoordinateReferenceSystem> key = this.createListKey(srcCrs, targetCrs);
        return (Transform)this.transformMap.get(key);
    }

    public void put(CoordinateReferenceSystem srcCrs, CoordinateReferenceSystem targetCrs, Transform transform) {
        this.transformMap.put(this.createListKey(srcCrs, targetCrs), transform);
    }

    public void clear() {
        this.transformMap.clear();
    }
}

