/*
 * Decompiled with CFR 0.152.
 */
package hec.map;

import hec.map.LocalPt;
import hec.map.LocalRect;
import hec.map.MapScale;
import hec.map.TransformCache;
import hec.map.WorldPt;
import hec.map.WorldRect;
import hec.map.crs.CRS;
import hec.map.crs.CRSException;
import hec.map.crs.CoordinateReferenceSystem;
import hec.map.crs.Transform;
import java.awt.Dimension;
import java.awt.geom.AffineTransform;
import java.util.logging.Level;
import java.util.logging.Logger;

public class TransformMapScale
extends MapScale {
    static final TransformCache mCache = new TransformCache();
    private final CoordinateReferenceSystem mDataCrs;
    private final CoordinateReferenceSystem mMapScaleCrs;
    private Transform mTransform;
    private Transform mInvTransform;
    WorldPt testPt = new WorldPt();

    public TransformMapScale(MapScale scl, CoordinateReferenceSystem mapScaleCrs, CoordinateReferenceSystem dataCrs) throws CRSException {
        super(scl);
        this.mDataCrs = dataCrs;
        this.mMapScaleCrs = mapScaleCrs;
        this.mTransform = mCache.get(this.mDataCrs, this.mMapScaleCrs);
        if (this.mTransform == null) {
            this.mTransform = CRS.getDefault().findTransform(this.mDataCrs, this.mMapScaleCrs, true);
            mCache.put(this.mDataCrs, this.mMapScaleCrs, this.mTransform);
        }
        this.mInvTransform = mCache.get(this.mMapScaleCrs, this.mDataCrs);
        if (this.mInvTransform == null) {
            this.mInvTransform = CRS.getDefault().findTransform(this.mMapScaleCrs, this.mDataCrs, true);
            mCache.put(this.mMapScaleCrs, this.mDataCrs, this.mInvTransform);
        }
    }

    @Override
    public boolean contains(WorldPt wpt) {
        double[] srcXPts = new double[]{wpt.e};
        double[] srcYPts = new double[]{wpt.n};
        try {
            this.mTransform.transform(srcXPts, srcYPts, 0, srcXPts, srcYPts, 0, 1);
        }
        catch (CRSException ex) {
            Logger.getLogger(TransformMapScale.class.getName()).log(Level.SEVERE, null, ex);
            return false;
        }
        return super.contains(new WorldPt(srcXPts[0], srcYPts[0]));
    }

    @Override
    public boolean contains(LocalPt pt) {
        return super.contains(pt);
    }

    @Override
    public double getAvgW2LScale() {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public WorldPt getOrigin() {
        WorldPt origin = super.getOrigin();
        double[] srcXPts = new double[]{origin.e};
        double[] srcYPts = new double[]{origin.n};
        try {
            this.mInvTransform.transform(srcXPts, srcYPts, 0, srcXPts, srcYPts, 0, 1);
        }
        catch (CRSException ex) {
            Logger.getLogger(TransformMapScale.class.getName()).log(Level.SEVERE, null, ex);
            return null;
        }
        return new WorldPt(srcXPts[0], srcYPts[0]);
    }

    @Override
    public WorldRect getRegionExtents() {
        return this.transformRect(super.getRegionExtents(), this.mInvTransform);
    }

    @Override
    public LocalRect getViewRect() {
        return super.getViewRect();
    }

    @Override
    public WorldRect getWorldRect() {
        return this.transformRect(super.getWorldRect(), this.mInvTransform);
    }

    @Override
    public double getXScale() {
        return super.getXScale();
    }

    @Override
    public double getYScale() {
        return super.getYScale();
    }

    @Override
    public double getZoom() {
        return super.getZoom();
    }

    @Override
    public void growRegionExtents(WorldRect rc) {
        super.growRegionExtents(this.transformRect(rc, this.mTransform));
    }

    @Override
    public AffineTransform local2WorldTransform(AffineTransform transform) {
        return null;
    }

    @Override
    public void lp2wp(LocalPt lpt, WorldPt wpt) {
        super.lp2wp(lpt, wpt);
        WorldPt tempPt = this.transformPoint(wpt, this.mInvTransform);
        wpt.e = tempPt.e;
        wpt.n = tempPt.n;
    }

    @Override
    public WorldRect lr2wr(LocalRect lr) {
        WorldRect wr = super.lr2wr(lr);
        return this.transformRect(wr, this.mInvTransform);
    }

    @Override
    public void setOrigin(WorldPt p) {
        super.setOrigin(this.transformPoint(p, this.mTransform));
    }

    @Override
    public void setOrigin(WorldPt p, boolean computeScaling) {
        super.setOrigin(this.transformPoint(p, this.mTransform), computeScaling);
    }

    @Override
    public void setRegionExtents(WorldRect rc) {
        super.setRegionExtents(this.transformRect(rc, this.mTransform));
    }

    @Override
    public void setViewRect(LocalRect rc) {
        super.setViewRect(rc);
    }

    @Override
    public void setViewRect(Dimension d) {
        super.setViewRect(d);
    }

    @Override
    public void setZoom(double z) {
        super.setZoom(z);
    }

    @Override
    public void showAll() {
        super.showAll();
    }

    @Override
    public AffineTransform world2LocalTransform(AffineTransform transform) {
        return super.world2LocalTransform(transform);
    }

    @Override
    public void wp2lp(WorldPt wpt, LocalPt lpt) {
        super.wp2lp(this.transformPoint(wpt, this.mTransform), lpt);
    }

    @Override
    public LocalRect wr2lr(WorldRect wr) {
        return super.wr2lr(this.transformRect(wr, this.mTransform));
    }

    @Override
    public LocalRect wr2lr(WorldRect wr, LocalRect lr) {
        return super.wr2lr(this.transformRect(wr, this.mTransform), lr);
    }

    @Override
    public void zoomByFactor(double factor) {
        super.zoomByFactor(factor);
    }

    @Override
    public boolean zoomIn(WorldRect wc) {
        return super.zoomIn(this.transformRect(wc, this.mTransform));
    }

    @Override
    public boolean zoomIn(LocalRect rc) {
        return super.zoomIn(rc);
    }

    public WorldPt transformPoint(WorldPt pt) {
        return this.transformPoint(pt, this.mTransform);
    }

    public WorldRect transformRect(WorldRect bounds) {
        return this.transformRect(bounds, this.mTransform);
    }

    protected WorldPt transformPoint(WorldPt pt, Transform transform) {
        double[] transformXPts = new double[]{pt.e};
        double[] transformYPts = new double[]{pt.n};
        try {
            transform.transform(transformXPts, transformYPts, 0, transformXPts, transformYPts, 0, 1);
        }
        catch (CRSException ex) {
            Logger.getLogger(TransformMapScale.class.getName()).log(Level.SEVERE, null, ex);
            return null;
        }
        return new WorldPt(transformXPts[0], transformYPts[0]);
    }

    protected WorldRect transformRect(WorldRect bounds, Transform transform) {
        if (bounds == null) {
            return null;
        }
        if (transform == null) {
            return bounds;
        }
        double[] transformXPts = new double[4];
        double[] transformYPts = new double[4];
        transformXPts[0] = bounds.e;
        transformYPts[0] = bounds.n;
        transformXPts[1] = bounds.w;
        transformYPts[1] = bounds.n;
        transformXPts[2] = bounds.w;
        transformYPts[2] = bounds.s;
        transformXPts[3] = bounds.e;
        transformYPts[3] = bounds.s;
        try {
            transform.transform(transformXPts, transformYPts, 0, transformXPts, transformYPts, 0, 4);
        }
        catch (CRSException ex) {
            Logger.getLogger(this.getClass().getName()).log(Level.SEVERE, null, ex);
            return bounds;
        }
        WorldRect wr = new WorldRect();
        WorldPt pt = new WorldPt();
        pt.e = transformXPts[0];
        pt.n = transformYPts[0];
        wr.grow(pt);
        pt.e = transformXPts[1];
        pt.n = transformYPts[1];
        wr.grow(pt);
        pt.e = transformXPts[2];
        pt.n = transformYPts[2];
        wr.grow(pt);
        pt.e = transformXPts[3];
        pt.n = transformYPts[3];
        wr.grow(pt);
        return wr;
    }
}

