/*
 * Decompiled with CFR 0.152.
 */
package hec.map;

import hec.map.WorldPointHolder;
import hec.map.WorldPt;
import hec.map.aishape.AiShapeFieldDescriptor;
import hec.map.aishape.Field;
import hec.map.crs.CRS;
import hec.map.crs.CRSException;
import hec.map.crs.CoordinateReferenceSystem;
import hec.map.crs.Transform;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;

public class TransformPointHolder
implements WorldPointHolder {
    private CoordinateReferenceSystem _toCRS;
    private Transform _transform;
    private WorldPointHolder _wptH;
    private double[] xPt = new double[1];
    private double[] yPt = new double[1];

    public TransformPointHolder(WorldPointHolder wptH, CoordinateReferenceSystem toCRS) {
        this._wptH = wptH;
        this._toCRS = toCRS;
        try {
            this._transform = CRS.getDefault().findTransform(wptH.getCoordinateReferenceSystem(), this._toCRS, true);
        }
        catch (CRSException e1) {
            Logger.getLogger(TransformPointHolder.class.getName()).log(Level.SEVERE, null, e1);
        }
    }

    public WorldPt transform(WorldPt wpt) {
        if (wpt != null) {
            this.xPt[0] = wpt.e;
            this.yPt[0] = wpt.n;
            try {
                this._transform.transform(this.xPt, this.yPt, 0, this.xPt, this.yPt, 0, 1);
            }
            catch (CRSException ex) {
                Logger.getLogger(TransformPointHolder.class.getName()).log(Level.SEVERE, null, ex);
            }
        }
        return new WorldPt(this.xPt[0], this.yPt[0]);
    }

    @Override
    public int getPointCount() {
        return this._wptH.getPointCount();
    }

    @Override
    public WorldPt getPointAt(int index) {
        return this.transform(this._wptH.getPointAt(index));
    }

    @Override
    public List<AiShapeFieldDescriptor> getFieldDescriptors() {
        return this._wptH.getFieldDescriptors();
    }

    @Override
    public List<Field> getFields(int index) {
        return this._wptH.getFields(index);
    }

    @Override
    public CoordinateReferenceSystem getCoordinateReferenceSystem() {
        return this._toCRS;
    }
}

