/*
 * Decompiled with CFR 0.152.
 */
package hec.map;

import hec.map.WorldPt;
import hec.map.WorldRect;
import hec.map.crs.CRSException;
import hec.map.crs.Transform;
import java.util.logging.Level;
import java.util.logging.Logger;
import rma.util.RMAConst;

public class TransformUtility {
    static double[] transformXPts = null;
    static double[] transformYPts = null;

    public static synchronized WorldRect transformRect(WorldRect bounds, Transform transform) {
        if (bounds == null) {
            return null;
        }
        if (!(RMAConst.isValidValue(bounds.e) && RMAConst.isValidValue(bounds.n) && RMAConst.isValidValue(bounds.w) && RMAConst.isValidValue(bounds.s))) {
            Logger.getLogger(TransformUtility.class.getName()).log(Level.INFO, "TransformUtility: trying to transform a rectangle with invalid values.");
            return bounds;
        }
        if (transformXPts == null || transformXPts.length < 4) {
            transformXPts = new double[4];
            transformYPts = new double[4];
        }
        if (transform == null) {
            return bounds;
        }
        TransformUtility.transformXPts[0] = bounds.e;
        TransformUtility.transformYPts[0] = bounds.n;
        TransformUtility.transformXPts[1] = bounds.w;
        TransformUtility.transformYPts[1] = bounds.n;
        TransformUtility.transformXPts[2] = bounds.w;
        TransformUtility.transformYPts[2] = bounds.s;
        TransformUtility.transformXPts[3] = bounds.e;
        TransformUtility.transformYPts[3] = bounds.s;
        try {
            transform.transform(transformXPts, transformYPts, 0, transformXPts, transformYPts, 0, 4);
        }
        catch (CRSException ex) {
            String msg = "An exception occured trying to transform the following rectange: (" + bounds.toString() + ")\nusing the following transform: " + transform.toString();
            Logger.getLogger(TransformUtility.class.getName()).log(Level.SEVERE, msg, ex);
            return bounds;
        }
        WorldRect wr = new WorldRect();
        WorldPt pt = new WorldPt();
        pt.e = transformXPts[0];
        pt.n = transformYPts[0];
        wr.grow(pt);
        pt.e = transformXPts[1];
        pt.n = transformYPts[1];
        wr.grow(pt);
        pt.e = transformXPts[2];
        pt.n = transformYPts[2];
        wr.grow(pt);
        pt.e = transformXPts[3];
        pt.n = transformYPts[3];
        wr.grow(pt);
        return wr;
    }
}

