/*
 * Decompiled with CFR 0.152.
 */
package hec.map;

import hec.map.WorldPt;
import rma.util.RMAIO;

public class WorldArc {
    public WorldPt pt = new WorldPt();
    public double radius = Double.NEGATIVE_INFINITY;
    public double startAngle = Double.NEGATIVE_INFINITY;
    public double endAngle = Double.NEGATIVE_INFINITY;

    public WorldArc() {
    }

    public WorldArc(double pe, double pn, double r, double sa, double ea) {
        this.pt.e = pe;
        this.pt.n = pn;
        this.radius = r;
        this.startAngle = sa;
        this.endAngle = ea;
    }

    public WorldArc(WorldArc a) {
        this.pt.e = a.pt.e;
        this.pt.n = a.pt.n;
        this.radius = a.radius;
        this.startAngle = a.startAngle;
        this.endAngle = a.endAngle;
    }

    public void init(double pe, double pn, double r, double sa, double ea) {
        this.pt.e = pe;
        this.pt.n = pn;
        this.radius = r;
        this.startAngle = sa;
        this.endAngle = ea;
    }

    public void init(WorldArc a) {
        this.pt.e = a.pt.e;
        this.pt.n = a.pt.n;
        this.radius = a.radius;
        this.startAngle = a.startAngle;
        this.endAngle = a.endAngle;
    }

    public double length() {
        if (!this.isValid()) {
            return Double.NEGATIVE_INFINITY;
        }
        double ea = this.endAngle;
        if (ea < this.startAngle) {
            ea += 360.0;
        }
        double l = (ea - this.startAngle) * Math.PI * 2.0 * this.radius;
        return l;
    }

    public double distToPoint(WorldPt pt) {
        return Double.NEGATIVE_INFINITY;
    }

    public boolean isValid() {
        return this.pt.n != Double.NEGATIVE_INFINITY && this.pt.e != Double.NEGATIVE_INFINITY && this.radius != Double.NEGATIVE_INFINITY && this.startAngle != Double.NEGATIVE_INFINITY && this.endAngle != Double.NEGATIVE_INFINITY;
    }

    public String toString() {
        String str = RMAIO.toString(this.pt.e) + ", " + RMAIO.toString(this.pt.n) + ", " + RMAIO.toString(this.radius) + ", " + RMAIO.toString(this.startAngle) + ", " + RMAIO.toString(this.endAngle);
        return str;
    }

    public String parseString(String str) {
        int idx = str.indexOf(",");
        if (idx < 0) {
            return null;
        }
        this.pt.e = RMAIO.parseDouble(str.substring(0, idx));
        String str2 = str.substring(idx + 1);
        int idx2 = str2.indexOf(",");
        if (idx2 < 0) {
            this.pt.n = RMAIO.parseDouble(str2);
            return null;
        }
        this.pt.n = RMAIO.parseDouble(str2.substring(0, idx2));
        return str2.substring(idx2 + 1);
    }
}

