/*
 * Decompiled with CFR 0.152.
 */
package hec.map;

import hec.io.AsciiSerializable;
import hec.map.LocalPt;
import hec.map.MapScale;
import hec.map.WorldLineSeg;
import hec.map.WorldPt;
import hec.map.WorldRect;
import java.io.Serializable;
import java.lang.reflect.Field;
import java.util.Enumeration;
import java.util.StringTokenizer;
import java.util.Vector;
import rma.util.RMAIO;

public class WorldLine
implements Serializable,
AsciiSerializable,
Cloneable {
    static final long serialVersionUID = -1735228946849693610L;
    public static final int RIGHTBANK = 1;
    public static final int LEFTBANK = -1;
    public Vector pts = new Vector();
    protected transient double _length = 0.0;
    protected transient WorldRect _bounds = null;
    protected transient double[] _coordAtPt;
    protected static transient WorldLineSeg _tmpSeg = new WorldLineSeg();

    public boolean isEmpty() {
        return this.pts == null || this.pts.isEmpty();
    }

    public Object clone() {
        try {
            WorldLine line = (WorldLine)super.clone();
            line.pts = new Vector(this.pts.size());
            for (int i = 0; i < this.pts.size(); ++i) {
                WorldPt pt = (WorldPt)this.pts.elementAt(i);
                WorldPt cl = (WorldPt)pt.clone();
                if (cl == null) continue;
                line.pts.addElement(cl);
            }
            return line;
        }
        catch (CloneNotSupportedException e) {
            return null;
        }
    }

    public void reverseDirection() {
        Vector v = new Vector(this.pts.size());
        int imax = this.pts.size();
        for (int i = imax - 1; i >= 0; --i) {
            v.add(this.pts.elementAt(i));
        }
        this.pts = v;
        this.invalidate();
    }

    public WorldPt newPt() {
        return new WorldPt();
    }

    public WorldPt getFirstPt() {
        if (this.pts.size() < 1) {
            return null;
        }
        return (WorldPt)this.pts.elementAt(0);
    }

    public WorldPt getLastPt() {
        if (this.pts.size() < 1) {
            return null;
        }
        return (WorldPt)this.pts.lastElement();
    }

    public WorldPt getCenterPt() {
        WorldPt refpt = new WorldPt();
        for (int i = 0; i < this.pts.size(); ++i) {
            WorldPt pt = (WorldPt)this.pts.elementAt(i);
            if (pt == null) continue;
            if (i == 0) {
                refpt.init(pt);
                continue;
            }
            refpt.e += pt.e;
            refpt.n += pt.n;
        }
        double xnum = this.pts.size();
        if (xnum > 1.0) {
            refpt.e /= xnum;
            refpt.n /= xnum;
        }
        return refpt;
    }

    public boolean nearPt(WorldPt wpt, double tol) {
        if (wpt == null || this.pts.size() < 2) {
            return false;
        }
        WorldLineSeg l = new WorldLineSeg();
        WorldPt ptn = new WorldPt();
        WorldPt ptnbest = new WorldPt();
        double mindist = Double.MAX_VALUE;
        int ifound = -1;
        l.pt1 = (WorldPt)this.pts.elementAt(0);
        for (int i = 1; i < this.pts.size(); ++i) {
            WorldPt pt = (WorldPt)this.pts.elementAt(i);
            if (pt == null) continue;
            l.pt0 = l.pt1;
            l.pt1 = pt;
            double dist = wpt.ptNearLineSeg(l, ptn);
            if (!(dist < mindist) || !(dist <= tol)) continue;
            mindist = dist;
            ptnbest.init(ptn);
            ifound = i;
        }
        return ifound >= 0;
    }

    public double getNearestLocationSigned(WorldPt wpt, WorldPt ptnbest) {
        if (wpt == null || ptnbest == null || this.pts.size() < 2) {
            return Double.NEGATIVE_INFINITY;
        }
        WorldLineSeg l = new WorldLineSeg();
        WorldPt ptn = new WorldPt();
        double mindist = Double.MAX_VALUE;
        int ifound = -1;
        l.pt1 = (WorldPt)this.pts.elementAt(0);
        for (int i = 1; i < this.pts.size(); ++i) {
            WorldPt pt = (WorldPt)this.pts.elementAt(i);
            if (pt == null) continue;
            l.pt0 = l.pt1;
            l.pt1 = pt;
            double dist = wpt.ptNearLineSegSigned(l, ptn);
            if (!(Math.abs(dist) < Math.abs(mindist))) continue;
            mindist = dist;
            ptnbest.init(ptn);
            ifound = i;
        }
        return mindist;
    }

    public double getNearestLocation(WorldPt wpt, WorldPt ptnbest) {
        if (wpt == null || this.pts.size() < 2) {
            return Double.NEGATIVE_INFINITY;
        }
        WorldLineSeg l = new WorldLineSeg();
        WorldPt ptn = new WorldPt();
        double mindist = Double.MAX_VALUE;
        int ifound = -1;
        l.pt1 = (WorldPt)this.pts.elementAt(0);
        int npts = this.pts.size();
        for (int i = 1; i < npts; ++i) {
            WorldPt pt = (WorldPt)this.pts.elementAt(i);
            if (pt == null) continue;
            l.pt0 = l.pt1;
            l.pt1 = pt;
            double dist = wpt.ptNearLineSeg(l, ptn);
            if (!(dist < mindist)) continue;
            mindist = dist;
            if (ptnbest != null) {
                ptnbest.init(ptn);
            }
            ifound = i;
        }
        return mindist;
    }

    public double getLength() {
        int i;
        if (this._length != 0.0) {
            return this._length;
        }
        int npts = this.pts.size();
        if (npts < 2) {
            return 0.0;
        }
        if (this._coordAtPt == null || this._coordAtPt.length != npts) {
            this._coordAtPt = new double[this.pts.size()];
        }
        this._coordAtPt[0] = 0.0;
        WorldPt pt0 = (WorldPt)this.pts.elementAt(0);
        for (i = 1; i < npts; ++i) {
            WorldPt pt = (WorldPt)this.pts.elementAt(i);
            this._length += pt0.distToPoint(pt);
            this._coordAtPt[i] = this._length;
            pt0 = pt;
        }
        if (this._length > 0.0) {
            i = 0;
            while (i < npts) {
                int n = i++;
                this._coordAtPt[n] = this._coordAtPt[n] / this._length;
            }
        } else {
            this._coordAtPt[npts - 1] = 1.0;
        }
        return this._length;
    }

    public void invalidate() {
        this._length = 0.0;
        this._coordAtPt = null;
        this._bounds = null;
    }

    public int getPtIndexBeforeCoord(double coord) {
        int npts;
        if (this._coordAtPt == null) {
            this.getLength();
        }
        if ((npts = this.pts.size()) < 2) {
            return -1;
        }
        for (int i = 1; i < npts; ++i) {
            if (!(this._coordAtPt[i] > coord)) continue;
            return i - 1;
        }
        return npts - 1;
    }

    public int getPtIndexNearCoord(double coord) {
        int npts;
        if (this._coordAtPt == null) {
            this.getLength();
        }
        if ((npts = this.pts.size()) < 2) {
            return -1;
        }
        for (int i = 1; i < npts; ++i) {
            if (!(this._coordAtPt[i] >= coord)) continue;
            if (coord - this._coordAtPt[i - 1] < this._coordAtPt[i] - coord) {
                return i - 1;
            }
            return i;
        }
        return npts - 1;
    }

    public double getCoordAtLocation(WorldPt wpt) {
        if (wpt == null || this.pts.size() < 2) {
            return Double.NEGATIVE_INFINITY;
        }
        WorldLineSeg l = new WorldLineSeg();
        WorldPt ptn = new WorldPt();
        WorldPt ptnbest = new WorldPt();
        double cumlen = 0.0;
        double mindist = Double.MAX_VALUE;
        double coord = Double.NEGATIVE_INFINITY;
        int ifound = -1;
        double length = this.getLength();
        if (length == 0.0) {
            return Double.NEGATIVE_INFINITY;
        }
        l.pt1 = (WorldPt)this.pts.elementAt(0);
        for (int i = 1; i < this.pts.size(); ++i) {
            WorldPt pt = (WorldPt)this.pts.elementAt(i);
            if (pt == null) continue;
            l.pt0 = l.pt1;
            l.pt1 = pt;
            double dist = wpt.ptNearLineSeg(l, ptn);
            if (dist < mindist) {
                mindist = dist;
                ptnbest.init(ptn);
                ifound = i;
                double seglen = l.pt0.distToPoint(ptnbest);
                coord = (cumlen + seglen) / length;
            }
            cumlen += l.length();
        }
        return coord;
    }

    public WorldPt getLocationByCoord(double coord) {
        double length = this.getLength();
        double dist = coord * length;
        double cumdist = 0.0;
        WorldPt spt0 = (WorldPt)this.pts.elementAt(0);
        for (int i = 1; i < this.pts.size(); ++i) {
            WorldPt spt = (WorldPt)this.pts.elementAt(i);
            double seglen = spt0.distToPoint(spt);
            if (cumdist + seglen >= dist) {
                WorldPt pt = spt0.interpolateLocation(spt, (dist - cumdist) / seglen);
                return pt;
            }
            cumdist += seglen;
            spt0 = spt;
        }
        return this.newPt();
    }

    public boolean insertPt(WorldPt wpt, double tol) {
        if (wpt == null || this.pts.size() < 2) {
            return false;
        }
        this.invalidate();
        WorldLineSeg l = new WorldLineSeg();
        WorldPt ptn = new WorldPt();
        WorldPt ptnbest = this.newPt();
        double mindist = Double.MAX_VALUE;
        int ifound = -1;
        l.pt1 = (WorldPt)this.pts.elementAt(0);
        for (int i = 1; i < this.pts.size(); ++i) {
            WorldPt pt = (WorldPt)this.pts.elementAt(i);
            if (pt == null) continue;
            l.pt0 = l.pt1;
            l.pt1 = pt;
            double dist = wpt.ptNearLineSeg(l, ptn);
            if (!(dist < mindist) || !(dist <= tol)) continue;
            mindist = dist;
            ptnbest.init(ptn);
            ifound = i;
        }
        if (ifound >= 0) {
            this.pts.insertElementAt(ptnbest, ifound);
            return true;
        }
        return false;
    }

    public boolean removePt(WorldPt wpt, double tol) {
        if (wpt == null || this.pts.size() <= 3) {
            return false;
        }
        this.invalidate();
        WorldRect rc = new WorldRect(wpt.e - tol, wpt.n + tol, wpt.e + tol, wpt.n - tol);
        for (int i = 0; i < this.pts.size(); ++i) {
            WorldPt pt = (WorldPt)this.pts.elementAt(i);
            if (pt == null || !rc.contains(pt)) continue;
            this.pts.removeElementAt(i);
            return true;
        }
        return false;
    }

    public boolean removePtsAfter(WorldPt wpt) {
        if (wpt == null || !wpt.isValid()) {
            return false;
        }
        if (this.pts.size() == 2) {
            ((WorldPt)this.pts.get(1)).init(wpt);
            this.invalidate();
            return true;
        }
        for (int i = this.pts.size() - 1; i >= 0; --i) {
            WorldPt pt = (WorldPt)this.pts.get(i);
            if (pt == null || !pt.equals(wpt)) continue;
            for (int j = i - 1; j >= 0; --j) {
                this.pts.remove(j);
            }
            this.invalidate();
            return true;
        }
        return false;
    }

    public String toString() {
        StringBuffer buf = new StringBuffer(this.pts.size() * 30);
        for (int i = 0; i < this.pts.size(); ++i) {
            WorldPt pt = (WorldPt)this.pts.elementAt(i);
            if (pt == null) continue;
            if (i > 0) {
                buf.append(", ");
            }
            buf.append(pt.toString());
        }
        return buf.toString();
    }

    public void parseString(String str) {
        if (Boolean.getBoolean("Use.WorldPt.ParseString")) {
            String substr = str;
            this.invalidate();
            this.pts.removeAllElements();
            while (substr != null) {
                WorldPt pt = this.newPt();
                substr = pt.parseString(substr);
                if (!pt.isValid()) continue;
                this.pts.addElement(pt);
            }
        } else {
            StringTokenizer tokenizer = new StringTokenizer(str, ",");
            while (tokenizer.hasMoreTokens()) {
                WorldPt wpt = new WorldPt();
                String eStr = tokenizer.nextToken();
                if (tokenizer.hasMoreTokens()) {
                    String nStr = tokenizer.nextToken();
                    wpt.init(RMAIO.parseDouble(eStr), RMAIO.parseDouble(nStr));
                    this.pts.add(wpt);
                    continue;
                }
                break;
            }
        }
    }

    static boolean calcSlope(WorldPt p0, WorldPt p1, WorldPt slope) {
        if (p0 == null || p1 == null) {
            return false;
        }
        double dx = p1.e - p0.e;
        double dy = p1.n - p0.n;
        double distsq = dx * dx + dy * dy;
        if (distsq == 0.0) {
            return false;
        }
        double dist = Math.sqrt(distsq);
        slope.e = dx / dist;
        slope.n = dy / dist;
        return true;
    }

    public WorldLine createOffsetLine(double coord0, double coord1, double offset, int bank) {
        double dist;
        WorldPt pt1;
        int i;
        WorldLine newline = new WorldLine();
        if (coord1 < coord0) {
            double c2 = coord1;
            coord1 = coord0;
            coord0 = c2;
        }
        WorldPt slope0 = new WorldPt();
        WorldPt slope1 = new WorldPt();
        WorldPt ptbest = new WorldPt();
        WorldPt ptdist = new WorldPt();
        double cumdist = 0.0;
        double length = this.getLength();
        int imax = this.pts.size();
        WorldPt pt0 = (WorldPt)this.pts.elementAt(0);
        int icnt = 0;
        for (i = 1; i < imax; ++i) {
            double n;
            double e;
            pt1 = (WorldPt)this.pts.elementAt(i);
            if ((cumdist += pt0.distToPoint(pt1)) / length < coord0) {
                pt0 = pt1;
                continue;
            }
            WorldLine.calcSlope(pt0, pt1, slope1);
            if (i == 1 || ++icnt == 1) {
                e = pt0.e - slope1.n * (double)bank * offset;
                n = pt0.n + slope1.e * (double)bank * offset;
                newline.pts.addElement(new WorldPt(e, n));
            } else {
                double cosang = Math.sqrt((slope0.n * slope1.n + slope0.e * slope1.e + 1.0) / 2.0);
                double cross = slope0.e * slope1.n - slope0.n * slope1.e;
                dist = Math.sqrt((slope0.n + slope1.n) * (slope0.n + slope1.n) + (slope0.e + slope1.e) * (slope0.e + slope1.e));
                if (cross * (double)bank < 0.0) {
                    e = pt0.e - slope0.n * (double)bank * offset;
                    n = pt0.n + slope0.e * (double)bank * offset;
                    newline.pts.addElement(new WorldPt(e, n));
                    if (cosang > 0.5) {
                        if (dist == 0.0) {
                            dist = 2.0;
                        }
                        e = pt0.e - (slope0.n + slope1.n) / dist * (double)bank * offset;
                        n = pt0.n + (slope0.e + slope1.e) / dist * (double)bank * offset;
                        newline.pts.addElement(new WorldPt(e, n));
                    }
                    e = pt0.e - slope1.n * (double)bank * offset;
                    n = pt0.n + slope1.e * (double)bank * offset;
                    newline.pts.addElement(new WorldPt(e, n));
                } else {
                    if ((dist *= cosang) == 0.0) {
                        dist = 2.0;
                    }
                    e = pt0.e - (slope0.n + slope1.n) / dist * (double)bank * offset;
                    n = pt0.n + (slope0.e + slope1.e) / dist * (double)bank * offset;
                    newline.pts.addElement(new WorldPt(e, n));
                }
            }
            if (i == imax - 1 || cumdist / length > coord1) {
                e = pt1.e - slope1.n * (double)bank * offset;
                n = pt1.n + slope1.e * (double)bank * offset;
                newline.pts.addElement(new WorldPt(e, n));
            }
            if (cumdist / length > coord1) break;
            pt0 = pt1;
            slope0.init(slope1);
        }
        Vector<WorldPt> newpts = new Vector<WorldPt>(this.pts.size());
        pt0 = (WorldPt)newline.pts.elementAt(0);
        newpts.addElement(pt0);
        imax = newline.pts.size();
        WorldLineSeg seg = new WorldLineSeg();
        WorldLineSeg jseg = new WorldLineSeg();
        for (i = 1; i < imax; ++i) {
            pt1 = (WorldPt)newline.pts.elementAt(i);
            seg.init(pt0, pt1);
            WorldPt jpt0 = (WorldPt)newline.pts.elementAt(imax - 1);
            for (int j = imax - 2; j > i; --j) {
                WorldPt jpt1 = (WorldPt)newline.pts.elementAt(j);
                jseg.init(jpt0, jpt1);
                if (seg.intersect(jseg, ptbest, ptdist)) {
                    pt1.init(ptbest);
                    i = j;
                    break;
                }
                jpt0 = jpt1;
            }
            newpts.addElement(pt1);
            pt0 = pt1;
        }
        newline.pts = new Vector(newpts.size());
        newline.pts.addElement(newpts.elementAt(0));
        imax = newpts.size();
        for (i = 1; i < imax - 1; ++i) {
            pt0 = (WorldPt)newpts.elementAt(i);
            if (this.getNearestLocation(pt0, ptbest) < offset * 0.95) continue;
            newline.pts.addElement(pt0);
        }
        newline.pts.addElement(newpts.elementAt(imax - 1));
        if (coord0 == 0.0 && coord1 == 1.0) {
            return newline;
        }
        WorldPt ptStart = this.getLocationByCoord(coord0);
        WorldPt ptEnd = this.getLocationByCoord(coord1);
        double c0 = newline.getCoordAtLocation(ptStart);
        double c1 = newline.getCoordAtLocation(ptEnd);
        newpts = new Vector();
        newpts.addElement(newline.getLocationByCoord(c0));
        cumdist = 0.0;
        length = newline.getLength();
        pt0 = (WorldPt)newline.pts.elementAt(0);
        imax = newline.pts.size();
        for (i = 1; i < imax; ++i) {
            pt1 = (WorldPt)newline.pts.elementAt(i);
            dist = pt0.distToPoint(pt1);
            if ((cumdist += dist / length) > c0 && cumdist < c1) {
                newpts.addElement(pt1);
            }
            pt0 = pt1;
        }
        newpts.addElement(newline.getLocationByCoord(c1));
        newline.pts = newpts;
        return newline;
    }

    public boolean intersects(WorldLine wl, WorldPt intersectPt) {
        if (wl == null || wl.pts.size() < 2 || this.pts.size() < 2) {
            return false;
        }
        WorldLineSeg wlls = new WorldLineSeg();
        WorldLineSeg ls = new WorldLineSeg();
        int size = this.pts.size();
        int wlsize = wl.pts.size();
        ls.pt1 = (WorldPt)this.pts.get(0);
        WorldPt wptDist = new WorldPt();
        for (int i = 1; i < size; ++i) {
            WorldPt ipt = (WorldPt)this.pts.get(i);
            if (ipt == null) continue;
            ls.pt0 = ls.pt1;
            ls.pt1 = ipt;
            wlls.pt1 = (WorldPt)wl.pts.get(0);
            for (int j = 1; j < wlsize; ++j) {
                WorldPt pt = (WorldPt)wl.pts.get(j);
                if (pt == null) continue;
                wlls.pt0 = wlls.pt1;
                wlls.pt1 = pt;
                if (!wlls.intersect(ls, intersectPt, wptDist)) continue;
                return true;
            }
        }
        return false;
    }

    public boolean intersects(WorldLineSeg l, WorldPt ptOfIntersect, WorldPt ptDist, int istart) {
        WorldLineSeg seg = new WorldLineSeg();
        WorldPt pti = new WorldPt();
        WorldPt ptd = new WorldPt();
        double mindist = Double.MAX_VALUE;
        boolean b = false;
        int imax = this.pts.size();
        if (istart >= imax - 1) {
            return false;
        }
        WorldPt pt0 = (WorldPt)this.pts.elementAt(istart);
        for (int i = istart + 1; i < imax; ++i) {
            WorldPt pt1 = (WorldPt)this.pts.elementAt(i);
            seg.init(pt0, pt1);
            if (l.intersect(seg, pti, ptd) && ptd.e < mindist) {
                b = true;
                ptOfIntersect.init(pti);
                ptDist.init(ptd);
            }
            pt0 = pt1;
        }
        return b;
    }

    public int getLocalRegionArrays(MapScale scl, int[] xarray, int[] yarray) {
        return this.getLocalRegionArrays(scl, xarray, yarray, 6.0);
    }

    public int getLocalRegionArrays(MapScale scl, int[] xarray, int[] yarray, double width) {
        return this.getLocalRegionArrays(scl, xarray, yarray, width, 0, this.pts.size());
    }

    public int getLocalRegionArrays(MapScale scl, int[] xarray, int[] yarray, double width, int start, int numPoints) {
        int y;
        int x;
        if (start < 0) {
            start = 0;
        }
        if (start + numPoints > this.pts.size()) {
            numPoints = this.pts.size() - start;
        }
        if (numPoints < 2 || this.pts.size() < 2) {
            return 0;
        }
        int mpt = numPoints * 2 - 1;
        WorldPt slope0 = new WorldPt();
        WorldPt slope1 = new WorldPt();
        double halfwidth = width / 2.0;
        WorldPt pt0 = (WorldPt)this.pts.elementAt(start);
        WorldPt pt1 = (WorldPt)this.pts.elementAt(start + 1);
        WorldLine.calcSlope(pt0, pt1, slope1);
        LocalPt lpt = new LocalPt();
        if (scl != null) {
            scl.wp2lp(pt0, lpt);
            x = lpt.x;
            y = lpt.y;
        } else {
            x = (int)pt0.e;
            y = (int)pt0.n;
        }
        double ix = slope1.e * halfwidth;
        double iy = slope1.n * halfwidth;
        xarray[0] = (int)((double)x - iy);
        yarray[0] = (int)((double)y - ix);
        xarray[mpt] = (int)((double)x + iy);
        yarray[mpt] = (int)((double)y + ix);
        int loopCnt = numPoints;
        if (xarray.length / 2 < numPoints) {
            loopCnt = xarray.length / 2;
            System.out.println("WorldLine.getLocalRegionArrays: clipped line to " + loopCnt + " points needed " + this.pts.size());
        }
        int idx = 2;
        for (int i = start + 2; i < loopCnt + start; ++i) {
            pt0 = pt1;
            slope0.init(slope1);
            pt1 = (WorldPt)this.pts.elementAt(i);
            WorldLine.calcSlope(pt0, pt1, slope1);
            slope0.e = (slope0.e + slope1.e) / 2.0;
            slope0.n = (slope0.n + slope1.n) / 2.0;
            double dist = Math.sqrt(slope0.e * slope0.e + slope0.n * slope0.n);
            if (scl != null) {
                scl.wp2lp(pt0, lpt);
                x = lpt.x;
                y = lpt.y;
            } else {
                x = (int)pt0.e;
                y = (int)pt0.n;
            }
            ix = slope0.e * halfwidth / dist;
            iy = slope0.n * halfwidth / dist;
            xarray[idx - 1] = (int)((double)x - iy);
            yarray[idx - 1] = (int)((double)y - ix);
            xarray[mpt - (idx - 1)] = (int)((double)x + iy);
            yarray[mpt - (idx - 1)] = (int)((double)y + ix);
            ++idx;
        }
        if (scl != null) {
            scl.wp2lp(pt1, lpt);
            x = lpt.x;
            y = lpt.y;
        } else {
            x = (int)pt1.e;
            y = (int)pt1.n;
        }
        ix = slope1.e * halfwidth;
        iy = slope1.n * halfwidth;
        xarray[idx - 1] = (int)((double)x - iy);
        yarray[idx - 1] = (int)((double)y - ix);
        xarray[mpt - (idx - 1)] = (int)((double)x + iy);
        yarray[mpt - (idx - 1)] = (int)((double)y + ix);
        return mpt + 1;
    }

    public int getLocalArrays(MapScale scl, int[] xarray, int[] yarray, int start, int numPoints) {
        if (start < 0) {
            start = 0;
        }
        if (start + numPoints > this.pts.size()) {
            numPoints = this.pts.size() - start;
        }
        if (numPoints < 2 || this.pts.size() < 2) {
            return 0;
        }
        int mpt = numPoints - 1;
        WorldPt pt0 = (WorldPt)this.pts.get(start);
        WorldPt pt1 = (WorldPt)this.pts.get(start + 1);
        LocalPt lpt = new LocalPt();
        scl.wp2lp(pt0, lpt);
        int x = lpt.x;
        int y = lpt.y;
        xarray[0] = x;
        yarray[0] = y;
        int loopCnt = numPoints;
        if (xarray.length / 2 < numPoints) {
            loopCnt = xarray.length / 2;
            System.out.println("WorldLine.getLocalArrays: clipped line to " + loopCnt + " points needed " + this.pts.size());
        }
        int idx = 2;
        for (int i = start + 2; i < loopCnt + start; ++i) {
            pt1 = (WorldPt)this.pts.get(i);
            scl.wp2lp(pt1, lpt);
            x = lpt.x;
            y = lpt.y;
            xarray[idx - 1] = x;
            yarray[idx - 1] = y;
            ++idx;
        }
        return mpt;
    }

    public int getLocalArrays2d(MapScale scl, int[] xarray, int[] yarray, int start, int numPoints) {
        if (start < 0) {
            start = 0;
        }
        if (start + numPoints > this.pts.size()) {
            numPoints = this.pts.size() - start;
        }
        if (numPoints < 2 || this.pts.size() < 2) {
            return 0;
        }
        int mpt = numPoints;
        WorldPt pt0 = (WorldPt)this.pts.get(start);
        WorldPt pt1 = (WorldPt)this.pts.get(start + 1);
        LocalPt lpt = new LocalPt();
        scl.wp2lp(pt0, lpt);
        int x = lpt.x;
        int y = lpt.y;
        xarray[0] = x;
        yarray[0] = y;
        int loopCnt = numPoints;
        if (xarray.length / 2 < numPoints) {
            loopCnt = xarray.length / 2;
            System.out.println("WorldLine.getLocalArrays: clipped line to " + loopCnt + " points needed " + this.pts.size());
        }
        int idx = 1;
        for (int i = start + 1; i < loopCnt + start; ++i) {
            pt1 = (WorldPt)this.pts.get(i);
            scl.wp2lp(pt1, lpt);
            x = lpt.x;
            y = lpt.y;
            xarray[idx] = x;
            yarray[idx] = y;
            ++idx;
        }
        return loopCnt;
    }

    public boolean getSlopeAtCoord(double coord, WorldPt wpt, WorldPt slope) {
        if (coord == Double.NEGATIVE_INFINITY || wpt == null || slope == null) {
            return false;
        }
        if (this.pts.size() < 2) {
            return false;
        }
        if (_tmpSeg == null) {
            _tmpSeg = new WorldLineSeg();
        }
        WorldLineSeg l = _tmpSeg;
        if (this._coordAtPt == null) {
            this.getLength();
        }
        for (int ii = 1; ii < this._coordAtPt.length; ++ii) {
            if (this._coordAtPt[ii] < coord) continue;
            l.pt0 = (WorldPt)this.pts.get(ii - 1);
            l.pt1 = (WorldPt)this.pts.get(ii);
            double slen = l.length();
            if (slen == 0.0) {
                slope.init(1.0, 0.0);
                return true;
            }
            double scl = (coord - this._coordAtPt[ii - 1]) / (this._coordAtPt[ii] - this._coordAtPt[ii - 1]);
            wpt.init(l.pt0.e + (l.pt1.e - l.pt0.e) * scl, l.pt0.n + (l.pt1.n - l.pt0.n) * scl);
            slope.init((l.pt1.e - l.pt0.e) / slen, (l.pt1.n - l.pt0.n) / slen);
            return true;
        }
        return false;
    }

    public void setLinePoint(double coord, WorldPt wpt) {
        WorldPt existingPt;
        if (this.pts.size() <= 0) {
            return;
        }
        if (coord == 0.0) {
            existingPt = (WorldPt)this.pts.elementAt(0);
        } else if (coord == 1.0) {
            existingPt = (WorldPt)this.pts.elementAt(this.pts.size() - 1);
        } else {
            return;
        }
        if (existingPt != null) {
            this.invalidate();
            existingPt.init(wpt);
        }
    }

    public WorldRect getBounds() {
        if (this._bounds == null && this.pts.size() > 0) {
            this._bounds = new WorldRect();
            this._bounds.initToPoint((WorldPt)this.pts.firstElement());
            Enumeration e = this.pts.elements();
            while (e.hasMoreElements()) {
                WorldPt p = (WorldPt)e.nextElement();
                this._bounds.growToPoint(p);
            }
        }
        return this._bounds;
    }

    public boolean add(WorldLine line) {
        if (line == null) {
            return false;
        }
        if (this.pts.size() == 0) {
            this.invalidate();
            this.pts.addAll(line.pts);
            return true;
        }
        WorldPt theirFirstPt = line.getFirstPt();
        WorldPt theirLastPt = line.getLastPt();
        WorldPt myFirstPt = this.getFirstPt();
        WorldPt myLastPt = this.getLastPt();
        int size = line.pts.size();
        if (myLastPt.equals(theirFirstPt)) {
            this.pts.ensureCapacity(size + this.pts.size());
            for (int i = 1; i < size; ++i) {
                this.pts.add(line.pts.elementAt(i));
            }
        } else if (myLastPt.equals(theirLastPt)) {
            this.pts.ensureCapacity(size + this.pts.size());
            for (int i = size - 2; i >= 0; --i) {
                this.pts.add(line.pts.elementAt(i));
            }
        } else if (myFirstPt.equals(theirFirstPt)) {
            this.pts.ensureCapacity(size + this.pts.size());
            for (int i = 1; i < size; ++i) {
                this.pts.insertElementAt(line.pts.elementAt(i), 0);
            }
        } else if (myFirstPt.equals(theirLastPt)) {
            this.pts.ensureCapacity(size + this.pts.size());
            for (int i = size - 2; i >= 0; --i) {
                this.pts.insertElementAt(line.pts.elementAt(i), 0);
            }
        } else {
            return false;
        }
        this.invalidate();
        return true;
    }

    public boolean equals(Object obj) {
        if (obj instanceof WorldLine) {
            return this.equals((WorldLine)obj);
        }
        return false;
    }

    public boolean equals(WorldLine that) {
        if (that == null) {
            return false;
        }
        if (that == this) {
            return true;
        }
        return that.pts.equals(this.pts);
    }

    @Override
    public Object getFieldObject(Field fld) {
        try {
            Object obj = fld.get(this);
            return obj;
        }
        catch (IllegalAccessException e) {
            return null;
        }
    }

    @Override
    public boolean setFieldObject(Field fld, Object fobj) {
        try {
            fld.set(this, fobj);
            return true;
        }
        catch (IllegalAccessException e) {
            return false;
        }
        catch (IllegalArgumentException e) {
            return false;
        }
    }
}

