/*
 * Decompiled with CFR 0.152.
 */
package hec.map;

import hec.map.WorldPt;

public class WorldLineSeg {
    public WorldPt pt0 = new WorldPt();
    public WorldPt pt1 = new WorldPt();

    public WorldLineSeg() {
    }

    public WorldLineSeg(WorldPt s, WorldPt t) {
        this.pt0.init(s);
        this.pt1.init(t);
    }

    public WorldLineSeg(WorldLineSeg l) {
        this.pt0.init(l.pt0);
        this.pt1.init(l.pt1);
    }

    public void init(WorldPt p0, WorldPt p1) {
        this.pt0.init(p0);
        this.pt1.init(p1);
    }

    public double delx() {
        return this.pt1.e - this.pt0.e;
    }

    public double dely() {
        return this.pt1.n - this.pt0.n;
    }

    public double length() {
        return Math.sqrt(this.delx() * this.delx() + this.dely() * this.dely());
    }

    public double xoft(double t) {
        return this.pt0.e + t * this.delx();
    }

    public double yoft(double t) {
        return this.pt0.n + t * this.dely();
    }

    public WorldPt poft(double t) {
        WorldPt p = new WorldPt();
        p.e = this.xoft(t);
        p.n = this.yoft(t);
        return p;
    }

    public boolean intersect(WorldLineSeg l, WorldPt p, WorldPt pdist) {
        double dx0 = this.delx();
        double dy0 = this.dely();
        double dx1 = l.delx();
        double dy1 = l.dely();
        if (dx0 == dx1 && dy0 == dy1) {
            return false;
        }
        if (dx0 * dy1 - dx1 * dy0 == 0.0) {
            return false;
        }
        double dist = ((l.pt0.e - this.pt0.e) * dy1 - (l.pt0.n - this.pt0.n) * dx1) / (dx0 * dy1 - dx1 * dy0);
        double dist1 = Math.abs(dy1) > 1.0E-9 ? (this.pt0.n - l.pt0.n + dist * dy0) / dy1 : (this.pt0.e - l.pt0.e + dist * dx0) / dx1;
        pdist.e = dist;
        pdist.n = dist1;
        if (dist >= 0.0 && dist <= 1.0 && dist1 >= 0.0 && dist1 <= 1.0) {
            p.e = this.pt0.e + dx0 * dist;
            p.n = this.pt0.n + dy0 * dist;
            return true;
        }
        return false;
    }
}

