/*
 * Decompiled with CFR 0.152.
 */
package hec.map;

import hec.map.WorldLine;
import hec.map.WorldLineSeg;
import hec.map.WorldPt;
import java.awt.geom.Rectangle2D;
import java.io.Serializable;
import java.util.StringTokenizer;
import rma.util.RMAIO;

public class WorldRect
implements Serializable {
    static final long serialVersionUID = -3709151209438231954L;
    public double w = Double.NEGATIVE_INFINITY;
    public double n = Double.NEGATIVE_INFINITY;
    public double e = Double.NEGATIVE_INFINITY;
    public double s = Double.NEGATIVE_INFINITY;

    public WorldRect() {
    }

    public WorldRect(double rw, double rn, double re, double rs) {
        this.w = rw;
        this.n = rn;
        this.e = re;
        this.s = rs;
        this.justify();
    }

    public WorldRect(WorldPt nw, WorldPt se) {
        this.w = nw.e;
        this.n = nw.n;
        this.e = se.e;
        this.s = se.n;
        this.justify();
    }

    public WorldRect(WorldPt p, double radius) {
        this.w = p.e - radius;
        this.e = p.e + radius;
        this.n = p.n + radius;
        this.s = p.n - radius;
    }

    public WorldRect(WorldRect r) {
        this.set(r);
    }

    public WorldRect(Rectangle2D r) {
        this.w = r.getX();
        this.e = this.w + r.getWidth();
        this.n = r.getY() + r.getHeight();
        this.s = r.getY();
    }

    public Rectangle2D.Double getRectangle2D() {
        Rectangle2D.Double rect = new Rectangle2D.Double(this.w, this.s, this.width(), this.height());
        return rect;
    }

    public void set(WorldRect r) {
        this.e = r.e;
        this.w = r.w;
        this.n = r.n;
        this.s = r.s;
        this.justify();
    }

    public double width() {
        return this.e - this.w;
    }

    public double height() {
        return this.n - this.s;
    }

    public double area() {
        return (this.e - this.w) * (this.n - this.s);
    }

    public void copy(WorldRect r) {
        this.e = r.e;
        this.w = r.w;
        this.n = r.n;
        this.s = r.s;
        this.justify();
    }

    public boolean init(String extents) {
        if (extents == null) {
            this.setInvalid();
            return false;
        }
        StringTokenizer tokenizer = new StringTokenizer(extents, ",");
        if (tokenizer.countTokens() < 4) {
            this.setInvalid();
            return false;
        }
        this.w = RMAIO.parseDouble(tokenizer.nextToken(), Double.NEGATIVE_INFINITY);
        this.n = RMAIO.parseDouble(tokenizer.nextToken(), Double.NEGATIVE_INFINITY);
        this.e = RMAIO.parseDouble(tokenizer.nextToken(), Double.NEGATIVE_INFINITY);
        this.s = RMAIO.parseDouble(tokenizer.nextToken(), Double.NEGATIVE_INFINITY);
        return this.isValid();
    }

    public void init(double pw, double pn, double pe, double ps) {
        this.w = pw;
        this.n = pn;
        this.e = pe;
        this.s = ps;
        this.justify();
    }

    public void init(WorldPt p, double radius) {
        this.w = p.e - radius;
        this.e = p.e + radius;
        this.n = p.n + radius;
        this.s = p.n - radius;
        this.justify();
    }

    public void init(WorldPt nw, WorldPt se) {
        this.w = nw.e;
        this.n = nw.n;
        this.e = se.e;
        this.s = se.n;
        this.justify();
    }

    public void init(WorldRect rc) {
        this.e = rc.e;
        this.w = rc.w;
        this.n = rc.n;
        this.s = rc.s;
        this.justify();
    }

    public void init(WorldPt p) {
        if (p == null) {
            return;
        }
        this.e = this.w = p.e;
        this.n = this.s = p.n;
    }

    @Deprecated
    public void initToPoint(WorldPt p) {
        if (p == null) {
            return;
        }
        this.e = this.w = p.e;
        this.n = this.s = p.n;
    }

    public void grow(WorldPt p) {
        if (p == null) {
            return;
        }
        if (this.w == Double.NEGATIVE_INFINITY) {
            this.w = p.e;
        }
        if (this.s == Double.NEGATIVE_INFINITY) {
            this.s = p.n;
        }
        if (p.e != Double.NEGATIVE_INFINITY && this.e < p.e) {
            this.e = p.e;
        }
        if (p.e != Double.NEGATIVE_INFINITY && this.w > p.e) {
            this.w = p.e;
        }
        if (p.n != Double.NEGATIVE_INFINITY && this.n < p.n) {
            this.n = p.n;
        }
        if (p.n != Double.NEGATIVE_INFINITY && this.s > p.n) {
            this.s = p.n;
        }
    }

    @Deprecated
    public void growToPoint(WorldPt p) {
        this.grow(p);
    }

    public void grow(WorldRect r) {
        if (r == null) {
            return;
        }
        if (this.w == Double.NEGATIVE_INFINITY) {
            this.w = r.w;
        }
        if (this.s == Double.NEGATIVE_INFINITY) {
            this.s = r.s;
        }
        if (r.e != Double.NEGATIVE_INFINITY && this.e < r.e) {
            this.e = r.e;
        }
        if (r.e != Double.NEGATIVE_INFINITY && this.e < r.w) {
            this.e = r.w;
        }
        if (r.w != Double.NEGATIVE_INFINITY && this.w > r.w) {
            this.w = r.w;
        }
        if (r.w != Double.NEGATIVE_INFINITY && this.w > r.e) {
            this.w = r.e;
        }
        if (r.n != Double.NEGATIVE_INFINITY && this.n < r.n) {
            this.n = r.n;
        }
        if (r.n != Double.NEGATIVE_INFINITY && this.n < r.s) {
            this.n = r.s;
        }
        if (r.s != Double.NEGATIVE_INFINITY && this.s > r.s) {
            this.s = r.s;
        }
        if (r.s != Double.NEGATIVE_INFINITY && this.s > r.n) {
            this.s = r.n;
        }
    }

    @Deprecated
    public void growToRect(WorldRect r) {
        this.grow(r);
    }

    public void justify() {
        double tmp;
        if (this.w > this.e) {
            tmp = this.e;
            this.e = this.w;
            this.w = tmp;
        }
        if (this.s > this.n) {
            tmp = this.n;
            this.n = this.s;
            this.s = tmp;
        }
    }

    public boolean isValid() {
        if (this.w == Double.NEGATIVE_INFINITY || this.n == Double.NEGATIVE_INFINITY || this.e == Double.NEGATIVE_INFINITY || this.s == Double.NEGATIVE_INFINITY) {
            return false;
        }
        if (this.area() == 0.0) {
            return false;
        }
        this.justify();
        return true;
    }

    public void setInvalid() {
        this.s = Double.NEGATIVE_INFINITY;
        this.e = Double.NEGATIVE_INFINITY;
        this.n = Double.NEGATIVE_INFINITY;
        this.w = Double.NEGATIVE_INFINITY;
    }

    public boolean contains(double pte, double ptn) {
        return pte >= this.w && pte <= this.e && ptn >= this.s && ptn <= this.n;
    }

    public boolean contains(WorldPt pt) {
        if (pt == null) {
            return false;
        }
        return pt.e >= this.w && pt.e <= this.e && pt.n >= this.s && pt.n <= this.n;
    }

    public boolean contains(double tolerance, WorldPt pt) {
        if (pt == null) {
            return false;
        }
        return pt.e >= this.w - tolerance && pt.e <= this.e + tolerance && pt.n >= this.s - tolerance && pt.n <= this.n + tolerance;
    }

    public boolean contains(WorldRect rect) {
        if (rect == null) {
            return false;
        }
        return rect.w >= this.w && rect.n <= this.n && rect.e <= this.e && rect.s >= this.s;
    }

    public boolean contains(WorldLine l) {
        if (l == null) {
            return false;
        }
        if (!this.intersects(l.getBounds())) {
            return false;
        }
        for (int ii = 0; ii < l.pts.size(); ++ii) {
            WorldPt p = (WorldPt)l.pts.get(ii);
            if (!this.contains(p)) continue;
            return true;
        }
        return true;
    }

    public boolean intersects(WorldRect rc) {
        if (rc == null) {
            return false;
        }
        if (rc.e < this.w) {
            return false;
        }
        if (rc.w > this.e) {
            return false;
        }
        if (rc.n < this.s) {
            return false;
        }
        return !(rc.s > this.n);
    }

    public boolean intersect(WorldLineSeg l, WorldLineSeg lclipped) {
        WorldPt pt0 = l.pt0;
        WorldPt pt1 = l.pt1;
        int iquad0 = this.quad(pt0);
        int iquad1 = this.quad(pt1);
        if (iquad0 == 22 && iquad1 == 22) {
            lclipped = l;
            return true;
        }
        boolean swap = false;
        boolean out = true;
        int icnt = 0;
        while (out) {
            if (iquad0 < 20 && iquad1 < 20) {
                return false;
            }
            if (iquad0 > 30 && iquad1 > 30) {
                return false;
            }
            if (iquad0 % 10 < 2 && iquad1 % 10 < 2) {
                return false;
            }
            if (iquad0 % 10 > 2 && iquad1 % 10 > 2) {
                return false;
            }
            if (iquad0 == 22) {
                WorldPt ptTmp = pt0;
                pt0 = pt1;
                pt1 = ptTmp;
                int iquadtmp = iquad0;
                iquad0 = iquad1;
                iquad1 = iquadtmp;
                swap = !swap;
            }
            double xb = Double.NEGATIVE_INFINITY;
            double yb = Double.NEGATIVE_INFINITY;
            if (iquad0 % 10 > 2) {
                xb = pt0.e + (pt1.e - pt0.e) * (this.n - pt0.n) / (pt1.n - pt0.n);
                yb = this.n;
            } else if (iquad0 % 10 < 2) {
                xb = pt0.e + (pt1.e - pt0.e) * (this.s - pt0.n) / (pt1.n - pt0.n);
                yb = this.s;
            } else if (iquad0 > 30) {
                yb = pt0.n + (pt1.n - pt0.n) * (this.e - pt0.e) / (pt1.e - pt0.e);
                xb = this.e;
            } else if (iquad0 < 20) {
                yb = pt0.n + (pt1.n - pt0.n) * (this.w - pt0.e) / (pt1.e - pt0.e);
                xb = this.w;
            }
            pt0 = new WorldPt(xb, yb);
            iquad0 = this.quad(pt0);
            if (iquad0 == 22 && iquad1 == 22) {
                if (swap) {
                    lclipped.pt0 = pt1;
                    lclipped.pt1 = pt0;
                } else {
                    lclipped.pt0 = pt0;
                    lclipped.pt1 = pt1;
                }
                return true;
            }
            if (++icnt <= 8) continue;
            return false;
        }
        return false;
    }

    private int quad(WorldPt p) {
        int iquad = 22;
        if (p.e < this.w) {
            iquad = 12;
        }
        if (p.e > this.e) {
            iquad = 32;
        }
        if (p.n < this.s) {
            --iquad;
        }
        if (p.n > this.n) {
            ++iquad;
        }
        return iquad;
    }

    public WorldRect getIntersection(WorldRect rc) {
        if (!this.intersects(rc)) {
            return null;
        }
        WorldRect irc = new WorldRect(this);
        if (rc.w > this.w) {
            irc.w = rc.w;
        }
        if (rc.e < this.e) {
            irc.e = rc.e;
        }
        if (rc.n < this.n) {
            irc.n = rc.n;
        }
        if (rc.s > this.s) {
            irc.s = rc.s;
        }
        return irc;
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof WorldRect)) {
            return super.equals(obj);
        }
        WorldRect compWr = (WorldRect)obj;
        boolean tf = false;
        if (compWr.w == this.w && compWr.e == this.e && compWr.n == this.n && compWr.s == this.s) {
            tf = true;
        }
        return tf;
    }

    public WorldPt getCenterPoint() {
        double y = (this.n + this.s) / 2.0;
        double x = (this.w + this.e) / 2.0;
        return new WorldPt(x, y);
    }

    public String toString() {
        return this.w + "," + this.n + "," + this.e + "," + this.s;
    }

    public String paramString() {
        return "W:" + RMAIO.setPrecision(this.w, 3) + " N:" + RMAIO.setPrecision(this.n, 3) + " E:" + RMAIO.setPrecision(this.e, 3) + " S:" + RMAIO.setPrecision(this.s, 3);
    }
}

