/*
 * Decompiled with CFR 0.152.
 */
package hec.map;

import com.vividsolutions.jts.geom.Envelope;
import com.vividsolutions.jts.index.strtree.STRtree;
import hec.map.WorldLine;
import hec.map.WorldLineSeg;
import hec.map.WorldPt;
import hec.map.WorldRect;
import hec.map.WorldRegionIterator;
import java.awt.Rectangle;
import java.awt.Shape;
import java.awt.geom.AffineTransform;
import java.awt.geom.Area;
import java.awt.geom.Path2D;
import java.awt.geom.PathIterator;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Vector;

public class WorldRegion
implements Serializable,
Cloneable,
Shape {
    private static final long serialVersionUID = 286645682652024221L;
    public Vector pts = new Vector();
    private transient Boolean _isClockwise = null;
    private transient Boolean _isSelfIntersecting = null;
    private transient WorldRect _bounds = null;

    public WorldLine getOutline() {
        return this.getOutline(new WorldLine());
    }

    public WorldLine getOutline(WorldLine line) {
        line.pts.clear();
        if (this.pts.size() > 0) {
            line.pts.addAll(this.pts);
            line.pts.add(this.pts.firstElement());
        }
        return line;
    }

    public double getArea() {
        double area = this.getAreaUnsigned();
        if (area < 0.0) {
            area *= -1.0;
        }
        return area;
    }

    private double getAreaUnsigned() {
        double area = 0.0;
        int imax = this.pts.size();
        if (imax < 3) {
            return 0.0;
        }
        WorldPt pt0 = (WorldPt)this.pts.lastElement();
        for (int i = 0; i < imax; ++i) {
            WorldPt pt1 = (WorldPt)this.pts.get(i);
            area += (pt0.n + pt1.n) * (pt0.e - pt1.e) / 2.0;
            pt0 = pt1;
        }
        return area;
    }

    public synchronized Object clone() {
        try {
            WorldRegion region = (WorldRegion)super.clone();
            region._isClockwise = this._isClockwise;
            region.pts = new Vector(this.pts.size());
            for (int i = 0; i < this.pts.size(); ++i) {
                WorldPt pt = (WorldPt)this.pts.elementAt(i);
                WorldPt cl = (WorldPt)pt.clone();
                if (cl == null) continue;
                region.pts.addElement(cl);
            }
            return region;
        }
        catch (CloneNotSupportedException e) {
            return null;
        }
    }

    public WorldRect getWorldRectBounds() {
        if (this._bounds == null) {
            this._bounds = new WorldRect();
        }
        if (!this._bounds.isValid()) {
            for (int ii = 0; ii < this.pts.size(); ++ii) {
                this._bounds.grow((WorldPt)this.pts.get(ii));
            }
        }
        return this._bounds;
    }

    public WorldPt getCentroid() {
        double area = this.getAreaUnsigned();
        if (area == 0.0) {
            return null;
        }
        WorldPt centroid = new WorldPt(0.0, 0.0);
        ArrayList ptsCopy = new ArrayList(this.pts);
        ptsCopy.add(this.pts.get(0));
        for (int i = 0; i < ptsCopy.size() - 1; ++i) {
            WorldPt pt0 = (WorldPt)ptsCopy.get(i);
            WorldPt pt1 = (WorldPt)ptsCopy.get(i + 1);
            double second_factor = pt0.e * pt1.n - pt1.e * pt0.n;
            centroid.e += (pt0.e + pt1.e) * second_factor;
            centroid.n += (pt0.n + pt1.n) * second_factor;
        }
        centroid.e /= 6.0 * area;
        centroid.n /= 6.0 * area;
        return centroid;
    }

    public WorldPt getCenterPt() {
        WorldPt refpt = new WorldPt();
        for (int i = 0; i < this.pts.size(); ++i) {
            WorldPt pt = (WorldPt)this.pts.elementAt(i);
            if (pt == null) continue;
            if (i == 0) {
                refpt.init(pt);
                continue;
            }
            refpt.e += pt.e;
            refpt.n += pt.n;
        }
        double xnum = this.pts.size();
        if (xnum > 1.0) {
            refpt.e /= xnum;
            refpt.n /= xnum;
        }
        return refpt;
    }

    public boolean contains(WorldPt wpt) {
        Double dbl;
        int i;
        if (this.pts.size() < 3) {
            return false;
        }
        WorldRect bounds = this.getWorldRectBounds();
        if (!bounds.contains(wpt)) {
            return false;
        }
        Vector<Double> xvec = new Vector<Double>();
        WorldPt pt1 = null;
        for (i = 0; i <= this.pts.size(); ++i) {
            WorldPt pt = i < this.pts.size() ? (WorldPt)this.pts.elementAt(i) : (WorldPt)this.pts.elementAt(0);
            if (pt == null) continue;
            WorldPt pt0 = pt1;
            pt1 = pt;
            if (pt0 == null) continue;
            if (pt0.e == pt1.e && pt0.n == pt1.n) {
                if (wpt.e != pt1.e || wpt.n != pt1.n) continue;
                return true;
            }
            if (wpt.n == pt0.n && wpt.n == pt1.n) {
                if (!(wpt.e >= pt0.e && wpt.e <= pt1.e) && (!(wpt.e <= pt0.e) || !(wpt.e >= pt1.e))) continue;
                return true;
            }
            if (pt0.n == pt1.n || !(wpt.n >= pt0.n && wpt.n <= pt1.n) && (!(wpt.n <= pt0.n) || !(wpt.n >= pt1.n))) continue;
            double xdist = pt0.e + (pt1.e - pt0.e) * (wpt.n - pt0.n) / (pt1.n - pt0.n);
            boolean found = false;
            for (int j = 0; j < xvec.size(); ++j) {
                dbl = (Double)xvec.elementAt(j);
                if (!(xdist < dbl)) continue;
                xvec.insertElementAt(new Double(xdist), j);
                found = true;
                break;
            }
            if (found) continue;
            xvec.addElement(new Double(xdist));
        }
        for (i = 1; i < xvec.size(); i += 2) {
            dbl = (Double)xvec.elementAt(i - 1);
            Double dbl2 = (Double)xvec.elementAt(i);
            if (!(wpt.e >= dbl) || !(wpt.e <= dbl2)) continue;
            return true;
        }
        return false;
    }

    public boolean insertPt(WorldPt wpt) {
        double dist;
        WorldPt pt;
        int i;
        if (wpt == null || this.pts.size() < 2) {
            this.pts.add(wpt);
        }
        WorldLineSeg l = new WorldLineSeg();
        WorldPt ptn = new WorldPt();
        WorldPt ptnbest = new WorldPt();
        double mindist = Double.MAX_VALUE;
        int ifound = -1;
        l.pt1 = (WorldPt)this.pts.elementAt(0);
        for (i = 1; i < this.pts.size(); ++i) {
            pt = (WorldPt)this.pts.elementAt(i);
            if (pt == null) continue;
            l.pt0 = l.pt1;
            l.pt1 = pt;
            dist = wpt.ptNearLineSeg(l, ptn);
            if (!(dist < mindist)) continue;
            mindist = dist;
            ptnbest.init(ptn);
            ifound = i;
        }
        pt = (WorldPt)this.pts.elementAt(0);
        l.pt0 = l.pt1;
        l.pt1 = pt;
        dist = wpt.ptNearLineSeg(l, ptn);
        if (dist < mindist) {
            mindist = dist;
            ptnbest.init(ptn);
            ifound = i;
        }
        if (ifound >= 0) {
            this.pts.insertElementAt(wpt, ifound);
            this.invalidate();
            return true;
        }
        return false;
    }

    public boolean insertPt(WorldPt wpt, double tol) {
        double dist;
        WorldPt pt;
        int i;
        if (wpt == null || this.pts.size() < 2) {
            return false;
        }
        WorldLineSeg l = new WorldLineSeg();
        WorldPt ptn = new WorldPt();
        WorldPt ptnbest = new WorldPt();
        double mindist = Double.MAX_VALUE;
        int ifound = -1;
        l.pt1 = (WorldPt)this.pts.elementAt(0);
        for (i = 1; i < this.pts.size(); ++i) {
            pt = (WorldPt)this.pts.elementAt(i);
            if (pt == null) continue;
            l.pt0 = l.pt1;
            l.pt1 = pt;
            dist = wpt.ptNearLineSeg(l, ptn);
            if (!(dist < mindist) || !(dist <= tol)) continue;
            mindist = dist;
            ptnbest.init(ptn);
            ifound = i;
        }
        pt = (WorldPt)this.pts.elementAt(0);
        l.pt0 = l.pt1;
        l.pt1 = pt;
        dist = wpt.ptNearLineSeg(l, ptn);
        if (dist < mindist && dist <= tol) {
            mindist = dist;
            ptnbest.init(ptn);
            ifound = i;
        }
        if (ifound >= 0) {
            this.pts.insertElementAt(ptnbest, ifound);
            this.invalidate();
            return true;
        }
        return false;
    }

    public boolean removePt(WorldPt wpt, double tol) {
        if (wpt == null || this.pts.size() <= 3) {
            return false;
        }
        WorldRect rc = new WorldRect(wpt.e - tol, wpt.n + tol, wpt.e + tol, wpt.n - tol);
        for (int i = 0; i < this.pts.size(); ++i) {
            WorldPt pt = (WorldPt)this.pts.elementAt(i);
            if (pt == null || !rc.contains(pt)) continue;
            this.pts.removeElementAt(i);
            this.invalidate();
            return true;
        }
        return false;
    }

    public String toString() {
        String str = "";
        for (int i = 0; i < this.pts.size(); ++i) {
            WorldPt pt = (WorldPt)this.pts.elementAt(i);
            if (pt == null) continue;
            if (i > 0) {
                str = str.concat(", ");
            }
            str = str.concat(pt.toString());
        }
        return str;
    }

    public void parseString(String str) {
        String substr = str;
        this.pts.removeAllElements();
        while (substr != null) {
            WorldPt pt = new WorldPt();
            substr = pt.parseString(substr);
            if (!pt.isValid()) continue;
            this.pts.addElement(pt);
        }
    }

    public void invalidate() {
        if (this._bounds != null) {
            this._bounds.set(new WorldRect());
        }
        this._isClockwise = null;
        this._isSelfIntersecting = null;
    }

    public boolean isClockwise() {
        if (this._isClockwise == null) {
            this.calculateClockwise();
        }
        return this._isClockwise;
    }

    private void calculateClockwise() {
        WorldPt pt0;
        if (this.pts.size() < 1) {
            this._isClockwise = Boolean.FALSE;
            return;
        }
        double pi = Math.PI;
        double sumAng = 0.0;
        int npts = this.pts.size();
        WorldPt pt1 = (WorldPt)this.pts.get(0);
        if (pt1.equals(pt0 = (WorldPt)this.pts.get(npts - 1))) {
            pt0 = (WorldPt)this.pts.elementAt(npts - 2);
        }
        double ang0 = 0.0;
        int icnt = 0;
        for (int i = 0; i < npts; ++i) {
            pt1 = (WorldPt)this.pts.elementAt(i);
            if (pt0.equals(pt1)) continue;
            double dx = pt1.e - pt0.e;
            double dy = pt1.n - pt0.n;
            if (Math.abs(dx) < 1.0 && Math.abs(dy) < 1.0) continue;
            double ang1 = Math.atan2(dy, dx);
            if (icnt > 0) {
                double angdiff = ang1 - ang0;
                if (angdiff > pi) {
                    angdiff -= pi * 2.0;
                } else if (angdiff < -pi) {
                    angdiff += pi * 2.0;
                }
                sumAng += angdiff;
            }
            ang0 = ang1;
            pt0 = pt1;
            ++icnt;
        }
        this._isClockwise = sumAng > 1.0 ? Boolean.FALSE : (sumAng < -1.0 ? Boolean.TRUE : Boolean.TRUE);
    }

    public void reversePts() {
        Collections.reverse(this.pts);
        this.invalidate();
    }

    public boolean isSelfIntersecting() {
        if (this._isSelfIntersecting == null) {
            this.calculateSelfIntersecting();
        }
        return this._isSelfIntersecting;
    }

    private void calculateSelfIntersecting() {
        WorldPt pt1;
        WorldPt pt0;
        this._isSelfIntersecting = Boolean.FALSE;
        WorldLineSeg seg = new WorldLineSeg();
        STRtree tree = new STRtree();
        for (int ii = 1; ii < this.pts.size(); ++ii) {
            pt0 = (WorldPt)this.pts.get(ii - 1);
            if (pt0.equals(pt1 = (WorldPt)this.pts.get(ii))) continue;
            tree.insert(new Envelope(pt0.e, pt1.e, pt0.n, pt1.n), (Object)new WorldLineSeg(pt0, pt1));
        }
        Envelope env = new Envelope();
        WorldPt ptIntersect = new WorldPt();
        WorldPt ptDist = new WorldPt();
        block1: for (int ii = 1; !this._isSelfIntersecting.booleanValue() && ii < this.pts.size(); ++ii) {
            pt0 = (WorldPt)this.pts.get(ii - 1);
            pt1 = (WorldPt)this.pts.get(ii);
            WorldLineSeg testSegment = new WorldLineSeg();
            env.init(pt0.e, pt1.e, pt0.n, pt1.n);
            List query = tree.query(env);
            for (Object value : query) {
                WorldLineSeg regionSeg = (WorldLineSeg)value;
                testSegment.init(pt0, pt1);
                if (testSegment.pt0.equals(seg.pt0) && testSegment.pt1.equals(seg.pt1) || !regionSeg.intersect(testSegment, ptIntersect, ptDist)) continue;
                if (!ptIntersect.equals(pt0) && !ptIntersect.equals(pt1)) {
                    this._isSelfIntersecting = Boolean.TRUE;
                    continue block1;
                }
                if (!seg.pt0.equals(regionSeg.pt0) && !seg.pt0.equals(regionSeg.pt1) || !seg.pt1.equals(regionSeg.pt0) && !seg.pt1.equals(regionSeg.pt1)) continue;
                this._isSelfIntersecting = Boolean.TRUE;
                continue block1;
            }
        }
    }

    public boolean intersect(WorldLine line) {
        if (line == null) {
            return false;
        }
        int size = line.pts.size();
        WorldLineSeg lseg = new WorldLineSeg();
        for (int i = 0; i < size - 1; ++i) {
            WorldPt pt0 = (WorldPt)line.pts.elementAt(i);
            WorldPt pt1 = (WorldPt)line.pts.elementAt(i + 1);
            lseg.init(pt0, pt1);
            if (!this.intersect(lseg, 0)) continue;
            return true;
        }
        return false;
    }

    public WorldPt intersection(WorldLine line) {
        if (line == null) {
            return null;
        }
        int size = line.pts.size();
        WorldLineSeg lseg = new WorldLineSeg();
        for (int i = 0; i < size - 1; ++i) {
            WorldPt pt0 = (WorldPt)line.pts.elementAt(i);
            WorldPt pt1 = (WorldPt)line.pts.elementAt(i + 1);
            lseg.init(pt0, pt1);
            if (!this.intersect(lseg, 0)) continue;
            return this.intersection(lseg, 0);
        }
        return this.intersection(lseg, 0);
    }

    private WorldPt intersection(WorldLineSeg seg, int ptIndex) {
        WorldLineSeg regionSeg = new WorldLineSeg();
        WorldPt ptIntersect = new WorldPt();
        WorldPt ptDist = new WorldPt();
        for (int ii = ptIndex; ii < this.pts.size() - 1; ++ii) {
            WorldPt pt1;
            WorldPt pt0 = (WorldPt)this.pts.get(ii);
            if (pt0.equals(pt1 = (WorldPt)this.pts.get(ii + 1))) continue;
            regionSeg.init(pt0, pt1);
            if (!regionSeg.intersect(seg, ptIntersect, ptDist)) continue;
            if (!ptIntersect.equals(pt0) && !ptIntersect.equals(pt1)) {
                return ptIntersect;
            }
            if (!seg.pt0.equals(regionSeg.pt0) && !seg.pt0.equals(regionSeg.pt1) || !seg.pt1.equals(regionSeg.pt0) && !seg.pt1.equals(regionSeg.pt1)) continue;
            return ptIntersect;
        }
        return ptIntersect;
    }

    private boolean intersect(WorldLineSeg seg, int ptIndex) {
        WorldLineSeg regionSeg = new WorldLineSeg();
        WorldPt ptIntersect = new WorldPt();
        WorldPt ptDist = new WorldPt();
        for (int ii = ptIndex; ii < this.pts.size() - 1; ++ii) {
            WorldPt pt1;
            WorldPt pt0 = (WorldPt)this.pts.get(ii);
            if (pt0.equals(pt1 = (WorldPt)this.pts.get(ii + 1))) continue;
            regionSeg.init(pt0, pt1);
            if (!regionSeg.intersect(seg, ptIntersect, ptDist)) continue;
            if (!ptIntersect.equals(pt0) && !ptIntersect.equals(pt1)) {
                return true;
            }
            if (!seg.pt0.equals(regionSeg.pt0) && !seg.pt0.equals(regionSeg.pt1) || !seg.pt1.equals(regionSeg.pt0) && !seg.pt1.equals(regionSeg.pt1)) continue;
            return true;
        }
        return false;
    }

    @Override
    public boolean contains(double x, double y) {
        WorldPt pt = new WorldPt(x, y);
        return this.contains(pt);
    }

    @Override
    public boolean contains(double x, double y, double w, double h) {
        return true;
    }

    public boolean contains(WorldRegion wRegion) {
        if (wRegion == null || wRegion.pts == null || wRegion.pts.size() == 0) {
            return false;
        }
        for (int i = 0; i < wRegion.pts.size(); ++i) {
            if (this.contains((WorldPt)wRegion.pts.get(i))) continue;
            return false;
        }
        WorldLineSeg lineSeg = new WorldLineSeg();
        for (int i = 0; i < wRegion.pts.size() - 1; ++i) {
            WorldPt pt0 = (WorldPt)wRegion.pts.get(i);
            WorldPt pt1 = (WorldPt)wRegion.pts.get(i + 1);
            lineSeg.init(pt0, pt1);
            if (!this.intersect(lineSeg, 0)) continue;
            return false;
        }
        return true;
    }

    @Override
    public boolean contains(Rectangle2D r) {
        return false;
    }

    @Override
    public PathIterator getPathIterator(AffineTransform at) {
        return new WorldRegionIterator(this, at);
    }

    @Override
    public PathIterator getPathIterator(AffineTransform at, double flatness) {
        return new WorldRegionIterator(this, at);
    }

    @Override
    public boolean intersects(double x, double y, double w, double h) {
        return false;
    }

    @Override
    public boolean intersects(Rectangle2D r) {
        return false;
    }

    @Override
    public Rectangle getBounds() {
        WorldRect wrect = this.getWorldRectBounds();
        if (wrect == null) {
            return null;
        }
        Rectangle rect = new Rectangle((int)wrect.w, (int)wrect.s, (int)(wrect.e - wrect.w), (int)(wrect.n - wrect.s));
        return rect;
    }

    @Override
    public Rectangle2D getBounds2D() {
        WorldRect wrect = this.getWorldRectBounds();
        if (wrect == null) {
            return null;
        }
        Rectangle2D.Double rect = new Rectangle2D.Double();
        ((Rectangle2D)rect).setRect(wrect.w, wrect.s, wrect.e - wrect.w, wrect.n - wrect.s);
        return rect;
    }

    @Override
    public boolean contains(Point2D p) {
        return this.contains(new WorldPt(p.getX(), p.getY()));
    }

    public void init(WorldRegion region) {
        if (region == this) {
            return;
        }
        this.pts.clear();
        if (region == null) {
            return;
        }
        int size = region.pts.size();
        for (int i = 0; i < size; ++i) {
            WorldPt wpt = (WorldPt)region.pts.get(i);
            this.pts.add(wpt.clone());
        }
    }

    public Area getArea2D() {
        if (this.pts == null || this.pts.size() < 1) {
            return new Area();
        }
        Path2D.Double path = new Path2D.Double();
        WorldPt pt = (WorldPt)this.pts.get(0);
        path.moveTo(pt.e, pt.n);
        for (int ii = 1; ii < this.pts.size(); ++ii) {
            pt = (WorldPt)this.pts.get(ii);
            path.lineTo(pt.e, pt.n);
        }
        path.closePath();
        Area area = new Area(path);
        return area;
    }

    public static double getArea(Area area) {
        double sum = 0.0;
        double xBegin = 0.0;
        double yBegin = 0.0;
        double xPrev = 0.0;
        double yPrev = 0.0;
        double[] coords = new double[6];
        PathIterator iterator = area.getPathIterator(null);
        while (!iterator.isDone()) {
            switch (iterator.currentSegment(coords)) {
                case 0: {
                    xBegin = coords[0];
                    yBegin = coords[1];
                    break;
                }
                case 1: {
                    sum += (coords[0] - xPrev) * (coords[1] + yPrev) / 2.0;
                    break;
                }
                case 4: {
                    sum += (xBegin - xPrev) * (yBegin + yPrev) / 2.0;
                }
            }
            xPrev = coords[0];
            yPrev = coords[1];
            iterator.next();
        }
        return sum;
    }
}

