/*
 * Decompiled with CFR 0.152.
 */
package hec.map;

import hec.map.WorldPt;
import hec.map.WorldRegion;
import java.awt.geom.AffineTransform;
import java.awt.geom.PathIterator;
import java.util.NoSuchElementException;

class WorldRegionIterator
implements PathIterator {
    WorldRegion m_region = null;
    AffineTransform m_transform;
    int index = 0;

    WorldRegionIterator(WorldRegion r, AffineTransform at) {
        this.m_transform = at;
        this.m_region = r;
    }

    @Override
    public int getWindingRule() {
        return 1;
    }

    @Override
    public boolean isDone() {
        return this.index > this.m_region.pts.size();
    }

    @Override
    public void next() {
        ++this.index;
    }

    @Override
    public int currentSegment(float[] coords) {
        if (this.isDone()) {
            throw new NoSuchElementException("rect iterator out of bounds");
        }
        if (this.index == this.m_region.pts.size()) {
            return 4;
        }
        WorldPt pt = (WorldPt)this.m_region.pts.get(this.index);
        coords[0] = (float)pt.e;
        coords[1] = (float)pt.n;
        if (this.m_transform != null) {
            this.m_transform.transform(coords, 0, coords, 0, 1);
        }
        return this.index == 0 ? 0 : 1;
    }

    @Override
    public int currentSegment(double[] coords) {
        if (this.isDone()) {
            throw new NoSuchElementException("rect iterator out of bounds");
        }
        if (this.index == this.m_region.pts.size()) {
            return 4;
        }
        WorldPt pt = (WorldPt)this.m_region.pts.get(this.index);
        coords[0] = pt.e;
        coords[1] = pt.n;
        if (this.m_transform != null) {
            this.m_transform.transform(coords, 0, coords, 0, 1);
        }
        return this.index == 0 ? 0 : 1;
    }
}

