/*
 * Decompiled with CFR 0.152.
 */
package hec.map.aidem;

import hec.map.GridMap;
import hec.map.MapIdentifier;
import hec.map.MapObject;
import hec.map.WorldPt;
import hec.map.WorldRect;
import java.io.IOException;
import rma.util.RMAIO;

public abstract class AiDemBaseMap
extends MapObject
implements GridMap {
    protected double _cellsize = 1.0;
    protected float[] _data;
    protected WorldPt _lowerLeftCorner;
    protected float _maxElev = Float.MIN_VALUE;
    protected float _minElev = Float.MAX_VALUE;
    protected float _nodata = -9999.0f;
    protected int _numcol = 0;
    protected int _numrow = 0;

    public AiDemBaseMap(String fileName) {
        super(fileName);
    }

    public AiDemBaseMap(MapIdentifier id) {
        super(id);
    }

    public AiDemBaseMap() {
    }

    @Override
    public void load() throws IOException {
    }

    @Override
    public void unload() {
    }

    public int getAreaHeight() {
        return this._numrow;
    }

    public int getAreaWidth() {
        return this._numcol;
    }

    public double getResolutionX() {
        return this._cellsize;
    }

    public double getResolutionY() {
        return this._cellsize;
    }

    @Override
    public boolean supportsNoDataValue() {
        return true;
    }

    public float[] getData() {
        return this._data;
    }

    public WorldPt getLowerLeftCorner() {
        return this._lowerLeftCorner;
    }

    @Override
    public String getName() {
        String path = this._mapId.getPath();
        return path != null ? RMAIO.getFileNameNoExtension(path) : "";
    }

    @Override
    public WorldRect getGridCellSize() {
        WorldRect r = new WorldRect();
        r.w = 0.0;
        r.s = 0.0;
        r.e = this._cellsize;
        r.n = this._cellsize;
        return r;
    }

    protected void init() {
        this._data = null;
        this._numcol = 0;
        this._numrow = 0;
        this._cellsize = 1.0;
        this._lowerLeftCorner = null;
        this._nodata = -9999.0f;
        this._loaded = false;
    }

    @Override
    public double getMinimumElevation() {
        if (this._minElev == Float.MAX_VALUE) {
            this.calcMinMax();
        }
        return this._minElev;
    }

    @Override
    public double getMaximumElevation() {
        if (this._maxElev == Float.MIN_VALUE) {
            this.calcMinMax();
        }
        return this._maxElev;
    }

    private void calcMinMax() {
        if (this._data == null) {
            return;
        }
        for (int ii = 0; ii < this._data.length; ++ii) {
            if (this._data[ii] == this._nodata) continue;
            if (this._minElev > this._data[ii]) {
                this._minElev = this._data[ii];
            }
            if (!(this._maxElev < this._data[ii])) continue;
            this._maxElev = this._data[ii];
        }
    }

    @Override
    public double getNoDataValue() {
        return this._nodata;
    }

    public void setNoDataValue(double noDataValue) {
        this._nodata = (float)noDataValue;
    }

    public WorldPt cellToWorldPt(int row, int col) {
        WorldPt pt = new WorldPt();
        pt.e = (double)col * this.getResolutionX() + this._lowerLeftCorner.e;
        pt.n = this._lowerLeftCorner.n + (double)this._numrow * this.getResolutionY() - (double)row * this.getResolutionY();
        return pt;
    }

    public WorldPt cellToWorldPt(int cellIndex) {
        int row = cellIndex / this.getAreaWidth();
        int col = cellIndex % this.getAreaWidth();
        return this.cellToWorldPt(row, col);
    }

    @Override
    public float[] getElevation(double[] northing, double[] easting) {
        float[] elevations = new float[northing != null ? northing.length : 0];
        for (int i = 0; i < elevations.length; ++i) {
            elevations[i] = this.getElevation(easting[i], northing[i]);
        }
        return elevations;
    }

    @Override
    public float getElevation(WorldPt pt) {
        return this.getElevation(pt.e, pt.n);
    }

    private float getElevation(double pte, double ptn) {
        float retval = Float.NEGATIVE_INFINITY;
        int idx = this.worldPtToCell(pte, ptn);
        if (idx >= 0 && idx < this._data.length) {
            retval = this._data[idx];
        }
        return retval;
    }

    public int worldPtToCell(WorldPt pt) {
        return this.worldPtToCell(pt.e, pt.n);
    }

    public int worldPtToCell(double pte, double ptn) {
        int idx = -1;
        if (this._data != null && this._lowerLeftCorner != null && this._extent != null && this._extent.contains(pte, ptn)) {
            int icol = (int)((pte - this._lowerLeftCorner.e) / this._cellsize);
            int irow = (int)((double)this._numrow - (ptn - this._lowerLeftCorner.n) / this._cellsize);
            idx = irow * this._numcol + icol;
        }
        return idx;
    }

    public abstract void loadHeader() throws IOException;

    public abstract boolean fillArray(float[] var1, long var2, long var4, int var6) throws IOException;
}

