/*
 * Decompiled with CFR 0.152.
 */
package hec.map.aidem;

import hec.io.EndianInputStream;
import hec.io.EndianOutputStream;
import hec.io.HecFile;
import hec.io.Identifier;
import hec.map.ElevationMap;
import hec.map.GridMap;
import hec.map.MapIdentifier;
import hec.map.MapObjectInterface;
import hec.map.WorldPt;
import hec.map.WorldRect;
import hec.map.aidem.AiDemBaseMap;
import java.io.BufferedInputStream;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.ByteArrayInputStream;
import java.io.DataInputStream;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.StringTokenizer;
import rma.util.RMAIO;

public class AiDemFltMap
extends AiDemBaseMap
implements Serializable,
MapObjectInterface,
ElevationMap,
GridMap {
    public static final String EXTENSION = ".flt";
    private String _byteOrder;

    public AiDemFltMap(String fileName) {
        super(fileName);
        this.init();
    }

    public AiDemFltMap(MapIdentifier id) {
        super(id);
        this.init();
    }

    public AiDemFltMap() {
        this.init();
    }

    @Override
    public List getFilenames() {
        ArrayList<Object> l = new ArrayList<Object>();
        l.add(this._mapId.getPath());
        Object path = this._mapId.getPath();
        path = RMAIO.getPathNoExtension((String)path) + ".hdr";
        l.add(path);
        return l;
    }

    @Override
    public void unload() {
        this.init();
    }

    @Override
    public void load() throws IOException {
        if (!this._loaded) {
            Object path;
            int idx;
            HecFile file = this._mapId.getFile();
            if (file == null) {
                Identifier id = this.openFile(this._mapId);
                if (id != null) {
                    file = id.getFile();
                    this._mapId.setFile(file);
                } else {
                    return;
                }
            }
            if ((idx = ((String)(path = this._mapId.getFile().getPath())).indexOf(EXTENSION)) >= 0) {
                path = ((String)path).substring(0, idx);
            }
            path = (String)path + ".prj";
            this.readProjection(this.openFile(new Identifier((String)path)));
            this.loadBin(file);
            this._loaded = true;
        }
    }

    @Override
    public void loadHeader() throws IOException {
        HecFile file = this._mapId.getFile();
        if (file == null) {
            Identifier id = this.openFile(this._mapId);
            if (id == null) {
                // empty if block
            }
            file = id.getFile();
        }
        Object path = file.getPath();
        File f = new File((String)(path = RMAIO.getPathNoExtension((String)path) + ".hdr"));
        if (!f.exists()) {
            String message = "The required header file\n" + (String)path + "\n was not found.";
            throw new FileNotFoundException(message);
        }
        FileReader fReader = new FileReader(f);
        BufferedReader reader = new BufferedReader(fReader);
        this.loadHeader(reader);
        reader.close();
    }

    private void loadHeader(BufferedReader in) throws IOException {
        String line;
        this._lowerLeftCorner = new WorldPt();
        while ((line = in.readLine()) != null) {
            StringTokenizer st;
            if (line.isEmpty() || !(st = new StringTokenizer(line)).hasMoreElements()) continue;
            String tok = st.nextToken();
            if (tok.equalsIgnoreCase("ncols")) {
                this._numcol = RMAIO.parseInt(st.nextToken());
                continue;
            }
            if (tok.equalsIgnoreCase("nrows")) {
                this._numrow = RMAIO.parseInt(st.nextToken());
                continue;
            }
            if (tok.equalsIgnoreCase("cellsize")) {
                this._cellsize = RMAIO.parseDouble(st.nextToken());
                continue;
            }
            if (tok.equalsIgnoreCase("xllcorner")) {
                this._lowerLeftCorner.e = RMAIO.parseDouble(st.nextToken());
                continue;
            }
            if (tok.equalsIgnoreCase("yllcorner")) {
                this._lowerLeftCorner.n = RMAIO.parseDouble(st.nextToken());
                continue;
            }
            if (tok.equalsIgnoreCase("NODATA_value")) {
                this._nodata = RMAIO.parseFloat(st.nextToken());
                continue;
            }
            if (!tok.equals("byteorder")) continue;
            this._byteOrder = st.nextToken();
        }
        this.updateExtents();
    }

    private void updateExtents() {
        this._extent = new WorldRect(this._lowerLeftCorner.e, this._lowerLeftCorner.n, this._lowerLeftCorner.e + this._cellsize * (double)this._numcol, this._lowerLeftCorner.n + this._cellsize * (double)this._numrow);
    }

    @Override
    public boolean fillArray(float[] dest, long destPosition, long srcPosition, int length) throws IOException {
        if (this._data != null) {
            System.arraycopy(this._data, (int)srcPosition, dest, (int)destPosition, length);
            return true;
        }
        HecFile file = this.getMapIdentifier().getFile();
        if (file == null) {
            return false;
        }
        long readFrom = srcPosition * 4L;
        long readLength = (long)length * 4L;
        byte[] floatBytes = file.getByteArray(readFrom, (int)readLength);
        ByteArrayInputStream bais = new ByteArrayInputStream(floatBytes);
        EndianInputStream eis = new EndianInputStream(bais);
        int type = 100;
        if ("LSBFIRST".equalsIgnoreCase(this._byteOrder)) {
            type = 200;
        }
        for (int ii = 0; ii < length; ++ii) {
            dest[(int)destPosition + ii] = eis.readFloat(type);
        }
        return true;
    }

    public void loadBin(HecFile file) throws IOException {
        EndianInputStream in = null;
        try {
            DataInputStream dataInputStream = file.getDataInputStream();
            BufferedInputStream bis = new BufferedInputStream(dataInputStream);
            in = new EndianInputStream(bis);
            this.loadHeader();
            int type = 100;
            if ("LSBFIRST".equalsIgnoreCase(this._byteOrder)) {
                type = 200;
            }
            this._data = new float[this._numcol * this._numrow];
            for (int ib = 0; ib < this._numcol * this._numrow; ++ib) {
                this._data[ib] = in.readFloat(type);
            }
            in.close();
        }
        catch (Exception e) {
            System.out.println(e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean writeFile(Identifier fltId) {
        String hdrPath;
        Identifier hdrId;
        if (fltId == null) {
            return false;
        }
        HecFile file = fltId.getFile();
        if (file == null) {
            fltId = this.newThenOpenFile(fltId);
        }
        if ((file = fltId.getFile()) == null) {
            System.out.println("writeFile:failed to create/open file " + fltId.getPath());
            return false;
        }
        String basePath = fltId.getPath();
        if (basePath.lastIndexOf(".") > 0) {
            basePath = basePath.substring(0, basePath.lastIndexOf("."));
        }
        if ((hdrId = this.newThenOpenFile(new Identifier(hdrPath = basePath + ".hdr"))) == null) {
            return false;
        }
        if (!this.writeHeader(hdrId)) {
            return false;
        }
        EndianOutputStream eOut = file.getEndianOutputStream();
        if (eOut == null) {
            return false;
        }
        int max = this._numrow * this._numcol;
        try {
            for (int i = 0; i < max; ++i) {
                try {
                    eOut.writeFloat(200, this._data[i]);
                    continue;
                }
                catch (IOException e) {
                    System.out.println("writeFile:error writing file " + fltId.getPath() + " Error:" + e);
                    e.printStackTrace();
                    break;
                }
            }
            boolean bl = true;
            return bl;
        }
        finally {
            try {
                eOut.close();
            }
            catch (IOException iOException) {}
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected boolean writeHeader(Identifier hdrId) {
        HecFile file = hdrId.getFile();
        if (file == null) {
            return false;
        }
        BufferedWriter writer = file.getBufferedWriter();
        if (writer == null) {
            return false;
        }
        try {
            writer.write("ncols         " + this._numcol);
            writer.newLine();
            writer.write("nrows         " + this._numrow);
            writer.newLine();
            writer.write("xllcorner     " + this._lowerLeftCorner.e);
            writer.newLine();
            writer.write("yllcorner     " + this._lowerLeftCorner.n);
            writer.newLine();
            writer.write("cellsize      " + this._cellsize);
            writer.newLine();
            writer.write("NODATA_value  " + this._nodata);
            writer.newLine();
            writer.write("byteorder     LSBFIRST");
            writer.newLine();
            boolean bl = true;
            return bl;
        }
        catch (IOException ioe) {
            System.out.println("writeHeader:Error writing header to " + hdrId.getPath() + " Error:" + ioe);
        }
        finally {
            try {
                writer.flush();
                writer.close();
            }
            catch (IOException iOException) {}
        }
        return false;
    }

    public boolean setElevation(WorldPt pt, float val) {
        if (this._data == null || this._lowerLeftCorner == null || pt == null) {
            return false;
        }
        return this.setElevation(pt.e, pt.n, val);
    }

    public boolean setElevation(double e, double n, float val) {
        boolean retval = false;
        if (this._extent == null || !this._extent.contains(e, n)) {
            System.out.println("setElevation:point " + e + ", " + n + " outside of bound " + this._extent);
        } else {
            int idx = this.worldPtToCell(e, n);
            if (this._data != null && idx >= 0 && idx < this._data.length) {
                this._data[idx] = val;
                retval = true;
            }
        }
        return retval;
    }

    public void setAreaHeight(int numRow) {
        int oldNumRow = this._numrow;
        this._numrow = numRow;
        if (oldNumRow != this._numrow) {
            this._data = null;
            this._data = new float[this._numcol * this._numrow];
            Arrays.fill(this._data, (float)this.getNoDataValue());
        }
    }

    public void setAreaWidth(int numCol) {
        int oldNumCol = this._numcol;
        this._numcol = numCol;
        if (oldNumCol != this._numcol) {
            this._data = null;
            this._data = new float[this._numcol * this._numrow];
            Arrays.fill(this._data, (float)this.getNoDataValue());
        }
    }

    public void setAreaSize(int rows, int cols) {
        boolean resize = false;
        if (this._numrow != rows) {
            resize = true;
        }
        if (this._numcol != cols) {
            resize = true;
        }
        this._numrow = rows;
        this._numcol = cols;
        if (resize) {
            this._data = null;
            this._data = new float[this._numcol * this._numrow];
            Arrays.fill(this._data, (float)this.getNoDataValue());
        }
    }

    public void setLowerLeftCorner(WorldPt wpt) {
        if (this._lowerLeftCorner == null) {
            this._lowerLeftCorner = new WorldPt(wpt);
        } else {
            this._lowerLeftCorner.init(wpt);
        }
        this.updateExtents();
    }

    public void setCellSize(double cellSize) {
        double oldCellSize = this._cellsize;
        this._cellsize = cellSize;
        if (oldCellSize != cellSize) {
            this.updateExtents();
        }
    }

    @Override
    public boolean mapIdentifierEquals(MapIdentifier mapid) {
        if (this.getMapIdentifier().equals(mapid)) {
            return true;
        }
        if (mapid == null) {
            return false;
        }
        return false;
    }
}

