/*
 * Decompiled with CFR 0.152.
 */
package hec.map.aidem;

import hec.map.DisplayCoordinateReferenceSystem;
import hec.map.ElevationGlyph;
import hec.map.GlyphDataRecord;
import hec.map.LocalRect;
import hec.map.LocalRegion;
import hec.map.MapGlyph;
import hec.map.MapObjectInterface;
import hec.map.MapPanel;
import hec.map.MapScale;
import hec.map.WorldPt;
import hec.map.WorldRect;
import hec.map.aidem.AiDemBaseMap;
import hec.map.aidem.AiDemGlyphDataRecord;
import hec.map.crs.CRS;
import hec.map.crs.CoordinateReferenceSystem;
import hec.map.crs.Transform;
import java.awt.AlphaComposite;
import java.awt.Composite;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.MediaTracker;
import java.awt.Toolkit;
import java.awt.event.MouseEvent;
import java.awt.image.BufferedImage;
import java.awt.image.ImageObserver;
import java.awt.image.MemoryImageSource;
import java.io.Serializable;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import rma.util.ColorContour;
import rma.util.RMAIO;

public class AiDemGlyph
extends MapGlyph
implements Serializable,
ImageObserver,
ElevationGlyph {
    protected Image _img = null;
    protected int _areaWidth = Integer.MIN_VALUE;
    protected int _areaHeight = Integer.MIN_VALUE;
    MediaTracker _tracker = null;
    int _buildCount = 0;
    int[] _pix = null;
    CoordinateReferenceSystem displayedWKT = null;

    public AiDemGlyph() {
        this.init();
    }

    public AiDemGlyph(MapPanel panel, AiDemBaseMap map) {
        this.setMapPanel(panel);
        this.setMap(map);
    }

    @Override
    protected void init() {
        if (this._map == null || this._mapPanel == null) {
            return;
        }
        AiDemBaseMap map = (AiDemBaseMap)this._map;
        this._areaWidth = map.getAreaWidth();
        this._areaHeight = map.getAreaHeight();
    }

    @Override
    public void setMap(MapObjectInterface map) {
        this._pix = null;
        super.setMap(map);
    }

    @Override
    public GlyphDataRecord getDefaultDataRecord() {
        return new AiDemGlyphDataRecord();
    }

    @Override
    public void fillMap(boolean load) {
        super.fillMap(load);
        if (load) {
            this.createImage();
        } else if (this._img != null) {
            this.clearImage();
        }
    }

    private void clearImage() {
        if (this._img == null) {
            return;
        }
        try {
            this._tracker.removeImage(this._img);
        }
        catch (Exception e) {
            System.out.println("Error removing image from tracker.  " + e);
        }
        this._img = null;
    }

    @Override
    public double getNoDataValue() {
        if (this._map == null) {
            return Double.NEGATIVE_INFINITY;
        }
        return ((AiDemBaseMap)this._map).getNoDataValue();
    }

    public double getElevation(WorldPt pt) {
        if (this._map == null) {
            return Double.NEGATIVE_INFINITY;
        }
        AiDemBaseMap map = (AiDemBaseMap)this._map;
        return map.getElevation(pt);
    }

    @Override
    public double getMaximumElevation() {
        if (this._map == null) {
            return Double.NEGATIVE_INFINITY;
        }
        AiDemBaseMap map = (AiDemBaseMap)this._map;
        return map.getMaximumElevation();
    }

    @Override
    public double getMinimumElevation() {
        if (this._map == null) {
            return Double.NEGATIVE_INFINITY;
        }
        AiDemBaseMap map = (AiDemBaseMap)this._map;
        return map.getMinimumElevation();
    }

    protected synchronized void createImage() {
        if (this._map == null || this._img != null || this._mapPanel == null) {
            return;
        }
        double[] rgb3 = new double[3];
        try {
            long t1 = new Date().getTime();
            AiDemGlyphDataRecord data = (AiDemGlyphDataRecord)this.getDataRecord();
            if (data == null) {
                data = new AiDemGlyphDataRecord();
                this.setDataRecord(data);
            }
            if (!data.getSet()) {
                data.setGlyph(this);
            }
            AiDemBaseMap map = (AiDemBaseMap)this._map;
            this._areaWidth = map.getAreaWidth();
            this._areaHeight = map.getAreaHeight();
            float[] demData = map.getData();
            if (demData == null) {
                return;
            }
            float[][] matrix = new float[this._areaHeight][this._areaWidth];
            WorldRect extent = map.getExtent();
            int ptr = 0;
            for (int row = 0; row < this._areaHeight; ++row) {
                for (int col = 0; col < this._areaWidth; ++col) {
                    matrix[row][col] = demData[ptr++];
                }
            }
            CoordinateReferenceSystem refSystem = map.getCoordinateReferenceSystem();
            List filenames = map.getFilenames();
            if (this._pix == null) {
                this._pix = new int[this._areaHeight * this._areaWidth];
            }
            double aa = data.getAspectAngle();
            double theta = -Math.PI / 180 * (aa - 90.0);
            double cosTheta = Math.cos(theta);
            double sinTheta = Math.sin(theta);
            double sinPhi = 0.5;
            double aaMag = Math.sqrt(cosTheta * cosTheta + sinTheta * sinTheta + sinPhi * sinPhi);
            cosTheta /= aaMag;
            sinTheta /= aaMag;
            sinPhi /= aaMag;
            double[] vec0 = new double[3];
            double[] vec1 = new double[3];
            double[] cross = new double[3];
            double lafc = 1.0;
            double mapResX = map.getResolutionX();
            double mapResY = map.getResolutionY();
            ColorContour cc = data.getColorContour();
            boolean onOff = data.getAspectEnabled();
            HashMap pixelMap = new HashMap();
            iContainer key = new iContainer(0.0f);
            Object value = null;
            for (int id = 0; id < demData.length; ++id) {
                float val = demData[id];
                if (val == map._nodata || Float.isNaN(val)) continue;
                if (onOff) {
                    int in = id - map._numcol;
                    float eleN = in < 0 ? val : demData[in];
                    int ie = id + 1;
                    float eleE = ie % map._numcol == 0 ? val : demData[ie];
                    int is = id + map._numcol;
                    float eleS = is >= demData.length ? val : demData[is];
                    int iw = id - 1;
                    float eleW = id % map._numcol == 0 ? val : demData[iw];
                    vec0[0] = 2.0 * mapResX;
                    vec0[1] = 0.0;
                    vec0[2] = (eleE - eleW) * 10.0f;
                    vec1[0] = 0.0;
                    vec1[1] = 2.0 * mapResY;
                    vec1[2] = (eleN - eleS) * 10.0f;
                    cross[0] = vec0[1] * vec1[2] - vec0[2] * vec1[1];
                    cross[1] = vec0[2] * vec1[0] - vec0[0] * vec1[2];
                    cross[2] = vec0[0] * vec1[1] - vec0[1] * vec1[0];
                    double nMag = Math.sqrt(cross[0] * cross[0] + cross[1] * cross[1] + cross[2] * cross[2]);
                    double dot = 1.0;
                    if (nMag != 0.0) {
                        dot = (cosTheta * cross[0] + sinTheta * cross[1] + sinPhi * cross[2]) / nMag;
                    }
                    if (cross[2] < 0.0) {
                        dot *= -1.0;
                    }
                    lafc = (dot + 1.25) / 2.25;
                }
                this._pix[id] = cc.getRGB(rgb3, val, lafc);
            }
            if (this._tracker == null) {
                this._tracker = new MediaTracker(this._mapPanel);
            }
            MemoryImageSource mis = new MemoryImageSource(this._areaWidth, this._areaHeight, this._pix, 0, this._areaWidth);
            if (this._img != null) {
                try {
                    this._tracker.removeImage(this._img);
                }
                catch (Exception e) {
                    System.out.println("Error removing image from tracker.  " + e);
                }
            }
            this._img = Toolkit.getDefaultToolkit().createImage(mis);
            this._tracker.addImage(this._img, 0);
            try {
                this._tracker.waitForAll();
            }
            catch (Exception e) {
                System.out.println("Error waiting for image from tracker.  " + e);
            }
            CoordinateReferenceSystem viewSystem = null;
            try {
                viewSystem = DisplayCoordinateReferenceSystem.getDefault().getCoordinateRefereceSystem();
            }
            catch (Exception e) {
                System.out.println(e.getMessage());
            }
            BufferedImage buffImg = new BufferedImage(this._img.getWidth(null), this._img.getHeight(null), 2);
            Graphics2D g2 = buffImg.createGraphics();
            g2.drawImage(this._img, null, null);
            g2.dispose();
            this._img = buffImg;
            if (refSystem != null && viewSystem != null) {
                Transform transform = CRS.getDefault().findTransform(refSystem, viewSystem, true);
                this._img = transform.transform(buffImg, extent.getRectangle2D());
            }
            this.displayedWKT = viewSystem;
            long t2 = new Date().getTime();
            System.out.println("**  Dem Glyph Image Build #" + this._buildCount++ + " took  " + new Long(t2 - t1).toString() + " ms.");
        }
        catch (Exception e) {
            e.printStackTrace();
            System.out.println(e);
        }
        this.notifyAll();
    }

    @Override
    public void draw(Graphics g, MapScale scl) {
        WorldRect mwr;
        if (this._map == null || this._mapPanel == null) {
            return;
        }
        AiDemGlyphDataRecord data = (AiDemGlyphDataRecord)this.getDataRecord();
        if (data == null) {
            data = new AiDemGlyphDataRecord();
            this.setDataRecord(data);
        }
        if (data.isModified()) {
            this.clearImage();
            data.setModified(false);
        }
        CoordinateReferenceSystem displayCrs = DisplayCoordinateReferenceSystem.getDefault().getCoordinateRefereceSystem();
        if (this._img == null || this.displayedWKT != displayCrs) {
            this._img = null;
            this.createImage();
        }
        WorldRect swr = scl.getWorldRect();
        WorldRect iwr = mwr = this.transformRect(this._map.getExtent());
        if (_paintOk && iwr != null) {
            if (this._areaWidth == Integer.MIN_VALUE || this._areaHeight == Integer.MIN_VALUE) {
                return;
            }
            double xscl = (double)this._areaWidth / (mwr.e - mwr.w);
            double yscl = (double)this._areaHeight / (mwr.n - mwr.s);
            LocalRect ilr = scl.wr2lr(iwr);
            double zoom = scl.getZoom();
            int dx1 = ilr.l;
            int dy1 = ilr.t;
            int dx2 = ilr.r;
            int dy2 = ilr.b;
            int sx1 = (int)((iwr.w - mwr.w) * xscl);
            int sy1 = (int)((mwr.n - iwr.n) * yscl);
            int sx2 = (int)((iwr.e - mwr.w) * xscl);
            int sy2 = (int)((mwr.n - iwr.s) * yscl);
            if (g instanceof Graphics2D) {
                Graphics2D g2 = (Graphics2D)g;
                Composite oldac = g2.getComposite();
                AlphaComposite ac = AlphaComposite.getInstance(3, data.getAlpha());
                g2.setComposite(ac);
                g2.drawImage(this._img, dx1, dy1, dx2, dy2, sx1, sy1, sx2, sy2, this);
                if (oldac != null) {
                    g2.setComposite(oldac);
                }
            }
        }
    }

    @Override
    public boolean imageUpdate(Image img, int infoflags, int x, int y, int width, int height) {
        return false;
    }

    @Override
    public float getElevationAt(int ix, int iy) {
        if (this._mapPanel == null || this._map == null) {
            return Float.NEGATIVE_INFINITY;
        }
        WorldPt wpt = new WorldPt(this._mapPanel.scale().x2e(ix), this._mapPanel.scale().y2n(iy));
        return (float)this.getElevation(wpt);
    }

    @Override
    public void drawElevationStats(Graphics g, LocalRegion region) {
    }

    @Override
    public String getToolTipText(WorldPt wpt, MouseEvent e) {
        double elev = this.getElevation(wpt);
        return RMAIO.setPrecision2(elev, 3);
    }

    static {
        System.setProperty("com.sun.media.jai.disableMediaLib", "true");
    }

    private class iContainer {
        float _int;

        public iContainer(float intc) {
            this._int = intc;
        }

        public void setValue(float intc) {
            this._int = intc;
        }

        public float getValue() {
            return this._int;
        }
    }
}

