/*
 * Decompiled with CFR 0.152.
 */
package hec.map.aidem;

import hec.io.HecFile;
import hec.io.Identifier;
import hec.map.MapIdentifier;
import hec.map.MapObjectInterface;
import hec.map.WorldPt;
import hec.map.WorldRect;
import hec.map.aidem.AiDemBaseMap;
import java.io.BufferedOutputStream;
import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.Serializable;
import java.nio.ByteBuffer;
import java.util.StringTokenizer;
import rma.util.RMAIO;

public class AiDemMap
extends AiDemBaseMap
implements Serializable,
MapObjectInterface {
    public static final String EXTENSION = ".asc";
    public static final long BINARY_HEADER_LENGTH = 44L;

    public AiDemMap(String fileName) {
        super(fileName);
        this.init();
    }

    public AiDemMap(MapIdentifier id) {
        super(id);
        this.init();
    }

    public AiDemMap() {
        this.init();
    }

    @Override
    public void unload() {
        this.init();
    }

    @Override
    public void load() throws IOException {
        if (!this._loaded) {
            HecFile file = this._mapId.getFile();
            if (file == null) {
                Identifier id = this.openFile(this._mapId);
                file = id.getFile();
                this._mapId.setFile(file);
            }
            this.ensureBinaryFile();
            file = this._mapId.getFile();
            this.loadBin(file);
            this._loaded = true;
        }
    }

    @Override
    public void loadHeader() throws IOException {
        this.ensureBinaryFile();
        HecFile file = this._mapId.getFile();
        DataInputStream in = file.getDataInputStream();
        this.loadHeader(in);
        in.close();
    }

    private void loadHeader(DataInputStream in) throws IOException {
        this._numcol = in.readInt();
        this._numrow = in.readInt();
        this._cellsize = in.readDouble();
        this._lowerLeftCorner = new WorldPt();
        this._lowerLeftCorner.e = in.readDouble();
        this._lowerLeftCorner.n = in.readDouble();
        this._nodata = in.readFloat();
        this._minElev = in.readFloat();
        this._maxElev = in.readFloat();
        this._extent = new WorldRect(this._lowerLeftCorner.e, this._lowerLeftCorner.n, this._lowerLeftCorner.e + this._cellsize * (double)this._numcol, this._lowerLeftCorner.n + this._cellsize * (double)this._numrow);
    }

    @Override
    public boolean fillArray(float[] dest, long destPosition, long srcPosition, int length) throws IOException {
        if (this._data != null) {
            System.arraycopy(this._data, (int)srcPosition, dest, (int)destPosition, length);
            return true;
        }
        this.ensureBinaryFile();
        HecFile file = this.getMapIdentifier().getFile();
        if (file == null) {
            return false;
        }
        long readFrom = 44L + srcPosition * 4L;
        long readLength = (long)length * 4L;
        byte[] floatBytes = file.getByteArray(readFrom, (int)readLength);
        ByteArrayInputStream bais = new ByteArrayInputStream(floatBytes);
        DataInputStream dis = new DataInputStream(bais);
        int ii = (int)destPosition;
        while ((long)ii < destPosition + (long)length) {
            dest[ii] = dis.readFloat();
            ++ii;
        }
        return true;
    }

    public void ensureBinaryFile() throws IOException {
        String ext;
        HecFile file = this._mapId.getFile();
        boolean binary = false;
        String name = file.getName();
        int idx = name.lastIndexOf(".");
        if (idx > -1 && (ext = name.substring(idx + 1)).lastIndexOf("bin") > -1) {
            binary = true;
        }
        if (!binary) {
            String pathname = this._mapId.getPath() + "bin";
            Identifier pathId = new Identifier(pathname);
            pathId.setName(RMAIO.getFileFromPath(pathname));
            Identifier idOut = this.newFile(pathId);
            if (idOut != null) {
                this.convertToBin(file, idOut.getFile());
            } else {
                idOut = this.openFile(pathId);
                if (idOut.getFile().lastModified() < file.lastModified()) {
                    this.convertToBin(file, idOut.getFile());
                }
            }
            this.getMapIdentifier().setIdentifier(pathId);
            this.getMapIdentifier().setFile(idOut.getFile());
        }
    }

    private void convertToBin(HecFile asciiFile, HecFile binFile) {
        BufferedReader in = null;
        try {
            String line;
            DataOutputStream out = binFile.getDataOutputStream();
            BufferedOutputStream bout = new BufferedOutputStream(out);
            in = asciiFile.getBufferedReader();
            this._lowerLeftCorner = new WorldPt();
            if (!this.readAsciiHeader(in)) {
                in.close();
                bout.flush();
                bout.close();
            }
            this._minElev = Float.MAX_VALUE;
            this._maxElev = Float.MIN_VALUE;
            int NUM_FLOAT_BUFF_SIZE = 1052;
            byte[] byteArray = new byte[NUM_FLOAT_BUFF_SIZE * 4];
            ByteBuffer byteBuffer = ByteBuffer.wrap(byteArray);
            byteBuffer.putInt(this._numcol);
            byteBuffer.putInt(this._numrow);
            byteBuffer.putDouble(this._cellsize);
            byteBuffer.putDouble(this._lowerLeftCorner.e);
            byteBuffer.putDouble(this._lowerLeftCorner.n);
            byteBuffer.putFloat(this._nodata);
            byteBuffer.putFloat(this._minElev);
            byteBuffer.putFloat(this._maxElev);
            bout.write(byteArray, 0, byteBuffer.position());
            byteBuffer.rewind();
            int NUM_FLOATS = 0;
            String sval = "";
            while ((line = in.readLine()) != null) {
                StringTokenizer st = new StringTokenizer(line);
                while (st.hasMoreTokens()) {
                    sval = st.nextToken();
                    float val = RMAIO.parseFloat(sval);
                    if (NUM_FLOATS >= NUM_FLOAT_BUFF_SIZE) {
                        bout.write(byteArray);
                        byteBuffer.rewind();
                        NUM_FLOATS = 0;
                    }
                    byteBuffer.putFloat(val);
                    ++NUM_FLOATS;
                    if (val == this._nodata) continue;
                    if (this._minElev > val) {
                        this._minElev = val;
                    }
                    if (!(this._maxElev < val)) continue;
                    this._maxElev = val;
                }
            }
            in.close();
            if (byteBuffer.position() > 0) {
                bout.write(byteBuffer.array(), 0, byteBuffer.position());
            }
            bout.flush();
            bout.close();
            binFile.close();
            binFile.writeFloat(36L, this._minElev);
            binFile.writeFloat(40L, this._maxElev);
        }
        catch (Exception e) {
            System.out.println(e);
            e.printStackTrace();
        }
        this._extent = new WorldRect(this._lowerLeftCorner.e, this._lowerLeftCorner.n, this._lowerLeftCorner.e + this._cellsize * (double)this._numcol, this._lowerLeftCorner.n + this._cellsize * (double)this._numrow);
    }

    protected boolean readAsciiHeader(BufferedReader in) throws IOException {
        StringTokenizer st;
        String tok;
        while (true) {
            String line;
            if ("ncols".equalsIgnoreCase(tok = (st = new StringTokenizer(line = in.readLine())).nextToken().trim())) {
                this._numcol = RMAIO.parseInt(st.nextToken());
                continue;
            }
            if ("nrows".equalsIgnoreCase(tok)) {
                this._numrow = RMAIO.parseInt(st.nextToken());
                continue;
            }
            if ("cellsize".equalsIgnoreCase(tok)) {
                this._cellsize = RMAIO.parseDouble(st.nextToken());
                continue;
            }
            if ("xllcorner".equalsIgnoreCase(tok)) {
                this._lowerLeftCorner.e = RMAIO.parseDouble(st.nextToken());
                continue;
            }
            if (!"yllcorner".equalsIgnoreCase(tok)) break;
            this._lowerLeftCorner.n = RMAIO.parseDouble(st.nextToken());
        }
        if (!"NODATA_value".equalsIgnoreCase(tok)) {
            System.out.println("\nAiDem Load Failed reading header. Unknown token=" + tok);
            return false;
        }
        this._nodata = RMAIO.parseFloat(st.nextToken());
        return true;
    }

    public void loadBin(HecFile file) throws IOException {
        DataInputStream in = null;
        try {
            in = file.getDataInputStream();
            this.loadHeader(in);
            this._data = new float[this._numcol * this._numrow];
            for (int ib = 0; ib < this._numcol * this._numrow; ++ib) {
                this._data[ib] = in.readFloat();
            }
            in.close();
        }
        catch (Exception e) {
            System.out.println(e);
        }
    }

    @Override
    public boolean mapIdentifierEquals(MapIdentifier mapid) {
        String asciiFile;
        if (this.getMapIdentifier().equals(mapid)) {
            return true;
        }
        if (mapid == null) {
            return false;
        }
        String thatExt = RMAIO.getFileExtension(mapid.getPath());
        if (EXTENSION.equals(thatExt) && (asciiFile = this.getMapIdentifier().getPath()).endsWith(".ascbin")) {
            asciiFile = asciiFile.substring(0, asciiFile.length() - 3);
            return RMAIO.pathsEqual(mapid.getPath(), asciiFile);
        }
        return false;
    }
}

