/*
 * Decompiled with CFR 0.152.
 */
package hec.map.aishape;

import hec.io.EndianInputStream;
import hec.io.EndianOutputStream;
import hec.map.WorldLine;
import hec.map.WorldPt;
import hec.map.aishape.AiShapeObject;
import hec.map.importer.ImportArc;
import java.util.ArrayList;
import java.util.Vector;

public class AiShapeArc
extends AiShapeObject
implements ImportArc {
    int _numPoints;
    int _numParts;
    WorldPt _referencePt;
    Vector<WorldLine> _arcList = new Vector();

    public AiShapeArc(int index, Vector<WorldLine> worldLines) {
        super(3, index);
        this._arcList = worldLines;
        this._numParts = 0;
        this._numPoints = 0;
        for (int ii = 0; ii < this._arcList.size(); ++ii) {
            WorldLine line = this._arcList.get(ii);
            ++this._numParts;
            this._numPoints += line.pts.size();
            this._extents.grow(line.getBounds());
        }
    }

    protected AiShapeArc(int type) {
        super(type);
    }

    public AiShapeArc() {
        super(3);
    }

    @Override
    public int contentByteLength() {
        int len = 44;
        for (int ii = 0; ii < this._arcList.size(); ++ii) {
            WorldLine line = this._arcList.get(ii);
            len += 4;
            len += line.pts.size() * 2 * 8;
        }
        return len;
    }

    @Override
    public void writeRecord(EndianOutputStream output) {
        try {
            WorldLine line;
            int ii;
            this.writeRecordHeader(output);
            this.writeBoundingBox(output);
            output.writeInt(200, this._numParts);
            output.writeInt(200, this._numPoints);
            int partsIndex = 0;
            for (ii = 0; ii < this._arcList.size(); ++ii) {
                output.writeInt(200, partsIndex);
                line = this._arcList.get(ii);
                partsIndex += line.pts.size();
            }
            for (ii = 0; ii < this._arcList.size(); ++ii) {
                line = this._arcList.get(ii);
                for (int jj = 0; jj < line.pts.size(); ++jj) {
                    WorldPt pt = (WorldPt)line.pts.get(jj);
                    output.writeDouble(200, pt.e);
                    output.writeDouble(200, pt.n);
                }
            }
        }
        catch (Exception e) {
            System.out.println(e.toString());
        }
    }

    @Override
    public int readRecord(EndianInputStream input) {
        try {
            int recnum = this.readRecordHeader(input);
            if (recnum < 0) {
                return recnum;
            }
            this.readBoundingBox(input);
            this._numParts = input.readInt(200);
            this._contentRead += 2;
            this._numPoints = input.readInt(200);
            this._contentRead += 2;
            if (this._numParts > 3200 || this._numParts < -1) {
                return -1;
            }
            int[] partsIndex = new int[this._numParts + 1];
            for (int i = 0; i < this._numParts; ++i) {
                partsIndex[i] = input.readInt(200);
                this._contentRead += 2;
            }
            partsIndex[this._numParts] = this._numPoints;
            ArrayList<WorldPt> tmpPtsList = new ArrayList<WorldPt>(this._numPoints);
            for (int i = 0; i < this._numPoints; ++i) {
                double x = input.readDouble(200);
                this._contentRead += 4;
                double y = input.readDouble(200);
                this._contentRead += 4;
                tmpPtsList.add(new WorldPt(x, y));
            }
            this._arcList.setSize(this._numParts);
            for (int j = 0; j < this._numParts; ++j) {
                WorldLine wline = new WorldLine();
                wline.pts.addAll(tmpPtsList.subList(partsIndex[j], partsIndex[j + 1]));
                this._arcList.setElementAt(wline, j);
            }
        }
        catch (Exception e) {
            System.out.println("AiShapeArc.readRecord:Exception " + e.toString());
            return -1;
        }
        return this._index;
    }

    @Override
    public boolean contains(double tolerance, WorldPt pt) {
        if (super.contains(tolerance, pt)) {
            WorldPt ptOnLine = new WorldPt();
            for (int ii = 0; ii < this._arcList.size(); ++ii) {
                WorldLine wline = this._arcList.get(ii);
                if (!(wline.getNearestLocation(pt, ptOnLine) <= tolerance)) continue;
                return true;
            }
        }
        return false;
    }

    public WorldPt getReferencePt() {
        if (this._referencePt == null) {
            double xc = (this._extents.e + this._extents.w) / 2.0;
            double yc = (this._extents.n + this._extents.s) / 2.0;
            this._referencePt = new WorldPt(xc, yc);
        }
        return this._referencePt;
    }

    @Override
    public Vector<WorldLine> getArcLines() {
        return this._arcList;
    }

    public int getNumberOfLines() {
        return this._arcList.size();
    }
}

