/*
 * Decompiled with CFR 0.152.
 */
package hec.map.aishape;

import hec.io.AsciiSerializable;
import jakarta.xml.bind.annotation.XmlElement;
import jakarta.xml.bind.annotation.XmlRootElement;
import java.io.IOException;
import java.io.Serializable;
import java.lang.reflect.Field;
import java.util.Arrays;

@XmlRootElement(name="AiShapeFieldDescriptor")
public class AiShapeFieldDescriptor
implements Serializable,
Comparable,
AsciiSerializable {
    @XmlElement(name="Value")
    String _value;
    @XmlElement(name="Type")
    char _type;
    @XmlElement(name="Length")
    int _length;
    @XmlElement(name="Decimal")
    int _decimal;

    public AiShapeFieldDescriptor() {
    }

    public AiShapeFieldDescriptor(String value, char type, int length, int decimal) {
        this._value = value;
        this._type = type;
        this._length = length;
        this._decimal = decimal;
    }

    public AiShapeFieldDescriptor(byte[] field) throws IOException {
        int n;
        for (n = 0; n < 10 && field[n] != 0; ++n) {
        }
        this._value = new String(field, 0, n);
        this._type = (char)field[11];
        this._length = field[16] & 0xFF;
        this._decimal = field[17] & 0xFF;
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (!(obj instanceof AiShapeFieldDescriptor)) {
            return false;
        }
        AiShapeFieldDescriptor testDescriptor = (AiShapeFieldDescriptor)obj;
        boolean valuesEqual = false;
        valuesEqual = this._value == null && testDescriptor._value != null ? false : (this._value == null && testDescriptor._value == null ? true : (this._value != null && testDescriptor._value == null ? false : this._value.equals(testDescriptor._value)));
        return valuesEqual && testDescriptor._type == this._type && testDescriptor._length == this._length && testDescriptor._decimal == this._decimal;
    }

    public int getLength() {
        return this._length;
    }

    public void writeBytes(byte[] bytes) throws IOException {
        int len = this._value.length();
        for (int ii = 0; ii < len; ++ii) {
            bytes[ii] = (byte)this._value.charAt(ii);
        }
        Arrays.fill(bytes, len, 10, (byte)0);
        bytes[10] = 0;
        bytes[11] = (byte)this._type;
        Arrays.fill(bytes, 13, 16, (byte)0);
        bytes[16] = (byte)this._length;
        bytes[17] = (byte)this._decimal;
        Arrays.fill(bytes, 18, 20, (byte)0);
        bytes[20] = 1;
        Arrays.fill(bytes, 21, 32, (byte)0);
    }

    public String toString() {
        return this._value;
    }

    public int compareTo(Object compareTo) {
        return this._value.compareTo(compareTo.toString());
    }

    public char getType() {
        return this._type;
    }

    public boolean isUnique() {
        return this._type != 'C';
    }

    @Override
    public Object getFieldObject(Field fld) {
        try {
            Object obj = fld.get(this);
            return obj;
        }
        catch (IllegalAccessException e) {
            return null;
        }
    }

    @Override
    public boolean setFieldObject(Field fld, Object fobj) {
        try {
            fld.set(this, fobj);
            return true;
        }
        catch (IllegalAccessException e) {
            return false;
        }
        catch (IllegalArgumentException e) {
            return false;
        }
    }
}

