/*
 * Decompiled with CFR 0.152.
 */
package hec.map.aishape;

import hec.event.ModifiableListener;
import hec.map.DisplayCoordinateReferenceSystem;
import hec.map.GlyphDataRecord;
import hec.map.MapGlyph;
import hec.map.MapPanel;
import hec.map.MapScale;
import hec.map.WorldLine;
import hec.map.WorldLineSeg;
import hec.map.WorldPt;
import hec.map.WorldRect;
import hec.map.WorldRegion;
import hec.map.aishape.AiShapeArc;
import hec.map.aishape.AiShapeConst;
import hec.map.aishape.AiShapeGlyphDataRecord;
import hec.map.aishape.AiShapeMap;
import hec.map.aishape.AiShapeMultiPoint;
import hec.map.aishape.AiShapeObject;
import hec.map.aishape.AiShapePoint;
import hec.map.aishape.AiShapePolygon;
import hec.map.aishape.Field;
import hec.map.aishape.SelfIntersectingPolygonException;
import hec.map.aishape.ShapeDrawingAttribute;
import hec.map.aishape.ShapeHighlight;
import hec.map.crs.CRSException;
import hec.map.crs.CoordinateReferenceSystem;
import hec.map.crs.Transform;
import hec.map.importer.ShapeSource;
import hec.map.renderer.TracksRepaint;
import java.awt.AlphaComposite;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Composite;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Paint;
import java.awt.Stroke;
import java.awt.geom.AffineTransform;
import java.awt.image.BufferedImage;
import java.awt.image.RGBImageFilter;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Vector;
import java.util.logging.Level;
import java.util.logging.Logger;
import rma.lang.Modifiable;
import rma.util.FillPatternFactory;
import rma.util.LinearColorContour;
import rma.util.RmaSymbol;
import rma.util.TwoColorColorContour;

public class AiShapeGlyph
extends MapGlyph
implements AiShapeConst,
ShapeSource,
ModifiableListener,
TracksRepaint {
    private static final Logger logger = Logger.getLogger(AiShapeGlyph.class.getName());
    public static final int DEFAULT_NUM_POINTS = 10000;
    private List<WorldPt> _selectedPoints = new ArrayList<WorldPt>();
    private List<ShapeHighlight> _shapeHighlights = new ArrayList<ShapeHighlight>();
    AiShapeObject transformedAiShapeObj = null;
    List _txformedShapeList = new Vector();
    CoordinateReferenceSystem _currentDataCRS = null;
    boolean _cachingOn = true;
    boolean _transformedFailed = false;
    BufferedImage mBufferedImage = null;
    WorldRect mPreviousWorldRect = null;
    boolean isDirty = false;
    WorldLineSeg segment = new WorldLineSeg();
    WorldPt pt0 = new WorldPt();
    WorldPt pt1 = new WorldPt();

    public AiShapeGlyph(MapPanel panel, AiShapeMap map) {
        super(panel, map);
    }

    @Override
    public void close() {
        super.close();
        GlyphDataRecord dr = this.getDataRecord();
        if (dr != null) {
            dr.removeModifiableListener(this);
        }
    }

    @Override
    protected void init() {
        super.init();
    }

    @Override
    public GlyphDataRecord getDefaultDataRecord() {
        AiShapeGlyphDataRecord record = new AiShapeGlyphDataRecord();
        record.addModifiableListener(this);
        return record;
    }

    @Override
    public GlyphDataRecord getDataRecord() {
        GlyphDataRecord rec = super.getDataRecord();
        if (rec != null) {
            rec.removeModifiableListener(this);
            rec.addModifiableListener(this);
        }
        return rec;
    }

    @Override
    public void setDataRecord(GlyphDataRecord rec) {
        super.setDataRecord(rec);
        rec.removeModifiableListener(this);
        rec.addModifiableListener(this);
        this.isDirty = true;
    }

    public int getMapType() {
        AiShapeMap map = (AiShapeMap)this._map;
        if (map == null) {
            return 0;
        }
        return map.getType();
    }

    public List getShapeObjects(int x, int y) {
        MapScale scale = this._mapPanel.scale();
        double[] pe = new double[]{scale.x2e(x)};
        double[] pn = new double[]{scale.y2n(y)};
        double containmentBuffer = 5.0 * (1.0 / scale.getAvgW2LScale());
        CoordinateReferenceSystem dataSystem = this._map.getCoordinateReferenceSystem();
        CoordinateReferenceSystem viewSystem = DisplayCoordinateReferenceSystem.getDefault().getCoordinateRefereceSystem();
        Transform viewToDataTransform = this.transformLookup(viewSystem, dataSystem);
        try {
            viewToDataTransform.transform(pe, pn, 0, pe, pn, 0, 1);
        }
        catch (CRSException ex) {
            Logger.getLogger(AiShapeGlyph.class.getName()).log(Level.SEVERE, null, ex);
            return Collections.EMPTY_LIST;
        }
        WorldPt pt = new WorldPt(pe[0], pn[0]);
        return this.getShapeObjects(containmentBuffer, pt);
    }

    public List getShapeObjects(double containmentBuffer, WorldPt pt) {
        AiShapeMap map = (AiShapeMap)this._map;
        List shapes = map.getShapeObjects(containmentBuffer, pt);
        return shapes;
    }

    public List getShapeObjects() {
        AiShapeMap map = (AiShapeMap)this._map;
        List<AiShapeObject> shapes = map.getShapes();
        return shapes;
    }

    public Vector getAttributeVector() {
        if (this._map == null) {
            return null;
        }
        return ((AiShapeMap)this._map).getAttributes();
    }

    @Override
    public void fillMap(boolean load) {
        super.fillMap(load);
        this.isDirty = true;
        if (this._txformedShapeList != null) {
            this._txformedShapeList.clear();
        }
    }

    @Override
    public Vector getFieldDescriptors() {
        if (this._map == null) {
            return null;
        }
        return ((AiShapeMap)this._map).getFieldDescriptors();
    }

    @Override
    public void draw(Graphics g, MapScale scl) {
        try {
            if (this._map == null) {
                return;
            }
            long[] nextCheck = new long[]{-1L};
            if (AiShapeGlyph.shouldReturn(nextCheck)) {
                return;
            }
            Dimension d = this.getMapPanel().viewport().getSize();
            if (this.mBufferedImage == null || (double)this.mBufferedImage.getWidth() != d.getWidth() || (double)this.mBufferedImage.getHeight() != d.getHeight()) {
                this.isDirty = true;
                this.mBufferedImage = new BufferedImage((int)d.getWidth(), (int)d.getHeight(), 2);
            }
            if (this.mPreviousWorldRect == null || !scl.getWorldRect().equals(this.mPreviousWorldRect)) {
                this.isDirty = true;
            }
            boolean wasInterrupted = false;
            if (this.isDirty) {
                this.mPreviousWorldRect = scl.getWorldRect();
                Graphics2D graphics = (Graphics2D)this.mBufferedImage.getGraphics();
                graphics.setColor(new Color(0, 0, 1, 0));
                graphics.setComposite(AlphaComposite.Clear);
                graphics.fillRect(0, 0, this.mBufferedImage.getWidth(), this.mBufferedImage.getHeight());
                graphics.setComposite(AlphaComposite.SrcOver);
                AiShapeMap map = (AiShapeMap)this._map;
                WorldRect sclRect = scl.getWorldRect();
                WorldRect mapRect = this.getBounds();
                if (sclRect.intersects(mapRect) || sclRect.contains(mapRect)) {
                    if (map.getType() == 1 || map.getType() == 11 || map.getType() == 21) {
                        this.drawPoints(graphics, scl);
                    } else if (map.getType() == 3 || map.getType() == 13 || map.getType() == 23) {
                        boolean drawArcsCompleted = this.drawArcs(graphics, scl);
                        wasInterrupted = wasInterrupted || !drawArcsCompleted;
                    } else if (map.getType() == 5 || map.getType() == 15 || map.getType() == 25) {
                        boolean drawPolyCompleted = this.drawPolygons(graphics, scl);
                        wasInterrupted = wasInterrupted || !drawPolyCompleted;
                    } else if (map.getType() == 8) {
                        boolean drawMultiPointsCompleted = this.drawMultiPoints(graphics, scl);
                        wasInterrupted = wasInterrupted || !drawMultiPointsCompleted;
                    }
                    this.drawSelectedPoints(graphics, scl);
                    graphics.dispose();
                }
            }
            Composite oldAc = ((Graphics2D)g).getComposite();
            ((Graphics2D)g).setComposite(AlphaComposite.SrcOver);
            g.drawImage(this.mBufferedImage, 0, 0, null);
            ((Graphics2D)g).setComposite(oldAc);
            if (this.isDirty && !wasInterrupted) {
                this.isDirty = false;
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    @Override
    public void modifiedStateChanged(Modifiable obj, boolean modified) {
        this.isDirty = true;
        this.setRepaintNeeded(true);
        this._mapPanel.paintMap();
    }

    private void drawSelectedPoints(Graphics g, MapScale scl) {
        int cnt = this._selectedPoints.size();
        AiShapeGlyphDataRecord glyphData = (AiShapeGlyphDataRecord)this.getDataRecord();
        int symbolType = glyphData.getSymbolIndex();
        int size = glyphData.getPointSize();
        size += 2;
        Color ptColor = Color.YELLOW;
        for (int i = 0; i < cnt; ++i) {
            WorldPt wpt = this._selectedPoints.get(i);
            int x = scl.e2x(wpt.e);
            int y = scl.n2y(wpt.n);
            RmaSymbol.draw(g, x, y, symbolType, ptColor, ptColor, size);
        }
    }

    private boolean drawMultiPoints(Graphics g, MapScale scl) {
        int y;
        int x;
        WorldPt pt;
        WorldRect shapeRect;
        AiShapeMultiPoint aipt;
        CoordinateReferenceSystem dataSystem = this._map.getCoordinateReferenceSystem();
        CoordinateReferenceSystem viewSystem = DisplayCoordinateReferenceSystem.getDefault().getCoordinateRefereceSystem();
        Transform dataToViewTransform = this.transformLookup(dataSystem, viewSystem);
        AiShapeMap map = (AiShapeMap)this._map;
        WorldRect sclRect = scl.getWorldRect();
        AiShapeGlyphDataRecord glyphData = (AiShapeGlyphDataRecord)this.getDataRecord();
        Color defaultColor = glyphData.getDefaultColor();
        List<AiShapeObject> contentVec = map.getShapes();
        Graphics2D g2d = (Graphics2D)g;
        Stroke oldStroke = g2d.getStroke();
        int labelFieldIndex = glyphData.getLabelFieldIndex();
        Color ccStartColor = glyphData.getColorContourStart();
        Color ccEndColor = glyphData.getColorContourEnd();
        TwoColorColorContour colorContour = new TwoColorColorContour();
        colorContour.setMinColor(ccStartColor);
        colorContour.setMaxColor(ccEndColor);
        colorContour.setMinValue(0.0);
        colorContour.setMaxValue(contentVec.size());
        BasicStroke highlightStroke = null;
        double[] xPt = new double[1];
        double[] yPt = new double[1];
        WorldRect viewRectInDataCoords = this.transformRect(sclRect, viewSystem, dataSystem);
        for (int i = 0; i < contentVec.size(); ++i) {
            Color ptColor;
            aipt = (AiShapeMultiPoint)contentVec.get(i);
            shapeRect = aipt.getExtent();
            if (!viewRectInDataCoords.intersects(shapeRect) && !viewRectInDataCoords.contains(shapeRect)) continue;
            Field field = aipt.getAttribute().getField(glyphData.getFieldIndex());
            boolean hasDrawingAttribute = glyphData.hasDrawingAttribute(field);
            if (hasDrawingAttribute) {
                ShapeDrawingAttribute attr = glyphData.getDrawingAttribute(field);
                if (attr != null && attr.isHighlighted(aipt.getIndex())) {
                    ptColor = glyphData.getHighlightColor();
                    float strokeSize = attr.getBrushSize() * 3.0f;
                    highlightStroke = new BasicStroke(strokeSize);
                    g2d.setStroke(highlightStroke);
                } else {
                    ptColor = attr != null && !glyphData.drawUsingDefaultColor ? attr.getColor() : defaultColor;
                }
            } else {
                ptColor = defaultColor;
            }
            if (ptColor == null) {
                ptColor = defaultColor;
            }
            int symbolType = glyphData.getSymbolIndex();
            int size = glyphData.getPointSize();
            Vector points = aipt.getPoints();
            for (Object point : points) {
                pt = (WorldPt)point;
                xPt[0] = pt.e;
                yPt[0] = pt.n;
                try {
                    dataToViewTransform.transform(xPt, yPt, 0, xPt, yPt, 0, 1);
                }
                catch (CRSException ex) {
                    Logger.getLogger(AiShapeGlyph.class.getName()).log(Level.SEVERE, null, ex);
                }
                x = scl.e2x(xPt[0]);
                y = scl.n2y(yPt[0]);
                RmaSymbol.draw(g2d, x, y, symbolType, ptColor, ptColor, size);
                if (highlightStroke == null) continue;
                g2d.setStroke(oldStroke);
            }
        }
        if (labelFieldIndex >= 0) {
            int SPACER = 3;
            g2d.setColor(Color.black);
            Font f = glyphData.getLabelFont();
            AffineTransform oldTx = ((Graphics2D)g).getTransform();
            AffineTransform rotate = AffineTransform.getRotateInstance(Math.PI / 180 * glyphData.getLabelRotation());
            if (f == null) {
                f = g2d.getFont();
            }
            Font rotatedFont = f.deriveFont(rotate);
            g2d.setFont(rotatedFont);
            f = rotatedFont;
            FontMetrics fm = g2d.getFontMetrics();
            int ptSize = glyphData.getPointSize();
            int labelPos = glyphData.getLabelPosition();
            for (int ii = 0; ii < contentVec.size(); ++ii) {
                aipt = (AiShapeMultiPoint)contentVec.get(ii);
                shapeRect = aipt.getExtent();
                if (!viewRectInDataCoords.intersects(shapeRect) && !viewRectInDataCoords.contains(shapeRect)) continue;
                Vector points = aipt.getPoints();
                for (Object point : points) {
                    pt = (WorldPt)point;
                    xPt[0] = pt.e;
                    yPt[0] = pt.n;
                    try {
                        dataToViewTransform.transform(xPt, yPt, 0, xPt, yPt, 0, 1);
                    }
                    catch (CRSException ex) {
                        Logger.getLogger(AiShapeGlyph.class.getName()).log(Level.SEVERE, null, ex);
                    }
                    x = scl.e2x(xPt[0]);
                    y = scl.n2y(yPt[0]);
                    String label = aipt.getAttribute().getField(labelFieldIndex).toString();
                    int width = fm.stringWidth(label);
                    if (labelPos == 2 || labelPos == 3 || labelPos == 1) {
                        y -= ptSize / 2 + SPACER + fm.getDescent();
                    }
                    if (labelPos == 6 || labelPos == 5 || labelPos == 7) {
                        y += ptSize / 2 + SPACER + fm.getAscent();
                    }
                    if (labelPos == 0 || labelPos == 4) {
                        y += fm.getAscent() / 2;
                    }
                    if (labelPos == 0 || labelPos == 1 || labelPos == 7) {
                        x += ptSize / 2 + SPACER;
                    }
                    if (labelPos == 4 || labelPos == 3 || labelPos == 5) {
                        x -= ptSize / 2 + width + SPACER;
                    }
                    if (labelPos == 2 || labelPos == 6) {
                        x -= width / 2;
                    }
                    g2d.drawString(label, x, y);
                }
            }
        }
        return true;
    }

    private void drawPoints(Graphics g, MapScale scl) {
        int y;
        int x;
        WorldPt pt;
        WorldRect shapeRect;
        AiShapePoint aipt;
        CoordinateReferenceSystem dataSystem = this._map.getCoordinateReferenceSystem();
        CoordinateReferenceSystem viewSystem = DisplayCoordinateReferenceSystem.getDefault().getCoordinateRefereceSystem();
        Transform dataToViewTransform = this.transformLookup(dataSystem, viewSystem);
        AiShapeMap map = (AiShapeMap)this._map;
        WorldRect sclRect = scl.getWorldRect();
        AiShapeGlyphDataRecord glyphData = (AiShapeGlyphDataRecord)this.getDataRecord();
        Color defaultColor = glyphData.getDefaultColor();
        List<AiShapeObject> contentVec = map.getShapes();
        Graphics2D g2d = (Graphics2D)g;
        Stroke oldStroke = g2d.getStroke();
        int labelFieldIndex = glyphData.getLabelFieldIndex();
        Color ccStartColor = glyphData.getColorContourStart();
        Color ccEndColor = glyphData.getColorContourEnd();
        TwoColorColorContour colorContour = new TwoColorColorContour();
        colorContour.setMinColor(ccStartColor);
        colorContour.setMaxColor(ccEndColor);
        colorContour.setMinValue(0.0);
        colorContour.setMaxValue(contentVec.size());
        BasicStroke highlightStroke = null;
        double[] xPt = new double[1];
        double[] yPt = new double[1];
        WorldRect viewRectInDataCoords = this.transformRect(sclRect, viewSystem, dataSystem);
        for (int i = 0; i < contentVec.size(); ++i) {
            Color ptColor;
            aipt = (AiShapePoint)contentVec.get(i);
            shapeRect = aipt.getExtent();
            if (!viewRectInDataCoords.intersects(shapeRect) && !viewRectInDataCoords.contains(shapeRect)) continue;
            Field field = aipt.getAttribute().getField(glyphData.getFieldIndex());
            boolean hasDrawingAttribute = glyphData.hasDrawingAttribute(field);
            if (hasDrawingAttribute) {
                ShapeDrawingAttribute attr = glyphData.getDrawingAttribute(field);
                if (attr != null && attr.isHighlighted(aipt.getIndex())) {
                    ptColor = glyphData.getHighlightColor();
                    float strokeSize = attr.getBrushSize() * 3.0f;
                    highlightStroke = new BasicStroke(strokeSize);
                    g2d.setStroke(highlightStroke);
                } else {
                    ptColor = attr != null && !glyphData.drawUsingDefaultColor ? attr.getColor() : defaultColor;
                }
            } else {
                ptColor = defaultColor;
            }
            if (ptColor == null) {
                ptColor = defaultColor;
            }
            int symbolType = glyphData.getSymbolIndex();
            int size = glyphData.getPointSize();
            pt = aipt.getWorldPt();
            xPt[0] = pt.e;
            yPt[0] = pt.n;
            try {
                dataToViewTransform.transform(xPt, yPt, 0, xPt, yPt, 0, 1);
            }
            catch (CRSException ex) {
                Logger.getLogger(AiShapeGlyph.class.getName()).log(Level.SEVERE, null, ex);
            }
            x = scl.e2x(xPt[0]);
            y = scl.n2y(yPt[0]);
            RmaSymbol.draw(g2d, x, y, symbolType, ptColor, ptColor, size);
            if (highlightStroke == null) continue;
            g2d.setStroke(oldStroke);
        }
        if (labelFieldIndex >= 0) {
            int SPACER = 3;
            g2d.setColor(Color.black);
            Font f = glyphData.getLabelFont();
            AffineTransform oldTx = ((Graphics2D)g).getTransform();
            AffineTransform rotate = AffineTransform.getRotateInstance(Math.PI / 180 * glyphData.getLabelRotation());
            if (f == null) {
                f = g2d.getFont();
            }
            Font rotatedFont = f.deriveFont(rotate);
            g2d.setFont(rotatedFont);
            f = rotatedFont;
            FontMetrics fm = g2d.getFontMetrics();
            int ptSize = glyphData.getPointSize();
            int labelPos = glyphData.getLabelPosition();
            for (int ii = 0; ii < contentVec.size(); ++ii) {
                aipt = (AiShapePoint)contentVec.get(ii);
                shapeRect = aipt.getExtent();
                if (!viewRectInDataCoords.intersects(shapeRect) && !viewRectInDataCoords.contains(shapeRect)) continue;
                pt = aipt.getReferencePt();
                xPt[0] = pt.e;
                yPt[0] = pt.n;
                try {
                    dataToViewTransform.transform(xPt, yPt, 0, xPt, yPt, 0, 1);
                }
                catch (CRSException ex) {
                    Logger.getLogger(AiShapeGlyph.class.getName()).log(Level.SEVERE, null, ex);
                }
                x = scl.e2x(xPt[0]);
                y = scl.n2y(yPt[0]);
                String label = aipt.getAttribute().getField(labelFieldIndex).toString();
                int width = fm.stringWidth(label);
                if (labelPos == 2 || labelPos == 3 || labelPos == 1) {
                    y -= ptSize / 2 + SPACER + fm.getDescent();
                }
                if (labelPos == 6 || labelPos == 5 || labelPos == 7) {
                    y += ptSize / 2 + SPACER + fm.getAscent();
                }
                if (labelPos == 0 || labelPos == 4) {
                    y += fm.getAscent() / 2;
                }
                if (labelPos == 0 || labelPos == 1 || labelPos == 7) {
                    x += ptSize / 2 + SPACER;
                }
                if (labelPos == 4 || labelPos == 3 || labelPos == 5) {
                    x -= ptSize / 2 + width + SPACER;
                }
                if (labelPos == 2 || labelPos == 6) {
                    x -= width / 2;
                }
                g2d.drawString(label, x, y);
            }
        }
    }

    private boolean drawPolygons(Graphics g, MapScale scl) {
        CoordinateReferenceSystem dataSystem = this._map.getCoordinateReferenceSystem();
        CoordinateReferenceSystem viewSystem = DisplayCoordinateReferenceSystem.getDefault().getCoordinateRefereceSystem();
        Transform transform = this.transformLookup(dataSystem, viewSystem);
        if (!(dataSystem == null || viewSystem == null || dataSystem.equals(viewSystem) || !this._cachingOn || this._transformedFailed || this._currentDataCRS != null && this._currentDataCRS.equals(viewSystem))) {
            boolean shapesTransformed = this.transformPolyShapes(dataSystem, viewSystem);
            if (shapesTransformed) {
                this._currentDataCRS = viewSystem;
                this._transformedFailed = false;
            } else {
                this._transformedFailed = true;
                this._txformedShapeList.clear();
            }
        }
        AiShapeMap map = (AiShapeMap)this._map;
        WorldRect sclRect = scl.getWorldRect();
        AiShapeGlyphDataRecord glyphData = (AiShapeGlyphDataRecord)this.getDataRecord();
        int fieldIdx = glyphData.getFieldIndex();
        List contentVec = map.getShapes();
        Color defaultColor = glyphData.getDefaultColor();
        Dimension dim = this.getMapPanel().viewport().getSize();
        int w = dim.width;
        int h = dim.height;
        Graphics2D big = (Graphics2D)g.create();
        Stroke oldStroke = big.getStroke();
        Color ccStart = glyphData.getColorContourStart();
        Color ccEnd = glyphData.getColorContourEnd();
        TwoColorColorContour colorContour = new TwoColorColorContour();
        colorContour.setMinColor(ccStart);
        colorContour.setMaxColor(ccEnd);
        colorContour.setMinValue(0.0);
        colorContour.setMaxValue(contentVec.size());
        int[] shapeXArray = new int[10000];
        int[] shapeYArray = new int[10000];
        WorldRect viewRectInDataCoords = this.transformRect(sclRect, viewSystem, dataSystem);
        if (dataSystem != null && !dataSystem.equals(viewSystem) && this._txformedShapeList != null && this._txformedShapeList.size() > 0) {
            transform = this.transformLookup(this._currentDataCRS, viewSystem);
            contentVec = this._txformedShapeList;
            viewRectInDataCoords = this.transformRect(sclRect, viewSystem, this._currentDataCRS);
        }
        long[] nextCheck = new long[]{-1L};
        for (int ii = 0; ii < contentVec.size(); ++ii) {
            if (AiShapeGlyph.shouldReturn(nextCheck)) {
                return false;
            }
            AiShapePolygon poly = (AiShapePolygon)contentVec.get(ii);
            WorldRect shapeRect = poly.getExtent();
            if (!viewRectInDataCoords.intersects(shapeRect) && !viewRectInDataCoords.contains(shapeRect)) continue;
            BasicStroke highlightStroke = null;
            Field field = poly.getAttribute().getField(fieldIdx);
            boolean hasDrawingAttribute = glyphData.hasDrawingAttribute(field);
            Color fieldColor = null;
            if (hasDrawingAttribute) {
                ShapeDrawingAttribute attr = glyphData.getDrawingAttribute(field);
                if (attr != null && attr.isHighlighted(poly.getIndex())) {
                    fieldColor = glyphData.getHighlightColor();
                    float strokeSize = attr.getBrushSize() * 3.0f;
                    highlightStroke = new BasicStroke(strokeSize);
                    big.setStroke(highlightStroke);
                } else {
                    fieldColor = attr != null && !glyphData.drawUsingDefaultColor ? attr.getColor() : defaultColor;
                }
            } else {
                fieldColor = defaultColor;
            }
            if (fieldColor == null) {
                fieldColor = colorContour.getColor(ii);
            }
            Color fieldLineColor = glyphData.getBorderLineColor();
            List regions = poly.getRegions();
            Paint op = big.getPaint();
            Stroke os = big.getStroke();
            Paint tp = FillPatternFactory.createFillPattern(glyphData.getFillStyle(), fieldColor);
            BasicStroke bs = new BasicStroke(glyphData.getBorderWidth(), 0, 0, 10.0f, glyphData.getBorderLineStyle(), 0.0f);
            double[] xPts = new double[1];
            double[] yPts = new double[1];
            for (int j = 0; j < ((Vector)regions).size(); ++j) {
                int i;
                WorldRegion reg = (WorldRegion)((Vector)regions).elementAt(j);
                if (reg == null) continue;
                if (shapeXArray.length < reg.pts.size()) {
                    shapeXArray = new int[reg.pts.size()];
                    shapeYArray = new int[reg.pts.size()];
                }
                for (i = 0; i < reg.pts.size(); ++i) {
                    WorldPt pt = (WorldPt)reg.pts.elementAt(i);
                    if (AiShapeGlyph.shouldReturn(nextCheck)) {
                        return false;
                    }
                    if (pt == null) continue;
                    try {
                        xPts[0] = pt.e;
                        yPts[0] = pt.n;
                        transform.transform(xPts, yPts, 0, xPts, yPts, 0, 1);
                        shapeXArray[i] = scl.e2x(xPts[0]);
                        shapeYArray[i] = scl.n2y(yPts[0]);
                        continue;
                    }
                    catch (CRSException ex) {
                        Logger.getLogger(AiShapeGlyph.class.getName()).log(Level.SEVERE, null, ex);
                    }
                }
                if (i <= 0) continue;
                if (glyphData.drawAreas) {
                    big.setColor(fieldColor);
                    if (!reg.isClockwise()) {
                        big.setPaintMode();
                    } else {
                        big.setPaintMode();
                    }
                    big.setPaint(tp);
                    Composite oldac = big.getComposite();
                    AlphaComposite ac = AlphaComposite.getInstance(3, (float)(glyphData.getAlpha() / 100.0));
                    big.setComposite(ac);
                    big.fillPolygon(shapeXArray, shapeYArray, i);
                    big.setComposite(oldac);
                    if (op != null) {
                        big.setPaint(op);
                    }
                    big.setPaintMode();
                }
                if (!glyphData.drawLines) continue;
                big.setPaintMode();
                big.setColor(fieldLineColor);
                big.setStroke(bs);
                big.drawPolygon(shapeXArray, shapeYArray, i);
                if (os == null) continue;
                big.setStroke(os);
            }
            if (highlightStroke == null) continue;
            big.setStroke(oldStroke);
        }
        int labelFieldIndex = glyphData.getLabelFieldIndex();
        if (labelFieldIndex >= 0) {
            Font f = glyphData.getLabelFont();
            AffineTransform rotate = AffineTransform.getRotateInstance(Math.PI / 180 * glyphData.getLabelRotation());
            if (f == null) {
                f = big.getFont();
            }
            Font rotatedFont = f.deriveFont(rotate);
            big.setFont(rotatedFont);
            FontMetrics fm = big.getFontMetrics();
            int ptSize = glyphData.getPointSize();
            int labelPos = glyphData.getLabelPosition();
            int SPACER = 1;
            big.setColor(Color.black);
            double[] xPts = new double[1];
            double[] yPts = new double[1];
            for (int ii = 0; ii < contentVec.size(); ++ii) {
                if (AiShapeGlyph.shouldReturn(nextCheck)) {
                    return false;
                }
                AiShapePolygon aipt = (AiShapePolygon)contentVec.get(ii);
                WorldRect shapeRect = aipt.getExtent();
                if (!viewRectInDataCoords.intersects(shapeRect) && !viewRectInDataCoords.contains(shapeRect)) continue;
                WorldPt pt = aipt.getReferencePt();
                xPts[0] = pt.e;
                yPts[0] = pt.n;
                try {
                    transform.transform(xPts, yPts, 0, xPts, yPts, 0, 1);
                }
                catch (Exception e) {
                    Logger.getLogger(AiShapeGlyph.class.getName()).log(Level.SEVERE, e.getMessage(), e);
                }
                int x = scl.e2x(xPts[0]);
                int y = scl.n2y(yPts[0]);
                String label = aipt.getAttribute().getField(labelFieldIndex).toString();
                int width = fm.stringWidth(label);
                if (labelPos == 2 || labelPos == 3 || labelPos == 1) {
                    y -= fm.getDescent();
                }
                if (labelPos == 6 || labelPos == 5 || labelPos == 7) {
                    y += fm.getAscent();
                }
                if (labelPos == 0 || labelPos == 4) {
                    y += fm.getAscent() / 2;
                }
                if (labelPos == 0 || labelPos == 1 || labelPos == 7) {
                    x += ptSize / 2 + SPACER;
                }
                if (labelPos == 4 || labelPos == 3 || labelPos == 5) {
                    x -= width;
                }
                if (labelPos == 2 || labelPos == 6) {
                    x -= width / 2;
                }
                big.drawString(label, x, y);
            }
        }
        return true;
    }

    public double[][] simplify(double[] xpts, double[] ypts, double range, int startIdx, int endIdx) {
        boolean[] usePt = new boolean[endIdx - startIdx + 1];
        for (int i = 0; i < usePt.length; ++i) {
            usePt[i] = true;
        }
        this.simplifySection(xpts, ypts, usePt, startIdx, endIdx, range);
        int count = 0;
        for (int i = 0; i < usePt.length; ++i) {
            if (!usePt[i]) continue;
            ++count;
        }
        int idx = startIdx;
        double[][] returnValues = new double[2][count];
        for (int i = 0; i < usePt.length; ++i) {
            if (!usePt[i]) continue;
            returnValues[0][idx] = xpts[i];
            returnValues[1][idx] = ypts[i];
            ++idx;
        }
        return returnValues;
    }

    private void simplifySection(double[] xpts, double[] ypts, boolean[] usePt, int i, int j, double distanceTolerance) {
        int k;
        if (i + 1 == j) {
            return;
        }
        this.segment.pt0.e = xpts[i];
        this.segment.pt0.n = ypts[i];
        this.segment.pt1.e = xpts[j];
        this.segment.pt1.n = ypts[j];
        double maxDistance = -1.0;
        int maxIndex = i;
        for (k = i + 1; k < j; ++k) {
            this.pt0.e = xpts[k];
            this.pt0.n = ypts[k];
            double distance = this.pt0.distToLineSeg(this.segment);
            if (!(distance > maxDistance)) continue;
            maxDistance = distance;
            maxIndex = k;
        }
        if (maxDistance <= distanceTolerance) {
            for (k = i + 1; k < j; ++k) {
                usePt[k] = false;
            }
        } else {
            this.simplifySection(xpts, ypts, usePt, i, maxIndex, distanceTolerance);
            this.simplifySection(xpts, ypts, usePt, maxIndex, j, distanceTolerance);
        }
    }

    private boolean drawArcs(Graphics g, MapScale scl) {
        CoordinateReferenceSystem dataSystem = this._map.getCoordinateReferenceSystem();
        CoordinateReferenceSystem viewSystem = DisplayCoordinateReferenceSystem.getDefault().getCoordinateRefereceSystem();
        Transform transform = this.transformLookup(dataSystem, viewSystem);
        if (!(dataSystem == null || viewSystem == null || dataSystem.equals(viewSystem) || !this._cachingOn || this._transformedFailed || this._currentDataCRS != null && this._currentDataCRS.equals(viewSystem))) {
            boolean shapesTransformed = this.transformArcShapes(dataSystem, viewSystem);
            if (shapesTransformed) {
                this._currentDataCRS = viewSystem;
                this._transformedFailed = false;
            } else {
                this._transformedFailed = true;
                this._txformedShapeList.clear();
            }
        }
        AiShapeGlyphDataRecord glyphData = (AiShapeGlyphDataRecord)this.getDataRecord();
        int fieldIdx = glyphData.getFieldIndex();
        AiShapeMap map = (AiShapeMap)this._map;
        WorldRect sclRect = scl.getWorldRect();
        List contentVec = map.getShapes();
        Color defaultColor = glyphData.getDefaultColor();
        Graphics2D g2d = (Graphics2D)g;
        Stroke oldStroke = g2d.getStroke();
        BasicStroke bs = new BasicStroke(glyphData.getBorderWidth(), 0, 0, 10.0f, glyphData.getBorderLineStyle(), 0.0f);
        g2d.setStroke(bs);
        g2d.setColor(Color.black);
        Font f = glyphData.getLabelFont();
        AffineTransform oldTx = ((Graphics2D)g).getTransform();
        AffineTransform rotate = AffineTransform.getRotateInstance(Math.PI / 180 * glyphData.getLabelRotation());
        if (f == null) {
            f = g2d.getFont();
        }
        Font rotatedFont = f.deriveFont(rotate);
        g2d.setFont(rotatedFont);
        f = rotatedFont;
        FontMetrics fm = g2d.getFontMetrics();
        int ptSize = glyphData.getPointSize();
        int labelPos = glyphData.getLabelPosition();
        g.setFont(f);
        Color ccStartColor = glyphData.getColorContourStart();
        Color ccEndColor = glyphData.getColorContourEnd();
        TwoColorColorContour colorContour = new TwoColorColorContour();
        colorContour.setMinColor(ccStartColor);
        colorContour.setMaxColor(ccEndColor);
        colorContour.setMinValue(0.0);
        colorContour.setMaxValue(contentVec.size());
        WorldRect viewRectInDataCoords = this.transformRect(sclRect, viewSystem, dataSystem);
        double[] xPts = new double[1];
        double[] yPts = new double[1];
        int[] shapeXArray = new int[10000];
        int[] shapeYArray = new int[10000];
        if (dataSystem != null && !dataSystem.equals(viewSystem) && this._txformedShapeList != null && this._txformedShapeList.size() > 0) {
            transform = this.transformLookup(this._currentDataCRS, viewSystem);
            contentVec = this._txformedShapeList;
            viewRectInDataCoords = this.transformRect(sclRect, viewSystem, this._currentDataCRS);
        }
        long[] nextCheck = new long[]{-1L};
        for (int ii = 0; ii < contentVec.size(); ++ii) {
            WorldRect shapeRect;
            if (AiShapeGlyph.shouldReturn(nextCheck)) {
                return false;
            }
            AiShapeArc arcLine = (AiShapeArc)contentVec.get(ii);
            if (arcLine == null || !viewRectInDataCoords.intersects(shapeRect = arcLine.getExtent()) && !viewRectInDataCoords.contains(shapeRect)) continue;
            BasicStroke highlightStroke = null;
            Field field = arcLine.getAttribute().getField(fieldIdx);
            boolean hasDrawingAttribute = glyphData.hasDrawingAttribute(field);
            Color color = null;
            if (hasDrawingAttribute) {
                ShapeDrawingAttribute attr = glyphData.getDrawingAttribute(field);
                if (attr != null && attr.isHighlighted(arcLine.getIndex())) {
                    color = glyphData.getHighlightColor();
                    float strokeSize = attr.getBrushSize() * 3.0f;
                    highlightStroke = new BasicStroke(strokeSize);
                    g2d.setStroke(highlightStroke);
                } else if (attr != null && !glyphData.drawUsingDefaultColor) {
                    color = attr.getColor();
                    g2d.setStroke(bs);
                } else {
                    color = defaultColor;
                    g2d.setStroke(bs);
                }
            } else {
                color = defaultColor;
            }
            if (color == null) {
                color = colorContour.getColor(ii);
            }
            Vector<WorldLine> lineList = arcLine.getArcLines();
            for (int j = 0; j < lineList.size(); ++j) {
                int i;
                WorldLine wline = lineList.elementAt(j);
                if (wline == null) continue;
                if (shapeXArray.length < wline.pts.size()) {
                    shapeXArray = new int[wline.pts.size()];
                    shapeYArray = new int[wline.pts.size()];
                }
                Object[] ptsArray = wline.pts.toArray();
                for (i = 0; i < ptsArray.length; ++i) {
                    WorldPt pt = (WorldPt)ptsArray[i];
                    if (pt == null) continue;
                    if (AiShapeGlyph.shouldReturn(nextCheck)) {
                        return false;
                    }
                    try {
                        xPts[0] = pt.e;
                        yPts[0] = pt.n;
                        transform.transform(xPts, yPts, 0, xPts, yPts, 0, 1);
                        shapeXArray[i] = scl.e2x(xPts[0]);
                        shapeYArray[i] = scl.n2y(yPts[0]);
                        continue;
                    }
                    catch (CRSException ex) {
                        Logger.getLogger(AiShapeGlyph.class.getName()).log(Level.SEVERE, null, ex);
                    }
                }
                if (i <= 0) continue;
                g.setPaintMode();
                g.setColor(color);
                g.drawPolyline(shapeXArray, shapeYArray, i);
                int SPACER = 1;
                if (glyphData.getLabelFieldIndex() < 0) continue;
                WorldPt pt = arcLine.getReferencePt();
                try {
                    xPts[0] = pt.e;
                    yPts[0] = pt.n;
                    transform.transform(xPts, yPts, 0, xPts, yPts, 0, 1);
                }
                catch (CRSException ex) {
                    Logger.getLogger(AiShapeGlyph.class.getName()).log(Level.SEVERE, null, ex);
                    continue;
                }
                int x = scl.e2x(xPts[0]);
                int y = scl.n2y(yPts[0]);
                g.setColor(Color.black);
                String label = arcLine.getAttribute().getField(glyphData.getLabelFieldIndex()).toString();
                int width = fm.stringWidth(label);
                if (labelPos == 2 || labelPos == 3 || labelPos == 1) {
                    y -= ptSize / 2 + SPACER + fm.getDescent();
                }
                if (labelPos == 6 || labelPos == 5 || labelPos == 7) {
                    y += ptSize / 2 + SPACER + fm.getAscent();
                }
                if (labelPos == 0 || labelPos == 4) {
                    y += fm.getAscent() / 2;
                }
                if (labelPos == 0 || labelPos == 1 || labelPos == 7) {
                    x += ptSize / 2 + SPACER;
                }
                if (labelPos == 4 || labelPos == 3 || labelPos == 5) {
                    x -= ptSize / 2 + width + SPACER;
                }
                if (labelPos == 2 || labelPos == 6) {
                    x -= width / 2;
                }
                g.drawString(label, x, y);
            }
        }
        if (Boolean.getBoolean("ShapeMapDebug")) {
            if (AiShapeGlyph.shouldReturn(nextCheck)) {
                return false;
            }
            LinearColorContour cc = new LinearColorContour();
            cc.setColor(Color.blue);
            cc.setMinValue(0.0);
            for (int ii = 0; ii < contentVec.size(); ++ii) {
                AiShapeArc arcLine = (AiShapeArc)contentVec.get(ii);
                Vector<WorldLine> lineList = arcLine.getArcLines();
                cc.setMaxValue(lineList.size());
                for (int j = 0; j < lineList.size(); ++j) {
                    WorldLine wline = lineList.elementAt(j);
                    if (wline == null) continue;
                    Color c2 = cc.getColor(j);
                    this.drawLine(g, wline, scl, 2.0, c2, null, false, null, 0);
                }
            }
        }
        if (oldStroke != null) {
            g2d.setStroke(oldStroke);
        }
        return true;
    }

    public void selectPoints(List<WorldPt> worldPts) {
        this._selectedPoints.clear();
        if (worldPts != null) {
            this._selectedPoints.addAll(worldPts);
        }
        this.setRepaintNeeded(true);
        this._mapPanel.paintMap();
    }

    public void clearSelections() {
        this._selectedPoints.clear();
        this.isDirty = true;
        this.setRepaintNeeded(true);
        this._mapPanel.paintMap();
    }

    @Override
    public void highlightRecords(List shapes, int centerPointGraphic) {
        AiShapeGlyphDataRecord data = (AiShapeGlyphDataRecord)this.getDataRecord();
        int fieldIdx = data.getFieldIndex();
        ShapeHighlight sh = new ShapeHighlight(shapes, fieldIdx, data, this.getMapPanel(), centerPointGraphic);
        this.addShapeHighlight(sh);
    }

    @Override
    public void clearHighlights() {
        if (this._shapeHighlights.size() < 1) {
            return;
        }
        for (int ii = 0; ii < this._shapeHighlights.size(); ++ii) {
            ShapeHighlight shapeHighlight = this._shapeHighlights.get(ii);
            shapeHighlight.clearHighlight();
        }
        this._shapeHighlights.clear();
        this.isDirty = true;
    }

    public void addShapeHighlight(ShapeHighlight sh) {
        this._shapeHighlights.add(sh);
        this.isDirty = true;
    }

    @Override
    public List getShapes() {
        return ((AiShapeMap)this._map).getShapes();
    }

    @Override
    public CoordinateReferenceSystem getCoordinateReferenceSystem() {
        return this.getMap().getCoordinateReferenceSystem();
    }

    protected boolean transformArcShapes(CoordinateReferenceSystem dataCRS, CoordinateReferenceSystem toCRS) {
        if (dataCRS == null || toCRS == null || dataCRS.equals(toCRS)) {
            return false;
        }
        Transform dataToViewTransform = this.transformLookup(dataCRS, toCRS);
        List<AiShapeObject> contentVec = ((AiShapeMap)this._map).getShapes();
        this._txformedShapeList.clear();
        for (int ii = 0; ii < contentVec.size(); ++ii) {
            AiShapeArc arcLine = (AiShapeArc)contentVec.get(ii);
            AiShapeArc txformedShape = this.transformArcLine(dataToViewTransform, arcLine);
            this._txformedShapeList.add(txformedShape);
        }
        this._currentDataCRS = toCRS;
        return true;
    }

    protected AiShapeArc transformArcLine(Transform txform, AiShapeArc arcLine) {
        WorldLine txLine = null;
        Vector<WorldLine> newList = new Vector<WorldLine>();
        for (WorldLine wline : arcLine.getArcLines()) {
            if (wline == null) continue;
            txLine = this.transformWorldLine(txform, wline);
            newList.add(txLine);
        }
        AiShapeArc newArcLine = new AiShapeArc(arcLine.getIndex(), newList);
        newArcLine.setAttribute(arcLine.getAttribute());
        return newArcLine;
    }

    protected WorldLine transformWorldLine(Transform txform, WorldLine worldLine) {
        WorldLine newLine = (WorldLine)worldLine.clone();
        int npts = newLine.pts.size();
        for (int i = 0; i < npts; ++i) {
            WorldPt pt = (WorldPt)newLine.pts.get(i);
            this.transformWorldPt(txform, pt);
        }
        return newLine;
    }

    protected boolean transformPolyShapes(CoordinateReferenceSystem dataCRS, CoordinateReferenceSystem toCRS) {
        if (dataCRS == null || toCRS == null || dataCRS.equals(toCRS)) {
            return false;
        }
        Transform dataToViewTransform = this.transformLookup(dataCRS, toCRS);
        List<AiShapeObject> contentVec = ((AiShapeMap)this._map).getShapes();
        this._txformedShapeList.clear();
        for (int ii = 0; ii < contentVec.size(); ++ii) {
            AiShapePolygon arcPoly = (AiShapePolygon)contentVec.get(ii);
            AiShapePolygon txformedShape = this.transformPolygon(dataToViewTransform, arcPoly);
            this._txformedShapeList.add(txformedShape);
        }
        this._currentDataCRS = toCRS;
        return true;
    }

    protected AiShapePolygon transformPolygon(Transform txform, AiShapePolygon arcPoly) {
        WorldRegion txWorldReg = null;
        Vector<WorldRegion> newList = new Vector<WorldRegion>();
        for (WorldRegion oldRegion : arcPoly.getRegions()) {
            if (oldRegion == null) continue;
            txWorldReg = this.transformWorldRegion(txform, oldRegion);
            newList.add(txWorldReg);
        }
        AiShapePolygon newPolyShape = null;
        try {
            newPolyShape = new AiShapePolygon(arcPoly.getIndex(), newList);
        }
        catch (SelfIntersectingPolygonException ex) {
            Logger.getLogger(AiShapeGlyph.class.getName()).log(Level.SEVERE, "An invalid self intersecting polygon was encountered at index: " + arcPoly.getIndex(), ex);
            return arcPoly;
        }
        newPolyShape.setAttribute(arcPoly.getAttribute());
        return newPolyShape;
    }

    protected WorldRegion transformWorldRegion(Transform txform, WorldRegion worldRegion) {
        WorldRegion newRegion = (WorldRegion)worldRegion.clone();
        int npts = newRegion.pts.size();
        for (int i = 0; i < npts; ++i) {
            WorldPt pt = (WorldPt)newRegion.pts.get(i);
            this.transformWorldPt(txform, pt);
        }
        return newRegion;
    }

    protected WorldPt transformWorldPt(Transform txform, WorldPt wpt) {
        double[] xnew = new double[]{wpt.e};
        double[] ynew = new double[]{wpt.n};
        try {
            txform.transform(xnew, ynew, 0, xnew, ynew, 0, 1);
            wpt.e = xnew[0];
            wpt.n = ynew[0];
        }
        catch (CRSException ex) {
            Logger.getLogger(AiShapeGlyph.class.getName()).log(Level.SEVERE, null, ex);
            return wpt;
        }
        return wpt;
    }

    private class BlackFilter
    extends RGBImageFilter {
        private BlackFilter() {
        }

        @Override
        public int filterRGB(int x, int y, int rgb) {
            int r = (rgb & 0xFF0000) >> 16;
            int g = (rgb & 0xFF00) >> 8;
            int b = rgb & 0xFF;
            if (r == 0 && g == 0 && b == 1) {
                return rgb & 0xFFFFFF;
            }
            return rgb;
        }
    }
}

