/*
 * Decompiled with CFR 0.152.
 */
package hec.map.aishape;

import hec.gui.MoverDialog;
import hec.map.GlyphDataRecord;
import hec.map.GlyphDataRecordSerializable;
import hec.map.aishape.Field;
import hec.map.aishape.ShapeDrawingAttribute;
import java.awt.Color;
import java.awt.Font;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.IOException;
import java.io.Reader;
import java.io.Writer;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.StringTokenizer;
import java.util.Vector;
import java.util.prefs.Preferences;
import javax.swing.JDialog;
import org.jdom.Attribute;
import org.jdom.Content;
import org.jdom.DataConversionException;
import org.jdom.Document;
import org.jdom.Element;
import org.jdom.JDOMException;
import org.jdom.input.JDOMParseException;
import org.jdom.input.SAXBuilder;
import org.jdom.output.Format;
import org.jdom.output.XMLOutputter;
import rma.swing.RmaColor;
import rma.util.RMAIO;
import rma.util.RmaDrawConst;

public class AiShapeGlyphDataRecord
extends GlyphDataRecord
implements GlyphDataRecordSerializable,
PropertyChangeListener {
    public static final int SINGLE_SYMBOL = 0;
    public static final int UNIQUE_SYMBOL = 1;
    private static final double DEFAULT_ALPHA = 75.0;
    private static final long serialVersionUID = -5792407847286622231L;
    static final double red = 0.0;
    static final double yellow = 0.23;
    static final double green = 0.333;
    static final double cyan = 0.43;
    static final double blue = 0.667;
    static final double magenta = 0.833;
    static final double red1 = 0.999;
    int defaultRGB = -1;
    transient Color defaultColor = null;
    int highlightRGB = Color.red.getRGB();
    transient Color highlightColor = Color.red;
    boolean drawUsingDefaultColor = true;
    boolean drawLabels = false;
    boolean drawLines = true;
    boolean drawAreas = true;
    double mAlpha = 75.0;
    float[] mBorderLineStyle = RmaDrawConst.SOLID_STYLE_PATTERN;
    Color mBorderLineColor = Color.black;
    int mBorderWidth = 1;
    int mFillStyle = 0;
    Color mFillColor = Color.blue;
    int displayFieldIndex = 0;
    int defaultLineRGB = Color.red.getRGB();
    transient Color defaultLineColor = null;
    Hashtable drawingAttributeMap = new Hashtable();
    transient List _queryFields;
    transient int colorIndex = 0;
    static final int COLOR_INDEX_LIMIT = 500;
    private int mSymbolDrawType = 0;
    private int mPolygonDrawType = 0;
    private static final String DEFAULT_LABEL_FONT_NAME = "SansSerif";
    private static final int DEFAULT_FONT_STYLE = 0;
    private static final int DEFAULT_FONT_SIZE = 12;
    private transient Font mLabelFont = null;
    private String mFontName = "SansSerif";
    private String mFontStyle = Integer.toString(0);
    private String mFontSize = Integer.toString(12);
    private Color mColorContourStart = Color.blue;
    private Color mColorContourEnd = Color.red;
    private int mNumCountourSteps = 10;
    private double mLabelRotation = 0.0;
    private int mLabelPosition;
    private int mLabelFieldIndex = -1;
    private int mPointSize = 5;
    private int mSymbolIdx = 0;
    private boolean mUseGradations = false;
    private int mNumGradations = 5;
    private static final String ROOT_NODE_NAME = "ShapefileProperties";
    private static final int DEFAULT_STEP = 10;
    public static final String FLOAT_ARRAY_NODE_NAME = "floatArray";
    public static final String LENGTH_ATTRIBUTE = "Length";
    public static final String STEP_ATTRIBUTE = "Step";
    public static final String RANGE_ATTRIBUTE = "Range";
    public static final String DATA_ATTRIBUTE = "Data";
    transient PropertyChangeSupport mPropertyChangeSupport = new PropertyChangeSupport(this);

    private static Color createDefaultColor() {
        int colorIdx = Preferences.userNodeForPackage(AiShapeGlyphDataRecord.class).getInt("AiShapeDefaultColorIndex", 0);
        Color c2 = Color.blue;
        List colorList = RmaColor.getColorList();
        c2 = (Color)colorList.get(colorIdx % colorList.size());
        Preferences.userNodeForPackage(AiShapeGlyphDataRecord.class).putInt("AiShapeDefaultColorIndex", ++colorIdx);
        return c2;
    }

    public AiShapeGlyphDataRecord() {
        Color c2 = AiShapeGlyphDataRecord.createDefaultColor();
        this.defaultRGB = c2.getRGB();
    }

    public boolean getUseGradations() {
        return this.mUseGradations;
    }

    public void setDrawAreas(boolean draw) {
        this.drawAreas = draw;
    }

    public boolean getDrawAreas() {
        return this.drawAreas;
    }

    public void setUseGradations(boolean b) {
        this.mUseGradations = b;
    }

    public int getNumGradations() {
        return this.mNumGradations;
    }

    public void setNumGradations(int numGradations) {
        this.mNumGradations = numGradations;
    }

    public double getAlpha() {
        return this.mAlpha;
    }

    public void setAlpha(double alpha) {
        this.mAlpha = alpha;
    }

    public void setPolygonDrawType(int drawType) {
        assert (drawType == 0 || drawType == 1);
        this.mPolygonDrawType = drawType;
    }

    public int getPolygonDrawType() {
        return this.mPolygonDrawType;
    }

    public void setSymbolDrawType(int drawType) {
        assert (drawType == 0 || drawType == 1);
        this.mSymbolDrawType = drawType;
    }

    public int getSymbolDrawType() {
        return this.mSymbolDrawType;
    }

    public void setSymbolIndex(int symbolIdx) {
        this.mSymbolIdx = symbolIdx;
    }

    public int getSymbolIndex() {
        return this.mSymbolIdx;
    }

    public void setLabelFont(Font font) {
        assert (font != null);
        this.mLabelFont = font;
        this.mFontName = this.mLabelFont.getFontName();
        this.mFontStyle = Integer.toString(this.mLabelFont.getStyle());
        this.mFontSize = Integer.toString(this.mLabelFont.getSize());
    }

    public Font getLabelFont() {
        String labelFontName = this.mFontName;
        if (this.mLabelFont == null) {
            if (labelFontName == null || labelFontName.length() == 0) {
                labelFontName = DEFAULT_LABEL_FONT_NAME;
            }
            int fontStyle = 0;
            try {
                fontStyle = Integer.valueOf(this.mFontStyle);
            }
            catch (NumberFormatException e) {
                fontStyle = 0;
            }
            int fontSize = 12;
            try {
                fontSize = Integer.valueOf(this.mFontSize);
            }
            catch (NumberFormatException e) {
                fontSize = 12;
            }
            this.mLabelFont = new Font(labelFontName, fontStyle, fontSize);
        }
        return this.mLabelFont;
    }

    public Color getDefaultLineColor() {
        if (this.defaultLineColor == null) {
            this.buildColors();
        }
        return this.defaultLineColor;
    }

    public void setDefaultLineColor(Color c2) {
        this.defaultLineColor = c2;
        this.defaultLineRGB = c2.getRGB();
    }

    public Color getDefaultColor() {
        if (this.defaultColor == null) {
            this.buildColors();
        }
        return this.defaultColor;
    }

    public void setDefaultColor(Color c2) {
        this.defaultColor = c2;
        this.defaultRGB = c2.getRGB();
    }

    public Color getColorContourStart() {
        return this.mColorContourStart;
    }

    public void setColorContourStart(Color c2) {
        this.mColorContourStart = c2;
    }

    public void setColorContourSteps(int numSteps) {
        this.mNumCountourSteps = numSteps;
    }

    public void setColorContourEnd(Color c2) {
        this.mColorContourEnd = c2;
    }

    public Color getColorContourEnd() {
        return this.mColorContourEnd;
    }

    public void setHighlightColor(Color c2) {
        this.highlightColor = c2;
        this.highlightRGB = c2.getRGB();
    }

    public Color getHighlightColor() {
        if (this.highlightColor == null) {
            this.buildColors();
        }
        return this.highlightColor;
    }

    private void buildColors() {
        if (this.defaultColor == null) {
            if (this.defaultRGB != -1) {
                this.defaultColor = new Color(this.defaultRGB);
            } else {
                this.defaultColor = AiShapeGlyphDataRecord.createDefaultColor();
                this.defaultRGB = this.defaultColor.getRGB();
            }
        }
        if (this.highlightColor == null) {
            this.highlightColor = new Color(this.highlightRGB);
        }
        if (this.defaultLineColor == null) {
            this.defaultLineColor = new Color(this.defaultLineRGB);
        }
    }

    public boolean chooseQueryFields(JDialog parent, List availableFields) {
        Vector currentFields = this.getQueryFields();
        if (currentFields == null) {
            currentFields = new Vector();
            currentFields.addAll(availableFields);
        }
        MoverDialog dialog = new MoverDialog(parent, true, "Choose Query Fields");
        dialog.setMoveUpDownVisible(true);
        dialog.setData(availableFields, currentFields);
        dialog.setVisible(true);
        if (dialog.isCanceled()) {
            return false;
        }
        Vector selectedObjects = dialog.getSelectedObjectsVector();
        if (currentFields.equals(selectedObjects)) {
            return false;
        }
        this.setQueryFields(selectedObjects);
        return true;
    }

    public List getQueryFields() {
        return this._queryFields;
    }

    public void setQueryFields(List v) {
        this._queryFields = v;
    }

    public int getFieldIndex() {
        return this.displayFieldIndex;
    }

    public void setFieldIndex(int idx) {
        this.displayFieldIndex = idx;
    }

    public ShapeDrawingAttribute getDrawingAttribute(Object field) {
        ShapeDrawingAttribute attr = (ShapeDrawingAttribute)this.drawingAttributeMap.get(field);
        if (attr == null) {
            attr = new ShapeDrawingAttribute(this.getDefaultColor());
            this.setDrawingAttribute(field, attr);
        }
        return attr;
    }

    public Color buildColor() {
        int ib;
        int ig;
        double b;
        double g;
        double r;
        double c_strt = 0.833;
        double c_end = 0.0;
        if (this.colorIndex > 500) {
            this.colorIndex = 0;
        }
        ++this.colorIndex;
        double rlen = 500.0;
        int interval = (int)(rlen / 4.0);
        if (interval < 8) {
            interval = 8;
        }
        if (interval == 11) {
            interval = 10;
        }
        int ival = this.colorIndex % interval;
        int ilevel = this.colorIndex / interval;
        double hue = c_strt - (c_strt - c_end) * ((double)ival / (double)interval);
        double bright = 1.0;
        double sat = 1.0;
        if (ilevel == 1) {
            sat = 0.6;
        }
        if (ilevel == 2) {
            bright = 0.9;
        }
        if (ilevel == 3) {
            sat = 0.65;
            bright = 0.95;
        }
        if (hue >= 0.0 && hue < 0.23) {
            r = 255.0;
            g = 255.0 * (hue - 0.0) / 0.23;
            b = 0.0;
        } else if (hue >= 0.23 && hue < 0.333) {
            r = 255.0 * (0.333 - hue) / 0.10300000000000001;
            g = 255.0;
            b = 0.0;
        } else if (hue >= 0.333 && hue < 0.43) {
            r = 0.0;
            g = 255.0;
            b = 255.0 * (hue - 0.333) / 0.09699999999999998;
        } else if (hue >= 0.43 && hue < 0.667) {
            r = 0.0;
            g = 255.0 * (0.667 - hue) / 0.23700000000000004;
            b = 255.0;
        } else if (hue >= 0.667 && hue < 0.833) {
            r = 255.0 * (hue - 0.667) / 0.16599999999999993;
            g = 0.0;
            b = 255.0;
        } else if (hue >= 0.833 && hue < 0.999) {
            r = 255.0;
            g = 0.0;
            b = 255.0 * (0.999 - hue) / 0.16600000000000004;
        } else {
            r = 0.0;
            g = 0.0;
            b = 0.0;
        }
        double dr = 255.0 - r;
        double dg = 255.0 - g;
        double db = 255.0 - b;
        int ir = (int)((255.0 - dr * sat) * bright);
        if (ir < 0) {
            ir = 0;
        }
        if ((ig = (int)((255.0 - dg * sat) * bright)) < 0) {
            ig = 0;
        }
        if ((ib = (int)((255.0 - db * sat) * bright)) < 0) {
            ib = 0;
        }
        return new Color(ir, ig, ib);
    }

    public boolean hasDrawingAttribute(Object field) {
        return this.drawingAttributeMap.get(field) != null;
    }

    public void setDrawingAttribute(Object field, ShapeDrawingAttribute attr) {
        this.drawingAttributeMap.put(field, attr);
        attr.addPropertyChangeListener(this);
    }

    @Override
    protected void read0(String type, String param, BufferedReader input) throws IOException {
        if (type.compareTo("DrawLabels") == 0) {
            this.drawLabels = Boolean.valueOf(param);
        } else if (type.compareTo("DrawLines") == 0) {
            this.drawLines = Boolean.valueOf(param);
        } else if (type.compareTo("DrawAreas") == 0) {
            this.drawAreas = Boolean.valueOf(param);
        } else if (type.compareTo("DisplayFieldIndex") == 0) {
            this.displayFieldIndex = RMAIO.parseInt(param);
        }
    }

    @Override
    protected void write0(BufferedWriter output) throws IOException {
        output.write("DisplayFieldIndex=" + this.displayFieldIndex);
        output.newLine();
    }

    @Override
    public boolean useAsciiSerialization() {
        return true;
    }

    @Override
    public Object getFieldObject(java.lang.reflect.Field fld) {
        try {
            Object obj = fld.get(this);
            return obj;
        }
        catch (IllegalAccessException e) {
            return null;
        }
    }

    @Override
    public boolean setFieldObject(java.lang.reflect.Field fld, Object fobj) {
        try {
            fld.set(this, fobj);
            return true;
        }
        catch (IllegalAccessException e) {
            return false;
        }
        catch (IllegalArgumentException e) {
            return false;
        }
    }

    public double getLabelRotation() {
        return this.mLabelRotation;
    }

    public void setLabelRotation(double roation) {
        this.mLabelRotation = roation;
    }

    public void setLabelPosition(int position) {
        this.mLabelPosition = position;
    }

    public int getLabelPosition() {
        return this.mLabelPosition;
    }

    public void setLabelFieldIndex(int index) {
        this.mLabelFieldIndex = index;
    }

    public int getLabelFieldIndex() {
        return this.mLabelFieldIndex;
    }

    public void setPointSize(int size) {
        this.mPointSize = size;
    }

    public int getPointSize() {
        return this.mPointSize;
    }

    public float[] getBorderLineStyle() {
        return this.mBorderLineStyle;
    }

    public void setBorderLineStyle(float[] lineStyle) {
        this.mBorderLineStyle = lineStyle;
    }

    public int getBorderWidth() {
        return this.mBorderWidth;
    }

    public void setBorderWidth(int width) {
        this.mBorderWidth = width;
    }

    public Color getBorderLineColor() {
        return this.mBorderLineColor;
    }

    public void setBorderLineColor(Color borderColor) {
        this.mBorderLineColor = borderColor;
    }

    public void setDisplayBorder(boolean b) {
        this.drawLines = b;
    }

    public boolean isBorderDisplayed() {
        return this.drawLines;
    }

    public void setFillStyle(int fillStyle) {
        this.mFillStyle = fillStyle;
    }

    public int getFillStyle() {
        return this.mFillStyle;
    }

    public Color getFillColor() {
        return this.mFillColor;
    }

    public void setFillColor(Color fillColor) {
        this.mFillColor = fillColor;
    }

    public void setDrawUsingDefaultColor(boolean b) {
        this.drawUsingDefaultColor = b;
    }

    public boolean drawUsingDefaultColor() {
        return this.drawUsingDefaultColor;
    }

    @Override
    public void serialize(BufferedWriter writer) throws IOException {
        XMLOutputter outputter = new XMLOutputter();
        outputter.setFormat(Format.getPrettyFormat());
        outputter.output(this.saveDocument(), (Writer)writer);
    }

    public Document saveDocument() {
        Element rootElement = new Element(ROOT_NODE_NAME);
        Document doc = new Document(rootElement);
        Element child = new Element("DefaultRGB");
        child.addContent(Integer.toString(this.defaultRGB));
        rootElement.addContent((Content)child);
        rootElement.addContent((Content)new Element("HighlightRGB").addContent(Integer.toString(this.highlightRGB)));
        rootElement.addContent((Content)new Element("DrawUsingDefaultColor").addContent(Boolean.toString(this.drawUsingDefaultColor)));
        rootElement.addContent((Content)new Element("DrawLabels").addContent(Boolean.toString(this.drawLabels)));
        rootElement.addContent((Content)new Element("DrawLines").addContent(Boolean.toString(this.drawLines)));
        rootElement.addContent((Content)new Element("DrawArea").addContent(Boolean.toString(this.drawAreas)));
        rootElement.addContent((Content)new Element("Alpha").addContent(Double.toString(this.mAlpha)));
        rootElement.addContent((Content)new Element("BorderColor").addContent(RmaColor.color2String(this.mBorderLineColor)));
        rootElement.addContent((Content)new Element("BorderWidth").addContent(Integer.toString(this.mBorderWidth)));
        Element borderStyle = new Element("BorderStyle");
        AiShapeGlyphDataRecord.createArrayElements(borderStyle, this.mBorderLineStyle);
        rootElement.addContent((Content)borderStyle);
        rootElement.addContent((Content)new Element("FillColor").addContent(RmaColor.color2String(this.mFillColor)));
        rootElement.addContent((Content)new Element("FillStyle").addContent(RmaDrawConst.lookupFillPatternName(this.mFillStyle)));
        rootElement.addContent((Content)new Element("SymbolDrawType").addContent(Integer.toString(this.mSymbolDrawType)));
        rootElement.addContent((Content)new Element("PolygonDrawType").addContent(Integer.toString(this.mPolygonDrawType)));
        Element labelFnt = new Element("LabelFont");
        labelFnt.setAttribute("Name", this.mFontName);
        labelFnt.setAttribute("Style", this.mFontStyle);
        labelFnt.setAttribute("Size", this.mFontSize);
        rootElement.addContent((Content)labelFnt);
        rootElement.addContent((Content)new Element("DisplayFieldIndex").addContent(Integer.toString(this.displayFieldIndex)));
        rootElement.addContent((Content)new Element("ColorContourStartColor").addContent(RmaColor.color2String(this.mColorContourStart)));
        rootElement.addContent((Content)new Element("ColorContourEndColor").addContent(RmaColor.color2String(this.mColorContourEnd)));
        rootElement.addContent((Content)new Element("NumContourSteps").addContent(Integer.toString(this.mNumCountourSteps)));
        rootElement.addContent((Content)new Element("LabelRotation").addContent(Double.toString(this.mLabelRotation)));
        rootElement.addContent((Content)new Element("LabelPosition").addContent(Integer.toString(this.mLabelPosition)));
        rootElement.addContent((Content)new Element("LabelFieldIndex").addContent(Integer.toString(this.mLabelFieldIndex)));
        rootElement.addContent((Content)new Element("PointSize").addContent(Integer.toString(this.mPointSize)));
        rootElement.addContent((Content)new Element("SymbolIndex").addContent(Integer.toString(this.mSymbolIdx)));
        rootElement.addContent((Content)new Element("UseGradations").addContent(Boolean.toString(this.mUseGradations)));
        rootElement.addContent((Content)new Element("NumGradations").addContent(Integer.toString(this.mNumGradations)));
        Element attributeMap = new Element("AttributeMap");
        Set entrySet = this.drawingAttributeMap.entrySet();
        Iterator iterator = entrySet.iterator();
        while (iterator.hasNext()) {
            Element elemEntry = new Element("Entry");
            Map.Entry entry = iterator.next();
            Field f = (Field)entry.getKey();
            ShapeDrawingAttribute attrib = (ShapeDrawingAttribute)entry.getValue();
            Element fieldElement = new Element("Field");
            fieldElement.addContent((Content)new Element("Value").addContent(f.getValue().toString()));
            fieldElement.addContent((Content)new Element("Hash").addContent(Integer.toString(f.hash)));
            fieldElement.addContent((Content)new Element("FieldType").addContent(Character.toString(f.getType())));
            elemEntry.addContent((Content)fieldElement);
            Element attibuteElement = new Element("DrawingAttribute");
            attibuteElement.addContent((Content)new Element("DrawingColor").addContent(RmaColor.color2String(attrib.getColor())));
            attibuteElement.addContent((Content)new Element("BrushSize").addContent(Float.toString(attrib.getBrushSize())));
            elemEntry.addContent((Content)attibuteElement);
            attributeMap.addContent((Content)elemEntry);
        }
        rootElement.addContent((Content)attributeMap);
        return doc;
    }

    @Override
    public void deserialize(BufferedReader reader) throws IOException, JDOMException {
        Document doc = null;
        SAXBuilder builder = new SAXBuilder();
        try {
            doc = builder.build((Reader)reader);
        }
        catch (JDOMParseException e) {
            String msg = e.getMessage();
            if (msg != null && (msg = msg.toLowerCase()).contains("content is not allowed in prolog")) {
                return;
            }
            throw e;
        }
        Element root = doc.getRootElement();
        if (root == null) {
            return;
        }
        if (!ROOT_NODE_NAME.equals(root.getName())) {
            throw new IOException("Incorrect Shapefile Properties File.  Does not contain the correct root node.");
        }
        Element child = root.getChild("DefaultRGB");
        String value = child.getValue();
        this.defaultRGB = RMAIO.parseInt(value);
        child = root.getChild("HighlightRGB");
        value = child.getValue();
        this.highlightRGB = RMAIO.parseInt(value);
        child = root.getChild("DrawUsingDefaultColor");
        value = child.getValue();
        this.drawUsingDefaultColor = Boolean.parseBoolean(value);
        child = root.getChild("DrawLabels");
        value = child.getValue();
        this.drawLabels = Boolean.parseBoolean(value);
        child = root.getChild("DrawLines");
        value = child.getValue();
        this.drawLines = Boolean.parseBoolean(value);
        child = root.getChild("DrawArea");
        value = child.getValue();
        this.drawAreas = Boolean.parseBoolean(value);
        child = root.getChild("Alpha");
        value = child.getValue();
        this.mAlpha = RMAIO.parseDouble(value, 75.0);
        child = root.getChild("BorderColor");
        value = child.getValue();
        this.mBorderLineColor = RmaColor.parseColorString(value);
        child = root.getChild("BorderWidth");
        value = child.getValue();
        this.mBorderWidth = RMAIO.parseInt(value, 1);
        child = root.getChild("BorderStyle");
        this.mBorderLineStyle = RmaDrawConst.SOLID_STYLE_PATTERN;
        if (child != null) {
            this.mBorderLineStyle = AiShapeGlyphDataRecord.getFloatArrayElements(child);
        }
        child = root.getChild("FillColor");
        value = child.getValue();
        this.mFillColor = RmaColor.parseColorString(value);
        child = root.getChild("FillStyle");
        value = child.getValue();
        this.mFillStyle = RmaDrawConst.lookupFillPattern(value);
        child = root.getChild("SymbolDrawType");
        value = child.getValue();
        this.mSymbolDrawType = RMAIO.parseInt(value);
        child = root.getChild("PolygonDrawType");
        value = child.getValue();
        this.mPolygonDrawType = RMAIO.parseInt(value);
        child = root.getChild("DisplayFieldIndex");
        value = child.getValue();
        this.displayFieldIndex = RMAIO.parseInt(value);
        child = root.getChild("ColorContourStartColor");
        value = child.getValue();
        this.mColorContourStart = RmaColor.parseColorString(value);
        child = root.getChild("ColorContourEndColor");
        value = child.getValue();
        this.mColorContourEnd = RmaColor.parseColorString(value);
        child = root.getChild("NumContourSteps");
        value = child.getValue();
        this.mNumCountourSteps = RMAIO.parseInt(value, 0);
        child = root.getChild("LabelRotation");
        value = child.getValue();
        this.mLabelRotation = RMAIO.parseDouble(value, 0.0);
        child = root.getChild("LabelPosition");
        value = child.getValue();
        this.mLabelPosition = RMAIO.parseInt(value, 0);
        child = root.getChild("LabelFieldIndex");
        value = child.getValue();
        this.mLabelFieldIndex = RMAIO.parseInt(value, -1);
        child = root.getChild("PointSize");
        value = child.getValue();
        this.mPointSize = RMAIO.parseInt(value, 5);
        child = root.getChild("SymbolIndex");
        value = child.getValue();
        this.mSymbolIdx = RMAIO.parseInt(value, 0);
        child = root.getChild("LabelFont");
        if (child != null) {
            this.mFontName = child.getAttributeValue("Name");
            this.mFontStyle = child.getAttributeValue("Style");
            this.mFontSize = child.getAttributeValue("Size");
        }
        child = root.getChild("UseGradations");
        value = child.getValue();
        this.mUseGradations = Boolean.parseBoolean(value);
        child = root.getChild("NumGradations");
        value = child.getValue();
        this.mNumGradations = RMAIO.parseInt(value, 5);
        Element attributeChild = root.getChild("AttributeMap");
        List entries = attributeChild.getChildren("Entry");
        this.drawingAttributeMap.clear();
        Element fieldElem = null;
        Element attributeElem = null;
        Element entryElem = null;
        for (int i = 0; i < entries.size(); ++i) {
            entryElem = (Element)entries.get(i);
            fieldElem = entryElem.getChild("Field");
            Field field = new Field();
            child = fieldElem.getChild("Value");
            value = child.getValue();
            field.value = value;
            child = fieldElem.getChild("Hash");
            value = child.getValue();
            field.hash = RMAIO.parseInt(value);
            child = fieldElem.getChild("FieldType");
            value = child.getValue();
            field.fieldType = value.charAt(0);
            ShapeDrawingAttribute sda = new ShapeDrawingAttribute();
            attributeElem = entryElem.getChild("DrawingAttribute");
            child = attributeElem.getChild("DrawingColor");
            value = child.getValue();
            sda.setColor(RmaColor.parseColorString(value));
            child = attributeElem.getChild("BrushSize");
            value = child.getValue();
            sda.brushSize = RMAIO.parseFloat(value);
            this.setDrawingAttribute(field, sda);
        }
    }

    public static boolean createArrayElements(Element base, float[] array) {
        return AiShapeGlyphDataRecord.createArrayElements(base, array, AiShapeGlyphDataRecord.getStepSize(array));
    }

    public static boolean createArrayElements(Element base, float[] array, int step) {
        if (base == null || array == null) {
            return false;
        }
        if (step < 0) {
            step = AiShapeGlyphDataRecord.getStepSize(array);
        }
        Element arrayElem = new Element(FLOAT_ARRAY_NODE_NAME);
        base.addContent((Content)arrayElem);
        arrayElem.setAttribute(LENGTH_ATTRIBUTE, String.valueOf(array.length));
        arrayElem.setAttribute(STEP_ATTRIBUTE, String.valueOf(step));
        StringBuffer buffer = new StringBuffer();
        int cnt = 0;
        for (int i = 0; i < array.length; i += step) {
            Element child = new Element("F");
            arrayElem.addContent((Content)child);
            int endRange = Math.min(i + (step - 1), array.length);
            child.setAttribute(RANGE_ATTRIBUTE, String.valueOf(i + "-" + endRange));
            int j = i;
            for (cnt = 0; cnt < step && j < array.length; ++cnt, ++j) {
                buffer.append(array[j]);
                buffer.append(",");
            }
            if (buffer.length() > 0) {
                buffer.setLength(buffer.length() - 1);
            }
            child.setAttribute(DATA_ATTRIBUTE, buffer.substring(0));
            buffer.setLength(0);
        }
        return true;
    }

    protected static int getStepSize(Object array) {
        int length;
        java.lang.reflect.Field lenField;
        if (array == null) {
            return 10;
        }
        if (!array.getClass().isArray()) {
            return 10;
        }
        try {
            lenField = array.getClass().getDeclaredField("length");
        }
        catch (SecurityException e1) {
            return 10;
        }
        catch (NoSuchFieldException e1) {
            return 10;
        }
        if (lenField == null) {
            return 10;
        }
        try {
            length = lenField.getInt(array);
        }
        catch (IllegalArgumentException e) {
            return 10;
        }
        catch (IllegalAccessException e) {
            return 10;
        }
        if (length <= 10) {
            return 10;
        }
        if ((double)length <= 12.0) {
            return length;
        }
        if (length > 1000) {
            return 20;
        }
        return 10;
    }

    public static float[] getFloatArrayElements(Element elem) {
        if (elem == null) {
            return null;
        }
        Element arrayElem = AiShapeGlyphDataRecord.getArrayElement(elem, FLOAT_ARRAY_NODE_NAME);
        if (arrayElem == null) {
            return null;
        }
        int length = AiShapeGlyphDataRecord.getArrayLength(arrayElem);
        int step = AiShapeGlyphDataRecord.getArrayStep(arrayElem);
        float[] values = new float[length];
        List children = arrayElem.getChildren();
        int idx = 0;
        for (int i = 0; i < children.size(); ++i) {
            Element child = (Element)children.get(i);
            String data = AiShapeGlyphDataRecord.getArrayData(child);
            StringTokenizer tokenizer = new StringTokenizer(data, ",");
            while (tokenizer.hasMoreTokens()) {
                String token = tokenizer.nextToken();
                values[idx++] = RMAIO.parseFloat(token);
            }
        }
        return values;
    }

    private static Element getArrayElement(Element elem, String elemName) {
        if (!elemName.equals(elem.getName())) {
            return elem.getChild(elemName);
        }
        return elem;
    }

    private static int getArrayLength(Element arrayElem) {
        if (arrayElem == null) {
            return 0;
        }
        Attribute lengthAttr = arrayElem.getAttribute(LENGTH_ATTRIBUTE);
        try {
            return lengthAttr.getIntValue();
        }
        catch (DataConversionException e) {
            System.out.println("getArrayLength:DataConversionException getting array length " + e);
            e.printStackTrace();
            return 0;
        }
    }

    private static int getArrayStep(Element arrayElem) {
        if (arrayElem == null) {
            return 0;
        }
        Attribute stepAttr = arrayElem.getAttribute(STEP_ATTRIBUTE);
        try {
            return stepAttr.getIntValue();
        }
        catch (DataConversionException e) {
            System.out.println("getArrayStep:DataConversionException getting array length " + e);
            e.printStackTrace();
            return 0;
        }
    }

    private static String getArrayData(Element arrayElem) {
        if (arrayElem == null) {
            return "";
        }
        return arrayElem.getAttributeValue(DATA_ATTRIBUTE);
    }

    @Override
    public void propertyChange(PropertyChangeEvent evt) {
        this.mPropertyChangeSupport.firePropertyChange(evt);
        this.setModified(true);
    }

    public void addPropertyChangeListener(PropertyChangeListener listener) {
        this.mPropertyChangeSupport.addPropertyChangeListener(listener);
    }

    public void removePropertyChangeListener(PropertyChangeListener listener) {
        this.mPropertyChangeSupport.removePropertyChangeListener(listener);
    }
}

