/*
 * Decompiled with CFR 0.152.
 */
package hec.map.aishape;

import hec.map.JLayerSelection;
import hec.map.MapPanel;
import hec.map.MapScaleEditorPanel;
import hec.map.aishape.AiShapeFieldDescriptor;
import hec.map.aishape.AiShapeGlyph;
import hec.map.aishape.AiShapeGlyphDataRecord;
import hec.map.aishape.Attribute;
import hec.map.aishape.Field;
import hec.map.aishape.ShapeDrawingAttribute;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Image;
import java.awt.Insets;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.image.MemoryImageSource;
import java.io.Serializable;
import java.util.HashSet;
import java.util.Vector;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTabbedPane;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.table.TableColumn;
import rma.swing.ButtonCmdPanel;
import rma.swing.ButtonCmdPanelListener;
import rma.swing.RmaInsets;
import rma.swing.RmaJComboBox;
import rma.swing.RmaJDialog;
import rma.swing.RmaJTable;
import rma.swing.event.ReflectMultiListener;
import rma.swing.table.RmaTableModel;
import rma.util.RMAUtil;

public class AiShapeGlyphOptionJDlg
extends RmaJDialog
implements ListSelectionListener {
    AiShapeGlyph _glyph;
    AiShapeGlyphDataRecord _data;
    JLayerSelection _layerSel;
    RmaJTable _table;
    FieldColorTableModel _model;
    MapScaleEditorPanel m_mapScalePanel;
    MapPanel _mapPanel;
    int _selectedIndex;
    JLabel labelName;
    JPanel panel_checkboxes;
    JCheckBox checkboxDefaultColor;
    ColorButton buttonDefaultColor;
    ColorButton buttonDefaultLineColor;
    JCheckBox checkboxIds;
    JCheckBox checkboxLines;
    JCheckBox checkboxAreas;
    JPanel panel_buttons;
    JButton buttonOK;
    JButton buttonApply;
    JButton buttonCancel;
    JComboBox jcomboFieldType;
    JPanel panel_legend;
    static Vector nonPointColnames = new Vector();
    static Vector pointColnames = new Vector();
    static Vector nonPointEditable = new Vector();
    static Vector pointEditable = new Vector();
    Vector colnames;
    Vector editable;
    ReflectMultiListener listeners = new ReflectMultiListener();

    public AiShapeGlyphOptionJDlg(Frame parent, boolean modal, MapPanel panel, AiShapeGlyph glyph, AiShapeGlyphDataRecord datarec, JLayerSelection jls) {
        this(parent, modal);
        this._layerSel = jls;
        this._mapPanel = panel;
        this._glyph = glyph;
        this.m_mapScalePanel.setMapPanel(this._mapPanel);
        this.setDataRecord(datarec);
        this._selectedIndex = this._data.getFieldIndex();
        Vector fieldDescriptors = this._glyph.getFieldDescriptors();
        this.jcomboFieldType.removeAllItems();
        for (int i = 0; i < fieldDescriptors.size(); ++i) {
            AiShapeFieldDescriptor fld = (AiShapeFieldDescriptor)fieldDescriptors.elementAt(i);
            String str = fld._value;
            this.jcomboFieldType.addItem(str);
        }
        if (this._selectedIndex >= 0 && this._selectedIndex < fieldDescriptors.size()) {
            this.jcomboFieldType.setSelectedIndex(this._selectedIndex);
        } else if (this.jcomboFieldType.getItemCount() > 0) {
            this.jcomboFieldType.setSelectedIndex(0);
        }
        this.labelName.setText(this._glyph.getName());
        this.fillForm();
        SymItem lSymItem = new SymItem();
        this.jcomboFieldType.addItemListener(lSymItem);
        this._table.getSelectionModel().addListSelectionListener(this);
        this.checkboxDefaultColor.addActionListener(this.listeners.add(this, this.checkboxDefaultColor, "modified"));
        this.checkboxIds.addActionListener(this.listeners.add(this, this.checkboxIds, "modified"));
        this.checkboxLines.addActionListener(this.listeners.add(this, this.checkboxLines, "modified"));
        this.checkboxAreas.addActionListener(this.listeners.add(this, this.checkboxAreas, "modified"));
        this.buttonDefaultColor.addActionListener(this.listeners.add(this, this.buttonDefaultColor, "changeDefaultColor"));
        this.buttonDefaultLineColor.addActionListener(this.listeners.add(this, this.buttonDefaultLineColor, "changeDefaultLineColor"));
    }

    public void modified() {
        this.setModified(true);
    }

    private void changeColor(ColorButton cb) {
        Color newColor = RMAUtil.colorChooser(this, cb.getColor());
        if (newColor.equals(cb.getColor())) {
            return;
        }
        this.modified();
        cb.setColor(newColor);
        cb.repaint();
    }

    public void changeDefaultLineColor() {
        this.changeColor(this.buttonDefaultLineColor);
    }

    public void changeDefaultColor() {
        this.changeColor(this.buttonDefaultColor);
    }

    public void setDataRecord(AiShapeGlyphDataRecord data) {
        this._data = data;
        if (data != null) {
            this.buttonDefaultColor.setColor(data.getDefaultColor());
            this.buttonDefaultLineColor.setColor(data.getDefaultLineColor());
            this.checkboxDefaultColor.setSelected(data.drawUsingDefaultColor);
            this.checkboxIds.setSelected(data.drawLabels);
            this.checkboxLines.setSelected(data.drawLines);
            this.checkboxAreas.setSelected(data.drawAreas);
        }
    }

    public AiShapeGlyphOptionJDlg(Frame parent, boolean modal) {
        super(parent, modal);
        GridBagLayout gridBagLayout = new GridBagLayout();
        this.getContentPane().setLayout(gridBagLayout);
        this.setVisible(false);
        this.setTitle("Shapefile Display Options");
        this.setSize(300, 450);
        this.setLocation();
        this.labelName = new JLabel("Map Name");
        GridBagConstraints gbc = new GridBagConstraints();
        gbc.gridx = 0;
        gbc.gridy = 0;
        gbc.weightx = 1.0;
        gbc.anchor = 11;
        gbc.fill = 2;
        gbc.insets = new Insets(0, 20, 0, 0);
        this.getContentPane().add((Component)this.labelName, gbc);
        JTabbedPane tabbedPane = new JTabbedPane();
        this.getContentPane().add((Component)tabbedPane, new GridBagConstraints(0, 1, 1, 1, 1.0, 1.0, 18, 1, new Insets(5, 5, 0, 5), 0, 0));
        JPanel propertiesPanel = new JPanel(new GridBagLayout());
        this.m_mapScalePanel = new MapScaleEditorPanel();
        tabbedPane.add("Properties", propertiesPanel);
        tabbedPane.add("Scale", this.m_mapScalePanel);
        this.panel_checkboxes = new JPanel();
        gridBagLayout = new GridBagLayout();
        this.panel_checkboxes.setLayout(gridBagLayout);
        gbc = new GridBagConstraints();
        gbc.gridx = 0;
        gbc.gridy = 1;
        gbc.weightx = 1.0;
        gbc.anchor = 11;
        gbc.fill = 2;
        gbc.insets = new Insets(10, 30, 10, 0);
        propertiesPanel.add((Component)this.panel_checkboxes, gbc);
        this.checkboxDefaultColor = new JCheckBox("Draw Using Default Color");
        this.checkboxDefaultColor.setMnemonic('C');
        gbc = new GridBagConstraints();
        gbc.gridx = 0;
        gbc.gridy = 0;
        gbc.weightx = 1.0;
        gbc.anchor = 17;
        gbc.fill = 0;
        gbc.insets = new Insets(0, 0, 0, 0);
        this.panel_checkboxes.add((Component)this.checkboxDefaultColor, gbc);
        this.buttonDefaultColor = new ColorButton();
        this.buttonDefaultColor.setMargin(RmaInsets.INSETS0000);
        this.buttonDefaultColor.setColor(Color.gray);
        gbc = new GridBagConstraints();
        gbc.gridx = 1;
        gbc.gridy = 0;
        gbc.weightx = 1.0;
        gbc.ipady = 10;
        gbc.ipadx = 25;
        gbc.anchor = 17;
        gbc.fill = 0;
        gbc.insets = new Insets(0, 0, 0, 0);
        this.panel_checkboxes.add((Component)this.buttonDefaultColor, gbc);
        this.checkboxIds = new JCheckBox("Draw Labels");
        this.checkboxIds.setMnemonic('D');
        gbc = new GridBagConstraints();
        gbc.gridx = 0;
        gbc.gridy = 1;
        gbc.weightx = 1.0;
        gbc.anchor = 17;
        gbc.fill = 0;
        gbc.insets = new Insets(0, 0, 0, 0);
        this.panel_checkboxes.add((Component)this.checkboxIds, gbc);
        this.checkboxLines = new JCheckBox("Draw Lines");
        this.checkboxLines.setMnemonic('L');
        gbc = new GridBagConstraints();
        gbc.gridx = 0;
        gbc.gridy = 2;
        gbc.weightx = 1.0;
        gbc.anchor = 17;
        gbc.fill = 0;
        gbc.insets = new Insets(0, 0, 0, 0);
        this.panel_checkboxes.add((Component)this.checkboxLines, gbc);
        this.buttonDefaultLineColor = new ColorButton();
        this.buttonDefaultLineColor.setMargin(RmaInsets.INSETS0000);
        this.buttonDefaultLineColor.setColor(Color.gray);
        gbc = new GridBagConstraints();
        gbc.gridx = 1;
        gbc.gridy = 2;
        gbc.weightx = 1.0;
        gbc.ipady = 10;
        gbc.ipadx = 25;
        gbc.anchor = 17;
        gbc.fill = 0;
        gbc.insets = RmaInsets.INSETS0000;
        this.panel_checkboxes.add((Component)this.buttonDefaultLineColor, gbc);
        this.checkboxAreas = new JCheckBox("Draw Areas");
        this.checkboxAreas.setMnemonic('A');
        gbc = new GridBagConstraints();
        gbc.gridx = 0;
        gbc.gridy = 3;
        gbc.weightx = 1.0;
        gbc.anchor = 17;
        gbc.fill = 0;
        gbc.insets = new Insets(0, 0, 0, 0);
        this.panel_checkboxes.add((Component)this.checkboxAreas, gbc);
        ButtonCmdPanel buttons = new ButtonCmdPanel(14);
        gbc = new GridBagConstraints();
        gbc.gridx = 0;
        gbc.gridy = 4;
        gbc.gridwidth = 0;
        gbc.weightx = 1.0;
        gbc.anchor = 15;
        gbc.fill = 2;
        gbc.insets = new Insets(5, 5, 5, 5);
        this.getContentPane().add((Component)buttons, gbc);
        buttons.addCmdPanelListener(new ButtonCmdPanelListener(){

            @Override
            public void buttonCmdActionPerformed(ActionEvent event) {
                int id = event.getID();
                if (id == 8) {
                    AiShapeGlyphOptionJDlg.this.okPressed();
                } else if (id == 2) {
                    AiShapeGlyphOptionJDlg.this.applyPressed();
                } else if (id == 4) {
                    AiShapeGlyphOptionJDlg.this.cancelPressed();
                }
            }
        });
        this.jcomboFieldType = new RmaJComboBox();
        gbc = new GridBagConstraints();
        gbc.gridx = 0;
        gbc.gridy = 2;
        gbc.anchor = 17;
        gbc.fill = 0;
        gbc.insets = new Insets(0, 28, 10, 0);
        propertiesPanel.add((Component)this.jcomboFieldType, gbc);
        this.panel_legend = new JPanel();
        this.panel_legend.setLayout(new BorderLayout(0, 0));
        gbc = new GridBagConstraints();
        gbc.gridx = 0;
        gbc.gridy = 3;
        gbc.weightx = 1.0;
        gbc.weighty = 1.0;
        gbc.fill = 1;
        gbc.insets = new Insets(0, 0, 0, 0);
        propertiesPanel.add((Component)this.panel_legend, gbc);
        this.registerEnterKey(true);
        this.registerEscapeKey(true);
    }

    public void cancelPressed() {
        this.setVisible(false);
    }

    public void okPressed() {
        this.applyPressed();
        this.setVisible(false);
    }

    public void applyPressed() {
        if (this._data == null) {
            return;
        }
        Vector attributeList = this._glyph.getAttributeVector();
        int fieldIdx = this._data.getFieldIndex();
        if (this._glyph.getMapType() == 1) {
            Color c2 = this._model.getColor(0);
            this._data.setDefaultColor(c2);
        } else {
            for (int i = 0; i < attributeList.size(); ++i) {
                Attribute attrib = (Attribute)attributeList.elementAt(i);
                if (attrib == null) continue;
                Field field = attrib.getField(fieldIdx);
                Color clr = this._model.getColor(field);
                ShapeDrawingAttribute attr = this._data.getDrawingAttribute(field);
                attr.setColor(clr);
            }
        }
        this._data.setDefaultColor(this.buttonDefaultColor.getColor());
        this._data.setDefaultLineColor(this.buttonDefaultLineColor.getColor());
        this._data.drawUsingDefaultColor = this.checkboxDefaultColor.isSelected();
        this._data.drawLabels = this.checkboxIds.isSelected();
        this._data.drawLines = this.checkboxLines.isSelected();
        this._data.drawAreas = this.checkboxAreas.isSelected();
        this._layerSel.setDataRecord(this._data);
        this._data.setModified(true);
        this._glyph.setMaximumScale(this.m_mapScalePanel.getMaximumScale());
        this._glyph.setMinimumScale(this.m_mapScalePanel.getMinimumScale());
        this._data.notifyObservers(this._layerSel);
        this.setModified(false);
    }

    void fillForm() {
        this.fillLegend();
        this.m_mapScalePanel.setScale(this._glyph.getMinimumScale(), this._glyph.getMaximumScale());
    }

    void fillLegend() {
        Vector rows = new Vector();
        int fieldIdx = this._data.getFieldIndex();
        if (this._glyph.getMapType() == 1) {
            Color c2 = this._data.getDefaultColor();
            Image img = this.makeImage(c2);
            ColorImageIcon imgicon = new ColorImageIcon(img, c2);
            Vector<ColorImageIcon> row = new Vector<ColorImageIcon>(1);
            row.add(imgicon);
            rows.add(row);
            this.colnames = pointColnames;
            this.editable = pointEditable;
        } else {
            HashSet<Field> fields = new HashSet<Field>();
            Vector attributeList = this._glyph.getAttributeVector();
            for (int i = 0; i < attributeList.size(); ++i) {
                Field field;
                Attribute attrib = (Attribute)attributeList.elementAt(i);
                if (attrib == null || fields.contains(field = attrib.getField(fieldIdx))) continue;
                Vector<Serializable> row = new Vector<Serializable>();
                ShapeDrawingAttribute attr = this._data.getDrawingAttribute(field);
                Color c3 = attr.getColor();
                Image img = this.makeImage(c3);
                ColorImageIcon imgicon = new ColorImageIcon(img, c3, field);
                row.add(imgicon);
                row.add(field);
                rows.add(row);
                fields.add(field);
            }
            this.colnames = nonPointColnames;
            this.editable = nonPointEditable;
        }
        this._model = new FieldColorTableModel(this.colnames, rows, this.editable);
        if (this._table == null) {
            this._table = new RmaJTable(this.panel_legend);
            this._table.setSelectionMode(1);
            this._table.setColumnSelectionAllowed(false);
            this._table.setCellSelectionEnabled(false);
            this._table.setRowSelectionAllowed(true);
            this._table.setPopupMenuEnabled(false);
            this._table.setVisible(true);
            this.panel_legend.add("Center", this._table.getScrollPane());
        }
        this._table.setModel(this._model);
        this.setTableWidths();
    }

    @Override
    public void setVisible(boolean tf) {
        super.setVisible(tf);
        if (tf) {
            this.setTableWidths();
        }
    }

    public void setTableWidths() {
        JScrollPane pane = this._table.getScrollPane();
        int width = pane.getWidth() / this.colnames.size();
        for (int i = 0; i < this.colnames.size(); ++i) {
            TableColumn tc = this._table.getColumnModel().getColumn(i);
            tc.setPreferredWidth(width);
            tc.setWidth(width);
        }
        this._table.revalidate();
        this._table.repaint();
    }

    void fieldType_ItemStateChanged(ItemEvent event) {
        this._selectedIndex = this.jcomboFieldType.getSelectedIndex();
        this._data.setFieldIndex(this._selectedIndex);
        this.setModified(true);
        this.fillLegend();
    }

    Image makeImage(Color clr) {
        int i;
        int w = 14;
        int h = 14;
        int myClr = clr.getRGB();
        int[] pix = new int[w * h];
        for (int i2 = 0; i2 < pix.length; ++i2) {
            pix[i2] = myClr;
        }
        int lastrow = pix.length - w;
        int blk = Color.black.getRGB();
        for (i = 0; i < w; ++i) {
            pix[i] = blk;
            pix[i + lastrow] = blk;
        }
        for (i = 0; i < pix.length - w; i += w) {
            pix[i] = blk;
            pix[i + w - 1] = blk;
        }
        MemoryImageSource mis = new MemoryImageSource(w, h, pix, 0, w);
        Image img = Toolkit.getDefaultToolkit().createImage(mis);
        return img;
    }

    @Override
    public void valueChanged(ListSelectionEvent e) {
        int[] rows = this._table.getSelectedRows();
        boolean changed = false;
        for (int ii = 0; ii < rows.length; ++ii) {
            if (rows[ii] < 0 || rows[ii] >= this._model.getRowCount()) continue;
            Vector row = this._model.getRow(rows[ii]);
            ColorImageIcon imgIcon = (ColorImageIcon)row.get(0);
            Color oldColor = imgIcon.color;
            Color newColor = RMAUtil.colorChooser(this, oldColor);
            if (newColor.equals(oldColor)) continue;
            Image img = this.makeImage(newColor);
            if (this._glyph.getMapType() == 1) {
                imgIcon = new ColorImageIcon(img, newColor);
                row.setElementAt(imgIcon, 0);
            } else {
                Object field = row.get(1);
                imgIcon = new ColorImageIcon(img, newColor, field);
                row.setElementAt(imgIcon, 0);
                row.setElementAt(field, 1);
            }
            changed = true;
            this.setModified(true);
        }
        if (changed) {
            this._table.getSelectionModel().clearSelection();
        }
    }

    public String getSelectedFieldType() {
        return (String)this.jcomboFieldType.getSelectedItem();
    }

    static {
        nonPointColnames.add("Color");
        nonPointColnames.add("Value");
        nonPointEditable.add(false);
        nonPointEditable.add(false);
        pointColnames.add("Color");
        pointEditable.add(false);
    }

    class SymItem
    implements ItemListener {
        SymItem() {
        }

        @Override
        public void itemStateChanged(ItemEvent event) {
            Object object = event.getSource();
            if (object == AiShapeGlyphOptionJDlg.this.jcomboFieldType) {
                AiShapeGlyphOptionJDlg.this.fieldType_ItemStateChanged(event);
            }
        }
    }

    class ColorButton
    extends JButton {
        protected Color _color = Color.gray;

        public Color getColor() {
            return this._color;
        }

        public void setColor(Color c2) {
            this._color = c2;
            int w = 12;
            int h = 12;
            int rgb = c2.getRGB();
            int[] pix = new int[h * w];
            for (int ii = 0; ii < pix.length; ++ii) {
                pix[ii] = rgb;
            }
            MemoryImageSource mis = new MemoryImageSource(w, h, pix, 0, w);
            Image img = Toolkit.getDefaultToolkit().createImage(mis);
            this.setIcon(new ImageIcon(img));
        }
    }

    public class FieldColorTableModel
    extends RmaTableModel {
        public FieldColorTableModel(Vector columnNames, Vector rows, Vector editable) {
            super(columnNames, rows, editable);
        }

        public Color getColor(Object field) {
            for (int ii = 0; ii < this.rows.size(); ++ii) {
                Vector row = (Vector)this.rows.get(ii);
                if (!row.contains(field)) continue;
                ColorImageIcon imgIcon = (ColorImageIcon)row.get(0);
                return imgIcon.color;
            }
            return null;
        }

        public Color getColor(int idx) {
            Vector row = (Vector)this.rows.get(idx);
            ColorImageIcon imgIcon = (ColorImageIcon)row.get(0);
            return imgIcon.color;
        }

        public Object getField(int idx) {
            Vector row = (Vector)this.rows.get(idx);
            return row.get(1);
        }
    }

    public class ColorImageIcon
    extends ImageIcon {
        Object value;
        Color color;

        public ColorImageIcon(Image img, Color c2) {
            super(img);
            this.value = "";
            this.color = c2;
        }

        public ColorImageIcon(Image img, Color c2, Object o) {
            super(img);
            this.value = o;
            this.color = c2;
        }

        @Override
        public String toString() {
            return this.value.toString();
        }
    }
}

