/*
 * Decompiled with CFR 0.152.
 */
package hec.map.aishape;

import hec.lang.Logger;
import hec.map.GlyphDataRecord;
import hec.map.JLayerSelection;
import hec.map.JLayerSelectionParent;
import hec.map.LayerSelectionAction;
import hec.map.MapGlyph;
import hec.map.MapPanel;
import hec.map.aishape.AiShapeFieldDescriptor;
import hec.map.aishape.AiShapeGlyph;
import hec.map.aishape.AiShapeGlyphDataRecord;
import hec.map.aishape.AiShapeMap;
import hec.map.aishape.AiShapeObject;
import hec.map.aishape.Attribute;
import hec.map.aishape.Field;
import hec.map.aishape.ShapeDrawingAttribute;
import hec.map.aishape.ShapeQueryDialog;
import hec.map.aishape.ui.AiShapeLinePropertiesDialog;
import hec.map.aishape.ui.AiShapePointPropertiesDialog;
import hec.map.aishape.ui.AiShapePolygonPropertiesDialog;
import java.awt.Color;
import java.awt.Component;
import java.awt.Frame;
import java.awt.Image;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.image.MemoryImageSource;
import java.util.AbstractList;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Vector;
import javax.swing.AbstractAction;
import javax.swing.DefaultListCellRenderer;
import javax.swing.ImageIcon;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JList;
import javax.swing.JPopupMenu;
import javax.swing.UIManager;
import rma.swing.RmaJList;
import rma.swing.list.RmaListModel;
import rma.util.Compare;
import rma.util.NaturalOrderComparator;
import rma.util.RMASort;

public class AiShapeLayerSelection
extends JLayerSelection {
    JDialog _optionsDialog = null;
    RmaJList _list;
    private Map _color2ImageMap = new HashMap();
    private Map _imageToImageIconMap = new HashMap();

    public AiShapeLayerSelection(JLayerSelectionParent parent, JFrame parentFrame, MapPanel mapPanel, MapGlyph glyph) {
        super(parent, parentFrame, mapPanel, glyph);
        this._list = new RmaJList();
        this._list.setCellRenderer(new AiShapeListCellRenderer());
        this.fillList();
        this._extraPanel.add((Component)this._list, "West");
        this._extraPanel.revalidate();
        this.addOptionsPopupMenu();
        this.refresh();
    }

    @Override
    protected void addActionsToPopup(JPopupMenu popupMenu) {
        super.addActionsToPopup(this._popupMenu);
        AttributesAction aa = new AttributesAction();
        aa.setJLayerSelection(this);
        popupMenu.add(aa);
    }

    @Override
    protected boolean allowScaleAdjustment() {
        return true;
    }

    @Override
    public void refresh() {
        super.refresh();
        this.fillList();
    }

    private void fillList() {
        if (this._list != null) {
            Object fieldType = null;
            AiShapeGlyph aiGlyph = (AiShapeGlyph)this._glyph;
            AiShapeGlyphDataRecord data = (AiShapeGlyphDataRecord)this.getDataRecord();
            Vector fieldDescriptors = aiGlyph.getFieldDescriptors();
            RmaListModel<Object> model = new RmaListModel<Object>(false);
            if (data.drawUsingDefaultColor()) {
                Image img = this.makeImage(data.getDefaultColor());
                ColorImageIcon imgicon = this.getColorImageIcon(img);
                model.addElement("Default Color");
                model.addElement(imgicon);
            } else {
                int fieldIdx = data.getFieldIndex();
                if (fieldIdx < fieldDescriptors.size()) {
                    AiShapeFieldDescriptor fld = (AiShapeFieldDescriptor)fieldDescriptors.elementAt(fieldIdx);
                    model.addElement(fld._value);
                }
                AbstractList attributeList = aiGlyph.getAttributeVector();
                HashSet<Field> fields = new HashSet<Field>();
                ArrayList<Object> fieldValues = new ArrayList<Object>(attributeList.size());
                ArrayList<Attribute> tempAttributeList = new ArrayList<Attribute>(attributeList.size());
                for (int i = 0; i < attributeList.size(); ++i) {
                    Attribute attrib = (Attribute)attributeList.get(i);
                    Field f = attrib.getField(fieldIdx);
                    if (f == null) continue;
                    fieldValues.add(f.getValue());
                    tempAttributeList.add(attrib);
                }
                NaturalOrderComparator comparitor = new NaturalOrderComparator();
                RMASort.mergeSort((Compare)comparitor, fieldValues, tempAttributeList);
                attributeList = tempAttributeList;
                for (int i = 0; i < attributeList.size(); ++i) {
                    Field field;
                    Attribute attrib = (Attribute)attributeList.get(i);
                    if (attrib == null || fields.contains(field = attrib.getField(fieldIdx))) continue;
                    ShapeDrawingAttribute attr = data.getDrawingAttribute(field);
                    Color c2 = attr.getColor();
                    Image img = this.makeImage(c2);
                    ColorImageIcon imgicon = new ColorImageIcon(img, field);
                    model.addElement(imgicon);
                    fields.add(field);
                }
            }
            this._list.setModel(model);
            this._color2ImageMap.clear();
            this._imageToImageIconMap.clear();
        }
    }

    @Override
    public boolean hasOptionDialog() {
        return true;
    }

    @Override
    public void showOptionDialog() {
        if (!(this._glyph instanceof AiShapeGlyph)) {
            return;
        }
        AiShapeGlyph glyph = (AiShapeGlyph)this._glyph;
        AiShapeGlyphDataRecord data = (AiShapeGlyphDataRecord)this._copyOfData;
        if (Logger.canDebug("maps")) {
            // empty if block
        }
        if (glyph.getMapType() == 1) {
            AiShapePointPropertiesDialog dlg = new AiShapePointPropertiesDialog((Frame)this._parentFrame, false, "Edit Point Properties");
            this._optionsDialog = dlg;
            dlg.setData(data, (AiShapeMap)this._glyph.getMap());
            dlg.setLayerSelection(this);
            dlg.setSize(300, 450);
            dlg.setLocationRelativeTo(this._parentFrame);
            dlg.setVisible(true);
        } else if (glyph.getMapType() == 3 || glyph.getMapType() == 13) {
            AiShapeLinePropertiesDialog dlg = new AiShapeLinePropertiesDialog((Frame)this._parentFrame, false, "Edit Line Properties");
            this._optionsDialog = dlg;
            dlg.setData(data, (AiShapeMap)this._glyph.getMap());
            dlg.setLayerSelection(this);
            dlg.setSize(300, 450);
            dlg.setLocationRelativeTo(this._parentFrame);
            dlg.setVisible(true);
        } else {
            AiShapePolygonPropertiesDialog dlg = new AiShapePolygonPropertiesDialog((Frame)this._parentFrame, false, "Edit Polygon Properties");
            this._optionsDialog = dlg;
            dlg.setData(data, (AiShapeMap)this._glyph.getMap());
            dlg.setLayerSelection(this);
            dlg.setSize(300, 600);
            dlg.setLocationRelativeTo(this._parentFrame);
            dlg.setVisible(true);
        }
        this.refresh();
    }

    @Override
    public void setDataRecord(GlyphDataRecord data) {
        super.setDataRecord(data);
        this.fillList();
        this._parent.nodeChanged(this);
    }

    @Override
    public void closeOptionDialog() {
        if (this._optionsDialog != null) {
            this._optionsDialog.setVisible(false);
        }
    }

    Image makeImage(Color clr) {
        int i;
        Image img = (Image)this._color2ImageMap.get(clr);
        if (img != null) {
            return img;
        }
        int w = 14;
        int h = 14;
        int myClr = clr.getRGB();
        int[] pix = new int[w * h];
        for (int i2 = 0; i2 < pix.length; ++i2) {
            pix[i2] = myClr;
        }
        int lastrow = pix.length - w;
        int blk = Color.black.getRGB();
        for (i = 0; i < w; ++i) {
            pix[i] = blk;
            pix[i + lastrow] = blk;
        }
        for (i = 0; i < pix.length - w; i += w) {
            pix[i] = blk;
            pix[i + w - 1] = blk;
        }
        MemoryImageSource mis = new MemoryImageSource(w, h, pix, 0, w);
        img = Toolkit.getDefaultToolkit().createImage(mis);
        this._color2ImageMap.put(clr, img);
        return img;
    }

    protected ColorImageIcon getColorImageIcon(Image img) {
        ColorImageIcon cii = (ColorImageIcon)this._imageToImageIconMap.get(img);
        if (cii == null) {
            cii = new ColorImageIcon(img);
            this._imageToImageIconMap.put(img, cii);
        }
        return cii;
    }

    public class AiShapeListCellRenderer
    extends DefaultListCellRenderer {
        @Override
        public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
            this.setComponentOrientation(list.getComponentOrientation());
            if (value instanceof ColorImageIcon) {
                ColorImageIcon cii = (ColorImageIcon)value;
                this.setIcon(cii);
                this.setText(cii.toString());
                if (isSelected) {
                    this.setBackground(list.getSelectionBackground());
                    this.setForeground(list.getSelectionForeground());
                } else {
                    this.setBackground(list.getBackground());
                    this.setForeground(list.getForeground());
                }
                this.setEnabled(list.isEnabled());
                this.setFont(list.getFont());
                this.setBorder(cellHasFocus ? UIManager.getBorder("List.focusCellHighlightBorder") : noFocusBorder);
                return this;
            }
            return super.getListCellRendererComponent((JList<?>)list, value, index, isSelected, cellHasFocus);
        }
    }

    public class AttributesAction
    extends AbstractAction
    implements LayerSelectionAction {
        private JLayerSelection _selection;
        private ShapeQueryDialog _dialog;

        public AttributesAction() {
            super("Attributes Table...");
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            if (this._dialog == null) {
                this._dialog = new ShapeQueryDialog((Frame)AiShapeLayerSelection.this._parentFrame, false);
                this._dialog.setLocationRelativeTo(AiShapeLayerSelection.this._parentFrame);
            }
            AiShapeGlyph glyph = (AiShapeGlyph)this._selection.getGlyph();
            AiShapeMap map = (AiShapeMap)glyph.getMap();
            List<AiShapeObject> shapes = map.getShapes();
            this._dialog.setGlyphs(new AiShapeGlyph[]{glyph});
            this._dialog.addShapes(glyph, shapes);
            if (!this._dialog.isVisible()) {
                this._dialog.setVisible(true);
            }
        }

        @Override
        public void setJLayerSelection(JLayerSelection selection) {
            this._selection = selection;
        }

        @Override
        public LayerSelectionAction clone() {
            try {
                return (LayerSelectionAction)super.clone();
            }
            catch (CloneNotSupportedException cne) {
                return new AttributesAction();
            }
        }
    }

    public class ColorImageIcon
    extends ImageIcon {
        Object value;

        public ColorImageIcon(Image img, Object o) {
            super(img);
            this.value = o;
        }

        public ColorImageIcon(Image img) {
            super(img);
            this.value = "";
        }

        @Override
        public String toString() {
            return this.value.toString();
        }
    }
}

