/*
 * Decompiled with CFR 0.152.
 */
package hec.map.aishape;

import hec.io.EndianInputStream;
import hec.io.EndianOutputStream;
import hec.io.HecFile;
import hec.io.Identifier;
import hec.map.MapIdentifier;
import hec.map.MapObject;
import hec.map.MapObjectInterface;
import hec.map.WorldPt;
import hec.map.WorldRect;
import hec.map.aishape.AiShapeArc;
import hec.map.aishape.AiShapeConst;
import hec.map.aishape.AiShapeFieldDescriptor;
import hec.map.aishape.AiShapeIndex;
import hec.map.aishape.AiShapeMultiPoint;
import hec.map.aishape.AiShapeObject;
import hec.map.aishape.AiShapePoint;
import hec.map.aishape.AiShapePointM;
import hec.map.aishape.AiShapePointZ;
import hec.map.aishape.AiShapePolygon;
import hec.map.aishape.AiShapePolygonM;
import hec.map.aishape.AiShapePolygonZ;
import hec.map.aishape.AiShapePolylineM;
import hec.map.aishape.AiShapePolylineZ;
import hec.map.aishape.Attribute;
import hec.map.crs.CoordinateReferenceSystem;
import hec.map.importer.ShapeSource;
import hec.map.transform.CoordinateInfo;
import java.io.BufferedWriter;
import java.io.IOException;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.List;
import java.util.Vector;

public class AiShapeMap
extends MapObject
implements Serializable,
MapObjectInterface,
AiShapeConst,
ShapeSource {
    double[] _bounds = new double[4];
    int _version;
    int _shapeType;
    int _shpFileLength;
    int _shxFileLength;
    Vector<AiShapeObject> _shapeObjectList = new Vector();
    Vector<AiShapeIndex> _indexList = new Vector();
    Vector<Attribute> _attributeList = new Vector();
    Vector<AiShapeFieldDescriptor> _fieldDescriptors = new Vector();
    @Deprecated
    private CoordinateInfo _coordInfo = null;

    public AiShapeMap(String path) {
        super(path);
        this.init();
    }

    public AiShapeMap(MapIdentifier id) {
        super(id);
        this.init();
    }

    public AiShapeMap() {
        this.init();
    }

    public int getType() {
        return this._shapeType;
    }

    public void init() {
        for (int i = 0; i < 4; ++i) {
            this._bounds[i] = -3.4028234663852886E38;
        }
        this._shapeType = 0;
        this._shapeObjectList.clear();
        this._indexList.clear();
        this._attributeList.clear();
        this._fieldDescriptors.clear();
        this._loaded = false;
    }

    @Override
    public List<AiShapeObject> getShapes() {
        return this._shapeObjectList;
    }

    public Vector<Attribute> getAttributes() {
        return this._attributeList;
    }

    @Override
    public Vector<AiShapeFieldDescriptor> getFieldDescriptors() {
        return this._fieldDescriptors;
    }

    public List getShapeObjects(double containmentBuffer, WorldPt pt) {
        ArrayList<AiShapeObject> list = new ArrayList<AiShapeObject>();
        for (int ii = 0; ii < this._shapeObjectList.size(); ++ii) {
            AiShapeObject shape = this._shapeObjectList.get(ii);
            if (!shape.contains(containmentBuffer, pt)) continue;
            list.add(shape);
        }
        return list;
    }

    public void writeData(int type, List fieldDescriptors, List shapes, List attributes) {
        this.init();
        this._version = 1000;
        this._shapeType = type;
        this._shapeObjectList.addAll(shapes);
        this._attributeList.addAll(attributes);
        this._fieldDescriptors.addAll(fieldDescriptors);
        int offset = 50;
        for (int ii = 0; ii < this._shapeObjectList.size(); ++ii) {
            AiShapeObject shape = this._shapeObjectList.get(ii);
            this._extent.grow(shape.getExtent());
            AiShapeIndex index = new AiShapeIndex();
            index.offset = offset;
            index.contentLength = shape.contentByteLength() / 2;
            offset += shape.recordByteLength() / 2;
            this._indexList.add(index);
        }
        this._shpFileLength = this.calculateShpFileLength() / 2;
        this._shxFileLength = this.calculateShxFileLength() / 2;
        this.writeFile(this.getMapIdentifier());
        this._loaded = true;
    }

    public int calculateShpFileLength() {
        int len = 100;
        for (int ii = 0; ii < this._shapeObjectList.size(); ++ii) {
            AiShapeObject shape = this._shapeObjectList.get(ii);
            len += shape.recordByteLength();
        }
        return len;
    }

    public int calculateShxFileLength() {
        int len = 100 + 8 * this._indexList.size();
        return len;
    }

    @Override
    public void load() throws IOException {
        if (!this._loaded) {
            HecFile file = this._mapId.getFile();
            if (file == null) {
                Identifier id = this.openFile(this._mapId);
                if (id == null) {
                    System.out.println("load:failed to open file " + this._mapId);
                    return;
                }
                file = id.getFile();
                this._mapId.setFile(file);
            }
            this._loaded = this.readFile(this._mapId);
        }
    }

    @Override
    public void unload() {
        this.init();
    }

    public boolean writeFile(Identifier shpId) {
        long t1 = System.currentTimeMillis();
        String basePath = shpId.getPath();
        if (basePath.lastIndexOf(".") > 0) {
            basePath = basePath.substring(0, basePath.lastIndexOf("."));
        }
        String shxPath = basePath + ".shx";
        String dbfPath = basePath + ".dbf";
        String prjPath = basePath + ".prj";
        Identifier prjId = this.newThenOpenFile(new Identifier(prjPath));
        if (prjId == null) {
            return false;
        }
        if (!this.writePrj(prjId)) {
            return false;
        }
        Identifier dbfId = this.newThenOpenFile(new Identifier(dbfPath));
        if (dbfId == null) {
            return false;
        }
        if (!this.writeDbf(dbfId)) {
            return false;
        }
        Identifier shxId = this.newThenOpenFile(new Identifier(shxPath));
        if (shxId == null) {
            return false;
        }
        if (!this.writeShx(shxId)) {
            return false;
        }
        Identifier tempShpId = shpId;
        if (tempShpId.getFile() == null) {
            tempShpId = this.newThenOpenFile(tempShpId);
        }
        if (!this.writeShp(tempShpId)) {
            return false;
        }
        long t2 = System.currentTimeMillis();
        return true;
    }

    private boolean writeDbf(Identifier dbfId) {
        HecFile file = dbfId.getFile();
        try {
            int ii;
            EndianOutputStream output = file.getEndianOutputStream();
            output.writeByte(3);
            Calendar c2 = Calendar.getInstance();
            byte year = (byte)(c2.get(1) - 1900);
            byte month = (byte)(c2.get(2) + 1);
            byte day = (byte)c2.get(5);
            output.writeByte(year);
            output.writeByte(month);
            output.writeByte(day);
            int numRecs = this._attributeList.size();
            output.writeInt(200, numRecs);
            short headerLength = (short)(33 + this._fieldDescriptors.size() * 32);
            output.writeShort(200, headerLength);
            short recordLength = 1;
            for (ii = 0; ii < this._fieldDescriptors.size(); ++ii) {
                AiShapeFieldDescriptor fieldDescriptor = this._fieldDescriptors.get(ii);
                recordLength = (short)(recordLength + fieldDescriptor.getLength());
            }
            output.writeShort(200, recordLength);
            for (ii = 0; ii < 20; ++ii) {
                output.writeByte(0);
            }
            byte[] fieldBytes = new byte[32];
            for (int i = 0; i < this._fieldDescriptors.size(); ++i) {
                AiShapeFieldDescriptor attDescr = this._fieldDescriptors.get(i);
                attDescr.writeBytes(fieldBytes);
                output.write(fieldBytes);
            }
            output.writeByte(13);
            byte[] recordBytes = new byte[recordLength];
            for (int i = 0; i < this._attributeList.size(); ++i) {
                Attribute attrib = this._attributeList.get(i);
                attrib.writeBytes(this._fieldDescriptors, recordBytes);
                output.write(recordBytes);
            }
            byte[] terminator = new byte[]{26};
            output.write(terminator);
            output.close();
        }
        catch (Exception e) {
            System.out.println("Error writing " + file.getPath());
            System.out.println(e.toString());
            e.printStackTrace();
            return false;
        }
        return true;
    }

    private boolean writeShx(Identifier shxId) {
        HecFile file = shxId.getFile();
        try {
            EndianOutputStream output = file.getEndianOutputStream();
            this.writeFileHeader(output, this._shxFileLength);
            for (int i = 0; i < this._indexList.size(); ++i) {
                AiShapeIndex shapeIndex = this._indexList.get(i);
                output.writeInt(100, shapeIndex.offset);
                output.writeInt(100, shapeIndex.contentLength);
            }
            output.close();
        }
        catch (Exception e) {
            System.out.println("Error writing " + file.getPath());
            System.out.println(e.toString());
            return false;
        }
        return true;
    }

    private void writeFileHeader(EndianOutputStream output, int fileLength) throws IOException {
        output.writeInt(100, 9994);
        output.writeInt(100, 0);
        output.writeInt(100, 0);
        output.writeInt(100, 0);
        output.writeInt(100, 0);
        output.writeInt(100, 0);
        output.writeInt(100, fileLength);
        output.writeInt(200, 1000);
        output.writeInt(200, this._shapeType);
        WorldRect extent = this.getExtent();
        output.writeDouble(200, extent.w);
        output.writeDouble(200, extent.s);
        output.writeDouble(200, extent.e);
        output.writeDouble(200, extent.n);
        output.writeDouble(200, 0.0);
        output.writeDouble(200, 0.0);
        output.writeDouble(200, 0.0);
        output.writeDouble(200, 0.0);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean writePrj(Identifier prjId) {
        HecFile file = prjId.getFile();
        CoordinateReferenceSystem crs = this.getCoordinateReferenceSystem();
        if (crs == null) {
            return true;
        }
        String wkt = crs.toWKT();
        wkt = wkt.replace("\r\n", "");
        BufferedWriter writer = file.getBufferedWriter();
        if (writer == null) {
            System.out.println("writePrj:failed to get Writer for " + file.getPath());
            return false;
        }
        try {
            writer.write(wkt);
            writer.newLine();
            boolean bl = true;
            return bl;
        }
        catch (IOException e) {
            System.out.println("writePrj:error writing " + file.getPath() + " Error:" + e);
        }
        finally {
            try {
                writer.close();
            }
            catch (IOException iOException) {}
        }
        return false;
    }

    private boolean writeShp(Identifier shpId) {
        HecFile file = shpId.getFile();
        try {
            EndianOutputStream output = file.getEndianOutputStream();
            this.writeFileHeader(output, this._shpFileLength);
            for (int i = 0; i < this._shapeObjectList.size(); ++i) {
                AiShapeObject shapeObj = this._shapeObjectList.get(i);
                shapeObj.writeRecord(output);
            }
            output.close();
        }
        catch (Exception e) {
            System.out.println("Error writing " + file.getPath());
            System.out.println(e.toString());
            return false;
        }
        return true;
    }

    @Override
    public boolean readProjection(Identifier prjId) {
        boolean b = super.readProjection(prjId);
        return b;
    }

    public boolean readFile(MapIdentifier shpId) {
        Identifier dbfId;
        long t1 = System.currentTimeMillis();
        this.init();
        String basePath = shpId.getPath();
        if (basePath.lastIndexOf(".") > 0) {
            basePath = basePath.substring(0, basePath.lastIndexOf("."));
        }
        String shxPath = basePath + ".shx";
        String dbfPath = basePath + ".dbf";
        String prjPath = basePath + ".prj";
        Identifier prjId = this.openFile(new Identifier(prjPath));
        if (prjId != null) {
            this.readProjection(prjId);
        }
        if ((dbfId = this.openFile(new Identifier(dbfPath))) == null || dbfId.getFile() == null) {
            System.out.println("readFile:WARNING failed to open map file " + dbfPath);
            return false;
        }
        if (!this.readDbf(dbfId)) {
            return false;
        }
        Identifier shxId = this.openFile(new Identifier(shxPath));
        if (shxId == null) {
            return false;
        }
        if (!this.readShx(shxId)) {
            return false;
        }
        if (!this.readShp(shpId)) {
            return false;
        }
        long t2 = System.currentTimeMillis();
        return true;
    }

    private boolean readShx(Identifier shxId) {
        HecFile file = shxId.getFile();
        try {
            EndianInputStream input = file.getEndianInputStream();
            input.readInt(100);
            input.skipBytes(20);
            this._shxFileLength = input.readInt(100);
            input.readInt(200);
            this._shapeType = input.readInt(200);
            this._bounds[0] = input.readDouble(200);
            this._bounds[1] = input.readDouble(200);
            this._bounds[2] = input.readDouble(200);
            this._bounds[3] = input.readDouble(200);
            this.setExtent(new WorldRect(this._bounds[0], this._bounds[3], this._bounds[2], this._bounds[1]));
            input.skipBytes(32);
            int numElements = 2 * (this._shxFileLength - 50) / 8;
            for (int i = 0; i < numElements; ++i) {
                AiShapeIndex shapeIndex = new AiShapeIndex();
                shapeIndex.offset = input.readInt(100);
                shapeIndex.contentLength = input.readInt(100);
                this._indexList.add(shapeIndex);
            }
            input.close();
        }
        catch (Exception e) {
            System.out.println("readShx:Error reading " + file.getPath());
            System.out.println(e.toString());
            System.out.println("Number of Elements read =" + new Integer(this._indexList.size()).toString());
            return false;
        }
        return true;
    }

    private boolean readShp(Identifier shpId) {
        HecFile file = shpId.getFile();
        try {
            EndianInputStream input = file.getEndianInputStream();
            input.readInt(100);
            input.skipBytes(20);
            this._shpFileLength = input.readInt(100);
            this._version = input.readInt(200);
            this._shapeType = input.readInt(200);
            input.skipBytes(64);
            int numElements = this._indexList.size();
            int offset = 100;
            for (int i = 0; i < numElements; ++i) {
                AiShapeIndex shapeIndex = this._indexList.elementAt(i);
                int skipAmt = shapeIndex.offset * 2 - offset;
                if (skipAmt > 0) {
                    System.out.println("readShp:at offset " + offset + " shape object starts at " + shapeIndex.offset * 2 + " for shape index " + i);
                    System.out.println("readShp:skipping " + skipAmt);
                    input.skipBytes(skipAmt);
                    offset += skipAmt;
                }
                AiShapeObject shapeObj = null;
                if (this._shapeType == 5) {
                    shapeObj = new AiShapePolygon();
                } else if (this._shapeType == 3) {
                    shapeObj = new AiShapeArc();
                } else if (this._shapeType == 13) {
                    shapeObj = new AiShapePolylineZ();
                } else if (this._shapeType == 23) {
                    shapeObj = new AiShapePolylineM();
                } else if (this._shapeType == 8) {
                    shapeObj = new AiShapeMultiPoint();
                } else if (this._shapeType == 1) {
                    shapeObj = new AiShapePoint();
                } else if (this._shapeType == 11) {
                    shapeObj = new AiShapePointZ();
                } else if (this._shapeType == 21) {
                    shapeObj = new AiShapePointM();
                } else if (this._shapeType == 15) {
                    shapeObj = new AiShapePolygonZ();
                } else if (this._shapeType == 25) {
                    shapeObj = new AiShapePolygonM();
                } else {
                    System.out.println("WARNING: Invalid Shape Type in Shapefile, ID: " + this._shapeType + " for shape file " + file.getPath());
                    continue;
                }
                int rv = shapeObj.readRecord(input);
                if (rv < 0) {
                    if (rv != -99) {
                        System.out.println("Error reading Shapefile: " + file.getPath() + " object #" + this._attributeList.get(i));
                        offset += shapeObj.getBytesRead() + 8;
                        continue;
                    }
                    offset += shapeIndex.contentLength * 2 + 8;
                    continue;
                }
                offset += shapeObj.getBytesRead() + 8;
                shapeObj.setAttribute(this._attributeList.get(i));
                this._shapeObjectList.add(shapeObj);
            }
            input.close();
        }
        catch (Exception e) {
            System.out.println("readShp:Error reading " + file.getPath());
            System.out.println(e.toString());
            System.out.println("Number of Elements read =" + new Integer(this._shapeObjectList.size()).toString());
            return false;
        }
        return true;
    }

    private boolean readDbf(Identifier dbfId) {
        HecFile file = dbfId.getFile();
        try {
            int i;
            EndianInputStream input = file.getEndianInputStream();
            byte db3table = input.readByte();
            if (db3table != 3) {
                System.out.println("Error reading " + file.getPath());
                System.out.println("Expect DbaseIII file type");
                return false;
            }
            input.readByte();
            input.readByte();
            input.readByte();
            int numRecs = input.readInt(200);
            short nbytesH = input.readShort(200);
            short nbytesR = input.readShort(200);
            input.skipBytes(20);
            int fieldLen = nbytesH - 32 - 1;
            int nFieldDescr = fieldLen / 32;
            byte[] field = new byte[32];
            for (i = 0; i < nFieldDescr; ++i) {
                input.read(field, 0, 32);
                AiShapeFieldDescriptor attDescr = new AiShapeFieldDescriptor(field);
                this._fieldDescriptors.add(attDescr);
            }
            byte ibyte = input.readByte();
            if (ibyte != 13) {
                System.out.println("Error reading " + file.getPath());
                System.out.println("Did not find field descriptor terminator");
                return false;
            }
            byte[] attribRec = new byte[nbytesR];
            for (i = 0; i < numRecs; ++i) {
                input.read(attribRec, 0, nbytesR);
                Attribute attrib = new Attribute(i, this._fieldDescriptors, attribRec);
                this._attributeList.add(attrib);
            }
            input.close();
        }
        catch (Exception e) {
            System.out.println("Error reading " + file.getPath());
            System.out.println(e.toString());
            System.out.println("Number of Attributes read =" + new Integer(this._attributeList.size()).toString());
            return false;
        }
        return true;
    }

    @Override
    public List getFilenames() {
        ArrayList<Object> l = new ArrayList<Object>(3);
        String basePath = this._mapId.getPath();
        l.add(basePath);
        if (basePath.lastIndexOf(".") > 0) {
            basePath = basePath.substring(0, basePath.lastIndexOf("."));
        }
        String shxPath = basePath + ".shx";
        String dbfPath = basePath + ".dbf";
        String prjPath = basePath + ".prj";
        String hdrPath = basePath + ".hdr";
        Identifier openPrjId = this.openFile(new Identifier(prjPath));
        Identifier openHdrId = this.openFile(new Identifier(hdrPath));
        l.add(shxPath);
        l.add(dbfPath);
        if (openPrjId != null) {
            l.add(prjPath);
        }
        if (openHdrId != null) {
            l.add(hdrPath);
        }
        return l;
    }

    @Override
    public void highlightRecords(List shapes, int centerPointGraphic) {
    }

    @Override
    public void clearHighlights() {
    }

    @Override
    public CoordinateReferenceSystem getCoordinateReferenceSystem() {
        return super.getCoordinateReferenceSystem();
    }

    @Override
    @Deprecated
    public CoordinateInfo getCoordinateInfo() {
        return this._coordInfo;
    }

    public void setCoordinateReferenceSystem(CoordinateReferenceSystem crs) {
        this.mCoordinateReferencySystem = crs;
    }
}

