/*
 * Decompiled with CFR 0.152.
 */
package hec.map.aishape;

import hec.io.EndianInputStream;
import hec.io.EndianOutputStream;
import hec.map.WorldLine;
import hec.map.WorldPt;
import hec.map.aishape.AiShapeObject;
import java.util.Vector;

public class AiShapeMultiPoint
extends AiShapeObject {
    int _numPoints;
    WorldPt _referencePt;
    WorldLine _worldLine = new WorldLine();

    public AiShapeMultiPoint() {
        super(8);
    }

    @Override
    public int contentByteLength() {
        throw new UnsupportedOperationException("AiShapeMultiPoint.bodyByteLength() is not implemented.");
    }

    @Override
    public void writeRecord(EndianOutputStream output) {
        throw new UnsupportedOperationException("AiShapeMultiPoint.writeRecord() is not implemented.");
    }

    @Override
    public int readRecord(EndianInputStream input) {
        try {
            int recnum = this.readRecordHeader(input);
            if (recnum > 64000) {
                return -1;
            }
            if (recnum < 0) {
                return recnum;
            }
            this.readBoundingBox(input);
            this._numPoints = input.readInt(200);
            this._contentRead += 2;
            if (this._numPoints > 32000 || this._numPoints < -1) {
                return -1;
            }
            Vector pts = this._worldLine.pts;
            pts.setSize(this._numPoints);
            for (int i = 0; i < this._numPoints; ++i) {
                double x = input.readDouble(200);
                this._contentRead += 4;
                double y = input.readDouble(200);
                this._contentRead += 4;
                WorldPt pt = new WorldPt(x, y);
                pts.setElementAt(pt, i);
            }
        }
        catch (Exception e) {
            System.out.println("AiShapeMultiPoint.readRecord:Exception " + e.toString());
            return -1;
        }
        return 0;
    }

    public WorldPt getReferencePt() {
        if (this._referencePt == null) {
            double xc = (this._extents.e + this._extents.w) / 2.0;
            double yc = (this._extents.n + this._extents.s) / 2.0;
            this._referencePt = new WorldPt(xc, yc);
        }
        return this._referencePt;
    }

    @Override
    public boolean contains(double tolerance, WorldPt pt) {
        if (super.contains(tolerance, pt)) {
            Vector pts = this.getPoints();
            for (int ii = 0; ii < pts.size(); ++ii) {
                WorldPt multiPt = (WorldPt)pts.get(ii);
                if (!(multiPt.distToPoint(pt) <= tolerance)) continue;
                return true;
            }
        }
        return false;
    }

    public Vector getPoints() {
        return this._worldLine.pts;
    }

    public WorldLine getWorldLine() {
        return this._worldLine;
    }
}

