/*
 * Decompiled with CFR 0.152.
 */
package hec.map.aishape;

import hec.io.EndianInputStream;
import hec.io.EndianOutputStream;
import hec.map.WorldPt;
import hec.map.WorldRect;
import hec.map.aishape.AiShapeConst;
import hec.map.aishape.Attribute;
import hec.map.aishape.Field;
import java.io.IOException;
import java.io.Serializable;

public abstract class AiShapeObject
implements Serializable,
AiShapeConst {
    protected int _contentLength;
    protected int _type;
    protected int _index;
    Attribute _attribute;
    WorldRect _extents = new WorldRect();
    protected int _contentRead;

    public AiShapeObject(int type, int index) {
        this._type = type;
        this._index = index;
    }

    public AiShapeObject(int type) {
        this._type = type;
    }

    public int readRecord(EndianInputStream input) {
        return -1;
    }

    public abstract void writeRecord(EndianOutputStream var1) throws IOException;

    public boolean contains(double tolerance, WorldPt pt) {
        return this._extents != null && this._extents.isValid() && this._extents.contains(tolerance, pt);
    }

    public WorldRect getExtent() {
        return this._extents;
    }

    public void setAttribute(Attribute attrib) {
        this._attribute = attrib;
    }

    public Attribute getAttribute() {
        return this._attribute;
    }

    public int recordByteLength() {
        return 8 + this.contentByteLength();
    }

    public abstract int contentByteLength();

    public void writeRecordHeader(EndianOutputStream output) throws IOException {
        output.writeInt(100, this._index);
        int contentWordLength = this.contentByteLength() / 2;
        output.writeInt(100, contentWordLength);
        output.writeInt(200, this._type);
    }

    public int readRecordHeader(EndianInputStream input) {
        try {
            this._index = input.readInt(100);
            this._contentLength = input.readInt(100);
            int stype = input.readInt(200);
            this._contentRead += 2;
            if (stype == 0) {
                if (this._contentRead < this._contentLength) {
                    int skipAmt = this._contentLength * 2 - this._contentRead * 2;
                    input.skipBytes(skipAmt);
                    this._contentRead += skipAmt;
                }
                return -99;
            }
            if (stype != this._type) {
                System.out.println("Shapefile record type does not match Object type. index=" + this._index);
                System.out.println("_type =" + new Integer(this._type).toString());
                System.out.println("stype =" + new Integer(stype).toString());
                return -1;
            }
        }
        catch (Exception e) {
            System.out.println(e.toString());
            return -1;
        }
        return this._index;
    }

    public void writeBoundingBox(EndianOutputStream output) throws IOException {
        output.writeDouble(200, this._extents.w);
        output.writeDouble(200, this._extents.s);
        output.writeDouble(200, this._extents.e);
        output.writeDouble(200, this._extents.n);
    }

    public int readBoundingBox(EndianInputStream input) {
        try {
            this._extents.w = input.readDouble(200);
            this._extents.s = input.readDouble(200);
            this._extents.e = input.readDouble(200);
            this._extents.n = input.readDouble(200);
            this._contentRead += 16;
        }
        catch (Exception e) {
            System.out.println(e.toString());
            return -1;
        }
        return this._index;
    }

    public int getIndex() {
        return this._index;
    }

    public Field[] getFields() {
        if (this._attribute == null) {
            return null;
        }
        Field[] fields = this._attribute.getFields();
        return fields;
    }

    public void printFields() {
        if (this._attribute == null) {
            return;
        }
        Field[] fields = this._attribute.getFields();
        if (fields == null) {
            return;
        }
        System.out.print(fields[0]);
        for (int ii = 1; ii < fields.length; ++ii) {
            System.out.print(", " + fields[ii]);
        }
        System.out.print("\n");
    }

    public int getBytesRead() {
        return this._contentRead * 2;
    }
}

