/*
 * Decompiled with CFR 0.152.
 */
package hec.map.aishape;

import hec.map.aishape.AiShapeIndex;
import hec.map.aishape.AiShapeMap;
import hec.map.aishape.AiShapeObject;
import java.awt.Component;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.event.ActionEvent;
import java.util.List;
import java.util.Vector;
import rma.swing.ButtonCmdPanel;
import rma.swing.ButtonCmdPanelListener;
import rma.swing.RmaInsets;
import rma.swing.RmaJDialog;
import rma.swing.RmaJTable;

public class AiShapeObjectDialog
extends RmaJDialog {
    private AiShapeMap _map;
    private RmaJTable _objTable;
    private ButtonCmdPanel _cmdPanel;

    public AiShapeObjectDialog(Frame parent, AiShapeMap map) {
        super(parent, false);
        this._map = map;
        this.buildControls();
        this.fillForm();
        this.pack();
        this.setLocationRelativeTo(parent);
        this.setVisible(true);
    }

    private void buildControls() {
        this.getContentPane().setLayout(new GridBagLayout());
        Object[] headers = new String[]{"File Index", "Obj Index", "Offset", "Size"};
        this._objTable = new RmaJTable((Component)this, headers);
        GridBagConstraints gbc = new GridBagConstraints();
        gbc.gridx = 0;
        gbc.gridy = 0;
        gbc.weightx = 1.0;
        gbc.weighty = 1.0;
        gbc.anchor = 18;
        gbc.fill = 1;
        gbc.insets = RmaInsets.INSETS5505;
        this.getContentPane().add((Component)this._objTable.getScrollPane(), gbc);
        this._cmdPanel = new ButtonCmdPanel(256);
        gbc.gridx = 0;
        gbc.gridy = 1;
        gbc.weightx = 1.0;
        gbc.weighty = 0.0;
        gbc.anchor = 16;
        gbc.fill = 2;
        gbc.insets = RmaInsets.INSETS5505;
        this.getContentPane().add((Component)this._cmdPanel, gbc);
        this.addListeners();
    }

    private void addListeners() {
        this._cmdPanel.addCmdPanelListener(new ButtonCmdPanelListener(){

            @Override
            public void buttonCmdActionPerformed(ActionEvent e) {
                switch (e.getID()) {
                    case 256: {
                        AiShapeObjectDialog.this.setVisible(false);
                    }
                }
            }
        });
    }

    private void fillForm() {
        AiShapeIndex index;
        Vector<Object> row;
        int i;
        this._objTable.deleteCells();
        List<AiShapeObject> shapes = this._map.getShapes();
        Vector<AiShapeIndex> indexList = this._map._indexList;
        for (i = 0; i < shapes.size(); ++i) {
            row = new Vector<Object>();
            row.add(i + 1);
            AiShapeObject obj = this.findShape(shapes, i);
            if (obj != null) {
                row.add(obj.getIndex());
            } else {
                row.add("");
            }
            index = indexList.get(i);
            row.add(index.offset + " (" + index.offset * 2 + ")");
            row.add(index.contentLength + " (" + index.contentLength * 2 + ")");
            this._objTable.appendRow(row);
        }
        if (i < indexList.size()) {
            while (i < indexList.size()) {
                row = new Vector();
                row.add(i + 1);
                row.add("<n/a>");
                index = indexList.get(i);
                row.add(index.offset + " (" + index.offset * 2 + ")");
                row.add(index.contentLength + " (" + index.contentLength * 2 + ")");
                this._objTable.appendRow(row);
                ++i;
            }
        }
    }

    private AiShapeObject findShape(List shapes, int i) {
        if (i >= shapes.size()) {
            return null;
        }
        AiShapeObject obj = (AiShapeObject)shapes.get(i);
        int idx = i + 1;
        if (obj.getIndex() == idx) {
            return obj;
        }
        if (obj.getIndex() > idx) {
            for (int j = 0; j < shapes.size(); ++j) {
                obj = (AiShapeObject)shapes.get(j);
                if (obj.getIndex() != idx) continue;
                return obj;
            }
        }
        return null;
    }
}

