/*
 * Decompiled with CFR 0.152.
 */
package hec.map.aishape;

import hec.io.EndianInputStream;
import hec.io.EndianOutputStream;
import hec.map.WorldPt;
import hec.map.aishape.AiShapeObject;
import hec.map.importer.ImportPoint;
import java.io.IOException;
import java.util.logging.Level;
import java.util.logging.Logger;

public class AiShapePoint
extends AiShapeObject
implements ImportPoint {
    private WorldPt _thisPt;

    public AiShapePoint(int type) {
        super(type);
    }

    public AiShapePoint() {
        this(1);
    }

    public AiShapePoint(int index, WorldPt wp) {
        super(1, index);
        this.setWorldPt(wp);
    }

    public AiShapePoint(int type, int index, WorldPt wp) {
        super(type, index);
        this.setWorldPt(wp);
    }

    @Override
    public int contentByteLength() {
        return 20;
    }

    @Override
    public void writeRecord(EndianOutputStream output) {
        try {
            super.writeRecordHeader(output);
            double x = this._thisPt.e;
            double y = this._thisPt.n;
            output.writeDouble(200, x);
            output.writeDouble(200, y);
        }
        catch (IOException ex) {
            Logger.getLogger(AiShapePoint.class.getName()).log(Level.SEVERE, null, ex);
        }
    }

    @Override
    public int readRecord(EndianInputStream input) {
        try {
            int recnum = this.readRecordHeader(input);
            if (recnum < 0) {
                return recnum;
            }
            double x = input.readDouble(200);
            this._contentRead += 4;
            double y = input.readDouble(200);
            this._contentRead += 4;
            this._thisPt = new WorldPt(x, y);
            this._extents.n = y;
            this._extents.e = x;
            this._extents.s = y;
            this._extents.w = x;
        }
        catch (Exception e) {
            System.out.println(e.toString());
            return -1;
        }
        return this._index;
    }

    public WorldPt getReferencePt() {
        return this._thisPt;
    }

    public void setWorldPt(WorldPt pt) {
        this._thisPt = pt;
        this._extents.n = pt.n;
        this._extents.e = pt.e;
        this._extents.s = pt.n;
        this._extents.w = pt.e;
    }

    @Override
    public WorldPt getWorldPt() {
        return this._thisPt;
    }

    @Override
    public boolean contains(double tolerance, WorldPt pt) {
        return this._thisPt.distToPoint(pt) <= tolerance;
    }
}

