/*
 * Decompiled with CFR 0.152.
 */
package hec.map.aishape;

import hec.io.EndianInputStream;
import hec.io.EndianOutputStream;
import hec.map.WorldPt;
import hec.map.WorldRegion;
import hec.map.aishape.AiShapeObject;
import hec.map.aishape.SelfIntersectingPolygonException;
import hec.map.importer.ImportPolygon;
import java.io.IOException;
import java.util.List;
import java.util.Vector;

public class AiShapePolygon
extends AiShapeObject
implements ImportPolygon {
    int _numPoints;
    int _numParts;
    Vector<WorldRegion> _regions = new Vector();
    WorldPt _referencePt = null;

    public AiShapePolygon() {
        super(5);
    }

    protected AiShapePolygon(int type) {
        super(type);
    }

    public double getArea() {
        double area = 0.0;
        for (int i = 0; i < this._regions.size(); ++i) {
            WorldRegion region = this._regions.get(i);
            double subArea = region.getArea();
            if (!region.isClockwise()) {
                subArea *= -1.0;
            }
            area += subArea;
        }
        return area;
    }

    public AiShapePolygon(int index, Vector worldRegions) throws SelfIntersectingPolygonException {
        super(5, index);
        this._regions = worldRegions;
        this._numParts = 0;
        this._numPoints = 0;
        for (int ii = 0; ii < this._regions.size(); ++ii) {
            WorldRegion region = this._regions.get(ii);
            this.validateRegion(region);
            ++this._numParts;
            this._numPoints += region.pts.size();
            this._extents.grow(region.getWorldRectBounds());
        }
    }

    private void validateRegion(WorldRegion region) throws SelfIntersectingPolygonException {
        WorldPt ptLast;
        if (!region.isClockwise()) {
            region.reversePts();
        }
        if (region.isSelfIntersecting()) {
            throw new SelfIntersectingPolygonException(region);
        }
        if (region.pts.size() < 1) {
            return;
        }
        WorldPt ptFirst = (WorldPt)region.pts.get(0);
        if (!ptFirst.equals(ptLast = (WorldPt)region.pts.get(region.pts.size() - 1))) {
            region.pts.add(ptFirst);
            region.invalidate();
        }
    }

    @Override
    public int contentByteLength() {
        int len = 44;
        for (int ii = 0; ii < this._regions.size(); ++ii) {
            WorldRegion region = this._regions.get(ii);
            len += 4;
            len += region.pts.size() * 2 * 8;
        }
        return len;
    }

    @Override
    public void writeRecord(EndianOutputStream output) throws IOException {
        try {
            WorldRegion region;
            int ii;
            this.writeRecordHeader(output);
            this.writeBoundingBox(output);
            output.writeInt(200, this._numParts);
            output.writeInt(200, this._numPoints);
            int partsIndex = 0;
            for (ii = 0; ii < this._regions.size(); ++ii) {
                output.writeInt(200, partsIndex);
                region = this._regions.get(ii);
                partsIndex += region.pts.size();
            }
            for (ii = 0; ii < this._regions.size(); ++ii) {
                region = this._regions.get(ii);
                for (int jj = 0; jj < region.pts.size(); ++jj) {
                    WorldPt pt = (WorldPt)region.pts.get(jj);
                    output.writeDouble(200, pt.e);
                    output.writeDouble(200, pt.n);
                }
            }
        }
        catch (Exception e) {
            System.out.println(e.toString());
        }
    }

    @Override
    public int readRecord(EndianInputStream input) {
        try {
            int recnum = this.readRecordHeader(input);
            if (recnum < 0) {
                return recnum;
            }
            this.readBoundingBox(input);
            this._numParts = input.readInt(200);
            this._contentRead += 2;
            this._numPoints = input.readInt(200);
            this._contentRead += 2;
            if (this._numParts < -1) {
                return -1;
            }
            int[] partsIndex = new int[this._numParts + 1];
            for (int i = 0; i < this._numParts; ++i) {
                partsIndex[i] = input.readInt(200);
                this._contentRead += 2;
            }
            partsIndex[this._numParts] = this._numPoints;
            if (this._numPoints < 0) {
                return -1;
            }
            WorldPt[] tmpPts = new WorldPt[this._numPoints];
            for (int i = 0; i < this._numPoints; ++i) {
                double x = input.readDouble(200);
                this._contentRead += 4;
                double y = input.readDouble(200);
                this._contentRead += 4;
                tmpPts[i] = new WorldPt(x, y);
            }
            Vector<WorldRegion> clockwiseRegions = new Vector<WorldRegion>(this._numParts);
            Vector<WorldRegion> counterRegions = new Vector<WorldRegion>(this._numParts);
            for (int j = 0; j < this._numParts; ++j) {
                WorldRegion region = new WorldRegion();
                int npts = partsIndex[j + 1] - partsIndex[j];
                region.pts.setSize(npts);
                int k = 0;
                for (int i = partsIndex[j]; i < partsIndex[j + 1]; ++i) {
                    region.pts.setElementAt(tmpPts[i], k);
                    ++k;
                }
                if (region.isClockwise()) {
                    clockwiseRegions.add(region);
                    continue;
                }
                counterRegions.add(region);
            }
            this._regions.addAll(clockwiseRegions);
            this._regions.addAll(counterRegions);
        }
        catch (Exception e) {
            System.out.println(e.toString());
            return -1;
        }
        return this._index;
    }

    public WorldPt getReferencePt() {
        if (this._referencePt == null) {
            double xc = (this._extents.e + this._extents.w) / 2.0;
            double yc = (this._extents.n + this._extents.s) / 2.0;
            this._referencePt = new WorldPt(xc, yc);
        }
        return this._referencePt;
    }

    public Vector<WorldRegion> getRegions() {
        return this._regions;
    }

    @Override
    public boolean contains(double tolerance, WorldPt wpt) {
        WorldRegion reg;
        int j;
        if (!super.contains(tolerance, wpt)) {
            return false;
        }
        boolean flag = false;
        for (j = 0; j < this._regions.size(); ++j) {
            reg = this._regions.get(j);
            if (reg == null || !reg.isClockwise() || !reg.contains(wpt)) continue;
            flag = true;
            break;
        }
        if (!flag) {
            return false;
        }
        for (j = 0; j < this._regions.size(); ++j) {
            reg = this._regions.get(j);
            if (reg == null || reg.isClockwise() || !reg.contains(wpt)) continue;
            return false;
        }
        return flag;
    }

    public boolean insertPt(WorldPt wpt, double tol) {
        boolean flag = false;
        List regions = this.getRegions();
        for (int j = 0; j < regions.size(); ++j) {
            WorldRegion reg = (WorldRegion)regions.get(j);
            if (reg == null) continue;
            if (reg.insertPt(wpt, tol)) {
                // empty if block
            }
            return true;
        }
        return false;
    }

    public boolean removePt(WorldPt wpt, double tol) {
        boolean flag = false;
        List regions = this.getRegions();
        for (int j = 0; j < regions.size(); ++j) {
            WorldRegion reg = (WorldRegion)regions.get(j);
            if (reg == null) continue;
            if (reg.removePt(wpt, tol)) {
                // empty if block
            }
            return true;
        }
        return false;
    }

    public boolean equals(Object obj) {
        return false;
    }

    public Object clone() throws CloneNotSupportedException {
        return null;
    }
}

