/*
 * Decompiled with CFR 0.152.
 */
package hec.map.aishape;

import hec.io.EndianInputStream;
import hec.io.EndianOutputStream;
import hec.map.aishape.AiShapePolygon;
import hec.map.aishape.SelfIntersectingPolygonException;
import java.io.IOException;
import java.util.Vector;

public class AiShapePolygonZ
extends AiShapePolygon {
    double _zmin;
    double _zmax;
    double _mmin;
    double _mmax;
    double[] _zarray = null;
    double[] _marray = null;

    public AiShapePolygonZ() {
        super(15);
    }

    public AiShapePolygonZ(int index, Vector worldRegions) throws SelfIntersectingPolygonException {
        super(index, worldRegions);
    }

    @Override
    public int readRecord(EndianInputStream input) {
        super.readRecord(input);
        try {
            this._zmin = input.readDouble(200);
            this._contentRead += 4;
            this._zmax = input.readDouble(200);
            this._contentRead += 4;
            this._zarray = new double[this._numPoints];
            for (int i = 0; i < this._numPoints; ++i) {
                this._zarray[i] = input.readDouble(200);
                this._contentRead += 4;
            }
            int X = 44 + 4 * this._numParts;
            int Y = X + 16 * this._numPoints;
            int Z = Y + 16 + 8 * this._numPoints;
            if (this._contentLength > Z / 2) {
                this._marray = new double[this._numPoints];
                this._mmin = input.readDouble(200);
                this._contentRead += 4;
                this._mmax = input.readDouble(200);
                this._contentRead += 4;
                for (int i = 0; i < this._numPoints; ++i) {
                    this._marray[i] = input.readDouble(200);
                    this._contentRead += 4;
                }
            }
        }
        catch (Exception e) {
            System.out.println("AiShapePolygonZ.readRecord:Exception " + e);
        }
        return this._index;
    }

    @Override
    public void writeRecord(EndianOutputStream output) throws IOException {
        int i;
        super.writeRecord(output);
        output.writeDouble(200, this._zmin);
        output.writeDouble(200, this._zmax);
        for (i = 0; i < this._numPoints; ++i) {
            output.writeDouble(200, this._zarray[i]);
        }
        if (this._marray != null) {
            output.writeDouble(200, this._mmin);
            output.writeDouble(200, this._mmax);
            for (i = 0; i < this._marray.length; ++i) {
                output.writeDouble(200, this._marray[i]);
            }
        }
    }
}

