/*
 * Decompiled with CFR 0.152.
 */
package hec.map.aishape;

import hec.io.EndianInputStream;
import hec.io.EndianOutputStream;
import hec.map.aishape.AiShapeArc;
import java.io.IOException;
import java.util.Vector;

public class AiShapePolylineZ
extends AiShapeArc {
    private double _zmin;
    private double _zmax;
    private double _mmin;
    private double _mmax;
    private double[] _zarray = null;
    private double[] _marray = null;

    public AiShapePolylineZ() {
        super(13);
    }

    public AiShapePolylineZ(int index, Vector worldLines) {
        super(index, worldLines);
    }

    @Override
    public int contentByteLength() {
        return this._contentLength * 2;
    }

    @Override
    public int readRecord(EndianInputStream input) {
        super.readRecord(input);
        try {
            this._zmin = input.readDouble(200);
            this._contentRead += 4;
            this._zmax = input.readDouble(200);
            this._contentRead += 4;
            this._zarray = new double[this._numPoints];
            for (int i = 0; i < this._numPoints; ++i) {
                this._zarray[i] = input.readDouble(200);
                this._contentRead += 4;
            }
            int X = 44 + 4 * this._numParts;
            int Y = X + 16 * this._numPoints;
            int Z = Y + 16 + 8 * this._numPoints;
            if (this._contentLength > Z / 2) {
                this._marray = new double[this._numPoints];
                this._mmin = input.readDouble(200);
                this._contentRead += 4;
                this._mmax = input.readDouble(200);
                this._contentRead += 4;
                for (int i = 0; i < this._numPoints; ++i) {
                    this._marray[i] = input.readDouble(200);
                    this._contentRead += 4;
                }
            }
        }
        catch (Exception e) {
            System.out.println("AiShapePolylineZ.readRecord:Exception " + e);
        }
        return this._index;
    }

    @Override
    public void writeRecord(EndianOutputStream output) {
        super.writeRecord(output);
        try {
            int i;
            output.writeDouble(200, this._zmin);
            output.writeDouble(200, this._zmax);
            for (i = 0; i < this._zarray.length; ++i) {
                output.writeDouble(200, this._zarray[i]);
            }
            if (this._marray != null) {
                output.writeDouble(200, this._mmin);
                output.writeDouble(200, this._mmax);
                for (i = 0; i < this._zarray.length; ++i) {
                    output.writeDouble(200, this._marray[i]);
                }
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }
}

