/*
 * Decompiled with CFR 0.152.
 */
package hec.map.aishape;

import hec.io.HecFile;
import hec.map.transform.CoordinateInfo;
import hec.map.transform.CoordinateInfoFactory;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.StringReader;
import java.util.logging.Level;
import java.util.logging.Logger;

public class AiShapeProjection {
    private String _wkt;
    private CoordinateInfo _coordInfo = null;
    static final Logger LOGGER = Logger.getLogger(AiShapeProjection.class.getName());

    public AiShapeProjection(HecFile file) {
        this.processFile(file);
    }

    public AiShapeProjection(String wkt) {
        this.processText(wkt);
    }

    private void processFile(HecFile file) {
        BufferedReader reader = file.getBufferedReader();
        try {
            this.process(reader);
            reader.close();
        }
        catch (IOException e) {
            System.out.println("readPrj:Error reading " + file.getPath());
            LOGGER.log(Level.SEVERE, e.getMessage(), e);
        }
    }

    private void processText(String wkt) {
        BufferedReader reader = new BufferedReader(new StringReader(wkt));
        try {
            this.process(reader);
        }
        catch (IOException e) {
            System.out.println("readPrj:Error reading " + wkt);
            LOGGER.log(Level.SEVERE, e.getMessage(), e);
        }
    }

    private void process(BufferedReader reader) throws IOException {
        StringBuilder builder = new StringBuilder();
        this._wkt = "";
        try {
            String line = reader.readLine();
            while (line != null && line.length() != 0) {
                builder.append(line);
                line = reader.readLine();
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        this._wkt = builder.toString();
        this._coordInfo = CoordinateInfoFactory.getDefault().createCoordinateInfo(new StringReader(this._wkt));
    }

    public String getWKT() {
        return this._wkt;
    }

    public CoordinateInfo getCoordinateInfo() {
        return this._coordInfo;
    }
}

