/*
 * Decompiled with CFR 0.152.
 */
package hec.map.aishape;

import hec.appInterface.FileOpener;
import hec.io.EndianOutputStream;
import hec.io.HecFile;
import hec.io.Identifier;
import hec.io.SimpleHecFileImpl;
import hec.map.WorldRect;
import hec.map.aishape.AiShapeFieldDescriptor;
import hec.map.aishape.AiShapeIndex;
import hec.map.aishape.AiShapeObject;
import hec.map.aishape.Attribute;
import hec.map.crs.CoordinateReferenceSystem;
import java.io.BufferedWriter;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.RandomAccessFile;
import java.util.Calendar;
import java.util.List;

public class AiShapeWriter {
    int mShapeType = 1;
    CoordinateReferenceSystem _coordinateReferenceSystem;
    Identifier mShapeFileId = null;
    String mDBFFilePath = null;
    String mSHXFilePath = null;
    String mPRJFilePath = null;
    FileOpener mFileOpener = null;
    WorldRect mExtents = null;
    int mNumberRecords = 0;
    int mShapeFileLength = 0;
    int mShxFileLength = 0;
    int mShxOffset = 50;
    List<AiShapeFieldDescriptor> mFieldDescriptors;
    int mDbfRecordLength = 0;
    EndianOutputStream mShapeFileOutputStream = null;
    EndianOutputStream mShxFileOutputStream = null;
    EndianOutputStream mDbfFileOutputStream = null;

    public void setShapeType(int shapeType) {
        this.mShapeType = shapeType;
    }

    public void setIdentifier(Identifier id) {
        this.mShapeFileId = id;
        String basePath = this.mShapeFileId.getPath();
        if (basePath.lastIndexOf(".") > 0) {
            basePath = basePath.substring(0, basePath.lastIndexOf("."));
        }
        this.mSHXFilePath = basePath + ".shx";
        this.mDBFFilePath = basePath + ".dbf";
        this.mPRJFilePath = basePath + ".prj";
    }

    public void setFileOpener(FileOpener fileOpener) {
        this.mFileOpener = fileOpener;
    }

    public void init(List<AiShapeFieldDescriptor> fieldDescriptors) throws IOException {
        this.mFieldDescriptors = fieldDescriptors;
        this.mNumberRecords = 0;
        this.mShapeFileLength = 100;
        this.mShxFileLength = 100;
        this.mDbfRecordLength = 1;
        for (int ii = 0; ii < this.mFieldDescriptors.size(); ++ii) {
            AiShapeFieldDescriptor fieldDescriptor = this.mFieldDescriptors.get(ii);
            this.mDbfRecordLength += fieldDescriptor.getLength();
        }
        if (this.mFileOpener == null) {
            throw new IOException("FileOpener is not set");
        }
        HecFile file = this.mShapeFileId.getFile();
        if (file == null) {
            file = this.mFileOpener.openFile(new Identifier(this.mShapeFileId.getPath()), false).getFile();
        }
        this.mShapeFileOutputStream = file.getEndianOutputStream();
        this.writeFileHeader(this.mShapeFileOutputStream, this.mShapeFileLength / 2, this.mShapeType);
        Identifier dbfId = this.newThenOpenFile(new Identifier(this.mDBFFilePath));
        if (dbfId == null) {
            throw new IOException("Unable to create/open DBF file. ==> " + this.mDBFFilePath);
        }
        this.mDbfFileOutputStream = dbfId.getFile().getEndianOutputStream();
        this.writeDBFHeader(this.mDbfFileOutputStream);
        Identifier shxId = this.newThenOpenFile(new Identifier(this.mSHXFilePath));
        if (shxId == null) {
            throw new IOException("Unable to create/open SHX file. ==> " + this.mSHXFilePath);
        }
        this.mShxFileOutputStream = shxId.getFile().getEndianOutputStream();
        this.writeFileHeader(this.mShxFileOutputStream, this.mShxFileLength / 2, this.mShapeType);
    }

    public void closeFiles() throws IOException {
        this.writeDbfTerminator(this.mDbfFileOutputStream);
        this.mDbfFileOutputStream.flush();
        this.mDbfFileOutputStream.close();
        RandomAccessFile raFile = new RandomAccessFile(this.mDBFFilePath, "rw");
        ByteArrayOutputStream baous = new ByteArrayOutputStream();
        this.mDbfFileOutputStream = new EndianOutputStream(baous);
        this.writeDBFHeader(this.mDbfFileOutputStream);
        this.mDbfFileOutputStream.flush();
        raFile.write(baous.toByteArray());
        this.mDbfFileOutputStream.close();
        raFile.close();
        this.mShxFileOutputStream.flush();
        this.mShxFileOutputStream.close();
        raFile = new RandomAccessFile(this.mSHXFilePath, "rw");
        baous = new ByteArrayOutputStream();
        this.mShxFileOutputStream = new EndianOutputStream(baous);
        this.writeFileHeader(this.mShxFileOutputStream, this.mShxFileLength / 2, this.mShapeType);
        this.mShxFileOutputStream.flush();
        raFile.write(baous.toByteArray());
        this.mShxFileOutputStream.close();
        raFile.close();
        this.mShapeFileOutputStream.flush();
        this.mShapeFileOutputStream.close();
        raFile = new RandomAccessFile(this.mShapeFileId.getPath(), "rw");
        baous = new ByteArrayOutputStream();
        this.mShapeFileOutputStream = new EndianOutputStream(baous);
        this.writeFileHeader(this.mShapeFileOutputStream, this.mShapeFileLength / 2, this.mShapeType);
        this.mShapeFileOutputStream.flush();
        raFile.write(baous.toByteArray());
        this.mShapeFileOutputStream.close();
        raFile.close();
        if (this._coordinateReferenceSystem != null) {
            this.saveProjectionFile();
        }
    }

    public void appendShape(AiShapeObject shapeObject, Attribute attribute) throws IOException {
        if (this.mExtents == null) {
            this.mExtents = shapeObject.getExtent();
        } else {
            this.mExtents.grow(shapeObject.getExtent());
        }
        this.mShapeFileLength += shapeObject.recordByteLength();
        this.mShxFileLength += 8;
        AiShapeIndex index = new AiShapeIndex();
        index.offset = this.mShxOffset;
        index.contentLength = shapeObject.contentByteLength() / 2;
        this.writeIndex(this.mShxFileOutputStream, index);
        this.mShxOffset += shapeObject.recordByteLength() / 2;
        this.writeShape(this.mShapeFileOutputStream, shapeObject);
        this.writeDbfAttribute(this.mDbfFileOutputStream, attribute);
        ++this.mNumberRecords;
    }

    public void appendShape(List<AiShapeObject> shapeObjects, List<Attribute> attributes) throws IOException {
        for (int i = 0; i < shapeObjects.size(); ++i) {
            this.appendShape(shapeObjects.get(i), attributes.get(i));
        }
    }

    protected Identifier newThenOpenFile(Identifier pathId) {
        Identifier idOut = this.mFileOpener.createFile(pathId);
        if (idOut == null) {
            idOut = this.mFileOpener.openFile(pathId, true);
        }
        return idOut;
    }

    private void writeFileHeader(EndianOutputStream output, int fileLength, int shapeType) throws IOException {
        output.writeInt(100, 9994);
        output.writeInt(100, 0);
        output.writeInt(100, 0);
        output.writeInt(100, 0);
        output.writeInt(100, 0);
        output.writeInt(100, 0);
        output.writeInt(100, fileLength);
        output.writeInt(200, 1000);
        output.writeInt(200, shapeType);
        double w = 0.0;
        double e = 0.0;
        double n = 0.0;
        double s = 0.0;
        if (this.mExtents != null) {
            w = this.mExtents.w;
            e = this.mExtents.e;
            n = this.mExtents.n;
            s = this.mExtents.s;
        }
        output.writeDouble(200, w);
        output.writeDouble(200, s);
        output.writeDouble(200, e);
        output.writeDouble(200, n);
        output.writeDouble(200, 0.0);
        output.writeDouble(200, 0.0);
        output.writeDouble(200, 0.0);
        output.writeDouble(200, 0.0);
    }

    private boolean writeShape(EndianOutputStream output, AiShapeObject shapeObj) throws IOException {
        shapeObj.writeRecord(output);
        return true;
    }

    private boolean writeIndex(EndianOutputStream output, AiShapeIndex shapeIndex) throws IOException {
        output.writeInt(100, shapeIndex.offset);
        output.writeInt(100, shapeIndex.contentLength);
        return true;
    }

    public void writeDBFHeader(EndianOutputStream output) {
        try {
            int ii;
            output.writeByte(3);
            Calendar c2 = Calendar.getInstance();
            byte year = (byte)(c2.get(1) - 1900);
            byte month = (byte)(c2.get(2) + 1);
            byte day = (byte)c2.get(5);
            output.writeByte(year);
            output.writeByte(month);
            output.writeByte(day);
            output.writeInt(200, this.mNumberRecords);
            short headerLength = (short)(33 + this.mFieldDescriptors.size() * 32);
            output.writeShort(200, headerLength);
            short recordLength = 1;
            for (ii = 0; ii < this.mFieldDescriptors.size(); ++ii) {
                AiShapeFieldDescriptor fieldDescriptor = this.mFieldDescriptors.get(ii);
                recordLength = (short)(recordLength + fieldDescriptor.getLength());
            }
            output.writeShort(200, recordLength);
            for (ii = 0; ii < 20; ++ii) {
                output.writeByte(0);
            }
            byte[] fieldBytes = new byte[32];
            for (int i = 0; i < this.mFieldDescriptors.size(); ++i) {
                AiShapeFieldDescriptor attDescr = this.mFieldDescriptors.get(i);
                attDescr.writeBytes(fieldBytes);
                output.write(fieldBytes);
            }
            output.writeByte(13);
            byte[] byArray = new byte[recordLength];
        }
        catch (Exception e) {
            System.out.println(e.toString());
            e.printStackTrace();
            return;
        }
    }

    private void writeDbfTerminator(OutputStream output) throws IOException {
        byte[] terminator = new byte[]{26};
        output.write(terminator);
    }

    private void writeDbfAttribute(EndianOutputStream output, Attribute attribute) throws IOException {
        byte[] recordBytes = new byte[this.mDbfRecordLength];
        attribute.writeBytes(this.mFieldDescriptors, recordBytes);
        output.write(recordBytes);
    }

    public HecFile getProjectionFile() {
        String prjPath = this.mPRJFilePath;
        SimpleHecFileImpl prjFile = new SimpleHecFileImpl(prjPath);
        return prjFile;
    }

    public boolean saveProjectionFile() {
        HecFile file = this.getProjectionFile();
        String toWKT = this._coordinateReferenceSystem.toWKT();
        toWKT = toWKT.replace("\r\n", "");
        try {
            BufferedWriter writer = file.getBufferedWriter();
            writer.write(toWKT);
            writer.newLine();
            writer.flush();
            writer.close();
        }
        catch (IOException ex) {
            return false;
        }
        return true;
    }

    public void setCoordinateReferenceSystem(CoordinateReferenceSystem crs) {
        this._coordinateReferenceSystem = crs;
    }
}

