/*
 * Decompiled with CFR 0.152.
 */
package hec.map.aishape;

import hec.map.aishape.AiShapeConst;
import hec.map.aishape.AiShapeFieldDescriptor;
import hec.map.aishape.Field;
import java.io.IOException;
import java.io.Serializable;
import java.util.List;
import java.util.Vector;

public class Attribute
implements AiShapeConst,
Serializable {
    int _indexPosition;
    boolean _isDeleted;
    Field[] _fields;

    public Attribute(int indexPosition, Field[] fields) {
        this._fields = fields;
        this._indexPosition = indexPosition;
    }

    public Attribute(int indexPosition, Vector fieldDescr, byte[] record) {
        this._indexPosition = indexPosition;
        this._isDeleted = false;
        if ((char)record[0] == '*') {
            this._isDeleted = true;
        }
        this._fields = new Field[fieldDescr.size()];
        int recordIdx = 1;
        for (int i = 0; i < fieldDescr.size(); ++i) {
            int fieldLength;
            AiShapeFieldDescriptor fldDescr = (AiShapeFieldDescriptor)fieldDescr.get(i);
            int fieldIdx = recordIdx;
            for (fieldLength = 0; fieldLength < fldDescr._length && fieldIdx < record.length && record[fieldIdx] != 0; ++fieldIdx, ++fieldLength) {
            }
            Object s = null;
            s = Attribute.buildTrimmedString(record, recordIdx, fieldLength);
            switch (Character.toUpperCase(fldDescr.getType())) {
                case 'B': 
                case 'C': 
                case 'D': 
                case 'G': 
                case 'L': 
                case 'M': 
                case 'W': {
                    break;
                }
                case 'F': {
                    String str = s.toString();
                    try {
                        s = new Float(str);
                    }
                    catch (NumberFormatException e) {
                        s = new Float(Float.NEGATIVE_INFINITY);
                    }
                    break;
                }
                case 'N': {
                    String str = s.toString();
                    try {
                        s = new Double(str);
                        break;
                    }
                    catch (NumberFormatException e) {
                        s = new Double(Double.NEGATIVE_INFINITY);
                    }
                }
            }
            if (fldDescr.isUnique()) {
                this._fields[i] = new Field(s, fldDescr, indexPosition);
            } else {
                this._fields[i] = new Field(s);
                this._fields[i].setType(fldDescr.getType());
                this._fields[i].setName(fldDescr.toString());
            }
            recordIdx += fldDescr._length;
        }
    }

    public void writeBytes(List fieldDescriptors, byte[] recordBytes) throws IOException {
        int bytePosition = 0;
        recordBytes[bytePosition++] = 32;
        for (int ii = 0; ii < fieldDescriptors.size(); ++ii) {
            AiShapeFieldDescriptor fieldDescriptor = (AiShapeFieldDescriptor)fieldDescriptors.get(ii);
            String field = this._fields[ii].toString();
            for (int jj = 0; jj < fieldDescriptor.getLength(); ++jj) {
                recordBytes[bytePosition++] = jj < field.length() ? (int)field.charAt(jj) : 32;
                if (bytePosition < recordBytes.length) continue;
                return;
            }
        }
    }

    static String buildTrimmedString(byte[] bytes, int offset, int len) {
        int st;
        int count = len;
        for (st = 0; st < count && (char)bytes[offset + st] <= ' '; ++st) {
        }
        while (st < count && (char)bytes[offset + count - 1] <= ' ') {
            --count;
        }
        String s = st > 0 || count < len ? new String(bytes, offset + st, count - st) : new String(bytes, offset, count);
        return s;
    }

    public int getNumberOfFields() {
        return this._fields.length;
    }

    public Field getField(int idx) {
        if (idx < 0 || idx >= this._fields.length) {
            return null;
        }
        return this._fields[idx];
    }

    public Field[] getFields() {
        return this._fields;
    }

    public class Wrapper {
        Object value;

        public String toString() {
            return this.value.toString();
        }
    }
}

