/*
 * Decompiled with CFR 0.152.
 */
package hec.map.aishape;

import hec.map.aishape.AiShapeFieldDescriptor;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.TreeSet;
import java.util.Vector;
import javax.swing.ComboBoxModel;
import rma.swing.PruningComboBoxModel;
import rma.swing.table.AbstractRmaTableModel;

public class FieldMapModel
extends AbstractRmaTableModel {
    Vector _objectAttributes;
    HashMap _selectedFieldDescriptors;
    TreeSet _prunedFieldDescriptors;
    TreeSet _allFieldDescriptors;
    String _type;

    public FieldMapModel(Vector objectAttributes, List fieldDescriptors, Map defaults, String type) {
        this._objectAttributes = objectAttributes;
        this._allFieldDescriptors = new TreeSet(fieldDescriptors);
        this._selectedFieldDescriptors = new HashMap(objectAttributes.size());
        this._prunedFieldDescriptors = new TreeSet();
        this.m_columnNames = new String[]{type + " Attribute", "Shape Land Manager"};
        this._type = type;
        this.fillDefaults(defaults);
    }

    private void fillDefaults(Map defaults) {
        block0: for (int ii = 0; ii < this.getRowCount(); ++ii) {
            Object key = this.getValueAt(ii, 0);
            Object fieldName = defaults.get(key);
            if (fieldName == null) continue;
            for (Object fd : this._allFieldDescriptors) {
                if (!fieldName.equals(fd.toString())) continue;
                this.setValueAt(fd, ii, 1);
                continue block0;
            }
        }
    }

    public String getType() {
        return this._type;
    }

    @Override
    public Class getColumnClass(int columnIndex) {
        return Object.class;
    }

    @Override
    public int getRowCount() {
        return this._objectAttributes.size();
    }

    @Override
    public Object getValueAt(int rowIndex, int columnIndex) {
        if (columnIndex < 0 || columnIndex >= this.getColumnCount()) {
            return null;
        }
        if (rowIndex < 0) {
            return null;
        }
        switch (columnIndex) {
            case 0: {
                if (rowIndex >= this._objectAttributes.size()) {
                    return null;
                }
                return this._objectAttributes.get(rowIndex);
            }
            case 1: {
                if (rowIndex >= this._objectAttributes.size()) {
                    return null;
                }
                Object key = this._objectAttributes.get(rowIndex);
                Object value = this._selectedFieldDescriptors.get(key);
                return value;
            }
        }
        return null;
    }

    public AiShapeFieldDescriptor getFieldDescriptor(Object shapeAttribute) {
        return (AiShapeFieldDescriptor)this._selectedFieldDescriptors.get(shapeAttribute);
    }

    @Override
    public boolean isCellEditable(int rowIndex, int columnIndex) {
        return columnIndex == 1;
    }

    public void setNameField(Object aValue) {
        this.updatePrunedItems("Name Field", aValue);
    }

    public void updatePrunedItems(Object key, Object aValue) {
        Object oldValue = this._selectedFieldDescriptors.put(key, aValue);
        if (oldValue != null) {
            this._prunedFieldDescriptors.remove(oldValue);
        }
        if (aValue != null) {
            this._prunedFieldDescriptors.add(aValue);
        }
    }

    @Override
    public void setValueAt(Object aValue, int rowIndex, int columnIndex) {
        if (columnIndex != 1) {
            return;
        }
        if (rowIndex < 0 || rowIndex >= this._objectAttributes.size()) {
            return;
        }
        Object key = this._objectAttributes.get(rowIndex);
        this.updatePrunedItems(key, aValue);
    }

    public ComboBoxModel getFieldDescriptorComboBoxModel() {
        return new PruningComboBoxModel(this._prunedFieldDescriptors, this._allFieldDescriptors);
    }
}

