/*
 * Decompiled with CFR 0.152.
 */
package hec.map.aishape;

import hec.io.AsciiSerializable;
import hec.map.aishape.AiShapeConst;
import java.awt.Color;
import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.io.Serializable;
import java.lang.reflect.Field;
import java.util.HashSet;

public class ShapeDrawingAttribute
implements AiShapeConst,
AsciiSerializable,
Serializable {
    transient PropertyChangeSupport propertyChangeSupport = new PropertyChangeSupport(this);
    public static final int CENTER_POINT_GRAPHIC_NONE = 0;
    public static final int CENTER_POINT_GRAPHIC_FORWARD_ARROW = 1;
    public static final int CENTER_POINT_GRAPHIC_REVERSE_ARROW = 2;
    public static final int[] CENTER_POINT_GRAPHIC_TYPES = new int[]{0, 1, 2};
    int drawingRGB;
    private transient Color drawingColor;
    float brushSize = 1.0f;
    transient boolean highlighted;
    transient HashSet highlightedIndexes;
    transient int centerPointGraphic = 0;

    public ShapeDrawingAttribute() {
    }

    public ShapeDrawingAttribute(Color c2) {
        this.setColor(c2);
    }

    public final void setColor(Color c2) {
        Color oldColor = this.drawingColor;
        this.drawingColor = c2;
        this.drawingRGB = c2.getRGB();
        this.propertyChangeSupport.firePropertyChange("Color", oldColor, this.drawingColor);
    }

    public Color getColor() {
        if (this.drawingColor == null) {
            this.drawingColor = new Color(this.drawingRGB);
        }
        return this.drawingColor;
    }

    public synchronized boolean isHighlighted(int shapeIdx) {
        return this.isHighlighted(new Integer(shapeIdx));
    }

    public synchronized boolean isHighlighted(Integer shapeInt) {
        if (this.highlightedIndexes == null) {
            return false;
        }
        return this.highlightedIndexes.contains(shapeInt);
    }

    public synchronized void addHighlightedIndex(Integer shapeInt) {
        this.highlighted = true;
        if (this.highlightedIndexes == null) {
            this.highlightedIndexes = new HashSet();
        }
        this.highlightedIndexes.add(shapeInt);
        if (shapeInt != null) {
            this.propertyChangeSupport.fireIndexedPropertyChange("HighlightedIndex", (int)shapeInt, false, true);
        }
    }

    public synchronized void clearHighlightedIndex(Integer shapeInt) {
        if (this.highlightedIndexes == null) {
            return;
        }
        this.highlightedIndexes.remove(shapeInt);
        if (this.highlightedIndexes.size() < 1) {
            this.highlighted = false;
        }
        if (shapeInt != null) {
            this.propertyChangeSupport.fireIndexedPropertyChange("HighlightedIndex", (int)shapeInt, true, false);
        }
    }

    public void setCenterPointGraphic(int type) {
        boolean valid = false;
        for (int ii = 0; ii < CENTER_POINT_GRAPHIC_TYPES.length; ++ii) {
            if (type != CENTER_POINT_GRAPHIC_TYPES[ii]) continue;
            valid = true;
            break;
        }
        if (valid) {
            int oldType = this.centerPointGraphic;
            this.centerPointGraphic = type;
            this.propertyChangeSupport.firePropertyChange("CenterPointGraphic", oldType, this.centerPointGraphic);
        }
    }

    public int getCenterPointGraphic() {
        return this.centerPointGraphic;
    }

    public void setBrushSize(float f) {
        this.brushSize = f;
    }

    public float getBrushSize() {
        return this.brushSize;
    }

    public void addPropertyChangeListener(PropertyChangeListener listener) {
        this.propertyChangeSupport.addPropertyChangeListener(listener);
    }

    public void removePropertyChangeListener(PropertyChangeListener listener) {
        this.propertyChangeSupport.removePropertyChangeListener(listener);
    }

    @Override
    public Object getFieldObject(Field fld) {
        try {
            Object obj = fld.get(this);
            return obj;
        }
        catch (IllegalAccessException e) {
            return null;
        }
    }

    @Override
    public boolean setFieldObject(Field fld, Object fobj) {
        try {
            fld.set(this, fobj);
            return true;
        }
        catch (IllegalAccessException e) {
            return false;
        }
        catch (IllegalArgumentException e) {
            return false;
        }
    }
}

