/*
 * Decompiled with CFR 0.152.
 */
package hec.map.aishape;

import hec.map.WorldLine;
import hec.map.WorldPt;
import hec.map.WorldRegion;
import hec.map.aishape.AiShapeArc;
import hec.map.aishape.AiShapeGlyph;
import hec.map.aishape.AiShapeObject;
import hec.map.aishape.AiShapePoint;
import hec.map.aishape.AiShapePolygon;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.event.ActionEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.ArrayList;
import java.util.List;
import java.util.Vector;
import javax.swing.JDialog;
import javax.swing.JLabel;
import rma.swing.ButtonCmdPanel;
import rma.swing.ButtonCmdPanelListener;
import rma.swing.RmaInsets;
import rma.swing.RmaJDialog;
import rma.swing.RmaJTable;
import rma.util.RMAIO;

public class ShapeGeoInfoDialog
extends RmaJDialog {
    private AiShapeObject _shape;
    private RmaJTable _table;
    private ButtonCmdPanel _cmdPanel;
    private AiShapeGlyph _glyph;
    private JLabel _nameLabel;

    public ShapeGeoInfoDialog(JDialog parent, AiShapeObject shape, AiShapeGlyph glyph) {
        super((Dialog)parent, false);
        this._shape = shape;
        this._glyph = glyph;
        this.buildControls();
        this.addListeners();
        this.fillForm();
        this.pack();
        this.setLocationRelativeTo(this.getParent());
    }

    private void buildControls() {
        this.setTitle("Shape Geo Information");
        this.getContentPane().setLayout(new GridBagLayout());
        this._nameLabel = new JLabel();
        GridBagConstraints gbc = new GridBagConstraints();
        gbc.gridx = 0;
        gbc.gridy = 0;
        gbc.weightx = 1.0;
        gbc.weighty = 0.0;
        gbc.anchor = 18;
        gbc.fill = 2;
        gbc.insets = RmaInsets.INSETS5505;
        this.getContentPane().add((Component)this._nameLabel, gbc);
        Object[] headers = new String[]{"Index", "Easting", "Northing"};
        this._table = new RmaJTable(this, headers){

            @Override
            public Dimension getPreferredScrollableViewportSize() {
                Dimension d = super.getPreferredScrollableViewportSize();
                d.height = this.getRowHeight() * 5;
                return d;
            }
        };
        this._table.setColumnsEnabled(false, 0, 1, 2);
        gbc.gridx = 0;
        gbc.gridy = 1;
        gbc.weightx = 1.0;
        gbc.weighty = 1.0;
        gbc.anchor = 18;
        gbc.fill = 1;
        gbc.insets = RmaInsets.INSETS5505;
        this.getContentPane().add((Component)this._table.getScrollPane(), gbc);
        this._cmdPanel = new ButtonCmdPanel(256);
        gbc.gridx = 0;
        gbc.gridy = 10;
        gbc.weightx = 1.0;
        gbc.weighty = 0.0;
        gbc.anchor = 16;
        gbc.fill = 2;
        gbc.insets = RmaInsets.INSETS5505;
        this.getContentPane().add((Component)this._cmdPanel, gbc);
    }

    private void addListeners() {
        this._cmdPanel.addCmdPanelListener(new ButtonCmdPanelListener(){

            @Override
            public void buttonCmdActionPerformed(ActionEvent e) {
                switch (e.getID()) {
                    case 256: {
                        ShapeGeoInfoDialog.this.setVisible(false);
                        if (ShapeGeoInfoDialog.this._glyph != null) {
                            ShapeGeoInfoDialog.this._glyph.clearSelections();
                        }
                        ShapeGeoInfoDialog.this.dispose();
                    }
                }
            }
        });
        this._table.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                int row = ShapeGeoInfoDialog.this._table.rowAtPoint(e.getPoint());
                if (row == -1) {
                    return;
                }
                ShapeGeoInfoDialog.this.selectPoints(ShapeGeoInfoDialog.this._table.getSelectedRows());
            }
        });
    }

    protected void selectPoints(int[] rows) {
        if (this._glyph == null) {
            return;
        }
        if (rows == null || rows.length == 0) {
            this._glyph.clearSelections();
            return;
        }
        ArrayList<WorldPt> worldPts = new ArrayList<WorldPt>();
        for (int i = 0; i < rows.length; ++i) {
            double e = RMAIO.parseDouble(this._table.getValueAt(rows[i], 1));
            double n = RMAIO.parseDouble(this._table.getValueAt(rows[i], 2));
            WorldPt wpt = new WorldPt(e, n);
            worldPts.add(wpt);
        }
        this._glyph.selectPoints(worldPts);
    }

    private void fillForm() {
        this._nameLabel.setText(this._shape.toString());
        this._table.deleteCells();
        if (this._shape instanceof AiShapePoint) {
            this.fillForm((AiShapePoint)this._shape);
        } else if (this._shape instanceof AiShapeArc) {
            this.fillForm((AiShapeArc)this._shape);
        } else if (this._shape instanceof AiShapePolygon) {
            this.fillForm((AiShapePolygon)this._shape);
        }
    }

    private void fillForm(AiShapePolygon shape) {
        List regions = shape.getRegions();
        for (int r = 0; r < ((Vector)regions).size(); ++r) {
            WorldRegion region = (WorldRegion)((Vector)regions).get(r);
            for (int p = 0; p < region.pts.size(); ++p) {
                WorldPt pt = (WorldPt)region.pts.get(p);
                Vector<Object> row = new Vector<Object>();
                row.add(r + 1 + "-" + (p + 1));
                row.add(pt.e);
                row.add(pt.n);
                this._table.appendRow(row);
            }
        }
    }

    private void fillForm(AiShapeArc shape) {
        Vector<WorldLine> lines = shape.getArcLines();
        for (int r = 0; r < lines.size(); ++r) {
            WorldLine line = lines.get(r);
            for (int p = 0; p < line.pts.size(); ++p) {
                WorldPt pt = (WorldPt)line.pts.get(p);
                Vector<Object> row = new Vector<Object>();
                row.add(r + 1 + "-" + (p + 1));
                row.add(pt.e);
                row.add(pt.n);
                this._table.appendRow(row);
            }
        }
    }

    private void fillForm(AiShapePoint shape) {
        WorldPt pt = shape.getWorldPt();
        Vector<Object> row = new Vector<Object>();
        row.add("1");
        row.add(pt.e);
        row.add(pt.n);
        this._table.appendRow(row);
    }
}

