/*
 * Decompiled with CFR 0.152.
 */
package hec.map.aishape;

import hec.map.MapPanel;
import hec.map.aishape.AiShapeGlyphDataRecord;
import hec.map.aishape.AiShapeObject;
import hec.map.aishape.Field;
import hec.map.aishape.ShapeDrawingAttribute;
import java.util.HashMap;
import java.util.List;
import javax.swing.SwingUtilities;

public class ShapeHighlight
implements Runnable {
    HashMap _attrHash = new HashMap();
    long _delay;
    MapPanel _mapPanel;
    int _fieldIdx;
    private List _shapes;

    public ShapeHighlight(List shapes, int fieldIdx, AiShapeGlyphDataRecord data, MapPanel mapPanel, int centerPointGraphic) {
        this._mapPanel = mapPanel;
        this._fieldIdx = fieldIdx;
        this._shapes = shapes;
        this.highlightShapes(shapes, data, centerPointGraphic);
    }

    public ShapeHighlight(List shapes, int fieldIdx, AiShapeGlyphDataRecord data, MapPanel mapPanel, int centerPointGraphic, long delay) {
        this(shapes, fieldIdx, data, mapPanel, centerPointGraphic);
        this._delay = delay;
    }

    private void highlightShapes(List shapes, AiShapeGlyphDataRecord data, int centerPointGraphic) {
        for (int ii = 0; ii < shapes.size(); ++ii) {
            AiShapeObject shape = (AiShapeObject)shapes.get(ii);
            Field field = shape.getFields()[this._fieldIdx];
            ShapeDrawingAttribute attr = data.getDrawingAttribute(field);
            Integer shapeInt = new Integer(shape.getIndex());
            attr.addHighlightedIndex(shapeInt);
            attr.setCenterPointGraphic(centerPointGraphic);
            this._attrHash.put(shapeInt, attr);
        }
        this._mapPanel.paintMap();
    }

    public void highlight() {
        for (Integer shapeInt : this._attrHash.keySet()) {
            ShapeDrawingAttribute attr = (ShapeDrawingAttribute)this._attrHash.get(shapeInt);
            if (attr == null) continue;
            attr.addHighlightedIndex(shapeInt);
        }
        this._mapPanel.paintMap();
    }

    public void clearHighlight() {
        for (Integer shapeInt : this._attrHash.keySet()) {
            ShapeDrawingAttribute attr = (ShapeDrawingAttribute)this._attrHash.get(shapeInt);
            if (attr == null) continue;
            attr.clearHighlightedIndex(shapeInt);
            attr.setCenterPointGraphic(0);
        }
        this._mapPanel.paintMap();
    }

    public boolean contains(AiShapeObject shape) {
        Integer shapeInt = new Integer(shape.getIndex());
        return this._attrHash.get(shapeInt) != null;
    }

    public List getShapes() {
        return this._shapes;
    }

    @Override
    public void run() {
        long startTime;
        long curTime = startTime = System.currentTimeMillis();
        while (curTime - startTime <= this._delay) {
            try {
                Thread.currentThread();
                Thread.sleep(this._delay - (curTime - startTime));
            }
            catch (Exception exception) {
                // empty catch block
            }
            curTime = System.currentTimeMillis();
        }
        Runnable r = new Runnable(){

            @Override
            public void run() {
                ShapeHighlight.this._mapPanel.waitforPaintComplete();
                ShapeHighlight.this.clearHighlight();
            }
        };
        if (SwingUtilities.isEventDispatchThread()) {
            r.run();
        } else {
            SwingUtilities.invokeLater(r);
        }
    }
}

