/*
 * Decompiled with CFR 0.152.
 */
package hec.map.aishape;

import hec.map.importer.ImportObject;
import java.util.ArrayList;
import java.util.List;

public abstract class ShapeImport {
    private String _shapeName;
    private List _shapes = new ArrayList();
    private boolean _importShapes = true;
    private List _errors = new ArrayList();
    private String _type;

    public ShapeImport(String shapeName) {
        this._shapeName = shapeName;
    }

    public String getName() {
        return this._shapeName;
    }

    public void addShape(ImportObject shape) {
        this._shapes.add(shape);
    }

    public int getShapeCount() {
        return this._shapes.size();
    }

    public void setImportShapes(boolean tf) {
        this._importShapes = tf;
    }

    public boolean getImportShapes() {
        if (this.hasErrors()) {
            return false;
        }
        return this._importShapes;
    }

    public abstract int getShapeGraphicType();

    public abstract void addExistsError();

    public abstract void removeExistsError();

    public void clearErrors() {
        this._errors.clear();
    }

    public boolean hasErrors() {
        return this._errors.size() > 0;
    }

    public void addError(String error) {
        if (!this._errors.contains(error)) {
            this._errors.add(error);
        }
    }

    public void removeError(String error) {
        this._errors.remove(error);
    }

    public String getErrorString() {
        StringBuffer sb = new StringBuffer();
        for (int ii = 0; ii < this._errors.size(); ++ii) {
            sb.append(this._errors.get(ii));
        }
        return sb.toString();
    }

    public List getShapes() {
        return this._shapes;
    }

    public abstract boolean validate();

    public void setType(String type) {
        this._type = type;
    }

    public String getType() {
        return this._type;
    }
}

