/*
 * Decompiled with CFR 0.152.
 */
package hec.map.aishape;

import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dialog;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Rectangle;
import javax.swing.JLabel;
import javax.swing.JProgressBar;
import javax.swing.SwingUtilities;
import rma.swing.RmaJDialog;

public class ShapeImportProgressIndicator
extends RmaJDialog {
    Insets INSETS5555 = new Insets(5, 5, 5, 5);
    Insets INSETS5500 = new Insets(5, 5, 0, 0);
    RmaJDialog _parent;
    JProgressBar countProgressBar;
    String _title = "Shapefile Import Progress";
    JLabel _label;

    public ShapeImportProgressIndicator(RmaJDialog parent) {
        super((Dialog)parent, parent.isModal());
        this._parent = parent;
        this.setResizable(false);
        this.setTitle(this._title);
        GridBagLayout gridBagLayout = new GridBagLayout();
        this.getContentPane().setLayout(gridBagLayout);
        this._label = new JLabel("Shapes imported");
        GridBagConstraints gbc = new GridBagConstraints();
        gbc.gridx = 0;
        gbc.gridy = 0;
        gbc.fill = 2;
        gbc.anchor = 18;
        gbc.insets = this.INSETS5555;
        this.getContentPane().add((Component)this._label, gbc);
        this.countProgressBar = new JProgressBar();
        this.countProgressBar.setStringPainted(true);
        gbc = new GridBagConstraints();
        gbc.gridx = 0;
        gbc.gridy = 1;
        gbc.weightx = 1.0;
        gbc.fill = 2;
        gbc.anchor = 18;
        gbc.insets = this.INSETS5555;
        this.getContentPane().add((Component)this.countProgressBar, gbc);
    }

    public void setMax(int max) {
        this.countProgressBar.setMaximum(max);
    }

    public void incrementProgress(String text) {
        if (SwingUtilities.isEventDispatchThread()) {
            new IncrementProgress(text).run();
        } else {
            SwingUtilities.invokeLater(new IncrementProgress(text));
        }
    }

    @Override
    public void setVisible(boolean b) {
        if (b) {
            this._parent.setCursor(new Cursor(3));
            Rectangle bounds = this.getParent().getBounds();
            Rectangle abounds = this.getBounds();
            this.setLocation(bounds.x + (bounds.width - abounds.width) / 2, bounds.y + (bounds.height - abounds.height) / 2);
            super.setVisible(true);
        } else {
            super.setVisible(false);
        }
    }

    public void done() {
        try {
            Thread.currentThread();
            Thread.sleep(2000L);
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.setVisible(false);
        this._parent.setCursor(new Cursor(0));
    }

    public class IncrementProgress
    implements Runnable {
        String _text;

        public IncrementProgress(String text) {
            this._text = text;
        }

        @Override
        public void run() {
            ShapeImportProgressIndicator.this._label.setText(this._text);
            ShapeImportProgressIndicator.this.countProgressBar.setValue(ShapeImportProgressIndicator.this.countProgressBar.getValue() + 1);
        }
    }
}

