/*
 * Decompiled with CFR 0.152.
 */
package hec.map.aishape;

import hec.map.aishape.ShapeImport;
import hec.map.importer.ImportObject;
import hec.map.importer.ShapeSource;
import hec.map.streamAlignment.StreamAlignmentGlyph;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import rma.swing.RmaJTable;
import rma.swing.table.AbstractRmaTableModel;

public abstract class ShapeImportTableModel
extends AbstractRmaTableModel {
    public static final int NAME_COLUMN = 0;
    public static final int IMPORT_COLUMN = 1;
    private boolean _replaceExisting = false;
    protected RmaJTable _table;
    protected String _nameField;
    protected int _nameFieldIndex = -1;
    protected ShapeSource _shapeSource;
    protected HashMap<String, ShapeImport> _shapeImportHash = new HashMap();
    protected List<String> _shapeImportNames = new ArrayList<String>();
    private boolean _editingAllowed = true;
    protected StreamAlignmentGlyph _streamAlignmentGlyph;

    public ShapeImportTableModel(RmaJTable table) {
        this._table = table;
        this._table.setModel(this);
        this._table.setPopupMenuEnabled(false);
        this._table.setCheckBoxCellEditor(1);
    }

    @Override
    public boolean isCellEditable(int rowIndex, int columnIndex) {
        if (columnIndex > 0) {
            if (!this._editingAllowed) {
                return false;
            }
            String shapeName = this._shapeImportNames.get(rowIndex);
            ShapeImport shapeImport = this.getShapeImport(shapeName);
            return !shapeImport.hasErrors();
        }
        return false;
    }

    public ShapeImport getShapeImport(int row) {
        if (row < 0 || row >= this._shapeImportNames.size()) {
            return null;
        }
        String shapeName = this._shapeImportNames.get(row);
        return this.getShapeImport(shapeName);
    }

    @Override
    public void setColEnabled(boolean tf, int idx) {
        if (idx == 1) {
            this._editingAllowed = tf;
        }
    }

    public String getToolTip(int col, int row) {
        if (row < 0 || row >= this._shapeImportNames.size()) {
            return null;
        }
        String name = this._shapeImportNames.get(row);
        ShapeImport shapeImport = this._shapeImportHash.get(name);
        if (shapeImport.hasErrors()) {
            return shapeImport.getErrorString();
        }
        return null;
    }

    public List<String> getShapeImportNames() {
        return Collections.unmodifiableList(this._shapeImportNames);
    }

    public ShapeImport getShapeImport(String shapeName) {
        return this._shapeImportHash.get(shapeName);
    }

    public void setNameFieldIndex(int idx) {
        this._nameFieldIndex = idx;
        this.fillModel();
    }

    public int getNameFieldIndex() {
        return this._nameFieldIndex;
    }

    public boolean getReplaceExisting() {
        return this._replaceExisting;
    }

    public void setReplaceExisting(boolean tf) {
        if (this._replaceExisting == tf) {
            return;
        }
        this._replaceExisting = tf;
        if (this.getReplaceExisting()) {
            for (ShapeImport shapeImport : this._shapeImportHash.values()) {
                shapeImport.removeExistsError();
            }
        } else {
            for (ShapeImport shapeImport : this._shapeImportHash.values()) {
                if (shapeImport == null) continue;
                this.checkExistance(shapeImport);
            }
        }
        this.fireTableDataChanged();
    }

    @Override
    public Object getValueAt(int rowIndex, int columnIndex) {
        if (columnIndex == 0) {
            return this._shapeImportNames.get(rowIndex);
        }
        if (columnIndex == 1) {
            String shapeName = this._shapeImportNames.get(rowIndex);
            ShapeImport shapeImport = this._shapeImportHash.get(shapeName);
            return shapeImport.getImportShapes();
        }
        return null;
    }

    @Override
    public void setValueAt(Object aValue, int rowIndex, int columnIndex) {
        if (aValue == null) {
            return;
        }
        String shapeName = this._shapeImportNames.get(rowIndex);
        ShapeImport shapeImport = this._shapeImportHash.get(shapeName);
        if (columnIndex == 1) {
            Boolean bool = aValue instanceof Boolean ? (Boolean)aValue : Boolean.valueOf(Boolean.parseBoolean(aValue.toString()));
            shapeImport.setImportShapes(bool);
            this.fireTableCellUpdated(rowIndex, columnIndex);
        }
    }

    @Override
    public int getRowCount() {
        return this._shapeImportNames.size();
    }

    @Override
    public void fireTableStructureChanged() {
        super.fireTableStructureChanged();
        this._table.setCheckBoxCellEditor(1);
    }

    @Override
    public String getColumnName(int columnIndex) {
        switch (columnIndex) {
            case 0: {
                return this._nameField;
            }
            case 1: {
                return "Import";
            }
        }
        return null;
    }

    public void setShapeSource(ShapeSource source) {
        this._shapeSource = source;
    }

    @Override
    public int getColumnCount() {
        return 2;
    }

    @Override
    public Class getColumnClass(int columnIndex) {
        if (columnIndex == 0) {
            return Object.class;
        }
        return Boolean.class;
    }

    public abstract boolean importShapes();

    private void clear() {
        this._shapeImportNames.clear();
        this._shapeImportHash.clear();
        this.clearHighlights(true);
    }

    public void clearHighlights(boolean clearTableSelection) {
        if (clearTableSelection) {
            this._table.clearSelection();
        }
        if (this._shapeSource != null) {
            this._shapeSource.clearHighlights();
        }
    }

    public void setImportAll(boolean tf) {
        for (ShapeImport shapeImport : this._shapeImportHash.values()) {
            shapeImport.setImportShapes(tf);
        }
        this.fireTableDataChanged();
    }

    public void rowSelected(int[] rows) {
        this.clearHighlights(false);
        for (int ii = 0; ii < rows.length; ++ii) {
            String shapeName = this._shapeImportNames.get(rows[ii]);
            ShapeImport shapeImport = this._shapeImportHash.get(shapeName);
            List shapes = shapeImport.getShapes();
            if (this._shapeSource == null) {
                return;
            }
            int centerPointGraphic = shapeImport.getShapeGraphicType();
            this._shapeSource.highlightRecords(shapes, centerPointGraphic);
        }
    }

    public abstract ShapeImport buildShapeImport(String var1);

    public void fillModel() {
        this.clear();
        if (this._nameFieldIndex < 0 || this._nameFieldIndex >= this._shapeSource.getFieldDescriptors().size()) {
            return;
        }
        this._nameField = this._shapeSource.getFieldDescriptors().get(this._nameFieldIndex).toString();
        List shapes = this._shapeSource.getShapes();
        int count = shapes.size();
        for (int ii = 0; ii < count; ++ii) {
            ImportObject shape = (ImportObject)shapes.get(ii);
            String shapeName = shape.getAttribute().getField(this._nameFieldIndex).toString();
            ShapeImport shapeImport = this._shapeImportHash.get(shapeName);
            if (shapeImport == null) {
                shapeImport = this.buildShapeImport(shapeName);
                this._shapeImportHash.put(shapeName, shapeImport);
                this._shapeImportNames.add(shapeName);
            }
            shapeImport.addShape(shape);
        }
        Collections.sort(this._shapeImportNames);
        Iterator<ShapeImport> i = this._shapeImportHash.values().iterator();
        boolean tf = true;
        while (i.hasNext()) {
            ShapeImport shapeImport = i.next();
            if (shapeImport == null) continue;
            if (!shapeImport.validate()) {
                tf = false;
            }
            if (this.getReplaceExisting()) continue;
            this.checkExistance(shapeImport);
        }
        this.hasErrors(tf);
        this.fireTableStructureChanged();
    }

    protected void hasErrors(boolean tf) {
    }

    public void setStreamAlignmentGlyph(StreamAlignmentGlyph glyph) {
        this._streamAlignmentGlyph = glyph;
    }

    public abstract void checkExistance(ShapeImport var1);
}

